/*
* Copyright c                  Realtek Semiconductor Corporation, 2002  
* All rights reserved.
* 
* Program : Patching Switch core table driver 
* Abstract : 
* Author : chih-hua huang (chhuang@realtek.com.tw)               
* $Id: rtl865xC_tblDrvPatch.c,v 1.1 2010/05/19 11:15:37 jackey Exp $
*
*/

#include "rtl_types.h"
#include "rtl_utils.h"
#include "types.h"
#include "rtl8651_hwPatch.h"		/* define for chip related spec */
#include <common/rtl8651_aclLocal.h>
#include "rtl865xC_tblAsicDrv.h"
#include <common/rtl865x_common_local.h>
#include "mbuf.h"
#include "rtl865x_layer2.h"
#include "rtl8651_tblDrvPatch.h"

#ifdef RTL865X_MODEL_USER
#include "rtl_glue.h"
#include <stdio.h>
#include <string.h>
#define rtl8651_memcpy memcpy
#endif



/*
 *  The following functions are defined for new interface of ASIC driver.
 */

// In the development, the __LINE__ is defined as '' (without quotes).
// For release, the __LINE__ is defined as 'inline' (without quotes).

#ifdef CONFIG_RTL865X_LAYERED_DRIVER

#else
/*__INLINE__*/ int32 RTL8651_SETASICVLAN( rtl8651_tblDrv_vlanTable_t *vt )
{
	rtl865x_tblAsicDrv_vlanParam_t vlan;
	rtl865x_tblAsicDrv_intfParam_t intf;
	int32 retval;
	ether_addr_t resvMac = { {0x00, 0x00, 0x00, 0x00, 0x00, 0x00} };

	bzero( &intf, sizeof(intf) );
	intf.enableRoute = vt->softRoute? 0: vt->ipAttached;
	intf.inAclEnd = vt->inAclEnd;
	intf.inAclStart = vt->inAclStart;
	if ( vt->macNonExist ){
		intf.macAddr = resvMac;	/* It means there's no mac address at this net interface. */
	}
	else
		intf.macAddr = vt->macAddr;
	intf.macAddrNumber = vt->macAddrNumber;
	intf.mtu = vt->mtu;
	intf.outAclEnd = vt->outAclEnd;
	intf.outAclStart = vt->outAclStart;
	intf.valid = vt->valid;
	intf.vid = vt->vid;
	retval = rtl8651_setAsicNetInterface( RTL865XC_NETIFTBL_SIZE, &intf );
	if ( retval != SUCCESS ) return retval;

	bzero( &vlan, sizeof(vlan) );
	vlan.untagPortMask = vt->untagPortMask;
	if (RTL865X_TX_LINKDOWN_BUG)
	{
#if defined(RTL865X_TEST) || defined(RTL865X_MODEL_USER) || defined(RTL865X_MODEL_KERNEL)
		vlan.memberPortMask = vt->memberPortMask;
#else
		vlan.memberPortMask = vt->memberPortUpStatus;
#endif
	}
	else
	{
		vlan.memberPortMask = vt->memberPortMask /* & phyPortLinkStatus */;
	}
	retval = rtl8651_setAsicVlan( intf.vid, &vlan );

	return retval;
}

#endif

#if (defined (RTL865XB_DCUT_SWVLAN) || defined(CONFIG_RTL865XC)) && !defined(CONFIG_DEFAULTS_KERNEL_2_6)

int32 RTL865XC_SETASICVLAN ( rtl8651_tblDrv_swVlanTable_t *swVlanPtr )
{
	rtl865x_tblAsicDrv_vlanParam_t vlan;
	int32 retval;

	bzero( &vlan, sizeof(vlan) );
	vlan.untagPortMask = swVlanPtr->untagPortMask;
	vlan.memberPortMask = swVlanPtr->memberPortMask;
	vlan.fid = swVlanPtr->fid;
	retval = rtl8651_setAsicVlan( swVlanPtr->vid, &vlan );

	return retval;
}
#endif

__INLINE__ int32 convert_getAsicVlan( uint16 vid, ether_addr_t * mac, uint32 * mbr,
                                      uint32 * inAclStart, uint32 * inAclEnd, uint32 * outAclStart,
                                      uint32 * outAclEnd, int8 * internalIntf, int8 * enableRoute,
                                      int8 *portState, int8 * broadcastToCpu, int8 * promiscuous, 
                                      uint32 * untagPortMask, uint32 * macNumber, uint32 * mtu )
{
	int32 ret;
	rtl865x_tblAsicDrv_vlanParam_t vlan;
	rtl865x_tblAsicDrv_intfParam_t intf;

	bzero(&vlan , sizeof(rtl865x_tblAsicDrv_vlanParam_t));
	bzero(&intf , sizeof(rtl865x_tblAsicDrv_intfParam_t));

	ret = rtl8651_getAsicVlan( vid, &vlan );
	if ( ret != SUCCESS ) return ret;
	ret = rtl8651_getAsicNetInterface( RTL865XC_NETIFTBL_SIZE, &intf );
	if ( ret != SUCCESS ) return ret;

	if ( mac ) *mac = intf.macAddr;
	if ( mbr ) *mbr = vlan.memberPortMask;
	if ( inAclStart ) *inAclStart = intf.inAclStart;
	if ( inAclEnd ) *inAclEnd = intf.inAclEnd;
	if ( outAclStart ) *outAclStart = intf.outAclStart;
	if ( outAclEnd ) *outAclEnd = intf.outAclEnd;
	if ( enableRoute ) *enableRoute = intf.enableRoute;
	if ( untagPortMask ) *untagPortMask = vlan.untagPortMask;
	if ( macNumber ) *macNumber = intf.macAddrNumber;
	if ( mtu ) *mtu = intf.mtu;

	return SUCCESS;
}


__INLINE__ int32 convert_setAsicPppoe( uint32 index, uint16 sid )
{
	rtl865x_tblAsicDrv_pppoeParam_t pppoe;

	bzero(&pppoe , sizeof(rtl865x_tblAsicDrv_pppoeParam_t));
	
#ifdef CONFIG_RTL865XB_EXP_INVALID
	pppoe.age = 0;
#endif /* CONFIG_RTL865XB_EXP_INVALID */
	pppoe.sessionId = sid;
	return rtl8651_setAsicPppoe(index,&pppoe);
}


__INLINE__ int32 convert_getAsicPppoe( uint32 index, uint16 *sid )
{
	int32 ret;
	rtl865x_tblAsicDrv_pppoeParam_t pppoe;

	bzero(&pppoe , sizeof(rtl865x_tblAsicDrv_pppoeParam_t));

	ret = rtl8651_getAsicPppoe( index, &pppoe );
	if ( ret != SUCCESS ) return ret;

	if ( sid ) *sid = pppoe.sessionId;
	
#ifdef CONFIG_RTL865XB_EXP_INVALID
	if ( age ) pppoe.age;
#endif /* CONFIG_RTL865XB_EXP_INVALID */

	return SUCCESS;
}


__INLINE__ int32 convert_setAsicExtIntIpTable( uint32 ipIdx, ipaddr_t ExtIp, ipaddr_t IntIp,
                                   uint32 localPublic, uint32 nat)
{
	rtl865x_tblAsicDrv_extIntIpParam_t IpParam;

	bzero(&IpParam , sizeof(rtl865x_tblAsicDrv_extIntIpParam_t));
	
	IpParam.extIpAddr = ExtIp;
	IpParam.intIpAddr = IntIp;
	IpParam.localPublic = localPublic;
	IpParam.nat = nat;
#ifdef CONFIG_RTL865XB_EXP_INVALID
	IpParam.nhIndex = ;
#endif
	return rtl8651_setAsicExtIntIpTable(ipIdx,&IpParam);
}


__INLINE__ int32 convert_getAsicExtIntIpTable( uint32 index, ipaddr_t *ExtIp, ipaddr_t *IntIp, 
                                               int8 *localPublic, int8 *nat )
{
	int32 ret;
	rtl865x_tblAsicDrv_extIntIpParam_t ip;

	bzero(&ip, sizeof(rtl865x_tblAsicDrv_extIntIpParam_t));

	ret = rtl8651_getAsicExtIntIpTable( index, &ip );
	if ( ret != SUCCESS ) return ret;

	if ( ExtIp ) *ExtIp = ip.extIpAddr;
	if ( IntIp ) *IntIp = ip.intIpAddr;
	if ( localPublic ) *localPublic = ip.localPublic;
	if ( nat ) *nat = ip.nat;

#ifdef CONFIG_RTL865XB_EXP_INVALID
	if ( nhIndex ) *nhIndex = ip.nhIndex;
#endif

	return SUCCESS;
}


__INLINE__ int32 convert_setAsicArp( uint32 ArpPos, uint32 ArpIdx, uint32 asicPos )
{
	rtl865x_tblAsicDrv_arpParam_t arpParam;

	bzero(&arpParam, sizeof(rtl865x_tblAsicDrv_arpParam_t));

	arpParam.nextHopColumn = asicPos;
	arpParam.nextHopRow = ArpIdx;
	return rtl8651_setAsicArp( ArpPos, &arpParam );
}


__INLINE__ int32 convert_getAsicArp( uint32 index, uint32 *nextHopRow, uint32 *nextHopColumn )
{
	int32 ret;
	rtl865x_tblAsicDrv_arpParam_t arp;

	bzero(&arp, sizeof(rtl865x_tblAsicDrv_arpParam_t));

	ret = rtl8651_getAsicArp( index, &arp );
	if ( ret != SUCCESS ) return ret;

	if ( nextHopRow ) *nextHopRow = arp.nextHopRow;
	if ( nextHopColumn ) *nextHopColumn = arp.nextHopColumn;
	
	return SUCCESS;
}


__INLINE__ int32 convert_setAsicRouting( uint32 idx, ipaddr_t ipAddr, ipaddr_t ipMask,
                                         uint32 process, uint32 vidx, uint32 arpStart, uint32 arpEnd,
                                         uint32 nextHopRow, uint32 nextHopColumn, uint32 pppoeIdx )
{
	rtl865x_tblAsicDrv_routingParam_t routingParam;

	bzero(&routingParam, sizeof(rtl865x_tblAsicDrv_routingParam_t));
	
	routingParam.arpEnd = arpEnd;
	routingParam.arpStart = arpStart;
	routingParam.ipAddr = ipAddr;
	routingParam.ipMask = ipMask;
	routingParam.nextHopColumn = nextHopColumn;
	routingParam.nextHopRow = nextHopRow;
	routingParam.pppoeIdx = pppoeIdx;
	routingParam.process = process;
	routingParam.vidx = vidx;

#ifdef CONFIG_RTL865XB_EXP_INVALID
	routingParam.ipDomain = ;
	routingParam.nhAlgo = ;
	routingParam.nhNum = ;
	routingParam.nhNxt = ;
	routingParam.nhStart = ;
#endif

	return rtl8651_setAsicRouting( idx, &routingParam );
}


__INLINE__ int32 convert_getAsicRouting( uint32 index, ipaddr_t * ipAddr, ipaddr_t * ipMask, uint32 * process, //0: pppoe, 1:direct, 2:indirect, 4:Strong CPU, 
                                         uint32 * vidx, uint32 * arpStart, uint32 * arpEnd, 
                                         uint32 * nextHopRow, uint32 * nextHopColumn, uint32 * pppoeIdx) 
{
	uint32 ret;
	rtl865x_tblAsicDrv_routingParam_t routing;

	bzero(&routing, sizeof(rtl865x_tblAsicDrv_routingParam_t));
	
	if(index >= RTL8651_ROUTINGTBL_SIZE || ipAddr == NULL || ipMask == NULL || process == NULL ||	vidx == NULL || 
		arpStart == NULL || arpEnd == NULL || nextHopRow == NULL || nextHopColumn == NULL || pppoeIdx == NULL)
		return FAILED;

	ret = rtl8651_getAsicRouting( index, &routing );
	if ( ret != SUCCESS ) return ret;
	
	if ( ipAddr ) *ipAddr = routing.ipAddr;
	if ( ipMask ) *ipMask = routing.ipMask;
	if ( process ) *process = routing.process;
	if ( vidx ) *vidx = routing.vidx;
	if ( arpStart ) *arpStart = routing.arpStart;
	if ( arpEnd ) *arpEnd = routing.arpEnd;
	if ( nextHopRow ) *nextHopRow = routing.nextHopRow;
	if ( nextHopColumn ) *nextHopColumn = routing.nextHopColumn;
	if ( pppoeIdx ) *pppoeIdx = routing.pppoeIdx;

	return SUCCESS;
}


__INLINE__ int32 convert_setAsicServerPortTable( uint32 index, ipaddr_t ExtIp, uint16 ExtPort,
                                                 ipaddr_t IntIp, uint16 IntPort )
{
	rtl865x_tblAsicDrv_serverPortParam_t spParam;

	bzero(&spParam, sizeof(rtl865x_tblAsicDrv_serverPortParam_t));

	spParam.extIpAddr = ExtIp;
	spParam.extPort = ExtPort;
	spParam.intIpAddr = IntIp;
	spParam.intPort = IntPort;
	spParam.valid = 1;

#ifdef CONFIG_RTL865XB_EXP_INVALID
	spParam.nhIndex = ;
	spParam.portRange = ;
#endif
	
	return rtl8651_setAsicServerPortTable( index, &spParam );
}


__INLINE__ int32 convert_getAsicServerPortTable( uint32 index, ipaddr_t *ExtIp, uint16 *ExtPort,
                                                 ipaddr_t *IntIp, uint16 *IntPort ) 
{
	int32 ret;
	rtl865x_tblAsicDrv_serverPortParam_t sp;

	bzero(&sp, sizeof(rtl865x_tblAsicDrv_serverPortParam_t));

	ret = rtl8651_getAsicServerPortTable( index, &sp );
	if ( ret != SUCCESS ) return ret;

	if ( ExtIp ) *ExtIp = sp.extIpAddr;
	if ( ExtPort ) *ExtPort = sp.extPort;
	if ( IntIp ) *IntIp = sp.intIpAddr;
	if ( IntPort ) *IntPort = sp.intPort;

#ifdef CONFIG_RTL865XB_EXP_INVALID
	if ( nhIndex ) *nhIndex = sp.nhIndex;
	if ( portRange ) *portRange = sp.portRange;
#endif
	
	return SUCCESS;
}


__INLINE__ int32 convert_setAsicNaptTcpUdpTable( int8 forced,
                                                 ipaddr_t IntIp, uint16 IntPort, uint16 ExtPort,
                                                 uint32 ageSec, int8 entryType, int8 isTcp, int8 tcpFlag, 
                                                 int8 isCollision, int8 isCollision2, int8 isValid )
{
	rtl865x_tblAsicDrv_naptTcpUdpParam_t naptParam;

	bzero(&naptParam, sizeof(rtl865x_tblAsicDrv_naptTcpUdpParam_t));

	naptParam.ageSec = ageSec;
	naptParam.insideLocalIpAddr = IntIp;
	naptParam.insideLocalPort = IntPort;
	naptParam.isCollision = isCollision;
	naptParam.isTcp = isTcp;
	naptParam.offset = ExtPort >> RTL8651_TCPUDPTBL_BITS;
	naptParam.tcpFlag = tcpFlag;
	naptParam.isStatic = RTL8651_STATIC_NAPT_ENTRY & entryType? TRUE: FALSE;
	naptParam.isValid = isValid;

#ifdef CONFIG_RTL865XB_EXP_INVALID
	naptParam.isCollision2 = isCollision2;
	naptParam.isDedicated = ;
	naptParam.selEIdx = ;
	naptParam.selExtIPIdx = ;
#endif
	
	return rtl8651_setAsicNaptTcpUdpTable( forced, ExtPort & (RTL8651_TCPUDPTBL_SIZE-1),
	                                       &naptParam );
}


__INLINE__ int32 convert_getAsicNaptTcpUdpTable( uint8 *extIpIdx, uint16 index,
                                                 ipaddr_t *IntIp, uint16 *IntPort, uint16 *ExtPort,
                                                 uint32 *ageSec,  int8 * entryType, int8 *isTcp, int8 *tcpFlag,
                                                 int8 *isCollision, int8 *isValid, int8 *isCollision2,
                                                 int8 *isDedicated, uint16 *selEIdx, uint8 *selExtIpIdx )
{
	rtl865x_tblAsicDrv_naptTcpUdpParam_t naptParam;
	int32 ret;

	bzero(&naptParam, sizeof(rtl865x_tblAsicDrv_naptTcpUdpParam_t));

	ret = rtl8651_getAsicNaptTcpUdpTable( index, &naptParam );
	if ( ret != SUCCESS ) return ret;

  	if (extIpIdx != NULL) *extIpIdx = naptParam.insideLocalIpAddr & (RTL8651_IPTABLE_SIZE-1); //Note this is NOT GIDX, it's ExtIPTable Index!!!
	if (ageSec ) *ageSec = naptParam.ageSec;
	if ( IntIp ) *IntIp = naptParam.insideLocalIpAddr;
	if ( IntPort ) *IntPort = naptParam.insideLocalPort;
	if ( isCollision ) *isCollision = naptParam.isCollision;
	if ( isTcp ) *isTcp = naptParam.isTcp;
	if ( ExtPort )
	{
		if ( naptParam.isValid == TRUE && naptParam.isDedicated == TRUE &&
		     (naptParam.tcpFlag&2) && (naptParam.tcpFlag&1) )
		{
			/* HASH2's outbound entry, extPort is got from selEidx. */
			*ExtPort = ( naptParam.offset << RTL8651_TCPUDPTBL_BITS ) + naptParam.selEIdx;
		}
		else
		{
			*ExtPort = ( naptParam.offset << RTL8651_TCPUDPTBL_BITS ) + index;
		}
	}
	if ( tcpFlag ) *tcpFlag = naptParam.tcpFlag;
	if ( entryType )
	{
		*entryType = naptParam.isStatic ? RTL8651_STATIC_NAPT_ENTRY : 0;
		*entryType |= (naptParam.isValid == TRUE && naptParam.isDedicated == TRUE ) ? RTL8651_LIBERAL_NAPT_ENTRY : 0;
	}
	if ( isValid ) *isValid = naptParam.isValid;

	if ( isCollision2 ) *isCollision2 = naptParam.isCollision2;
	if ( isDedicated ) *isDedicated = naptParam.isDedicated;
	if ( selEIdx) *selEIdx = naptParam.selEIdx;
	if ( selExtIpIdx ) *selExtIpIdx = naptParam.selExtIPIdx;
	
	return SUCCESS;
}


__INLINE__ int32 convert_setAsicNaptIcmpTable(int8 forced,
                ipaddr_t IntIp, uint16 IntId, uint16 ExtId,
                uint32 ageSec, int8 entryType, int16 count, int8 isCollision, int8 isValid )
{
	rtl865x_tblAsicDrv_naptIcmpParam_t naptIcmp;

	bzero(&naptIcmp, sizeof(rtl865x_tblAsicDrv_naptIcmpParam_t));
	
	naptIcmp.ageSec = ageSec;
	naptIcmp.insideLocalId = IntId;
	naptIcmp.insideLocalIpAddr = IntIp;
	naptIcmp.isCollision = isCollision;
	naptIcmp.isStatic = RTL8651_STATIC_NAPT_ENTRY & entryType? TRUE: FALSE;
	naptIcmp.isValid = isValid;
	naptIcmp.offset = ExtId >> RTL8651_ICMPTBL_BITS;

#ifdef CONFIG_RTL865XB_EXP_INVALID
	naptIcmp.isPptp = ;
	naptIcmp.isSpi = ;
#endif

	return rtl8651_setAsicNaptIcmpTable( forced, ExtId&(RTL8651_ICMPTBL_SIZE-1), &naptIcmp );
}


__INLINE__ int32 convert_getAsicNaptIcmpTable( int8 precisePort, uint16 tarId,
                                               ipaddr_t *IntIp, uint16 *IntId,
                                               uint16 *ExtId, uint32 *ageSec, int8 *entryType,
                                               uint16 *count, int8 *isCollision, int8 *isValid )
{
	int32 ret;
	rtl865x_tblAsicDrv_naptIcmpParam_t naptIcmp;

	bzero(&naptIcmp, sizeof(rtl865x_tblAsicDrv_naptIcmpParam_t));
	
	ret = rtl8651_getAsicNaptIcmpTable( tarId&(RTL8651_ICMPTBL_SIZE-1), &naptIcmp );
	if ( ret == SUCCESS )
	{
		if ( ageSec ) *ageSec = naptIcmp.ageSec;
		if ( IntId ) *IntId = naptIcmp.insideLocalId;
		if ( IntIp ) *IntIp = naptIcmp.insideLocalIpAddr;
		if ( isCollision) *isCollision = naptIcmp.isCollision;
		if ( isValid ) *isValid = naptIcmp.isValid;
		if ( entryType ) *entryType = naptIcmp.isStatic ?RTL8651_STATIC_NAPT_ENTRY: RTL8651_DYNAMIC_NAPT_ENTRY;
		if ( ExtId ) *ExtId = naptIcmp.offset << RTL8651_ICMPTBL_BITS | (tarId&(RTL8651_ICMPTBL_SIZE-1));
	}
	
	return ret;
}


__INLINE__ int32 convert_setAsicAlg( uint32 index, uint16 port )
{
	rtl865x_tblAsicDrv_algParam_t alg;

	bzero(&alg, sizeof(rtl865x_tblAsicDrv_algParam_t));

	alg.port = port;
	
	return rtl8651_setAsicAlg( index, &alg );
}


__INLINE__ int32 convert_getAsicAlg( uint32 index, uint16 *port )
{
	int32 ret;
	rtl865x_tblAsicDrv_algParam_t alg;

	bzero(&alg, sizeof(rtl865x_tblAsicDrv_algParam_t));

	ret = rtl8651_setAsicAlg( index, &alg );
	if ( ret != SUCCESS ) return ret;

	if ( port ) *port = alg.port;
	
	return SUCCESS;
}




__INLINE__ int32 convert_setAsicL2Table(uint32 row, uint32 column, ether_addr_t * mac, int8 cpu, 
		int8 srcBlk, uint32 mbr, uint32 ageSec, int8 isStatic, int8 nhFlag, int8 auth)
{
	rtl865x_tblAsicDrv_l2Param_t l2;

	bzero(&l2, sizeof(rtl865x_tblAsicDrv_l2Param_t));

	l2.ageSec				= ageSec;
	l2.cpu				= cpu;
	l2.isStatic				= isStatic; 
	l2.memberPortMask		= mbr;
	l2.nhFlag				= nhFlag;
	l2.srcBlk				= srcBlk;
//#ifdef RTL865XC_LAN_PORT_NUM_RESTRIT
//	if(enable4LanPortNumRestrict == TRUE)
		l2.auth = auth;
//#endif	
	rtl8651_memcpy(&l2.macAddr, mac, 6);
	return rtl8651_setAsicL2Table(row, column, &l2);
}



#if 0
/*		
 * <<RTL8651 version B Bug>>
 * Due to the rtl8651 NAPT bug(if an entry is written into ASIC as a static entry, the 			
 * aging time and flow status will not be updated by ASIC), a patch is needed for 				
 * this bug:																					
 *	     Once an entry is added as a static entry(in fact, entries added by driver table		
 *		 are always static entry), we modify it to dynamic entry unconsciously in this		
 *		 macro.																					
 */	
int32 rtl8651_setAsicNaptTcpUdpTable_Patch(int8 forced, ipaddr_t sip, uint16 sport, uint16 gport,
		uint32 ageSec, int8 entryType, int8 isTcp, int8 tcpFlag, int8 isColl, int8 isValid) {

	return rtl8651_setAsicNaptTcpUdpTable(
		forced, 
		sip,
		sport,
		gport,
		ageSec,
#ifdef RTL8651B
		entryType,
#else
		RTL8651_DYNAMIC_NAPT_ENTRY,	/* patch here!! always false(dynamic) */
#endif
		isTcp,
		tcpFlag,
		isColl,
		isValid
	);
}


/*		
 * <<RTL8651 version B Bug>>
 * Due to the rtl8651 NAPT bug(if an entry is written into ASIC as a static entry, the 			
 * aging time and flow status will not be updated by ASIC), a patch is needed for 				
 * this bug:																					
 *	     Once an entry is added as a static entry(in fact, entries added by driver table		
 *		 are always static entry), we modify it to dynamic entry unconsciously in this		
 *		 macro.																					
 */	
int32 rtl8651_setAsicNaptIcmpTable_Patch(int8 forced, ipaddr_t sip, uint16 sID, uint16 gID, 
		uint32 ageSec, int8 entryType, int16 count, int8 isColl, int8 isValid) {

	return rtl8651_setAsicNaptIcmpTable(
			forced,
			sip,
			sID,
			gID,
			ageSec,
			RTL8651_DYNAMIC_NAPT_ENTRY,	/* patch here!! always false(dynamic) */
			count,
			isColl,
			isValid
	);
}


/*
 * <<RTL8651 version C Bug>> 
 * In this version, once the aging time of an ICMP static entry reaches zero, the ASIC
 * will reset its valid bit and never auto-learn. To patch this bug, once the 
 * static and valid fields of reading entry are 1 and 0 respectively, translate it
 * to static=1 and valid=1.
 */
int32 rtl8651_getAsicNaptIcmpTable_Patch(int8 preID, uint16 tgID, ipaddr_t *sip, uint16 *sID, 
		uint16 *gID, uint32 *ageSec, int8 *entryType, uint16 *count, int8 *isColl, int8 *isValid) {
	int8 _valid, _entryType;
	uint32 retval=rtl8651_getAsicNaptIcmpTable(
					preID,
					tgID,
					sip,
					sID,
					gID,
					ageSec,
					&_entryType,
					count,
					isColl,
					&_valid
	);
	/* patch here, if static bit is turned on, valid bit is always true */
	if (_entryType == RTL8651_STATIC_NAPT_ENTRY)  _valid = TRUE; 
	if (isValid != NULL)  *isValid = _valid;
	if (entryType != NULL) *entryType = _entryType;
	return retval;
}

#endif
/*
 * <<RTL8651 version B Bug>>
 * RTL8651 L2 entry bug:
 *		For each L2 entry added by driver table as a static entry, the aging time 
 *		will not be updated by ASIC
 * Bug fixed:
 *		To patch this bug, set the entry is a dynamic entry and turn on the 'nhFlag', 
 *		then the aging time of this entry will be updated and once aging time expired,
 *		it won't be removed by ASIC automatically.
 */
int32 rtl8651_setAsicL2Table_Patch(uint32 row, uint32 column, ether_addr_t * mac, int8 cpu, 
		int8 srcBlk, uint32 mbr, uint32 ageSec, int8 isStatic, int8 nhFlag, int8 auth) {
#if 0	
	ether_addr_t bcast_mac = { {0xff, 0xff, 0xff, 0xff, 0xff, 0xff} };
	ether_addr_t cpu_mac = {{0x00,0x00,0x0a,0x00,0x00,0x0f}};

	/* 
		In RTL865xC, we need to turn on the CPU bit of broadcast mac to let broadcast packets being trapped to CPU.
	*/

	if ( memcmp( &bcast_mac, mac, sizeof(ether_addr_t) ) == 0 || memcmp(&cpu_mac,mac,sizeof(ether_addr_t)) == 0)
	{
		return convert_setAsicL2Table(
				row,
				column,
				mac,
				TRUE,	/* Set CPU bit to TRUE */
				FALSE,
				mbr,
				500,
				isStatic,	/* No one will be broadcast/multicast source */
				nhFlag,/* No one will be broadcast/multicast source */
				TRUE
		);
	}
#endif
	if(mac->octet[0]&0x1)
	{
		return convert_setAsicL2Table(
				row,
				column,
				mac,
				cpu,
				FALSE,
				mbr,
				ageSec,
				isStatic,	/* No one will be broadcast/multicast source */
				nhFlag,	/* No one will be broadcast/multicast source */
				TRUE
		);
	}	
	else {
		int8 dStatic=isStatic/*, dnhFlag=(isStatic==TRUE? TRUE: FALSE)*/;
		int8 dnhFlag = nhFlag;
#if defined(CONFIG_RTL865X_PPTPL2TP)||defined(CONFIG_RTL865XB_PPTPL2TP)
		extern rtl8651_tblDrv_miiTunneling_t tunnel;
		uint32 MBR = (1 << tunnel.loopbackPort);
		if (tunnel.valid && mbr==MBR) {
			dStatic = TRUE;
			dnhFlag = FALSE;
		}
#endif		
		return convert_setAsicL2Table(
				row,
				column,
				mac,
				cpu,
				srcBlk,
				mbr,
				ageSec,
				dStatic,
				dnhFlag,
				auth
//				FALSE,							/* patch here!! always dynamic entry */
//				(isStatic==TRUE? TRUE: FALSE)	/* patch here!! nhFlag always turned on if static entry*/
		);
	}
}


/*
 * <<RTL8651 version B Bug>>
 * RTL8651 L2 entry bug:
 *		For each L2 entry added by driver table as a static entry, the aging time 
 *		will not be updated by ASIC
 * Bug fixed:
 *		To patch this bug, set the entry as a dynamic entry and turn on the 'nhFlag', 
 *		then the aging time of this entry will be updated and once aging time expired,
 *		it won't be removed by ASIC automatically.
 */
#if 0
int32 rtl8651_getAsicL2Table_Patch(uint32 row, uint32 column, ether_addr_t * mac, int8 * cpu, 
	int8 * srcBlk, int8 * isStatic, uint32 * mbr, uint32 * ageSec, int8 *nhFlag) 
{
	rtl865x_tblAsicDrv_l2Param_t l2;

	int32 retval = rtl8651_getAsicL2Table(row, column, &l2);
	if (mac) rtl8651_memcpy(mac, &l2.macAddr, 6);
	if (cpu) *cpu = l2.cpu;
	if (srcBlk) *srcBlk = l2.srcBlk;
	if (isStatic) *isStatic = l2.isStatic;
	if (mbr) *mbr = l2.memberPortMask;
	if (ageSec) *ageSec = l2.ageSec;
	if (nhFlag) *nhFlag = l2.nhFlag;
	if (isStatic != NULL) *isStatic = TRUE; /* patch!!, always TRUE(static entry */
	if (nhFlag != NULL) *nhFlag = FALSE;  /* always false */
	return retval;
}
#else

int32 rtl8651_getAsicL2Table_Patch(uint32 row, uint32 column, rtl865x_tblAsicDrv_l2Param_t *asic_l2_t)
{
	int32 retval = rtl8651_getAsicL2Table(row, column, asic_l2_t);
#ifdef CONFIG_RTL865XB_EXP_INVALID
	if (retval == SUCCESS) {
		asic_l2_t->isStatic	= TRUE;
		asic_l2_t->nhFlag	= FALSE;
	}
#endif
	return retval;
}


#endif


/*=========================================
  * ASIC CONVERSION DRIVER API: Legacy APIs
  *=========================================*/
#define RTL865XC_TBLDRVPATCH_LEGACY_API

__INLINE__ int32 convert_getAsicProtoTrap( uint32 index, uint8 *type, uint16 *content)
{
	rtlglue_printf("Current version of chip does not support hardware protocol-trap anymore.\n");
	return FAILED;
}


