/*
* Copyright c                  Realtek Semiconductor Corporation, 2002  
* All rights reserved.
* 
* Program : CLE Glue Functions for Unix-like Userspace Program
* Abstract :                                                           
*   This file is included by CLE module.
*   This file provides all glue functions that are needed in user-space for CLE shell.
* Author : Yung-Chien Lo (yjlou@realtek.com.tw)
* -------------------------------------------------------
* $Id: cle_userglue.c,v 1.1 2010/05/19 11:15:14 jackey Exp $
*/

#include <rtl_types.h>
#include <rtl_cle.h>
#include <cle_struct.h>
#include <rtl_glue.h>
#include <cle_userglue.h>



#define CMDBUFLEN 1024
#define CLEBUF 1024
static char outbuf[CLEBUF];
char prompt_from_cleParser[CMDBUFLEN >> 2];


/*
 * Modified from show_kernel_info() function in cleshell.c.
 */
int cle_userglue_read( char *prompt_to_cleShell, unsigned long maxlen, char *cmd, char ch )
{

#if 0
	printf( "prompt_from_cleParser:[%s]\n", outbuf );

	strncpy( buf, outbuf, maxlen );
#else
	int len;
	char *sc, *ds;
	
	len = strlen( prompt_from_cleParser );

	/* get prompt from cle */
	for( sc = prompt_from_cleParser, ds = prompt_to_cleShell; 
	     *sc!='\0' && *sc !='\t';
	     sc++, ds++ )
		*ds = *sc;
	sc++; *ds++=' '; *ds = 0; 
	
	/* TAB , ?: copy the info from the kernel to command buffer */
	if ( (len>0) && (ch == '\t' || ch == '?') ) 
	{
		strcpy(cmd, outbuf);
		/*snprintf( cmd, maxlen, "%s\t%s", prompt_from_cleParser, outbuf );*/
	}
	else
	{
		*cmd = 0;
	}
#endif
	return SUCCESS;
}


/*
 * Modified from cle_write() function in cle_linuxglue.c.
 */
int cle_userglue_write( char *ubuf, unsigned long count )
{
	unsigned int outLen;
	
	/* DO special thing */
	switch (ubuf[count-2]) {

	case '\n': /* Get Prompt Only */
		break;
		
	case '\t': /* Tab */
		outLen = CMDBUFLEN;
		ubuf[count-1] = 0;
		cle_setTabMode(0, 1);
		cle_parser(0, ubuf, outbuf, &outLen);
		cle_setTabMode(0, 0);
		break;
		
	case '?':
		outLen = CMDBUFLEN;
		ubuf[count-1] = '\0';
		cle_parser(0, ubuf, outbuf, &outLen);
		break;
		
	default: /* parsing input */

		ubuf[count-1] = 0;
		outLen = CMDBUFLEN;
		cle_parser(0, ubuf, outbuf, &outLen);
		*outbuf = 0;
		
	}

	/* Get UI prompt from cle */
	cle_getPrompt(0, prompt_from_cleParser, (CMDBUFLEN >> 2));

	return 1;
}


int cle_userglue_init()
{
	/* Initialize CLE Module */
	if (cle_init(1, 64, 64) != CLE_INIT_SUCCESS) {
		rtlglue_printf("rtlcle: cle module initial fail !\n");
		return 1;
	}
		
	/* Initialize CLE Root Directory */
	if(CLE_userIdError==cle_initUser("865x", CLE_UI_STYLE_STANDARD_IO, CLE_MODE_PRIVILEGE|CLE_MODE_SUPERENG, 4, cle_newCmdRoot)){
		rtlglue_printf("rtlcle: cle user init failed !\n");
		return 2;
	}

	return 0;
}


