/*
* Copyright c                  Realtek Semiconductor Corporation, 2007
* All rights reserved.
* 
* Program : ASIC Driver header file rtl8651_asicDebug.h to store all debugging related MACROs / UTILITIEs
* Abstract : 
* Creator : Yi-Lun Chen (chenyl@realtek.com.tw)
* Author :  
*
*/

#ifndef RTL8651_ASICDEBUG_H
#define RTL8651_ASICDEBUG_H

/* =====================================================
	Globally controlling definitions
   ===================================================== */
#define RTL_DEBUG_MSG		/* DEFINED: enable debugging message */

#ifdef RTL_DEBUG_MSG


/************************************************************************
 *  Two-dimension for debug information.
 *  Through the following two dimension, severity and module, we can con-
 *  trol the code size of debug information at compile time.
 *
 *  \   Severity    |           RTL_ASIC_MSG_LEVEL_MASK
 *   \________    |
 *   Module   \     | DEBUG | INFO   | NOTICE | WARN | ERR
 *  ___________\|_______|______|________|______|______
 *                       |            |          |               |          |
 *                       |            |          |               |          |
 *   T  ---------+------+------+--------+------+------  
 *   Y                  |            |          |               |           |
 *   P  ---------+------+------+--------+------+------  
 *   E                  |            |          |              |            |
 *      ---------+-------+-----+--------+-------+------
 *   M                 |             |          |              |            |
 *   A  ---------+------+------+--------+------+------  
 *   S                  |           |           |              |            |
 *   K  ---------+------+------+--------+------+------
 *                       |           |           |              |            |
 *
 *  The table follows 'AND' operation: only the debug code with both
 *  level mask and type mask are 1 will be compiled into runtime image.
 *
 ************************************************************************/

/************************************************************************
 *  Definitions for severity.
 *
 *  'RTL_ASIC_MSG_MASK' controls the level of serverity. More severity level
 *  makes larger code size.
 ************************************************************************/
#define RTL_ASIC_MSG_MASK			0xfffffefc

/* by level of importance */
#define RTL_ASIC_MSG_LEVEL_MASK		0x000000ff
#define RTL_ASIC_MSG_DEBUG			(1<<0)
#define RTL_ASIC_MSG_INFO				(1<<1)
#define RTL_ASIC_MSG_NOTICE			(1<<2)
#define RTL_ASIC_MSG_WARN				(1<<3)
#define RTL_ASIC_MSG_ERR				(1<<4)
#define RTL_ASIC_MSG_CRIT				(1<<5)
#define RTL_ASIC_MSG_ALERT				(1<<6)
#define RTL_ASIC_MSG_EMERG			(1<<7)
/* by functionality */
#define RTL_ASIC_MSG_FUNC_MASK		0x0000ff00
#define RTL_ASIC_MSG_TRACE				(1<<8)


/************************************************************************
 *  Definitions for ROME Driver Modules
 *
 *  Please add your module below.
 *
 ************************************************************************/
#define RTL_ASIC_MSG_LINKCTRL					(1<<0)
#define RTL_ASIC_MSG_INIT						(1<<1)
#define RTL_ASIC_MSG_TYPE_MASK				0xffffffff

#endif	/* RTL_DEBUG_MSG */

#if (RTL_ASIC_MSG_MASK & RTL_ASIC_MSG_DEBUG)
#define RTL_ASIC_DEBUG(type, fmt, args...) \
	do {if (type & RTL_ASIC_MSG_TYPE_MASK) rtlglue_printf("(%x)[%s-%d]-debug-: " fmt "\n", type, __FUNCTION__, __LINE__, ## args);} while (0)
#else
#define RTL_ASIC_DEBUG(type, fmt, args...) do {} while(0)
#endif

#if (RTL_ASIC_MSG_MASK & RTL_ASIC_MSG_INFO)
#define RTL_ASIC_INFO(type, fmt, args...) \
	do {if (type & RTL_ASIC_MSG_TYPE_MASK) rtlglue_printf("(%x)[%s-%d]-info-: " fmt "\n", type, __FUNCTION__, __LINE__, ## args);} while (0)
#else
#define RTL_ASIC_INFO(type, fmt, args...) do {} while(0)
#endif

#if (RTL_ASIC_MSG_MASK & RTL_ASIC_MSG_NOTICE)
#define RTL_ASIC_NOTICE(type, fmt, args...) \
	do {if (type & RTL_ASIC_MSG_TYPE_MASK) rtlglue_printf("(%x)[%s-%d]-notice-: " fmt "\n", type, __FUNCTION__, __LINE__, ## args);} while (0)
#else
#define RTL_ASIC_NOTICE(type, fmt, args...) do {} while(0)
#endif

#if (RTL_ASIC_MSG_MASK & RTL_ASIC_MSG_WARN)
#define RTL_ASIC_WARN(type, fmt, args...) \
	do {if (type & RTL_ASIC_MSG_TYPE_MASK) rtlglue_printf("(%x)[%s-%d]-warning-: " fmt "\n", type, __FUNCTION__, __LINE__, ## args);} while (0)
#else
#define RTL_ASIC_WARN(type, fmt, args...) do {} while(0)
#endif

#if (RTL_ASIC_MSG_MASK & RTL_ASIC_MSG_ERR)
#define RTL_ASIC_ERR(type, fmt, args...) \
	do {if (type & RTL_ASIC_MSG_TYPE_MASK) rtlglue_printf("[=!!Error !!=] =>\n\t(%x)[%s-%d]: " fmt "\n", type, __FUNCTION__, __LINE__, ## args);} while (0)
#else
#define RTL_ASIC_ERR(type, fmt, args...) do {} while(0)
#endif

#if (RTL_ASIC_MSG_MASK & RTL_ASIC_MSG_CRIT)
#define RTL_ASIC_CRIT(type, fmt, args...) \
	do {if (type & RTL_ASIC_MSG_TYPE_MASK) rtlglue_printf("[=!!Critical !!=] =>\n\t(%x)[%s-%d]: " fmt "\n", type, __FUNCTION__, __LINE__, ## args);} while (0)
#else
#define RTL_ASIC_CRIT(type, fmt, args...) do {} while(0)
#endif

#if (RTL_ASIC_MSG_MASK & RTL_ASIC_MSG_ALERT)
#define RTL_ASIC_ALERT(type, fmt, args...) \
	do {if (type & RTL_ASIC_MSG_TYPE_MASK) rtlglue_printf("[=!!Alert !!=] =>\n\t(%x)[%s-%d]: " fmt "\n", type, __FUNCTION__, __LINE__, ## args);} while (0)
#else
#define RTL_ASIC_ALERT(type, fmt, args...) do {} while(0)
#endif

#if (RTL_ASIC_MSG_MASK & RTL_ASIC_MSG_EMERG)
#define RTL_ASIC_EMERG(type, fmt, args...) \
	do {if (type & RTL_ASIC_MSG_TYPE_MASK) rtlglue_printf("[=!!Emergency !!=] =>\n\t(%x)[%s-%d]: " fmt "\n", type, __FUNCTION__, __LINE__, ## args);} while (0)
#else
#define RTL_ASIC_EMERG(type, fmt, args...) do {} while(0)
#endif

#if (RTL_ASIC_MSG_MASK & RTL_ASIC_MSG_TRACE)
#define RTL_ASIC_TRACE_IN(type, fmt, args...) \
	do {if (type & RTL_ASIC_MSG_TYPE_MASK) rtlglue_printf("=TRACE IN=(%x)[%s-%d]: " fmt "\n", type, __FUNCTION__, __LINE__, ## args);} while (0)
#define RTL_ASIC_TRACE_OUT(type, fmt, args...) \
	do {if (type & RTL_ASIC_MSG_TYPE_MASK) rtlglue_printf("=TRACE OUT=(%x)[%s-%d]: " fmt "\n", type, __FUNCTION__, __LINE__, ## args);} while (0)
#else
#define RTL_ASIC_TRACE_IN(type, fmt, args...) do {} while(0)
#define RTL_ASIC_TRACE_OUT(type, fmt, args...) do {} while(0)
#endif

#define RTL_ASIC_BUG(cause) \
	do {rtlglue_printf(" [= !! BUG !! =] at %s line %d\n\t=> Cause: %s\n\t=>-- system Halt\n", __FUNCTION__, __LINE__, cause); while(1);} while (0)

#endif /* RTL8651_ASICDEBUG_H */


