/*
*-------------------------------------------------------------------------
* Copyright c                  Realtek Semiconductor Corporation, 2002
* All rights reserved.
* 
* $Header: /cvsroot/Realtek/RTL8196B/kernels/linux-2.6.x/drivers/net/re865x/AsicDriver/hs.c,v 1.1 2010/05/19 11:14:57 jackey Exp $
*
* Abstract: This file provides header stamp access routines.
*
* $Author: jackey $
*
* $Log: hs.c,v $
* Revision 1.1  2010/05/19 11:14:57  jackey
* *** empty log message ***
*
* Revision 1.13  2007/05/04 05:03:26  yjlou
* -: remove -Wno-implicit in Makefile on 865xB platform.
*
* Revision 1.12  2006/12/04 07:44:49  alva_zhang
* replace all printk with rtlglue_printf
*
* Revision 1.11  2004/07/23 13:42:45  tony
* *: remove all warning messages
*
* Revision 1.10  2004/05/03 14:38:23  cfliu
* no message
*
* Revision 1.9  2004/04/20 03:44:02  tony
* if disable define "RTL865X_OVER_KERNEL" and "RTL865X_OVER_LINUX", __KERNEL__ and __linux__ will be undefined.
*
* Revision 1.8  2004/04/08 13:18:12  tony
* add PPTP/L2TP routine for MII lookback port.
*
* Revision 1.7  2004/04/08 02:12:22  chhuang
* modify hsa and hsb
*
* Revision 1.6  2004/04/02 06:44:08  jzchen
* Support both A version and B version
*
* Revision 1.5  2004/04/01 03:32:37  jzchen
* Change header stamp dump to 8650B format
*
* Revision 1.4  2004/03/31 15:29:08  jzchen
* Add new field and all message dumped are 8650B
*
* Revision 1.3  2004/03/26 11:25:44  cfliu
* Add hsb_dport(). Layer2fwd.c still needs it.
*
* Revision 1.2  2004/03/26 07:12:13  danwu
* add hs_cmdSetHsb routine
* allow parsing header stamps not directly read from asic
*
* Revision 1.1  2004/03/03 10:40:38  yjlou
* *: commit for mergence the difference in rtl86xx_tbl/ since 2004/02/26.
*
* Revision 1.1  2004/02/26 04:27:57  cfliu
* move hs.* into table driver directory
*
* Revision 1.1  2004/02/24 03:04:37  cfliu
* no message
*
* Revision 1.1  2003/12/23 14:41:34  cfliu
* rtl8651 wlan acceleration prototype.
*
* Revision 1.21  2003/09/26 07:08:51  danwu
* add llc_other and url_trap fields in HSB
*
* Revision 1.20  2003/09/23 09:51:20  danwu
* parse cpu reason following hsa
*
* Revision 1.19  2003/09/15 07:45:04  danwu
* no message
*
* Revision 1.18  2003/09/04 00:33:56  danwu
* replace cpuAcl with cpursn2
*
* Revision 1.17  2003/07/25 02:37:17  danwu
* no message
*
* Revision 1.16  2003/06/18 06:21:00  danwu
* no message
*
* Revision 1.15  2003/06/16 11:13:55  danwu
* add RTL8651 support for HSB
*
* Revision 1.14  2003/06/16 03:46:19  danwu
* no message
*
* Revision 1.13  2003/06/16 03:33:07  danwu
* remove directory of asicregs.h and let makefile decides the path according to
* chip
*
* Revision 1.12  2003/06/16 03:00:14  cfliu
* update HSA dump command
*
* Revision 1.11  2003/04/30 15:25:08  cfliu
* remove rtl_debug.h
*
* Revision 1.10  2002/10/15 04:25:21  henryCho
* Correct hs_readHsb(): update hsbWatch.ethrtype to a correct value.
*
* Revision 1.9  2002/10/07 15:12:57  henryCho
* = -> :
*
* Revision 1.8  2002/10/03 12:42:59  henryCho
* add l3ok and l4ok in hs_param_t.
*
* Revision 1.7  2002/09/25 13:33:59  waynelee
* add hs_dumpHsb(), hs_dumpHsa(), hs_dumpHsb_S() and hs_dumpHsa_S(),
* and change the arguments of hs_readHsb() and hs_readHsa()
*
* Revision 1.6  2002/09/24 07:28:53  henryCho
* Correct header stamp structure.
*
* Revision 1.5  2002/09/19 09:37:21  danwu
* no message
*
* Revision 1.4  2002/09/18 01:08:34  danwu
* Add hs_cmdDumpHsbHsa().
*
* Revision 1.3  2002/08/29 08:34:58  henryCho
* Adjust output.
*
* Revision 1.2  2002/08/28 03:51:08  orlando
* Add #include <sys/rtl_debug.h>.
*
* Revision 1.1  2002/08/28 03:31:51  orlando
* Header stamp access module.
*
*-------------------------------------------------------------------------
*/
#include "rtl_types.h"
#include "rtl_utils.h"
#include <linux/string.h>
#include "types.h"
#include "hsRegs.h"
#include "asicRegs.h"
#include "assert.h"
#include "hs.h"

#define DEBUGMSG( format )	        (rtlglue_printf format)
//#define DEBUGMSG( format )

/* STATIC VARIABLE DECLARATIONS
 */
hsb_param_t hsbParam;
hsa_param_t hsaParam;

hsb_param_watch_t hsbWatch;
hsa_param_watch_t hsaWatch;


/* LOCAL SUBPROGRAM SPECIFICATIONS
 */


/* PROGRAM BODY
*/

/* read header-stamp-before */
void hs_readHsb(hsb_param_watch_t *hsbWatch, hsb_param_t *hsbParam)
{
	uint32 v32;
	//uint16 v16;
	uint32 m[6]; // for mac address
	uint32 a[4]; // for ip address
	uint32 i=0;

	/* clear data structure */	
	memset((void *)hsbWatch, 0, sizeof(hsb_param_watch_t));
	
	hsbWatch->type = (uint32)hsbParam->type;
	hsbWatch->spa = (uint32)hsbParam->spa;
	hsbWatch->bc = (uint32)hsbParam->bc;
	hsbWatch->vlan = (uint32)hsbParam->vlan;
	hsbWatch->pppoe = (uint32)hsbParam->pppoe;
	hsbWatch->llc = (uint32)hsbParam->llc;
	
	// Protocol contents
	hsbWatch->vid = (uint32)hsbParam->vid;
	//v32_2 = (hsbParam.da47_28 >> 4);       // 47-32 (16)
	//v32  = (hsbParam.da47_28 & 0xf) << 28; // 31-28 (4)
	//v32 |= | hsbParam.da27_0;              // 27-0  (28)
	memset((void *)m, 0, sizeof(m));
	m[0] =  (hsbParam->da47_20 & 0x0ff00000) >> 20;
	m[1] =  (hsbParam->da47_20 & 0x000ff000) >> 12;
	m[2] =  (hsbParam->da47_20 & 0x00000ff0) >> 4 ;
	m[3] =  (hsbParam->da47_20 & 0x0000000f) << 4 ;
	m[3] |= (hsbParam->da19_0  & 0x000f0000) >> 16;
	m[4] =  (hsbParam->da19_0  & 0x0000ff00) >> 8 ;
	m[5] =  (hsbParam->da19_0  & 0x000000ff)      ;
	#if 0
	m[0] =  (hsbParam.da27_0  & 0x0ff00000) >> 20;
	m[1] =  (hsbParam.da27_0  & 0x000ff000) >> 12;
	m[2] =  (hsbParam.da27_0  & 0x00000ff0) >> 4 ;
	m[3] =  (hsbParam.da27_0  & 0x0000000f) << 4 ;
	m[3] |= (hsbParam.da47_28 & 0x000f0000) >> 16;
	m[4] = (hsbParam.da47_28 & 0x0000ff00) >> 8 ;
	m[5] = (hsbParam.da47_28 & 0x000000ff)      ;
	#endif
	for (i=0; i<6; i++)
	{
		hsbWatch->da[i] = m[i];
	}
	
	//v32_2 =  (hsbParam.sa47_44 << 12); // 47-44 (4)
	//v32_2 |= (hsbParam.sa43_12 >> 20); // 43-32 (12)
	//v32 = (hsbParam.sa43_12 << 12);    // 31-12 (20)
	//v32 =| hsbParam.sa11_0;            // 11-0  (12)
	memset((void *)m, 0, sizeof(m));
	m[0] =  (hsbParam->sa47_36 & 0x00000ff0) >> 4;
	m[1] =  (hsbParam->sa47_36 & 0x0000000f) << 4;
	m[1] |= (hsbParam->sa35_4  & 0xf0000000) >> 28;
	m[2] =  (hsbParam->sa35_4  & 0x0ff00000) >> 20;
	m[3] =  (hsbParam->sa35_4  & 0x000ff000) >> 12;
	m[4] =  (hsbParam->sa35_4  & 0x00000ff0) >>  4;
	m[5] =  (hsbParam->sa35_4  & 0x0000000f) <<  4;
	m[5] |= (hsbParam->sa3_0   & 0x0000000f);
	#if 0
	m[0] =  (hsbParam.sa11_0  & 0x00000ff0  ) >> 4 ;
	m[1] =  (hsbParam.sa11_0  & 0x0000000f  ) << 4 ;
	m[1] |= (hsbParam.sa43_12 & 0xf0000000  ) >> 28;
	m[2] =  (hsbParam.sa43_12 & 0x0ff00000  ) >> 20;
	m[3] =  (hsbParam.sa43_12 & 0x000ff000  ) >> 12;
	m[4] =  (hsbParam.sa43_12 & 0x00000ff0  ) >> 4 ;
	m[5] =  (hsbParam.sa43_12 & 0x0000000f  ) << 4 ;
	m[5] |= (hsbParam.sa47_44 & 0x0000000f  );
	#endif
	for (i=0; i<6; i++)
	{
		hsbWatch->sa[i] = m[i];
	}
	v32 = (hsbParam->ethrtype15_4 << 4) | hsbParam->ethrtype3_0;
	hsbWatch->ethrtype = v32;
	//v32 = ( (hsbParam.ethrtype11_0 & 0x00000fff) << 4) | (hsbParam.ethrtype15_12 & 0x0000000f);
	
	//v32 = (hsbParam.sip31_29 << 29) | hsbParam.sip28_0;
	memset((void *)a, 0, sizeof(a));
	//a[0] =  hsbParam.sip31_29 << 5;
	//a[0] |= (hsbParam.sip28_0 & 0x1f000000) >> 24;
	//a[1] =  (hsbParam.sip28_0 & 0x00ff0000) >> 16;
	//a[2] =  (hsbParam.sip28_0 & 0x0000ff00) >> 8 ;
	//a[3] =  (hsbParam.sip28_0 & 0x000000ff)      ;
	a[0] =  (uint32)((hsbParam->sip31_3 & 0x1fE00000) >> 21);
	a[1] =  (uint32)((hsbParam->sip31_3 & 0x001fE000) >> 13);
	a[2] =  (uint32)((hsbParam->sip31_3 & 0x00001fE0) >> 5 );
	a[3] =  (uint32)((hsbParam->sip31_3 & 0x0000001f) << 3 );
	a[3] |= (uint32)((hsbParam->sip2_0)                  );
	for (i=0; i<4; i++)
	{
		hsbWatch->sip[i] = a[i];
	}
	
	v32 = (hsbParam->sprt15_3 << 3) | hsbParam->sprt2_0;
	//v32 = (hsbParam.sprt12_0 << 3) | hsbParam.sprt15_13;
	hsbWatch->sprt = (uint32)v32;
	
	//v32 = (hsbParam.dip31_13 << 13) | hsbParam.dip12_0;
	memset((void *)a, 0, sizeof(a));
	a[0] =  (hsbParam->dip31_19 & 0x00001fe0) >>  5;
	a[1] =  (hsbParam->dip31_19 & 0x0000001f) <<  3;
	a[1] |= (hsbParam->dip18_0  & 0x00070000) >> 16;
	a[2] =  (hsbParam->dip18_0  & 0x0000ff00) >> 8 ;
	a[3] =  (hsbParam->dip18_0  & 0x000000ff)      ;
	#if 0
	a[0] =   hsbParam->dip12_0 >> 5 ;
	a[1] =  (hsbParam->dip12_0  & 0x0000001f) << 3 ;
	a[1] |= (hsbParam->dip31_13 & 0x00070000) >> 16;
	a[2] =  (hsbParam->dip31_13 & 0x0000ff00) >> 8 ;
	a[3] =  (hsbParam->dip31_13 & 0x000000ff)      ;
	#endif
	for (i=0; i<4; i++)
	{
		hsbWatch->dip[i] = a[i];
	}
		
	hsbWatch->dprt = (uint32)hsbParam->dprt;
	
	v32 = (hsbParam->ipptl7_3 << 3) | hsbParam->ipptl2_0;
	//v32 = (hsbParam.ipptl4_0 & 0x0000001f)<< 3 | (hsbParam.ipptl7_5 & 0x00000007);
	hsbWatch->ipptl = (uint32)v32;
	hsbWatch->ipflg = (uint32)hsbParam->ipflg;
	hsbWatch->iptos = (uint32)hsbParam->iptos;
	hsbWatch->tcpflg = (uint32)hsbParam->tcpflg;
	
	hsbWatch->dirtx = (uint32)hsbParam->dirtx;
	hsbWatch->prtnmat = (uint32)hsbParam->prtnmat;
       
	hsbWatch->udp_nocs = (uint32)hsbParam->udp_nocs;
	hsbWatch->ttlst = (uint32)hsbParam->ttlst;
	hsbWatch->pktend = (uint32)hsbParam->pktend;
	
	hsbWatch->hp = (uint32)hsbParam->hp;
	hsbWatch->hp2 = (uint32)hsbParam->hp2;
	hsbWatch->dp = (uint32)hsbParam->dp;
	
	hsbWatch->l4crcok = (uint32)hsbParam->l4crcok;
	hsbWatch->l3crcok = (uint32)hsbParam->l3crcok;
	hsbWatch->ipfragif = (uint32)hsbParam->ipfragif;

//#ifdef RTL8651B
	hsbWatch->ext_srcPrt = (uint32)(hsbParam->ext_srcPrtH<<1 | hsbParam->ext_srcPrtL);
	hsbWatch->cpu_l2 = (uint32)hsbParam->cpu_l2;
	hsbWatch->llc_other = (uint32)hsbParam->llc_other;
	hsbWatch->urltrap = (uint32)hsbParam->urltrap;
	hsbWatch->pppoesid = (uint32)hsbParam->pppoesid;
	hsbWatch->aDp = (uint32)(hsbParam->pppoesid >> 8)&0x7f;
	hsbWatch->aHp2 = (uint32)(hsbParam->pppoesid >> 15)&0x1;
//#endif /*RTL8651B*/

} /* end hs_readHsb */

uint32 hsb_aDport(void){
	memset((void *)&hsbParam, 0, sizeof(hsbParam));
	/* read HSB */
	memcpy((void *)&hsbParam,(void *)HSB_BASE, sizeof(hsb_param_t));
	hs_readHsb(&hsbWatch, &hsbParam);
	return hsbWatch.aDp;
}

uint32 hsb_dport(int32 flag){
	memset((void *)&hsbParam, 0, sizeof(hsbParam));
	/* read HSB */
	memcpy((void *)&hsbParam,(void *)HSB_BASE, sizeof(hsb_param_t));
	hs_readHsb(&hsbWatch, &hsbParam);
	if(flag)
		return hsbWatch.dp; //dport of ver B
	return hsbWatch.aDp; //dport of ver A
}

/* dump it to the console (formatted) */
void hs_displayHsb(hsb_param_watch_t * hsbWatch)
{
	int32	i=0;
	
	DEBUGMSG(("---------------------------- BEGIN HSB-----------------------------\n"));
	switch(hsbWatch->type) {
		case 0:	DEBUGMSG(("Packet Type Ethernet, ")); break;
		case 1:	DEBUGMSG(("Packet Type PPTP, ")); break;
		case 2:	DEBUGMSG(("Packet Type IP, ")); break;
		case 3:	DEBUGMSG(("Packet Type ICMP, ")); break;
		case 4:	DEBUGMSG(("Packet Type IGMP, ")); break;
		case 5:	DEBUGMSG(("Packet Type TCP, ")); break;
		case 6:	DEBUGMSG(("Packet Type UDP, ")); break;
		default:	DEBUGMSG(("Packet Unknown Type: %d, ",hsbWatch->type)); break;
	}
	if(hsbWatch->spa<7)
		DEBUGMSG(("source port: Physical port %d, ",hsbWatch->spa));
	else if(hsbWatch->ext_srcPrt<3)
		DEBUGMSG(("source port: Extension port %d, ",hsbWatch->ext_srcPrt));
	else
		DEBUGMSG(("source port: CPU, "));
	DEBUGMSG(("bytecount: %d (0x%x)\n",hsbWatch->bc,hsbWatch->bc));
	DEBUGMSG(("Layer2 Format %s",hsbWatch->vlan?"VLAN":"NoVLAN"));
	if(hsbWatch->vlan)
		DEBUGMSG((" ID: %d (0x%x)",hsbWatch->vid,hsbWatch->vid));
	DEBUGMSG((", %s, %s", hsbWatch->llc?"LLC":"NoLLC", hsbWatch->pppoe?"PPPoE":"NoPPPoE"));
	//if(hsbWatch->pppoesid)
		DEBUGMSG(("ID: %d (0x%x), ", hsbWatch->pppoesid, hsbWatch->pppoesid));
	DEBUGMSG(("\n"));
	
	// Protocol contents
	DEBUGMSG((("DMAC: ")));
	for (i=0; i<6; i++)
		DEBUGMSG(("%02x%s", hsbWatch->da[i], i<5?"-":""));
	DEBUGMSG((", "));
	
	DEBUGMSG(("SMAC: "));
	for (i=0; i<6; i++)
		DEBUGMSG(("%02x%s", hsbWatch->sa[i], i<5?"-":""));
	DEBUGMSG(("\n"));
	DEBUGMSG(("%s, ",hsbWatch->dirtx?"DirectTX":"FromPHY"));
	if(hsbWatch->dirtx) {
		DEBUGMSG(("L3 Checksum %x ", hsbWatch->sprt));
		DEBUGMSG(("L4 Checksum %x\n", hsbWatch->dprt));
		DEBUGMSG(("Reason %x ", hsbWatch->iptos));
		if((hsbWatch->ethrtype>>3)&0x1) 
			DEBUGMSG(("Add PPPoE Header ID: %d\n", hsbWatch->ethrtype&0x7));
		if((hsbWatch->pppoesid>>3)&0x1)
			DEBUGMSG(("Add VLAN Header ID: %d\n", hsbWatch->pppoesid&0x7));
		else
			DEBUGMSG(("\n"));
		DEBUGMSG(("Specify output port: "));
		for(i=0;i<6;i++)
			if((hsbWatch->pppoesid>>5)&(1<<i))
				DEBUGMSG(("%d ",i));
		if(hsbWatch->pppoesid>>11)	
			DEBUGMSG(("CPU\n"));
		else
			DEBUGMSG(("\n"));
			

		if(hsbWatch->spa== 7 && hsbWatch->ext_srcPrt) {//Only from extension port, the cpu_l2 has meaning
			if(hsbWatch->cpu_l2)
				DEBUGMSG(("CPU Send with Layer2 action"));
			else
				DEBUGMSG(("CPU Send with Multi-layer action"));
		}
	}
	else {
		DEBUGMSG(("ethertype: %d (0x%x)",hsbWatch->ethrtype,hsbWatch->ethrtype));
		
		DEBUGMSG(("sip: "));
		for (i=0; i<4; i++)
			DEBUGMSG(("%d%s", hsbWatch->sip[i], i<3?".":""));
		DEBUGMSG((", "));
		
		DEBUGMSG(("sprt (ICMP ID, L3 Checksum): %d 0x%x\n",(int)hsbWatch->sprt,(int)hsbWatch->sprt));
		
		DEBUGMSG(("dip: "));
		for (i=0; i<4; i++)
			DEBUGMSG(("%d%s", hsbWatch->dip[i], i<3?".":""));
		DEBUGMSG((", "));
			
		DEBUGMSG(("dprt: %d 0x%x \n",hsbWatch->dprt,hsbWatch->dprt));
		
		DEBUGMSG(("ip protocol (ICMP, IGMP Type): %d 0x%x, ",(int)hsbWatch->ipptl,(int)hsbWatch->ipptl));
		DEBUGMSG(("ip flag: %d 0x%x, ",hsbWatch->ipflg,hsbWatch->ipflg));
		DEBUGMSG(("ip tos: %d 0x%x\n",hsbWatch->iptos,hsbWatch->iptos));
		DEBUGMSG(("tcp flag: %d 0x%x, ",hsbWatch->tcpflg,hsbWatch->tcpflg));
		
		DEBUGMSG(("PatternMatch: %d, ",hsbWatch->prtnmat));
	       
		DEBUGMSG(("udp_nocs: %d\n",hsbWatch->udp_nocs));
		if(hsbWatch->ttlst == 2)
			DEBUGMSG(("TTL > 1,"));
		else
			DEBUGMSG(("TTL %x, ",hsbWatch->ttlst));
		DEBUGMSG(("pktend: %d, ",hsbWatch->pktend));

		DEBUGMSG(("Packet is %s priority",hsbWatch->hp?"High":"Low"));
		DEBUGMSG((" L3CSOK:%d, L4CSOK:%d, IPFRAGIF:%d",hsbWatch->l3crcok,hsbWatch->l4crcok,hsbWatch->ipfragif));
		DEBUGMSG(("\n"));

		DEBUGMSG(("LLC_Other_IF: %d, ",hsbWatch->llc_other));
		DEBUGMSG(("URL_Trap: %d\n",hsbWatch->urltrap));
	}
	DEBUGMSG(("----------------(A ver) OUTPUT INFO IN HSB----------------------------\n%s priority on output queue ",hsbWatch->hp2?"High":"Low"));
	DEBUGMSG(("Dest Port: "));
	for(i=0; i<6; i++)
		if(hsbWatch->aDp & (1<<i))
			DEBUGMSG(("%d ", i));
	if(	hsbWatch->aDp & 0x40)
		DEBUGMSG(("CPU "));
	DEBUGMSG(("\n"));
	DEBUGMSG(("----------------(B ver) OUTPUT INFO IN HSB----------------------------\n%s priority on output queue ",hsbWatch->hp2?"High":"Low"));
	DEBUGMSG(("Dest Port: "));
	for(i=0; i<6; i++)
		if(hsbWatch->dp & (1<<i))
			DEBUGMSG(("%d ", i));
	if(	hsbWatch->aDp & 0x40)
		DEBUGMSG(("CPU "));
	DEBUGMSG(("\n"));
		
}
/* dump all fields to one string */

void hs_displayHsb_S(hsb_param_watch_t * hsbWatch)
{

	DEBUGMSG(("HSB("));
	DEBUGMSG(("type:%d,",hsbWatch->type));
	DEBUGMSG(("spa:%d,",hsbWatch->spa));
	DEBUGMSG(("bc:%d,",hsbWatch->bc));
	DEBUGMSG(("vlan:%d,",hsbWatch->vlan));
	DEBUGMSG(("pppoe:%d,",hsbWatch->pppoe));
	DEBUGMSG(("llc:%d,",hsbWatch->llc));
	
	// Protocol contents
	DEBUGMSG(("vid:%d,",hsbWatch->vid));
	DEBUGMSG(("da:%02x-%02x-%02x-%02x-%02x-%02x,",hsbWatch->da[0],hsbWatch->da[1],hsbWatch->da[2],hsbWatch->da[3],hsbWatch->da[4],hsbWatch->da[5]));
	DEBUGMSG(("sa:%02x-%02x-%02x-%02x-%02x-%02x,",hsbWatch->sa[0],hsbWatch->sa[1],hsbWatch->sa[2],hsbWatch->sa[3],hsbWatch->sa[4],hsbWatch->sa[5]));
	
	//v32 = (hsbWatch->ethrtype15_12 << 12) | hsbWatch->ethrtype11_0;
	DEBUGMSG(("ethrtype:0x%04x,",hsbWatch->ethrtype));
	DEBUGMSG(("sip:%d.%d.%d.%d,",hsbWatch->sip[0],hsbWatch->sip[1],hsbWatch->sip[2],hsbWatch->sip[3]));
	DEBUGMSG(("sprt:%d,",(int)hsbWatch->sprt));
	
	DEBUGMSG(("dip:%d.%d.%d.%d,",hsbWatch->dip[0],hsbWatch->dip[1],hsbWatch->dip[2],hsbWatch->dip[3]));
		
	DEBUGMSG(("dprt:%d,",hsbWatch->dprt));
	
	DEBUGMSG(("ipptl:%d,",(int)hsbWatch->ipptl));
	DEBUGMSG(("ipflg:%d,",hsbWatch->ipflg));
	DEBUGMSG(("iptos:%d,",hsbWatch->iptos));
	DEBUGMSG(("tcpflg:%d,",hsbWatch->tcpflg));
	
	DEBUGMSG(("dirtx:%d,",hsbWatch->dirtx));
	DEBUGMSG(("prtnmat:%d,",hsbWatch->prtnmat));
       
	DEBUGMSG(("udp_nocs:%d,",hsbWatch->udp_nocs));
	DEBUGMSG(("ttlst:0x%x,",hsbWatch->ttlst));
	DEBUGMSG(("pktend:%d,",hsbWatch->pktend));
	
	DEBUGMSG(("hp:%d,",hsbWatch->hp));
	DEBUGMSG(("hp2:%d,",hsbWatch->hp2));
	DEBUGMSG(("dp:0x%x,",hsbWatch->dp));
	DEBUGMSG(("l3csok:%d,l4csok:%d,ipfragif:%d",hsbWatch->l3crcok,hsbWatch->l4crcok,hsbWatch->ipfragif));
	
//#ifdef RTL8651B
	DEBUGMSG((",extspa:%d,",hsbWatch->ext_srcPrt));
	DEBUGMSG(("cpul2:%d,",hsbWatch->cpu_l2));
	DEBUGMSG(("llc_other:%d,",hsbWatch->llc_other));
	DEBUGMSG(("url_trap:%d",hsbWatch->urltrap));
//#endif /*RTL8651B*/

	DEBUGMSG((")\n"));
}

/* read header-stamp-after */
void hs_readHsa(hsa_param_watch_t *hsaWatch, hsa_param_t *hsaParam)
{
	//uint32 v32;
	uint16 v16;
	uint32 m[6]; // for mac address
	uint32 a[4]; // for ip address	
	uint32 i=0;

	/* clear data structure */	
	memset((void *)hsaWatch, 0, sizeof(hsa_param_watch_t));
	
	memset((void *)m, 0, sizeof(m));
	m[0] =  (hsaParam->mac47_32 & 0x0000ff00) >> 8 ;
	m[1] =  (hsaParam->mac47_32 & 0x000000ff)      ;
	m[2] =  (hsaParam->mac31_0  & 0xff000000) >> 24;
	m[3] =  (hsaParam->mac31_0  & 0x00ff0000) >> 16;
	m[4] =  (hsaParam->mac31_0  & 0x0000ff00) >> 8 ;
	m[5] =   hsaParam->mac31_0  & 0x000000ff       ;
	#if 0
	m[0] =  hsaParam.mac15_0 >> 8                 ;
	m[1] =  hsaParam.mac15_0 & 0x000000ff         ;
	m[2] =  hsaParam.mac47_16 >> 24               ;
	m[3] =  (hsaParam.mac47_16 & 0x00ff0000) >> 16;
	m[4] =  (hsaParam.mac47_16 & 0x0000ff00) >> 8 ;
	m[5] =  hsaParam.mac47_16  & 0x000000ff       ;
	#endif
	for (i=0; i<6; i++)
	{
		hsaWatch->mac[i] = m[i];
	}

	memset((void *)a, 0, sizeof(a));
	a[0] =  hsaParam->ip31_16 >> 8;
	a[1] =  hsaParam->ip31_16 & 0x00ff; 
	a[2] =  hsaParam->ip15_0  >> 8;
	a[3] =  hsaParam->ip15_0  & 0x00ff;
	#if 0
	a[0] =  hsaParam.ip15_0  >> 8;
	a[1] =  hsaParam.ip15_0  & 0x00ff; 
	a[2] =  hsaParam.ip31_16 >> 8;
	a[3] =  hsaParam.ip31_16 & 0x00ff;
	#endif
	for (i=0; i<4; i++)
	{
		hsaWatch->ip[i] = a[i];
	}
	
	hsaWatch->prt = (uint32)hsaParam->prt;
	hsaWatch->l3cs = (uint32)hsaParam->l3cs;
	hsaWatch->l4cs = (uint32)hsaParam->l4cs;
	hsaWatch->egress = (uint32)hsaParam->egress;
	hsaWatch->l2act = (uint32)hsaParam->l2act;
	hsaWatch->l34act = (uint32)hsaParam->l34act;
	hsaWatch->dirtx = (uint32)hsaParam->dirtx;
	hsaWatch->type = (uint32)hsaParam->type;
	hsaWatch->llc = (uint32)hsaParam->llc;
	hsaWatch->vlan = (uint32)hsaParam->vlan;
	hsaWatch->dvid = (uint32)hsaParam->dvid;
	hsaWatch->pppoe = (uint32)hsaParam->pppoe;
	hsaWatch->pppid = (uint32)hsaParam->pppid;
	hsaWatch->ttl_1 = (uint32)hsaParam->ttl_1;
	hsaWatch->dpc = (uint32)hsaParam->dpc;

	v16 = 0;
	v16 =  hsaParam->bc10_5 << 5;
	v16 |= hsaParam->bc4_0;
	//v16 =  hsaParam.bc5_0 << 10;
	//v16 |= hsaParam.bc10_6 ;
	hsaWatch->bc = (uint32)v16;

//#ifndef RTL8651B
//	hsaWatch->pktend = (uint32)hsaParam->pktend;
//#else
	hsaWatch->l3CrcOk = (uint32)hsaParam->l3CrcOk;
	hsaWatch->l4CrcOk = (uint32)hsaParam->l4CrcOk;
	hsaWatch->frag = (uint32)hsaParam->frag;
	hsaWatch->lastFrag = (uint32)hsaParam->lastFrag;
	hsaWatch->extSpa = (uint32)hsaParam->extSpa;
	hsaWatch->dExtPrt = (uint32)hsaParam->dExtPrt;
//#endif
	hsaWatch->mulcst = (uint32)hsaParam->mulcst;
	hsaWatch->svid = (uint32)hsaParam->svid;
	hsaWatch->cpursn = (uint32)hsaParam->cpursn;
	hsaWatch->spa = (uint32)hsaParam->spa;
	
//#ifdef RTL8651B
	hsaWatch->ext_ttl_1if = (uint32)hsaParam->ext_ttl_1if;
	hsaWatch->cpursn2 = (uint32)hsaParam->cpursn2;
//#endif /*RTL8651B*/

} /* end hs_readHsa */

/* dump it to the console */

void hs_displayHsa(hsa_param_watch_t *hsaWatch)
{
	int32	i=0;

	DEBUGMSG(("------------------------ BEGIN HSA--------------------------------\n"));

	switch(hsaWatch->type) {
		case 0:	DEBUGMSG(("Packet Type Ethernet, ")); break;
		case 1:	DEBUGMSG(("Packet Type PPTP, ")); break;
		case 2:	DEBUGMSG(("Packet Type IP, ")); break;
		case 3:	DEBUGMSG(("Packet Type ICMP, ")); break;
		case 4:	DEBUGMSG(("Packet Type IGMP, ")); break;
		case 5:	DEBUGMSG(("Packet Type TCP, ")); break;
		case 6:	DEBUGMSG(("Packet Type UDP, ")); break;
		default:	DEBUGMSG(("Packet Unknown Type: %d, ",hsaWatch->type)); break;
	}
	DEBUGMSG(("%s, ",hsaWatch->dirtx?"DirectTX":"FromPHY"));
	if(hsaWatch->dirtx) {
		
		}
	else {
		}
	DEBUGMSG(("\nDMAC: "));
	for (i=0; i<6; i++)
	{
		DEBUGMSG(("%02x%s", hsaWatch->mac[i], i<5?"-":""));
	}
	DEBUGMSG((", "));

	DEBUGMSG(("New IP: "));
	for (i=0; i<4; i++)
	{
		DEBUGMSG(("%d%s", hsaWatch->ip[i], i<3?".":""));
	}
	DEBUGMSG((", "));
	DEBUGMSG(("L4 Port/ID: %d\n",hsaWatch->prt));
	DEBUGMSG(("L3cksum Delta: %x, ",hsaWatch->l3cs));
	DEBUGMSG(("L4cksum Delta: %x, ",hsaWatch->l4cs));
	DEBUGMSG(("egress: %d, ",hsaWatch->egress));
	DEBUGMSG(("l2act: %d, ",hsaWatch->l2act));
	DEBUGMSG(("l34act: %d\n",hsaWatch->l34act));
	DEBUGMSG(("llc: %d, ",hsaWatch->llc));
	DEBUGMSG(("vlan: %d, ",hsaWatch->vlan));
	DEBUGMSG(("dvid: %d\n ",hsaWatch->dvid));
	DEBUGMSG(("pppoe: %d, ",hsaWatch->pppoe));
	DEBUGMSG(("pppid: %d, ",hsaWatch->pppid));
	DEBUGMSG(("ttl_1: 0x%x, ",hsaWatch->ttl_1));
	DEBUGMSG(("dpc: %d \n",hsaWatch->dpc));

	DEBUGMSG(("bc: %d 0x%x, ",hsaWatch->bc,hsaWatch->bc));

	DEBUGMSG(("l3CrcOk: %d, ",hsaWatch->l3CrcOk));
	DEBUGMSG(("l4CrcOk: %d, ",hsaWatch->l4CrcOk));
	DEBUGMSG(("frag: %d, ",hsaWatch->frag));
	DEBUGMSG(("lastFrag: %d, ",hsaWatch->lastFrag));
	DEBUGMSG(("extSpa: %d, ",hsaWatch->extSpa));
	DEBUGMSG(("dExtPrt: %d\n",hsaWatch->dExtPrt));
	DEBUGMSG(("mulcst: %d, ",hsaWatch->mulcst));
	DEBUGMSG(("sourceVID: 0x%x, ",hsaWatch->svid));
	DEBUGMSG(("CPU Reason: 0x%x ACL %d, ",hsaWatch->cpursn, hsaWatch->cpursn2));
	DEBUGMSG(("Source Physical port: %d",hsaWatch->spa));
	
	DEBUGMSG((", Extension port need TTL -1: "));
	for(i=0; i<3; i++)
		if(hsaWatch->ext_ttl_1if & (1<<i))
			DEBUGMSG(("%d ", i));
	DEBUGMSG(("\n"));
}

/* dump all fields to one string */

void hs_displayHsa_S(hsa_param_watch_t *hsaWatch)
{

	DEBUGMSG(("HSA("));

	DEBUGMSG(("mac:%02x-%02x-%02x-%02x-%02x-%02x,",hsaWatch->mac[0],hsaWatch->mac[1],hsaWatch->mac[2],hsaWatch->mac[3],hsaWatch->mac[4],hsaWatch->mac[5]));

	DEBUGMSG(("ip:%d.%d.%d.%d,",hsaWatch->ip[0],hsaWatch->ip[1],hsaWatch->ip[2],hsaWatch->ip[3]));
	
	DEBUGMSG(("prt:%d,",hsaWatch->prt));
	DEBUGMSG(("l3cs:%d,",hsaWatch->l3cs));
	DEBUGMSG(("l4cs:%d,",hsaWatch->l4cs));
	DEBUGMSG(("egress:%d,",hsaWatch->egress));
	DEBUGMSG(("l2act:%d,",hsaWatch->l2act));
	DEBUGMSG(("l34act:%d,",hsaWatch->l34act));
	DEBUGMSG(("dirtx:%d,",hsaWatch->dirtx));
	DEBUGMSG(("type:%d,",hsaWatch->type));
	DEBUGMSG(("llc:%d,",hsaWatch->llc));
	DEBUGMSG(("vlan:%d,",hsaWatch->vlan));
	DEBUGMSG(("dvid:%d,",hsaWatch->dvid));
	DEBUGMSG(("pppoe:%d,",hsaWatch->pppoe));
	DEBUGMSG(("pppid:%d,",hsaWatch->pppid));
	DEBUGMSG(("ttl_1:0x%x,",hsaWatch->ttl_1));
	DEBUGMSG(("dpc:%d,",hsaWatch->dpc));

	DEBUGMSG(("bc:%d,",hsaWatch->bc));

//#ifndef RTL8651B
//	DEBUGMSG(("pktend:%d,",hsaWatch->pktend));
//#else
	DEBUGMSG(("l3CrcOk:%d,",hsaWatch->l3CrcOk));
	DEBUGMSG(("l4CrcOk:%d,",hsaWatch->l4CrcOk));
	DEBUGMSG(("frag:%d,",hsaWatch->frag));
	DEBUGMSG(("lastFrag:%d,",hsaWatch->lastFrag));
	DEBUGMSG(("extSpa:%d,",hsaWatch->extSpa));
	DEBUGMSG(("dExtPrt:%d,",hsaWatch->dExtPrt));
//#endif
	DEBUGMSG(("mulcst:%d,",hsaWatch->mulcst));
	DEBUGMSG(("svid:0x%x,",hsaWatch->svid));
	DEBUGMSG(("cpursn:0x%x,",hsaWatch->cpursn));
	DEBUGMSG(("spa:%d",hsaWatch->spa));
	
//#ifdef RTL8651B
	DEBUGMSG((",extttl:%d,", hsaWatch->ext_ttl_1if));
	DEBUGMSG(("cpursn2:%d", hsaWatch->cpursn2));
//#endif /*RTL8651B*/

	DEBUGMSG((")\n"));
	
#ifndef VERI_PLATEFORM
#ifdef RTL8651B
	swTableCmd_parseCpursn(hsaWatch->cpursn | (hsaWatch->cpursn2<<9));
#endif /*RTL8651B*/
#endif
}

void hs_cmdDumpHsbHsa(uint32 channel, int32 argc, int8 ** argv)
{
	hs_dumpHsb(1);
	hs_dumpHsa(1);
	return;
}

void hs_dumpHsb(uint32 flag)
{
	memset((void *)&hsbParam, 0, sizeof(hsbParam));
	/* read HSB */
	memDump((void *)HSB_BASE, sizeof(hsb_param_t),"Raw HSB");
	memcpy((void *)&hsbParam,(void *)HSB_BASE, sizeof(hsb_param_t));
	hs_readHsb(&hsbWatch, &hsbParam);

	if(flag==0)
		hs_displayHsb(&hsbWatch);
	else
		hs_displayHsb_S(&hsbWatch);
	return;
}

void hs_dumpHsa(uint32 flag)
{
	memset((void *)&hsaParam, 0, sizeof(hsaParam));
	/* read HSB */
	memDump((void *)HSA_BASE, sizeof(hsa_param_t),"Raw HSA");
	memcpy((void *)&hsaParam,(void *)HSA_BASE, sizeof(hsa_param_t));
	hs_readHsa(&hsaWatch, &hsaParam);

	if(flag==0)
		hs_displayHsa(&hsaWatch);
	else
		hs_displayHsa_S(&hsaWatch);
	return;
}

#ifdef RTL8651B
int32 hs_cmdSetHsb(uint32 channel, int32 argc, int8 ** argv)
{
#define ASIC_REAL_HSB_BIT_SIZ   308
    uint32 argn;
    uint32 val;
    uint32 word;
    uint32 *pword;
        
    /* Enable HSB writing */
    REG32(SWTECR) |= EN_HSB_WR;
    
    if (strncmp(argv[1], "test", 4) != 0)
    {
        /* default values */
        bzero(&hsbParam,sizeof(hsbParam));
        hsbParam.bc = 256;
        hsbParam.dip31_19 = (192<<5|168>>3);  //192.168.1.161
        hsbParam.dip18_0 = (168<<16)|(1<<8)|161;
        hsbParam.dprt = 200;
        hsbParam.da19_0 = (0x88<<8)|0x88;   //00-00-00-00-88-88
        hsbParam.ethrtype15_4 = 0x0800>>4;
        hsbParam.ethrtype3_0 = 0x0800&0xf;
        hsbParam.ipptl7_3 = 6>>3;   //tcp
        hsbParam.ipptl2_0 = 6&7;
        hsbParam.l3crcok = 1;
        hsbParam.l4crcok = 1;
        hsbParam.spa = 0;
        hsbParam.sip31_3 = (211<<21)|(2<<13)|(254<<5)|(8>>3);  //211.2.254.8
        hsbParam.sip2_0 = 8&7;
        hsbParam.sprt15_3 = 100>>3;
        hsbParam.sprt2_0 = 100&7;
        hsbParam.sa35_4 = (0x99<<4)|(0x9c>>4);  //00-00-00-00-99-9c
        hsbParam.sa3_0 = 0x9c&0xf;
        hsbParam.ttlst = 2;
        
        for (argn=1; argn<argc; argn++)
        {
            switch (argv[argn][0])
            {
                case 'b':
                    if (strncmp(argv[argn], "bc:", 3) == 0)
                    {
                        sscanf(argv[argn], "bc:%d", &val);
                        hsbParam.bc = val;
                    }
                    else
                        goto _parsefail;
                    break;
                case 'c':
                    if (strncmp(argv[argn], "cpul2:", 6) == 0)
                    {
                        sscanf(argv[argn], "cpul2:%d", &val);
                        hsbParam.cpu_l2 = val;
                    }
                    else
                        goto _parsefail;
                    break;
                case 'd':
                    if (strncmp(argv[argn], "dip:", 4) == 0)
                    {
                        uint32 ip0,ip1,ip2,ip3;
                        sscanf(argv[argn], "dip:%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
                        hsbParam.dip31_19 = (ip0<<5)|(ip1>>3);
                        hsbParam.dip18_0 = (ip1<<16)|(ip2<<8)|ip3;
                    }
                    else if (strncmp(argv[argn], "dprt:", 5) == 0)
                    {
                        sscanf(argv[argn], "dprt:%d", &val);
                        hsbParam.dprt = val;
                    }
                    else if (strncmp(argv[argn], "da:", 3) == 0)
                    {
                        uint32 mac0,mac1,mac2,mac3,mac4,mac5;
                        sscanf(argv[argn], "da:%02x-%02x-%02x-%02x-%02x-%02x", &mac0,&mac1,&mac2,&mac3,&mac4,&mac5);
                        hsbParam.da47_20 = (mac0<<20)|(mac1<<12)|(mac2<<4)|(mac3>>4);
                        hsbParam.da19_0 = (mac3<<16)|(mac4<<8)|mac5;
                    }
                    else if (strncmp(argv[argn], "dirtx:", 6) == 0)
                    {
                        sscanf(argv[argn], "dirtx:%d", &val);
                        hsbParam.dirtx = val;
                    }
                    else
                        goto _parsefail;
                    break;
                case 'e':
                    if (strncmp(argv[argn], "ethrtype:", 9) == 0)
                    {
                        uint32 ethrtype;
                        sscanf(argv[argn], "ethrtype:%d", &ethrtype);
                        hsbParam.ethrtype15_4 = ethrtype>>4;
                        hsbParam.ethrtype3_0 = ethrtype&0xf;
                    }
                    else if (strncmp(argv[argn], "extspa:", 7) == 0)
                    {
                        uint32 ext_srcPrt;
                        sscanf(argv[argn], "extspa:%d", &ext_srcPrt);
                        hsbParam.ext_srcPrtH = ext_srcPrt>>1;
                        hsbParam.ext_srcPrtL = ext_srcPrt&1;
                    }
                    else
                        goto _parsefail;
                    break;
                case 'h':
                    if (strncmp(argv[argn], "hp:", 3) == 0)
                    {
                        sscanf(argv[argn], "hp:%d", &val);
                        hsbParam.hp = val;
                    }
                    else
                        goto _parsefail;
                    break;
                case 'i':
                    if (strncmp(argv[argn], "ipptl:", 6) == 0)
                    {
                        uint32 ipptl;
                        sscanf(argv[argn], "ipptl:%d", &ipptl);
                        hsbParam.ipptl7_3 = ipptl>>3;
                        hsbParam.ipptl2_0 = ipptl&7;
                    }
                    else if (strncmp(argv[argn], "ipflg:", 6) == 0)
                    {
                        sscanf(argv[argn], "ipflg:%d", &val);
                        hsbParam.ipflg = val;
                    }
                    else if (strncmp(argv[argn], "iptos:", 6) == 0)
                    {
                        sscanf(argv[argn], "iptos:%d", &val);
                        hsbParam.iptos = val;
                    }
                    else if (strncmp(argv[argn], "ipfragif:", 9) == 0)
                    {
                        sscanf(argv[argn], "ipfragif:%d", &val);
                        hsbParam.ipfragif = val;
                    }
                    else
                        goto _parsefail;
                    break;
                case 'l':
                    if (strncmp(argv[argn], "llc:", 4) == 0)
                    {
                        sscanf(argv[argn], "llc:%d", &val);
                        hsbParam.llc = val;
                    }
                    else if (strncmp(argv[argn], "l3csok:", 7) == 0)
                    {
                        sscanf(argv[argn], "l3csok:%d", &val);
                        hsbParam.l3crcok = val;
                    }
                    else if (strncmp(argv[argn], "l4csok:", 7) == 0)
                    {
                        sscanf(argv[argn], "l4csok:%d", &val);
                        hsbParam.l4crcok = val;
                    }
                    else if (strncmp(argv[argn], "llc_other:", 10) == 0)
                    {
                        sscanf(argv[argn], "llc_other:%d", &val);
                        hsbParam.llc_other = val;
                    }
                    else
                        goto _parsefail;
                    break;
                case 'p':
                    if (strncmp(argv[argn], "pppoe:", 6) == 0)
                    {
                        sscanf(argv[argn], "pppoe:%d", &val);
                        hsbParam.pppoe = val;
                    }
                    else if (strncmp(argv[argn], "prtnmat:", 8) == 0)
                    {
                        sscanf(argv[argn], "prtnmat:%d", &val);
                        hsbParam.prtnmat = val;
                    }
                    else if (strncmp(argv[argn], "pppoe_sid:", 10) == 0)
                    {
                        sscanf(argv[argn], "pppoe_sid:%d", &val);
                        hsbParam.pppoe = 1;
                        hsbParam.pppoesid = val;
                    }
                    else
                        goto _parsefail;
                    break;
                case 's':
                    if (strncmp(argv[argn], "spa:", 4) == 0)
                    {
                        sscanf(argv[argn], "spa:%d", &val);
                        hsbParam.spa = val;
                    }
                    else if (strncmp(argv[argn], "sip:", 4) == 0)
                    {
                        uint32 ip0,ip1,ip2,ip3;
                        sscanf(argv[argn], "sip:%d.%d.%d.%d", &ip0, &ip1, &ip2, &ip3);
                        hsbParam.sip31_3 = (ip0<<21)|(ip1<<13)|(ip2<<5)|(ip3>>3);
                        hsbParam.sip2_0 = ip3&7;
                    }
                    else if (strncmp(argv[argn], "sprt:", 5) == 0)
                    {
                        uint32 sprt;
                        sscanf(argv[argn], "sprt:%d", &sprt);
                        hsbParam.sprt15_3 = sprt>>3;
                        hsbParam.sprt2_0 = sprt&7;
                    }
                    else if (strncmp(argv[argn], "sa:", 3) == 0)
                    {
                        uint32 mac0,mac1,mac2,mac3,mac4,mac5;
                        sscanf(argv[argn], "sa:%02x-%02x-%02x-%02x-%02x-%02x", &mac0,&mac1,&mac2,&mac3,&mac4,&mac5);
                        hsbParam.sa47_36 = (mac0<<4)|(mac1>>4);
                        hsbParam.sa35_4 = (mac1<<28)|(mac2<<20)|(mac3<<12)|(mac4<<4)|(mac5>>4);
                        hsbParam.sa3_0 = mac5&0xf;
                    }
                    else
                        goto _parsefail;
                    break;
                case 't':
                    if (strncmp(argv[argn], "tcpflg:", 7) == 0)
                    {
                        sscanf(argv[argn], "tcpflg:%d", &val);
                        hsbParam.tcpflg = val;
                    }
                    else if (strncmp(argv[argn], "type:", 5) == 0)
                    {
                        sscanf(argv[argn], "type:%d", &val);
                        hsbParam.type = val;
                    }
                    else if (strncmp(argv[argn], "ttlst:", 6) == 0)
                    {
                        sscanf(argv[argn], "ttlst:%d", &val);
                        hsbParam.ttlst = val;
                    }
                    else
                        goto _parsefail;
                    break;
                case 'u':
                    if (strncmp(argv[argn], "udp_nocs:", 9) == 0)
                    {
                        sscanf(argv[argn], "udp_nocs:%d", &val);
                        hsbParam.udp_nocs = val;
                    }
                    else if (strncmp(argv[argn], "url_trap:", 9) == 0)
                    {
                        sscanf(argv[argn], "url_trap:%d", &val);
                        hsbParam.urltrap = val;
                    }
                    else
                        goto _parsefail;
                    break;
                case 'v':
                    if (strncmp(argv[argn], "vid:", 4) == 0)
                    {
                        sscanf(argv[argn], "vid:%d", &val);
                        hsbParam.vlan = 1;
                        hsbParam.vid = val;
                    }
                    else if (strncmp(argv[argn], "vlan:", 5) == 0)
                    {
                        sscanf(argv[argn], "vlan:%d", &val);
                        hsbParam.vlan = val;
                    }
                    else
                        goto _parsefail;
                    break;
                
                default:
_parsefail:
        	   	   	printf("Unknown token '%s'!\n", argv[argn]);
        
                    /* Disable HSB writing */
                    REG32(SWTECR) &= ~EN_HSB_WR;
                    return FAILED;
            }
        }
        
        word = 0;
        pword = (uint32*) &hsbParam;
        while ((word<<2) <= sizeof(hsbParam))
        {
            /* Wait for command ready */
            while ( (REG32(SWTACR) & ACTION_MASK) != ACTION_DONE );
        
            REG32(TCR0) = *(pword++);
            REG32(TCR1) = *(pword++);
            REG32(TCR2) = *(pword++);
            REG32(TCR3) = *(pword++);
            REG32(TCR4) = *(pword++);
            REG32(TCR5) = *(pword++);
            REG32(TCR6) = *(pword++);
            REG32(TCR7) = *(pword++);
        
            /* Fill address */
            REG32(SWTAA) = HSB_BASE + (word<<2);
            /* Activate add command */
            REG32(SWTACR) = ACTION_START | CMD_FORCE;
            /* Wait for command done */
            while ( (REG32(SWTACR) & ACTION_MASK) != ACTION_DONE );
            /* Check status */
            if ( (REG32(SWTASR) & TABSTS_MASK) != TABSTS_SUCCESS )
            {
                printf("Writing fails!\n");
                /* Disable HSB writing */
                REG32(SWTECR) &= ~EN_HSB_WR;
                return FAILED;
            }
                
            word += 8;
        }
        
        /* HSB ready */
        REG32(TMCR) |= HSB_RDY;
        REG32(TMCR) &= ~HSB_RDY;
        
	hs_dumpHsb(1);
	hs_dumpHsa(1);
        
        /* Disable HSB writing */
        REG32(SWTECR) &= ~EN_HSB_WR;
    	return SUCCESS;
    }
    else
    {
        /* pattern test for hsb */
        uint32 pattern[7] = {0x55555555,0xaaaaaaaa,0x33333333,0xcccccccc,0x33cc55aa,0xffffffff,0x0};
        uint32 incpat;
        uint32 i;
        
        for (i=0; i<7; i++)
        {
            printf("Testing pattern %08x... ", pattern[i]);
            
            /* write pattern */
            word = 0;
            while ((word<<2) <= sizeof(hsbParam))
            {
                /* Wait for command ready */
                while ( (REG32(SWTACR) & ACTION_MASK) != ACTION_DONE );
            
                REG32(TCR0) = pattern[i];
                REG32(TCR1) = pattern[i];
                REG32(TCR2) = pattern[i];
                REG32(TCR3) = pattern[i];
                REG32(TCR4) = pattern[i];
                REG32(TCR5) = pattern[i];
                REG32(TCR6) = pattern[i];
                REG32(TCR7) = pattern[i];
            
                /* Fill address */
                REG32(SWTAA) = HSB_BASE + (word<<2);
                /* Activate add command */
                REG32(SWTACR) = ACTION_START | CMD_FORCE;
                /* Wait for command done */
                while ( (REG32(SWTACR) & ACTION_MASK) != ACTION_DONE );
                /* Check status */
                if ( (REG32(SWTASR) & TABSTS_MASK) != TABSTS_SUCCESS )
                {
                    printf("Writing fails\n");
                    /* Disable HSB writing */
                    REG32(SWTECR) &= ~EN_HSB_WR;
                    return FAILED;
                }
                    
                word += 8;
            }
            
            /* check */
            word = 0;
            while ((word<<2) <= sizeof(hsbParam))
            {
                if ((word<<5) < (ASIC_REAL_HSB_BIT_SIZ-32))
                {
                    if (*(uint32*)(HSB_BASE + (word<<2)) != pattern[i])
                    {
                        printf("Test pattern %08x fails at address %08x (read out %08x)!\n", 
                                    pattern[i], HSB_BASE + (word<<2), *(uint32*)(HSB_BASE + (word<<2)));
                        /* Disable HSB writing */
                        REG32(SWTECR) &= ~EN_HSB_WR;
                        return FAILED;
                    }
                }
                else
                {
                    uint32 mask=0xffffffff>>(((word+1)<<5)-ASIC_REAL_HSB_BIT_SIZ);
                    if ((*(uint32*)(HSB_BASE + (word<<2))&mask) != (pattern[i] & mask))
                    {
                        printf("Test pattern %08x fails at address %08x (read out %08x)!\n", 
                                    pattern[i], HSB_BASE + (word<<2), *(uint32*)(HSB_BASE + (word<<2)));
                        /* Disable HSB writing */
                        REG32(SWTECR) &= ~EN_HSB_WR;
                        return FAILED;
                    }
                    printf("PASS\n");
                    break;
                }
                word++;
            }
        }
        
        printf("Testing incremental pattern... ");
        
        /* write pattern */
        word = 0;
        incpat = 0x00010203;
        while ((word<<2) <= sizeof(hsbParam))
        {
            /* Wait for command ready */
            while ( (REG32(SWTACR) & ACTION_MASK) != ACTION_DONE );
        
            REG32(TCR0) = incpat;   incpat += 0x04040404;
            REG32(TCR1) = incpat;   incpat += 0x04040404;
            REG32(TCR2) = incpat;   incpat += 0x04040404;
            REG32(TCR3) = incpat;   incpat += 0x04040404;
            REG32(TCR4) = incpat;   incpat += 0x04040404;
            REG32(TCR5) = incpat;   incpat += 0x04040404;
            REG32(TCR6) = incpat;   incpat += 0x04040404;
            REG32(TCR7) = incpat;   incpat += 0x04040404;
        
            /* Fill address */
            REG32(SWTAA) = HSB_BASE + (word<<2);
            /* Activate add command */
            REG32(SWTACR) = ACTION_START | CMD_FORCE;
            /* Wait for command done */
            while ( (REG32(SWTACR) & ACTION_MASK) != ACTION_DONE );
            /* Check status */
            if ( (REG32(SWTASR) & TABSTS_MASK) != TABSTS_SUCCESS )
            {
                printf("Writing fails\n");
                /* Disable HSB writing */
                REG32(SWTECR) &= ~EN_HSB_WR;
                return FAILED;
            }
                
            word += 8;
        }
        
        /* check */
        word = 0;
        incpat = 0x00010203;
        while ((word<<2) <= sizeof(hsbParam))
        {
            if ((word<<5) < (ASIC_REAL_HSB_BIT_SIZ-32))
            {
                if (*(uint32*)(HSB_BASE + (word<<2)) != incpat)
                {
                    printf("Test pattern %08x fails at address %08x (read out %08x)!\n", 
                                incpat, HSB_BASE + (word<<2), *(uint32*)(HSB_BASE + (word<<2)));
                    /* Disable HSB writing */
                    REG32(SWTECR) &= ~EN_HSB_WR;
                    return FAILED;
                }
            }
            else
            {
                uint32 mask=0xffffffff>>(((word+1)<<5)-ASIC_REAL_HSB_BIT_SIZ);
                if ((*(uint32*)(HSB_BASE + (word<<2))&mask) != (incpat & mask))
                {
                    printf("Test pattern %08x fails at address %08x (read out %08x)!\n", 
                                incpat, HSB_BASE + (word<<2), *(uint32*)(HSB_BASE + (word<<2)));
                    /* Disable HSB writing */
                    REG32(SWTECR) &= ~EN_HSB_WR;
                    return FAILED;
                }
                printf("PASS\n");
                break;
            }
            word++;
            incpat += 0x04040404;
        }
        
        return SUCCESS;
    }
}
#endif /*RTL86151B*/

/*
void hs_cmdDumpHsbHsa(uint32 channel, int32 argc, int8 ** argv)
{
    uint8 * adr;
    uint32  size;
    
    adr = (uint8 *) HSB_BASE;
    size = sizeof(hsb_param_t);
    while (size--)
    {
        if ( *adr > 0x0f )
            printf("%x", *adr);
        else if ( *adr > 0 )
            printf("0%x", *adr);
        else
            printf("00");
        adr += 1;
    }
    
    printf("\n");
    adr = (uint8 *) HSA_BASE;
    size = sizeof(hsa_param_t);
    while (size--)
    {
        if ( *adr > 0x0f )
            printf("%x", *adr);
        else if ( *adr > 0 )
            printf("0%x", *adr);
        else
            printf("00");
        adr += 1;
    }
    
    return;
}*/

/* end of hs.c */
