/*
 * FILE NAME rtl_gpio.c
 *
 * BRIEF MODULE DESCRIPTION
 *  GPIO For Flash Reload Default
 *
 *  Author: jimmylin@realtek.com.tw
 *
 * Copyright 2005 Realtek Semiconductor Corp.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE	LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <asm/errno.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <linux/miscdevice.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/sched.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/reboot.h>
#include <linux/kmod.h>
#include <linux/proc_fs.h>

#define AUTO_CONFIG


#ifdef CONFIG_RTL_EB8186
	#define READ_RF_SWITCH_GPIO
#endif	

#ifdef CONFIG_RTL865X
#if defined(CONFIG_RTL8196B)
	#include <asm/rtl865x/rtl865xc_asicregs.h>
	#define RTL_GPIO_PABDIR		PABCD_DIR
	#define RTL_GPIO_PABDATA	PABCD_DAT
	#define RTL_GPIO_PABCNR		PABCD_CNR
	#define AUTOCFG_BTN_PIN		1
	#define AUTOCFG_LED_PIN		20
	#define RESET_LED_PIN		18
	#define RESET_BTN_PIN		0
	#define RTL_GPIO_MUX 0xB8000030
	#define RTL_GPIO_MUX_DATA 0x0FC00380//for WIFI ON/OFF and GPIO
	#define RTL_GPIO_WIFI_ONOFF
#else
	#include <asm/rtl865x/rtl865xc_asicregs.h>
	#define RTL_GPIO_PABDIR		PABCD_DIR
	#define RTL_GPIO_PABDATA	PABCD_DAT

	#define AUTOCFG_BTN_PIN		15
	#define AUTOCFG_LED_PIN		14
#if defined(CONFIG_RTL8186_KB)
	#define RESET_LED_PIN		15
#else
	#define RESET_LED_PIN		13
#endif
	#define RESET_BTN_PIN		15
#endif
#endif


#define PROBE_NULL		0
#define PROBE_ACTIVE	1
#define PROBE_RESET		2
#define PROBE_RELOAD	3

#ifdef CONFIG_RTL_EB8186
	#define RTL_GPIO_PABDIR		0xbd010124
	#define RTL_GPIO_PABDATA	0xbd010120
	#define RESET_BTN_PIN		0
	#define AUTOCFG_BTN_PIN		1
	#define RESET_LED_PIN		2
	#define AUTOCFG_LED_PIN		3
	#define AUTOCFG_LED_OFF		0
	#define AUTOCFG_LED_ON		1
	#define AUTOCFG_LED_BLINK	2
#if 0	
#else
	#define RTL_GPIO_PABDIR		0xbd010040
	#define RTL_GPIO_PABDATA	0xbd010044
	#define RTL_WLAN_CR9346		0xbd400050
	#define RTL_WLAN_CONFIG0	0xbd400051
	#define RTL_WLAN_PSR		0xbd40005e
	#define RESET_BTN_PIN		10
#endif	
#endif

#ifdef CONFIG_RTL8186_KB  
	#define PROBE_TIME	10
#else
	#define PROBE_TIME	5	
#endif

//#define  GPIO_DEBUG
#ifdef GPIO_DEBUG
/* note: prints function name for you */
#  define DPRINTK(fmt, args...) printk("%s: " fmt, __FUNCTION__ , ## args)
#else
#  define DPRINTK(fmt, args...)
#endif

#if defined(CONFIG_RTL8186_KB)
static int blinking_blue_Internet_connected = 0;
static int blinking_amber_Internet_connected = 0;
static int blinking_amber_modem = 0;
static int blinking_amber_wireless_computer = 0;
static int blinking_amber_wire_computer = 0;
static int blinking_blue_wireless_security = 0;
static int blinking_amber_wireless_security = 0;
static int blinking_amber_usb = 0;
static int dim_all_led = 	0;
static int during_booting = 0;

/* record status for eco dim mode*/
static char internet_connected_status = 0;
static char wireless_computer_status = 0;
static char wire_computer_status = 0;
static char wireless_security_status = 0;
static char wireless_status = 0;
static char wan_throughput_status = 0;
static char led_bridghtness_status = 0;
static char usb_status;
#endif

static struct timer_list probe_timer;
static unsigned int    probe_counter;
static unsigned int    probe_state;

static char default_flag='0';
//Add for update flash check 
#if !defined(CONFIG_RTL8186_TR) && !defined(CONFIG_RTL865X_AC) && !defined(CONFIG_RTL865X_SC) 
int start_count_time=0; 
int Reboot_Wait=0; 
#endif 

#ifndef CONFIG_RTL_EB8186
unsigned int led0enable;
#endif

#ifdef CONFIG_RTL8186_KB
//int	disable_power_led_blink=0;
int update_flash_timestamp=0;
#endif


#ifdef CONFIG_RTL8186_TR
int	system_led_blink=0;
extern int flash_write_flag;
#endif

#ifdef AUTO_CONFIG
static unsigned int		AutoCfg_LED_Blink;
static unsigned int		AutoCfg_LED_Toggle;

#if defined(CONFIG_RTL8186_KB)
void rtl865x_startBooting_ledControl(void)
{
	during_booting = 1;
}

void rtl865x_wireCompSolidBlue(void)
{
	/* Enable wire computer solid blue */
	RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x4<< 16)))|((0x8<< 16))));
	blinking_amber_wire_computer = 0;
}


void rtl865x_wireCompBlinkAmber(void)
{
	/* Enable wire computer amber */
	RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x8<< 16)))|((0x4<< 16))));
	blinking_amber_wire_computer = 1;
}
		
#endif
void autoconfig_gpio_init(void)
{
#if defined(CONFIG_RTL8186_KB)
	/*	B6	*/
	RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR)&(~(0x40 << 8))));
	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (0x40 << 8)));
	/*	C0~C7	*/
	RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR)&(~(0xff << 16))));
	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (0xff << 16)));
	/*	D0~D1	*/
	RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR)&(~(0x3 << 24))));
	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (0x3 << 24)));
	/*	G0~G7	*/
	RTL_W32(PEFGH_CNR,(RTL_R32(PEFGH_CNR)&(~(0xff << 16))));
	RTL_W32(PEFGH_DIR, (RTL_R32(PEFGH_DIR) | (0xff << 16)));
	/*	H3~H7	*/
	RTL_W32(PEFGH_CNR,(RTL_R32(PEFGH_CNR)&(~(0xf8 << 24))));
	RTL_W32(PEFGH_DIR, (RTL_R32(PEFGH_DIR) | (0xf8 << 24)));

	/* usb */
	RTL_W32(LEDCREG,(RTL_R32(LEDCREG)&(~(0x5f))));
	RTL_W32(LEDCREG, (RTL_R32(LEDCREG) | (0x47)));

	RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)|((0x1f0<< 16)))));
	blinking_blue_Internet_connected = blinking_amber_Internet_connected = 
		blinking_amber_modem =
		blinking_amber_wireless_computer = blinking_amber_wire_computer = 
		blinking_blue_wireless_security = blinking_amber_wireless_security = 
		blinking_amber_usb = 0;
	dim_all_led = 0;
#else
#if defined(CONFIG_RTL865X) || defined(CONFIG_RTL8196B)
	RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR)&(~(1 << AUTOCFG_BTN_PIN))));
	RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR)&(~(1 << AUTOCFG_LED_PIN))));		
#endif
	
	/* Set GPIOA pin 1 as input pin for auto config button */
	RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) & (~(1 << AUTOCFG_BTN_PIN))));
	/* Set GPIOA ping 3 as output pin for auto config led */
	RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) | (1 << AUTOCFG_LED_PIN)));
	/* turn off auto config led in the beginning */
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << AUTOCFG_LED_PIN)));
#endif
}


void autoconfig_gpio_off(void)
{
#if defined(CONFIG_RTL8186_KB)
	RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|(0xff<< 16)));
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|(0xff<< 8)));
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|(0xf<< 16)));
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|(0x2<< 24)));
	RTL_W32(LEDCR1, (RTL_R32(LEDCR1) & (~0x3)));
	RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x3))));

	RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)|((0x1f0<< 16)))));
	
	blinking_blue_Internet_connected = blinking_amber_Internet_connected = 
		blinking_amber_modem =
		blinking_amber_wireless_computer = blinking_amber_wire_computer = 
		blinking_blue_wireless_security = blinking_amber_wireless_security = 
		blinking_amber_usb = 0;
#else
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << AUTOCFG_LED_PIN)));
	AutoCfg_LED_Blink = 0;
#endif
}


void autoconfig_gpio_on(void)
{
#if defined(CONFIG_RTL8186_KB)
	RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)&(~(0xff<<16))));
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)&(~(0x40<<8))));
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)&(~(0xf<<16))));
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)&(~(0x2<<24))));
	RTL_W32(LEDCR1, (RTL_R32(LEDCR1) | (0x3)));
	RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x3))));

	RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x1f0<< 16)))));
	
	blinking_blue_Internet_connected = blinking_amber_Internet_connected = 
		blinking_amber_modem =
		blinking_amber_wireless_computer = blinking_amber_wire_computer = 
		blinking_blue_wireless_security = blinking_amber_wireless_security = 
		blinking_amber_usb = 0;
#else
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
	AutoCfg_LED_Blink = 0;
#endif
}


void autoconfig_gpio_blink(void)
{
#if defined(CONFIG_RTL8186_KB)
	autoconfig_gpio_on();
	blinking_blue_Internet_connected = blinking_amber_Internet_connected = 
		blinking_amber_modem =
		blinking_amber_wireless_computer = blinking_amber_wire_computer = 
		blinking_blue_wireless_security = blinking_amber_wireless_security = 
		blinking_amber_usb = 1;
	RTL_W32(LEDCR1, (RTL_R32(LEDCR1) | (0x3)));
	RTL_W32(LEDBCR, (RTL_R32(LEDBCR)|((0x3))));
#else
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
	AutoCfg_LED_Blink = 1;
	AutoCfg_LED_Toggle = 1;
#endif
}

#ifdef CONFIG_RTL8186_TR
void autoconfig_gpio_blink_quick(void)
{
	RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
	AutoCfg_LED_Blink = 2;
	AutoCfg_LED_Toggle = 1;
}
#endif
#endif // AUTO_CONFIG


#if 0
static int reset_flash_default(void *data)
{
	char *argv[3], *envp[1] = {NULL};
	int i = 0;
	int reset_default=(int)data;

	argv[i++] = "/bin/flash";
	argv[i++] = "reset";
	argv[i] = NULL;

	if(reset_default)
	{
		printk("Going to Reload Default\n");
		if (call_usermodehelper(argv[0], argv, envp,1))
			printk("failed to Reset to default\n");
	}
	machine_restart(0);
	return 0;
}
#endif


static void rtl_gpio_timer(unsigned long data)
{
	unsigned int pressed=1;

#if (defined(CONFIG_RTL8186_TR)||defined(CONFIG_RTL8186_KB)) && defined(AUTO_CONFIG)
#if defined(CONFIG_RTL8186_KB)
#else
	static int cnt=0;
#endif
	if (AutoCfg_LED_Blink == 2)
	{
		if (AutoCfg_LED_Toggle) {
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << AUTOCFG_LED_PIN)));
		}
		else {
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
		}
		AutoCfg_LED_Toggle = AutoCfg_LED_Toggle? 0 : 1;
	}

#if defined(CONFIG_RTL8186_KB)
#else
	if (cnt++%4)
		goto ret_timer;
#endif
#endif
	
#ifdef CONFIG_RTL_EB8186	
	if ((RTL_R32(RTL_GPIO_PABDATA) & (1 << RESET_BTN_PIN))){
#endif
#ifdef CONFIG_RTL865X
#if defined(CONFIG_RTL8196B)	
	if (RTL_R32(PABCD_DAT) & (1 << RESET_BTN_PIN)){
#else
	if ((RTL_R32(PEFGH_DAT) & (1 << RESET_BTN_PIN))){
#endif
#endif				
		pressed = 0;
#if	!defined(CONFIG_RTL8186_TR)&&!defined(CONFIG_RTL8186_KB)
		//turn off LED0
		RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | ((1 << RESET_LED_PIN))));
#endif
	}
	else
	{
		DPRINTK("Key pressed %d!\n", probe_counter+1);
	}

	if (probe_state == PROBE_NULL)
	{
		if (pressed)
		{
			probe_state = PROBE_ACTIVE;
			probe_counter++;
		}
		else
			probe_counter = 0;
	}
	else if (probe_state == PROBE_ACTIVE)
	{
		if (pressed)
		{
			probe_counter++;
#ifdef CONFIG_RTL8186_TR		
			if ((probe_counter >=1 ) && (probe_counter <=PROBE_TIME))
#else
			if ((probe_counter >=2 ) && (probe_counter <=PROBE_TIME))
#endif				
			{
#if 0
//#ifndef CONFIG_RTL_EB8186
				led0enable=1;
				// turn on LED0
				RTL_W8(RTL_WLAN_CR9346, 0xc0);
				RTL_W8(RTL_WLAN_CONFIG0, 0x10);
				RTL_W8(RTL_WLAN_PSR,(RTL_R8(RTL_WLAN_PSR)&0xEF));
#else
#if !(defined CONFIG_RTL8186_TR) && !defined(CONFIG_RTL8186_KB)
				DPRINTK("2-5 turn on led\n");
				//turn on LED0
				RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << RESET_LED_PIN))));
#endif				
#endif
			}
			else if (probe_counter >= PROBE_TIME)
			{
#if 0				
//#ifndef CONFIG_RTL_EB8186
				led0enable=1;
				RTL_W8(RTL_WLAN_CR9346, 0xc0);
				RTL_W8(RTL_WLAN_CONFIG0, 0x10);
				// sparkling LED0
				if (probe_counter & 1)
					RTL_W8(RTL_WLAN_PSR, (RTL_R8(RTL_WLAN_PSR)|0x10));
				else
					RTL_W8(RTL_WLAN_PSR, (RTL_R8(RTL_WLAN_PSR)&0xEF));
#else
				// sparkling LED0
				DPRINTK(">5 \n");
				
#ifdef CONFIG_RTL8186_KB
#if 0
				disable_power_led_blink=0;
#endif
#elif !defined(CONFIG_RTL8186_TR)
				if (probe_counter & 1)
					RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | ((1 << RESET_LED_PIN))));
				else
					RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << RESET_LED_PIN))));		
#endif // CONFIG_RTL8186_KB		
#endif // CONFIG_RTL_EB8186
			}
		}
		else
		{
			if (probe_counter < 2)
			{
				probe_state = PROBE_NULL;
				probe_counter = 0;
				DPRINTK("<2 \n");
			}
			else if (probe_counter >= PROBE_TIME)
			{
#if 0				
//#ifndef CONFIG_RTL_EB8186
				led0enable=1;
#endif

#if 0
#if	defined(CONFIG_RTL8186_KB)
				disable_power_led_blink=0;
#endif
#endif
				//reload default
			        default_flag='1';	
	//			kernel_thread(reset_flash_default, (void *)1, SIGCHLD);
				return;

			}
			else	
			{
#if 0				
//#ifndef CONFIG_RTL_EB8186
				RTL_W8(RTL_WLAN_PSR , (RTL_R8(RTL_WLAN_PSR)|0x10));
				RTL_W8(RTL_WLAN_CONFIG0, (RTL_R8(RTL_WLAN_CONFIG0)&(~0x10)));
#endif
				DPRINTK("2-5 reset\n");
				kill_proc(1,SIGTERM,1);
		//		kernel_thread(reset_flash_default, 0, SIGCHLD);
				return;
			}
		}
	}

#if  defined(AUTO_CONFIG) && (!defined(CONFIG_RTL8186_KB))
	if (AutoCfg_LED_Blink==1)
	{
		if (AutoCfg_LED_Toggle) {
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << AUTOCFG_LED_PIN)));
		}
		else {
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
		}
		AutoCfg_LED_Toggle = AutoCfg_LED_Toggle? 0 : 1;
	}
#endif

#if	defined(CONFIG_RTL8186_KB)
/*	if (dim_all_led == 0)	*/
	{
		if (likely(during_booting==0))
		{
			static int	toggle = 0;

			if (toggle<3)
			{
				toggle++;
				goto ret_timer;
			}

			toggle = 0;
			
			/* contorl the led blinking */
			if (blinking_blue_Internet_connected==1)
			{
				RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|((0xc0<< 16))));
				blinking_blue_Internet_connected=2;
			}
			else if (blinking_blue_Internet_connected==2)
			{
				RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x40<< 16)))|((0x80<< 16))));
				blinking_blue_Internet_connected=1;
			}

			if (blinking_amber_Internet_connected==1)
			{
				RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|((0xc0<< 16))));
				blinking_amber_Internet_connected=2;
			}
			else if (blinking_amber_Internet_connected==2)
			{
				RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x80<< 16)))|(((0x40<< 16)))));
				blinking_amber_Internet_connected=1;
			}

			if (blinking_amber_modem==1)
			{
				RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|((0x30<< 16))));
				blinking_amber_modem=2;
			}
			else if (blinking_amber_modem==2)
			{
				RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x20<< 16)))|(((0x10<< 16)))));
				blinking_amber_modem=1;
			}

			if (blinking_amber_wireless_computer==1)
			{
				RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|((0x3<< 16))));
				blinking_amber_wireless_computer=2;
			}
			else if (blinking_amber_wireless_computer==2)
			{
				RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x2<< 16)))|((0x1<< 16))));
				blinking_amber_wireless_computer=1;
			}

			if (blinking_amber_wire_computer==1)
			{
				RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|((0xc<< 16))));
				blinking_amber_wire_computer=2;
			}
			else if (blinking_amber_wire_computer==2)
			{
				RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x8<< 16)))|((0x4<< 16))));
				blinking_amber_wire_computer=1;
			}

			if (blinking_blue_wireless_security==1)
			{
				RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x20040<< 8))));
				blinking_blue_wireless_security=2;
			}
			else if (blinking_blue_wireless_security==2)
			{
				RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x40<< 8)))|(((0x2<< 24)))));
				blinking_blue_wireless_security=1;
			}

			if (blinking_amber_wireless_security==1)
			{
				RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x20040<< 8))));
				blinking_amber_wireless_security=2;
			}
			else if (blinking_amber_wireless_security==2)
			{
				RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x2<< 24)))|(((0x40<< 8)))));
				blinking_amber_wireless_security=1;
			}


			if (blinking_amber_usb==1)
			{
				RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x8<< 16))));
				blinking_amber_usb=2;
			}
			else if (blinking_amber_usb==2)
			{
				RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)&(~(0x8<< 16))));
				blinking_amber_usb=1;
			}
		}
		else
		{
			static int toggle = 0;

			if (toggle==1)
			{
				during_booting = ((during_booting)%8)+1;
				toggle = 0;
			}
			else
			{
				toggle++;
			}
			
			switch(during_booting)
			{
				case 1:
					RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x10<< 16)))|((0x1e0)<<16)));
					break;
				case 2:
				case 8:
					RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x30<< 16)))|((0x1c0)<<16)));
					break;
				case 3:
				case 7:
					RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x70<< 16)))|((0x180)<<16)));
					break;
				case 4:
				case 6:
					RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0xf0<< 16)))|((0x100)<<16)));
					break;
				case 5:
					RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x1f0<< 16)))));
					break;
			}
		}
	}
#endif


#if (defined(CONFIG_RTL8186_TR)||defined(CONFIG_RTL8186_KB)) && defined(AUTO_CONFIG)
ret_timer:
	mod_timer(&probe_timer, jiffies + 25);
#else
	mod_timer(&probe_timer, jiffies + 100);
#endif
}


#ifdef AUTO_CONFIG
static int read_proc(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	int len;
	char flag;

	if (RTL_R32(RTL_GPIO_PABDATA) & (1 << AUTOCFG_BTN_PIN))
		flag = '0';
	else
		flag = '1';
	len = sprintf(page, "%c\n", flag);

	len += sprintf(page+len, "CNR 0x%x  0x%x\n", (int)RTL_R32(PABCD_CNR), (int)RTL_R32(PEFGH_CNR));
	len += sprintf(page+len, "DIR 0x%x  0x%x\n", (int)RTL_R32(PABCD_DIR), (int)RTL_R32(PEFGH_DIR));
	len += sprintf(page+len, "DAT 0x%x  0x%x\n", (int)RTL_R32(PABCD_DAT), (int)RTL_R32(PEFGH_DAT));
	len += sprintf(page+len, "ISR 0x%x  0x%x\n", (int)RTL_R32(PABCD_ISR), (int)RTL_R32(PEFGH_ISR));
	len += sprintf(page+len, "IMR 0x%x 0x%x   0x%x 0x%x\n", (int)RTL_R32(PAB_IMR), (int)RTL_R32(PCD_IMR)
			, (int)RTL_R32(PEF_IMR), (int)RTL_R32(PGH_IMR));
	len += sprintf(page+len, "USB 0x%x  0x%x 0x%x\n", (int)RTL_R32(LEDCREG), (int)RTL_R32(LEDCR1), (int)RTL_R32(LEDBCR));

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}


static int write_proc(struct file *file, const char *buffer,
				unsigned long count, void *data)
{
	char flag;
//Add for update flash check
#if !defined(CONFIG_RTL8186_TR) && !defined(CONFIG_RTL865X_AC) && !defined(CONFIG_RTL865X_SC) 
        char start_count[10], wait[10]; 
#endif 

	if (count < 2)
		return -EFAULT;

	DPRINTK("file: %08x, buffer: %s, count: %lu, data: %08x\n",
		(unsigned int)file, buffer, count, (unsigned int)data);
	if (buffer && !copy_from_user(&flag, buffer, 1)) {

#ifdef CONFIG_RTL8186_KB
		/* record status for eco dim mode */
		if (flag=='3'||flag=='4'||flag=='5')
			wireless_computer_status = flag;
		if (flag=='6'||flag=='7'||flag=='8')
			wire_computer_status = flag;
		if (flag=='c'||flag=='d'||flag=='e'||flag=='f')
			internet_connected_status = flag;
		if (flag=='g'||flag=='h'||flag=='i'||flag=='j')
			wireless_security_status = flag;
		if (flag=='r'||flag=='s')
			wireless_status = flag;
		if (flag=='u'||flag=='v'||flag=='w'||flag=='x'||flag=='y')
			led_bridghtness_status = flag;
		if (flag=='V'||flag=='W'||flag=='X'||flag=='Y'||flag=='Z')
			wan_throughput_status = flag;
		if (flag=='n'||flag=='o'||flag=='p'||flag=='q')
			usb_status = flag;
checkFlags:
#endif
		if (flag == 'E')
			autoconfig_gpio_init();
		else if (flag == '0')
			autoconfig_gpio_off();
		else if (flag == '1')
			autoconfig_gpio_on();
		else if (flag == '2')
			autoconfig_gpio_blink();
//Add for update flash check
#if !defined(CONFIG_RTL8186_TR) && !defined(CONFIG_RTL865X_AC) && !defined(CONFIG_RTL865X_SC) 
                else if (flag == '4'){ 
                        start_count_time= 1; 
                        sscanf(buffer, "%s %s", start_count, wait);
			Reboot_Wait = (simple_strtol(wait,NULL,0))*100;
                } 
#endif 
#if defined(CONFIG_RTL8196B)	
		else if (flag == 'I')
		{
			printk("initial reset Led\n");
			RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | (RTL_GPIO_MUX_DATA)));
			RTL_W32(PEFGH_CNR, (RTL_R32(PEFGH_CNR) & (~(1 << RESET_BTN_PIN))));
			RTL_W32(PEFGH_DIR, (RTL_R32(PEFGH_DIR) & (~(1 << RESET_BTN_PIN))));
			//wps led initial
			RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR)&(~(1 << AUTOCFG_BTN_PIN))));
			RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR)&(~(1 << AUTOCFG_LED_PIN))));
			RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) & (~(1 << AUTOCFG_BTN_PIN))));
			RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) | (1 << AUTOCFG_LED_PIN)));
			//turn off wps led
			RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << AUTOCFG_LED_PIN)));
		}
#endif

#ifdef CONFIG_RTL8186_TR			
		else if (flag == '3') // update flash in special case		
			flash_write_flag = 0x8000;				
		else if (flag == '4') // enable system led blinking 
			system_led_blink = 1;	
		else if (flag == '5') // disable system led blinking 
			system_led_blink = 0;			
		else if (flag == '6')
			autoconfig_gpio_blink_quick();
		else if (flag == '7') // disable system led 
			system_led_blink = 2;								
#endif			

#ifdef CONFIG_RTL8186_KB
		else if (dim_all_led == 1)
		{
			goto check_dim_flag;
		}
		else if (flag == '3')
		{
			/* Enable wireless computer solid blue */
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x1<< 16)))|((0x2<< 16))));
			blinking_amber_wireless_computer = 0;
		}
		else if (flag == '4')
		{
			/* Enable wireless computer blinking amber */
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x2<< 16)))|((0x1<< 16))));
			blinking_amber_wireless_computer = 1;
		}
		else if (flag == '5')
		{
			/* disable wireless computer*/
			RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|((0x3<< 16))));
			blinking_amber_wireless_computer = 0;
		}
		else if (flag == '6')
		{
			/* Enable wire computer solid blue */
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x4<< 16)))|((0x8<< 16))));
			blinking_amber_wire_computer = 0;
		}
		else if (flag == '7')
		{
			/* Enable wire computer amber */
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x8<< 16)))|((0x4<< 16))));
			blinking_amber_wire_computer = 1;
		}
		else if (flag == '8')
		{
			/* Disable wire computer*/
			RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|((0xc<< 16))));
			blinking_amber_wire_computer = 0;
		}
		else if (flag == '9')
		{
			/* Enable modem/wan status solid blue */
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x10<< 16)))|((0x20<< 16))));
			blinking_amber_modem = 0;
		}
		else if (flag == 'a')
		{
			/* Enable modem/wan status blinking amber */
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x20<< 16)))|(((0x10<< 16)))));
			blinking_amber_modem = 1;
		}
		else if (flag == 'b')
		{
			/* Disable modem/wan status  */
			RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|((0x30<< 16))));
			blinking_amber_modem = 0;
		}
		else if (flag == 'c')
		{
			/* Enable Internet connected solid blue */
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x40<< 16)))|((0x80<< 16))));
			blinking_amber_Internet_connected = 0;
			blinking_blue_Internet_connected = 0;
		}
		else if (flag == 'd')
		{
			/* Enable Internet connected blinking blue */
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x40<< 16)))|(((0x80<< 16)))));
			blinking_blue_Internet_connected = 1;
			blinking_amber_Internet_connected = 0;
		}
		else if (flag == 'e')
		{
			/* Enable Internet connected blinking amber */
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0x80<< 16)))|(((0x40<< 16)))));
			blinking_amber_Internet_connected = 1;
			blinking_blue_Internet_connected = 0;
		}
		else if (flag == 'f')
		{
			/* Disable Internet connected */
			RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|((0xc0<< 16))));
			blinking_amber_Internet_connected = 0;
			blinking_blue_Internet_connected = 0;
		}
		else if (flag == 'g')
		{
			/* Enable wireless security solid blue */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x40<< 8)))|(((0x2<< 24)))));
			blinking_blue_wireless_security = 0;
			blinking_amber_wireless_security = 0;
		}
		else if (flag == 'h')
		{
			/* Enable wireless security blinking blue */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x40<< 8)))|(((0x2<< 24)))));
			blinking_blue_wireless_security = 1;
			blinking_amber_wireless_security = 0;
		}
		else if (flag == 'i')
		{
			/* Enable wireless security blinking amber */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x2<< 24)))|(((0x40<< 8)))));
			blinking_blue_wireless_security = 0;
			blinking_amber_wireless_security = 1;
		}
		else if (flag == 'j')
		{
			/* Disable wireless security */
			RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x20040<< 8))));
			blinking_blue_wireless_security = 0;
			blinking_amber_wireless_security = 0;
		}
		else if (flag == 'k')
		{
			/* Enable route/power solid blue */
			RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x1<< 24))));
			RTL_W32(LEDCR1, (RTL_R32(LEDCR1) | (0x2)));
			RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x2))));
			during_booting = 0;		/* disable booting sequence */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x10<< 16)))|((0x1e0)<<16)));
		}
		else if (flag == 'l')
		{
			/* Enable route/power blinking blue */
			RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x1<< 24))));
			RTL_W32(LEDCR1, (RTL_R32(LEDCR1) | (0x2)));
			RTL_W32(LEDBCR, (RTL_R32(LEDBCR)|((0x2))));
		}
		else if (flag == 'm')
		{
			/* Disable route/power */
			RTL_W32(LEDCR1, (RTL_R32(LEDCR1) & (~0x2)));
			RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x2))));
			RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x1<< 24))));
		}
		else if (flag == 'n')
		{
			/* Enable usb solid blue*/
			RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x8<< 16))));
			RTL_W32(LEDCR1, (RTL_R32(LEDCR1) | (0x1)));
			RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x1))));
			blinking_amber_usb = 0;
		}
		else if (flag == 'o')
		{
			/* Enable usb blinking blue*/
			RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x8<< 16))));
			RTL_W32(LEDCR1, (RTL_R32(LEDCR1) | (0x1)));
			RTL_W32(LEDBCR, (RTL_R32(LEDBCR)|((0x1))));
			blinking_amber_usb = 0;
		}
		else if (flag == 'p')
		{
			/* Enable usb blinking amber*/
			RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)&(~(0x8<< 16))));
			RTL_W32(LEDCR1, (RTL_R32(LEDCR1) & (~0x1)));
			RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x1))));
			blinking_amber_usb = 1;
		}
		else if (flag == 'q')
		{
			/* Disable usb */
			RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x8<< 16))));
			RTL_W32(LEDCR1, (RTL_R32(LEDCR1) & (~0x1)));
			RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x1))));
			blinking_amber_usb = 0;
		}
		else if (flag == 'r')
		{
			/*  wireless status solid blue  */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x2<< 16)))|(((0x4<< 16)))));
		}
		else if (flag == 's')
		{
			/*  wireless status off */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT))|(((0x6<< 16)))));
		}
		else if (flag == 'u')
		{
			/* Brightness 5%*/
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0xF8<< 24)))|((0xf0)<<24)));
		}
		else if (flag == 'v')
		{
			/* Brightness 15%*/
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0xF8<< 24)))|((0xe0)<<24)));
		}
		else if (flag == 'w')
		{
			/* Brightness 30%*/
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0xF8<< 24)))|((0xd0)<<24)));
		}
		else if (flag == 'x')
		{
			/* Brightness 60%*/
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0xF8<< 24)))|(0xa8)<<24));
		}
		else if (flag == 'y')
		{
			/* Brightness 100%*/
			RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0xF8<< 24)))|((0x80)<<24)));
		}
		else if (flag == 'Z')
		{	/* throughput 5% */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x10<< 16)))|((0x1e0)<<16)));
		}
		else if (flag == 'Y')
		{	/* throughput 15% */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x30<< 16)))|((0x1c0)<<16)));
		}
		else if (flag == 'X')
		{	/* throughput 30% */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x70<< 16)))|((0x180)<<16)));
		}
		else if (flag == 'W')
		{	/* throughput 60% */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0xf0<< 16)))|((0x100)<<16)));
		}
		else if (flag == 'V')
		{	/* throughput 100% */
			RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x1f0<< 16)))));
		}
		else if (flag == 'A')
		{	/* F/W update done  */
			update_flash_timestamp = jiffies;	
		}				
		else if (flag == 'U')
		{	/* Disable all led */
			dim_all_led = 1;
			autoconfig_gpio_off();			
		}

		{
check_dim_flag:
			if (flag == 'T' || dim_all_led>1)
			{	/* Enable power led directly, and check the wireless status.
				*   Leave all other led for timer
				*/
				switch(dim_all_led)
				{
					case 1:
						/* Enable route/power solid blue */
						RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x1<< 24))));
						RTL_W32(LEDCR1, (RTL_R32(LEDCR1) | (0x2)));
						RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x2))));
						dim_all_led = 2;
						if (led_bridghtness_status!=0)
						{
							flag = led_bridghtness_status;
							goto checkFlags;
						}
					case 2:
						dim_all_led = 3;
						if (wire_computer_status!=0)
						{
							flag = wire_computer_status;
							goto checkFlags;
						}
					case 3:
						dim_all_led = 4;
						if (wireless_status!=0)
						{
							flag = wireless_status;
							goto checkFlags;
						}
					case 4:
						dim_all_led = 5;
						if (wireless_security_status!=0)
						{
							flag = wireless_security_status;
							goto checkFlags;
						}
					case 5:
						dim_all_led = 6;
						if (wireless_computer_status!=0)
						{
							flag = wireless_computer_status;
							goto checkFlags;
						}
					case 6:
						dim_all_led = 7;
						if (internet_connected_status!=0)
						{
							flag = internet_connected_status;
							goto checkFlags;
						}
					case 7:
						dim_all_led = 8;
						if (wan_throughput_status!=0)
						{
							flag = wan_throughput_status;
							goto checkFlags;
						}
					case 8:
						dim_all_led = 0;
						if (usb_status!=0)
						{
							flag = usb_status;
							goto checkFlags;
						}
				}
			}
		}
#else		/*	#ifdef CONFIG_RTL8186_KB */
#if 0
#ifdef CONFIG_SQUASHFS
		else if (flag == '5')		
		{
			disable_power_led_blink=3; // set power-led off
		}
#endif
#endif
		else
			{}
#endif 		/*	#ifdef CONFIG_RTL8186_KB	*/

		return count;
	}
	else
		return -EFAULT;
}
#endif // AUTO_CONFIG

#ifdef CONFIG_RTL8186_KB
void led_blinking_blue(void)
{
	/* Enable usb blinking blue*/
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x8<< 16))));
      	RTL_W32(LEDCR1, (RTL_R32(LEDCR1) | (0x1)));
	RTL_W32(LEDBCR, (RTL_R32(LEDBCR)|((0x1))));
	blinking_amber_usb = 0;
}
void led_blinking_amber(void)
{
	/* Enable usb blinking amber*/
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)&(~(0x8<< 16))));
        RTL_W32(LEDCR1, (RTL_R32(LEDCR1) & (~0x1)));
        RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x1))));
	blinking_amber_usb = 1;
}
void led_off(void)                
{
	/* Disable usb */
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x8<< 16))));
	RTL_W32(LEDCR1, (RTL_R32(LEDCR1) & (~0x1)));
	RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x1))));
	blinking_amber_usb = 0;
}
#endif

static int default_read_proc(char *page, char **start, off_t off,
                     int count, int *eof, void *data)
{
      int len;
      len = sprintf(page, "%c\n", default_flag);
      if (len <= off+count) *eof = 1;
          *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
          return len;

}

static int default_write_proc(struct file *file, const char *buffer,
                      unsigned long count, void *data)
{
      if (count < 2)
         return -EFAULT;
      if (buffer && !copy_from_user(&default_flag, buffer, 1)) {
         return count;
         }
      return -EFAULT;
}

#ifdef READ_RF_SWITCH_GPIO
static int rf_switch_read_proc(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	int len;
	char flag;

	if (RTL_R32(RTL_GPIO_PABDATA) & (1 << 6))
		flag = '1';
	else
		flag = '0';
	len = sprintf(page, "%c\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}
#endif


int __init rtl_gpio_init(void)
{
	struct proc_dir_entry *res=NULL;

	printk("Realtek GPIO Driver for Flash Reload Default\n");

	// Set GPIOA pin 10(8181)/0(8186) as input pin for reset button
#ifdef CONFIG_RTL_EB8186
	RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) & (~(1 << RESET_BTN_PIN))));
#endif	
#if defined(CONFIG_RTL8186_KB)
	autoconfig_gpio_init();
#else

#if defined(CONFIG_RTL865X) && !defined(CONFIG_RTL8186_KB)
	RTL_W32(LEDCREG, 0x155500);
	RTL_W32(PEFGH_CNR, (RTL_R32(PEFGH_CNR) & (~(1 << RESET_BTN_PIN))));
	RTL_W32(PEFGH_DIR, (RTL_R32(PEFGH_DIR) & (~(1 << RESET_BTN_PIN))));	
#endif	
		
//#ifdef CONFIG_RTL_EB8186
	// Set GPIOA ping 2 as output pin for reset led
	RTL_W32(RTL_GPIO_PABDIR, (RTL_R32(RTL_GPIO_PABDIR) | ((1 << RESET_LED_PIN))));
//#endif
#endif
#ifdef AUTO_CONFIG
	res = create_proc_entry("gpio", 0, NULL);
	if (res) {
		res->read_proc = read_proc;
		res->write_proc = write_proc;
	}
	else {
		printk("Realtek GPIO Driver, create proc failed!\n");
	}
#endif
	res = create_proc_entry("load_default", 0, NULL);
        if (res) {
                res->read_proc=default_read_proc;
	        res->write_proc=default_write_proc;
	        }

#ifdef READ_RF_SWITCH_GPIO	        
	res = create_proc_entry("rf_switch", 0, NULL);
	if (res) {
		res->read_proc=rf_switch_read_proc;
		res->write_proc=NULL;
	}	            
#endif	

	init_timer (&probe_timer);
	probe_counter = 0;
	probe_state = PROBE_NULL;
#if (defined(CONFIG_RTL8186_TR)||defined(CONFIG_RTL8186_KB)) && defined(AUTO_CONFIG)
	probe_timer.expires = jiffies + 25;
#else
	probe_timer.expires = jiffies + 100;
#endif
	probe_timer.data = (unsigned long)NULL;
	probe_timer.function = &rtl_gpio_timer;
#if (defined(CONFIG_RTL8186_TR)||defined(CONFIG_RTL8186_KB)) && defined(AUTO_CONFIG)
	mod_timer(&probe_timer, jiffies + 25);
#else
	mod_timer(&probe_timer, jiffies + 100);
#endif

	return 0;
}


static void __exit rtl_gpio_exit(void)
{
	printk("Unload Realtek GPIO Driver \n");
	del_timer_sync(&probe_timer);
}


module_exit(rtl_gpio_exit);
module_init(rtl_gpio_init);

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("GPIO driver for Reload default");
