#include <linux/module.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/major.h>
#include <linux/kmod.h>
#include <linux/device.h>

//Realtek Header file define 
#include <asm/rtl865x/rtl865xc_asicregs.h>
#include <asm/mach-realtek/rtl_types.h>

#define RTL_GPIO_PABDIR		PABCD_DIR
#define RTL_GPIO_PABDATA	PABCD_DAT
#define RTL_GPIO_PABCNR		PABCD_CNR
#define RTL_GPIO_MUX 		0xB8000030
#define RTL_GPIO_MUX_DATA 	0x0FF00380 //for WIFI ON/OFF and GPIO
#define AUTOCFG_LED_PIN		18 //GPIOC1
#define WPS_LED_PIN		20 //GPIOC3
#define Get_GPIO_SW_IN() (!(REG32(RTL_GPIO_PABDATA) & (1<<0)) )
#define Get_WPS_SW_IN()  (!(REG32(RTL_GPIO_PABDATA) & (2<<0)) )

#define SWITCH_REG_BASE			0xBB800000
#define SWITCH_MULTICAST_OFFSET	(SWITCH_REG_BASE + 0x4428)

#ifdef GPIO_DEBUG
#define DEBUG_MSG(fmt, arg...)       printk(fmt, ##arg)
#else
#define DEBUG_MSG(fmt, arg...)
#endif


MODULE_DESCRIPTION("Realtek8196B GPIO driver");
MODULE_LICENSE("GPL");

static unsigned int gpio_ioctl (struct inode *inode, struct file *file, unsigned int gpio_pin, unsigned long gpio_action);
static int gpio_open (struct inode *inode, struct file *file);
static int gpio_release (struct inode *inode, struct file *file);

static struct file_operations gpio_fops = {
				owner:		THIS_MODULE,
				ioctl:		gpio_ioctl,
				open:		gpio_open,
				release:	gpio_release,
};

static int gpio_major = 201; 

/* tmp soultion: reboot by watch-dog (copy from loader) */
#define cli(x)              do { } while(0)
#define GIMR0    			0x3000
#define mips_io_port_base 	(0xB8000000)
void (*jumpF)(void);

void autoreboot()
{
	jumpF = (void *)(0xbfc00000);
	RTL_W32(0,GIMR0); // mask all interrupt	    
	cli();
#ifndef RTL8186
	//	   rtl_outl(ETH0_ADD+ NIC_CNR1, 0 ); //sc_yang
#else
	{
	unsigned int value;
	value = *(volatile unsigned int *)0xbd201434;
	value = value & 0xffffff00;
	*(volatile unsigned int *)(0xbd201434)=value;
	}
#endif

	prom_printf("\nreboot.......\n");
#if defined(RTL865X) || defined(RTL8196B)
	/* this is to enable 865xc watch dog reset */
	*(volatile unsigned long *)(0xB800311c)=0; 
	for(;;);
#endif
	/* reboot */
	jumpF();	
}

static unsigned int gpio_ioctl(struct inode *inode, struct file *file, unsigned int pin, unsigned long gpio_action)
{
	unsigned int gpio_data = 0;
	unsigned long value = 0; 
	unsigned long reg = 0;
	/* GPIO LED still have problem */
	if(gpio_action == 0) { 			// GPIO LED on
		RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << AUTOCFG_LED_PIN))));
	} else 	if(gpio_action == 1) {				// Read GPIO Push Buttion Data
		gpio_data = Get_GPIO_SW_IN();
	} else  if(gpio_action == 2) {  			// Read WPS Push Button 
		gpio_data = Get_WPS_SW_IN();
	} else  if(gpio_action == 3) {				// WPS LED on
		RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) & (~(1 << WPS_LED_PIN))));
	} else 	if(gpio_action == 4) {				// WPS LED off
		RTL_W32(RTL_GPIO_PABDATA, (RTL_R32(RTL_GPIO_PABDATA) | (1 << WPS_LED_PIN)));
	} else  if(gpio_action == 5) {
		RTL_W32(SWITCH_MULTICAST_OFFSET, (RTL_R32(SWITCH_MULTICAST_OFFSET) | 0x0010 )); 
	} else  if(gpio_action == 6) {
		RTL_W32(SWITCH_MULTICAST_OFFSET, (RTL_R32(SWITCH_MULTICAST_OFFSET) & 0xfff7 ));
	/* tmp soultion: reboot by watch-dog (copy from loader) */	
	} else if(gpio_action == 7){		
		autoreboot();
	}

		return gpio_data;
}

static int gpio_open (struct inode *inode, struct file *file)
{
	printk( "<1>gpio.o: opened.\n");
	//WPS and Stauts LED initialize GPIOC1 and GPIOC3
	RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | (RTL_GPIO_MUX_DATA)));
	RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR) & 0xfff5ffff));
	RTL_W32(PABCD_DIR,(RTL_R32(PABCD_DIR) | 0x000A0000));
	//printk("RTL_GPIO_MUX = 0x%08x \n",RTL_R32(RTL_GPIO_MUX));
	//printk("PABCD_CNR = 0x%08x, PABCD_DIR = 0x%8x\n",RTL_R32(PABCD_CNR),RTL_R32(PABCD_DIR));
	return 0;
}

static int gpio_release (struct inode *inode, struct file *file)
{
	printk( "<1>gpio.o: closed.\n");
	return 0;
}

static int __init gpio_init(void)
{
	int result;

	result = register_chrdev( gpio_major, "gpio_ioctl", &gpio_fops);
	
	if (result) {
		printk( "<1>gpio_ioctl : cannot get major %d\n", gpio_major);
		return result;
	}
	
	printk( "init gpio_ioctl Successful,  major = %d\n", gpio_major);
	return	0;
}



static void __exit gpio_exit(void)
{
	int result;
	result = unregister_chrdev(gpio_major, "gpio_ioctl");
	if(result) {
		printk("<1>gpio_ioctl : cannot get major %d\n", gpio_major);
	}
	return;
}

module_init(gpio_init);
module_exit(gpio_exit);
