#include <linux/config.h>
#include <linux/init.h>
#include <linux/string.h>
#include <linux/kernel.h>
#include <linux/ioport.h>
#include <linux/tty.h>
#include <linux/serial.h>
#include <linux/serial_core.h>

#include <asm/cpu.h>
#include <asm/bootinfo.h>
#include <asm/irq.h>
#include <asm/serial.h>
#include <asm/io.h>
#include <asm/time.h>

#include <prom.h>
#include <platform.h>

static void __init serial_init(void);
static void __init rtl8652_time_init(void);
static void rtl8652_timer_ack(void);

const char *get_system_type(void)
{
   return "RTL8652";
}

void __init prom_init(void)
{
   prom_console_init();
   prom_meminit();
}

void __init plat_mem_setup(void)
{
   /* Platform Specific Setup */
   serial_init();

   board_time_init = rtl8652_time_init;
   mips_timer_ack = rtl8652_timer_ack;
}

static void rtl8652_timer_ack(void)
{
   REG32(TCIR) |= TC0IP;
}

static void __init rtl8652_time_init(void)
{

}

void __init plat_timer_setup(struct irqaction *irq)
{
   /* Setup Timer0 */

   /* Clear Timer IP status */
   if (REG32(TCIR) & TC0IP)
      REG32(TCIR) |= TC0IP;

   /* Here irq->handler is passed from outside */
   irq->handler = timer_interrupt;
   setup_irq(TC0_IRQ, irq);

   REG32(TCCNR) = 0; /* disable timer before setting CDBR */
   REG32(CDBR) = (DIVISOR) << DIVF_OFFSET;
   REG32(TC0DATA) = (MHZ * (1000 / HZ)) << TCD_OFFSET;

   REG32(TCCNR) = TC0EN | TC0MODE_TIMER;
   REG32(TCIR) = TC0IE;
}

static void __init serial_init(void)
{
#ifdef CONFIG_SERIAL_8250
   struct uart_port s;

   memset(&s, 0, sizeof(s));

   s.type = PORT_16550A;
   s.membase = (unsigned char *) UART0_BASE;
   s.irq = UART0_IRQ;
   s.uartclk = SYSCLK - BAUDRATE * 24;
   s.flags = UPF_SKIP_TEST | UPF_LOW_LATENCY | UPF_SPD_CUST;
   s.iotype = UPIO_MEM;
   s.regshift = 2;
   s.fifosize = 1;
   s.custom_divisor = SYSCLK / (BAUDRATE * 16) - 1;

   /* Call early_serial_setup() here, to set up 8250 console driver */
   if (early_serial_setup(&s) != 0) {
      prom_printf("Serial setup failed!\n");
   }
#endif
}
