#!/bin/sh
#
# $Id: wan.sh,v 1.18 2009-02-09 13:29:37 michael Exp $
#
# usage: wan.sh
#

. /sbin/global.sh

unload_all_usb_module()
{
	usbserialLoaded=`lsmod |grep usbserial | awk '{print $3}'`
	if [ "$usbserialLoaded" != "" ] && [ "$usbserialLoaded" = "0" ]; then
		echo "Unload usbserial module.." > /dev/console
		/sbin/modprobe -r usbserial
	fi
		
	cdc_acmLoaded=`lsmod |grep cdc_acm | awk '{print $3}'`
	if [ "$cdc_acmLoaded" != "" ] && [ "$cdc_acmLoaded" = "0" ]; then
		echo "Unload CDC ACM module.." > /dev/console
		/sbin/modprobe -r cdc-acm			
	fi	
}

# stop all
killall -q syslogd
killall -q udhcpc
killall -q l2tpd
killall -q openl2tpd
killall -q pppd


clone_en=`nvram_get 2860 macCloneEnabled`
clone_mac=`nvram_get 2860 macCloneMac`
original_mac=`nvram_get 2860 OriginalWANMac`
#MAC Clone: bridge mode doesn't support MAC Clone
if [ "$opmode" != "0" -a "$clone_en" = "1" ]; then
	#checkMacClone $clone_mac &
	ifconfig $wan_if down
	ifconfig $wan_if hw ether $clone_mac
	ifconfig $wan_if up
	tCloneMac=`echo $clone_mac | awk -F: '{ print $1.$2.$3.$4.$5.$6}'`
	#switch add $tCloneMac 0000011 0
	#switch add $tCloneMac 0000011 1
	i2ccmd rtl clone $clone_mac
#add for mac cloning - U-Media Ricky Cao on Apr. 11 2008
elif [ "$opmode" != "0" -a "$clone_en" = "0" ]; then
	#i2ccmd rtl noclone $clone_mac 
	#killall checkMacClone 
	ifconfig $wan_if down
	ifconfig $wan_if hw ether $original_mac
	tCloneMac=`echo $clone_mac | awk -F: '{ print $1.$2.$3.$4.$5.$6}'`
	switch del $tCloneMac 0
	switch del $tCloneMac 1
	#i2ccmd rtl noclone $clone_mac
	ifconfig $wan_if up
#U-Media Ricky Cao on Apr. 11 2008
fi

#add for set WAN MTU - U-Media Ricky Cao on May 16 2008
wan_use_default_mtu=`nvram_get 2860 wan_use_default_mtu`
wan_mtu=`nvram_get 2860 wan_mtu`
if [ "$wan_use_default_mtu" = "1" ]; then
	if [ "$wanmode" = "STATIC" -o "$wanmode" = "DHCP" ]; then
		ifconfig eth2.2 mtu 1500
	fi
else
	if [ "$wanmode" = "STATIC" -o "$wanmode" = "DHCP" ]; then
		ifconfig eth2.2 mtu $wan_mtu
	else
		ifconfig eth2.2 mtu 1500
	fi
fi
#U-Media Ricky Cao on May 16 2008

#Jacky.Yang 05-Dec-2007 Fix bridge to support dhcp mode on WAN
#if [ "$wanmode" = "STATIC" -o "$opmode" = "0" ]; then
if [ "$wanmode" = "STATIC" ]; then
	#always treat bridge mode having static wan connection
	ip=`nvram_get 2860 wan_ipaddr`
	nm=`nvram_get 2860 wan_netmask`
	gw=`nvram_get 2860 wan_gateway`
	pd=`nvram_get 2860 wan_primary_dns`
	sd=`nvram_get 2860 wan_secondary_dns`

	#lan and wan ip should not be the same except in bridge mode
	if [ "$opmode" != "0" ]; then
		lan_ip=`nvram_get 2860 lan_ipaddr`
		if [ "$ip" = "$lan_ip" ]; then
			echo "wan.sh: warning: WAN's IP address is set identical to LAN"
			exit 0
		fi
	else
		#use lan's ip address instead
		ip=`nvram_get 2860 lan_ipaddr`
		nm=`nvram_get 2860 lan_netmask`
	fi
	ifconfig $wan_if $ip netmask $nm
	route del default
	if [ "$gw" != "" ]; then
	route add default gw $gw
	fi
	config-dns.sh $pd $sd
elif [ "$wanmode" = "DHCP" ]; then
	#Tom.Hung 2010-01-13, support DHCP DISCOVER hostname
	whostname=`nvram_get 2860 wHostName`
	if [ "$whostname" != "" ]; then
		if [ "$opmode" = "3" ]; then
			udhcpc -i br0 -s /sbin/udhcpc.sh -p /var/run/udhcpc.pid -h $whostname &
		else
			udhcpc -i $wan_if -s /sbin/udhcpc.sh -p /var/run/udhcpc.pid -h $whostname &
		fi
	else
		if [ "$opmode" = "3" ]; then
			udhcpc -i br0 -s /sbin/udhcpc.sh -p /var/run/udhcpc.pid &
		else
			udhcpc -i $wan_if -s /sbin/udhcpc.sh -p /var/run/udhcpc.pid &
		fi
	fi
	#Tom.Hung 2010-01-13
	
	#Jacky.Yang 27-Feb-2009, support manually configure dns server
	manuallyDNS=`nvram_get 2860 manuallyDNS`
	if [ "$manuallyDNS" = "1" ] ; then
		wan_primary_dns=`nvram_get 2860 wan_primary_dns`
		wan_secondary_dns=`nvram_get 2860 wan_secondary_dns`
		config-dns.sh $wan_primary_dns $wan_secondary_dns
	fi
elif [ "$wanmode" = "PPPOE" ]; then
	u=`nvram_get 2860 wan_pppoe_user`
	pw=`nvram_get 2860 wan_pppoe_pass`
	pppoe_opmode=`nvram_get 2860 wan_pppoe_opmode`
	if [ "$pppoe_opmode" = "" ]; then
		echo "pppoecd $wan_if -u $u -p $pw"
		pppoecd $wan_if -u "$u" -p "$pw"
	else
		pppoe_optime=`nvram_get 2860 wan_pppoe_optime`
		config-pppoe.sh $u $pw $wan_if $pppoe_opmode $pppoe_optime
	fi
	#Jacky.Yang 27-Feb-2009, support manually configure dns server
	manuallyDNS=`nvram_get 2860 manuallyDNS`
	if [ "$manuallyDNS" = "1" ] ; then
		wan_primary_dns=`nvram_get 2860 wan_primary_dns`
		wan_secondary_dns=`nvram_get 2860 wan_secondary_dns`
		config-dns.sh $wan_primary_dns $wan_secondary_dns
	fi
elif [ "$wanmode" = "L2TP" ]; then
	srv=`nvram_get 2860 wan_l2tp_server`
	u=`nvram_get 2860 wan_l2tp_user`
	pw=`nvram_get 2860 wan_l2tp_pass`
	mode=`nvram_get 2860 wan_l2tp_mode`
	l2tp_opmode=`nvram_get 2860 wan_l2tp_opmode`
	l2tp_optime=`nvram_get 2860 wan_l2tp_optime`
	if [ "$mode" = "0" ]; then
		ip=`nvram_get 2860 wan_l2tp_ip`
		nm=`nvram_get 2860 wan_l2tp_netmask`
		gw=`nvram_get 2860 wan_l2tp_gateway`
		if [ "$gw" = "" ]; then
			gw="0.0.0.0"
		fi
		config-l2tp.sh static $wan_if $ip $nm $gw $srv $u $pw $l2tp_opmode $l2tp_optime
	else
		config-l2tp.sh dhcp $wan_if $srv $u $pw $l2tp_opmode $l2tp_optime
	fi
	#Jacky.Yang 27-Feb-2009, support manually configure dns server
	manuallyDNS=`nvram_get 2860 manuallyDNS`
	if [ "$manuallyDNS" = "1" ] ; then
		wan_primary_dns=`nvram_get 2860 wan_primary_dns`
		wan_secondary_dns=`nvram_get 2860 wan_secondary_dns`
		config-dns.sh $wan_primary_dns $wan_secondary_dns
	fi
elif [ "$wanmode" = "PPTP" ]; then
	srv=`nvram_get 2860 wan_pptp_server`
	u=`nvram_get 2860 wan_pptp_user`
	pw=`nvram_get 2860 wan_pptp_pass`
	mode=`nvram_get 2860 wan_pptp_mode`
	pptp_opmode=`nvram_get 2860 wan_pptp_opmode`
	pptp_optime=`nvram_get 2860 wan_pptp_optime`
	if [ "$mode" = "0" ]; then
		ip=`nvram_get 2860 wan_pptp_ip`
		nm=`nvram_get 2860 wan_pptp_netmask`
		gw=`nvram_get 2860 wan_pptp_gateway`
		if [ "$gw" = "" ]; then
			gw="0.0.0.0"
		fi
		config-pptp.sh static $wan_if $ip $nm $gw $srv $u $pw $pptp_opmode $pptp_optime
	else
		config-pptp.sh dhcp $wan_if $srv $u $pw $pptp_opmode $pptp_optime
	fi
	#Jacky.Yang 27-Feb-2009, support manually configure dns server
	manuallyDNS=`nvram_get 2860 manuallyDNS`
	if [ "$manuallyDNS" = "1" ] ; then
		wan_primary_dns=`nvram_get 2860 wan_primary_dns`
		wan_secondary_dns=`nvram_get 2860 wan_secondary_dns`
		config-dns.sh $wan_primary_dns $wan_secondary_dns
	fi
#Add for Dialing-up with 3G modem - Ricky Cao
elif [ "$wanmode" = "3G" ]; then
	# Jacky.Yang 2-Jul-209, Drop Ralink SDK 3.3.0.0
        #dev=`nvram_get 2860 wan_3g_dev`
        #3g.sh $dev &
	echo "WAN type is configured to 3.5G"
	
	configChatIsRun=`ps > /tmp/psTmp; cat /tmp/psTmp | grep config-chat.sh; rm /tmp/psTmp`
	if [ "$configChatIsRun" != "" ]; then
		killall config-chat.sh
	fi
	
	#When device build-in Diffon ME100 module, it maybe has two 3G modem on system at the same time
	#We probide a control item on GUI for user to assign which interface to use
	#Ricky CAO
	echo "ME100 module appear on system"
	threeGIfName=`nvram_get 2860 ThreeGInterface`
	if [ "$threeGIfName" = "" ]; then
		threeGIfName="USB"
	fi
	/sbin/config-chat.sh "$threeGIfName" &
else
	echo "wan.sh: unknown wan connection type: $wanmode"
	exit 1
fi

#Add for Dialing-up with 3G modem - Ricky Cao
if [ "$wanmode" != "3G" ]; then
	killall config-chat.sh
fi
