#!/bin/sh -x

# udhcpc script edited by Tim Riker <Tim@Rikers.org>
old_ip=`ifconfig eth2.2 | grep 'inet ' | sed -e 's/^.*addr://g' |sed 's/Bcast.*$//g' |sed 's/ //g'`

[ -z "$1" ] && echo "Error: should be called from udhcpc" && exit 1

RESOLV_CONF="/etc/resolv.conf"
[ -n "$broadcast" ] && BROADCAST="broadcast $broadcast"
[ -n "$subnet" ] && NETMASK="netmask $subnet"

if [ -e /var/addOptionRoute  ]; then
	rm /var/addOptionRoute
fi 

#if [ 0 ]; then # DHCP option 33,121,249,  still have some problem, so do not release.
# David Lin, 2009-09-08, support dhcp option 33
[ -n "$staticroute" ] && {
	echo "DHCP option 33, data capture..."
	while [ 1 ]; do
		get_dest=$(echo $staticroute | awk '{ print $1 }')
		get_gw=$(echo $staticroute | awk '{ print $2 }')
		echo "route add -net $get_dest netmask 255.255.255.255 gw $get_gw dev $interface" >> /var/addOptionRoute
		#echo "[ADD ststic route]route add -net $get_dest netmask 255.255.255.255 gw $get_gw dev $interface" > /dev/console
		staticroute=$(echo $staticroute | sed "s/$get_dest $get_gw//g")
		chmod 755 /var/addOptionRoute

                # Leave the loop if staticroute is empty (we've parsed everything)
                [ ! -n "$staticroute" ] && break
	done
}
# David Lin, 2009-09-08

# David Lin, 2009-08-17, support dhcp option 121,249, CIDR STATIC ROUTES (rfc3442)
[ -n "$mscidrroute" ] && {
	echo "DHCP option 249, data capture..." > /dev/console
	cidrroute_data="$(echo $mscidrroute )"
}

[ -n "$cidrroute" ] && {
        echo "DHCP option 121, data capture..." > /dev/console
        cidrroute_data="$(echo $cidrroute ) $(echo $mscidrroute )"
}

[ -n "$cidrroute_data" ] && {
	# This defines how many CIDR Routes can be assigned so that we do not enter
	# an endless loop on malformed data
	MAXCIDRROUTES=24;
	ROUTECOUNTER=0;
	while [ ${MAXCIDRROUTES} -gt "0" ]; do
		# Format is
		# $MASK $NW $GW
		# $NW == AAA.BBB.CCC.DDD
		# $GW == EEE.FFF.CCC.DDD
		# $MASK AAA.[BBB].[CCC].[DDD] EEE.FFF.GGG.HHH
		#   1    2    3     4     5    6   7   8   9
		#cidrroute_data=$(echo $cidrroute_data | sed '/^[ \t]*//' )
		MASK=$(echo $cidrroute_data | awk '{ print $1 }')
		DeleteRule=""
		if [ ${MASK} = "0" ] ; then
			# $MASK EEE.FFF.GGG.HHH
			#   1    2   3   4   5
			NW="0.0.0.0"
			GW=$(echo $cidrroute_data | awk '{ print $2"."$3"."$4"."$5 }' )
			MASK_value="0.0.0.0"
			DeleteRule=$(echo $cidrroute_data | awk '{ print $1" "$2" "$3" "$4" "$5 }' )
		elif [ ${MASK} -le "8" ] ; then
			# $MASK AAA EEE.FFF.GGG.HHH
			#   1    2   3   4   5   6
			NW=$(echo $cidrroute_data | awk '{ print $2".0.0.0" }' )
			GW=$(echo $cidrroute_data | awk '{ print $3"."$4"."$5"."$6 }' )
			MASK_value="255.0.0.0"
			DeleteRule=$(echo $cidrroute_data | awk '{ print $1" "$2" "$3" "$4" "$5" "$6 }' )
		elif [ ${MASK} -le "16" ] ; then
			# $MASK AAA.BBB EEE.FFF.GGG.HHH
			#   1    2   3   4   5   6   7
			NW=$(echo $cidrroute_data | awk '{ print $2"."$3".0.0" }' )
			GW=$(echo $cidrroute_data | awk '{ print $4"."$5"."$6"."$7 }' )
			MASK_value="255.255.0.0"
			DeleteRule=$(echo $cidrroute_data | awk '{ print $1" "$2" "$3" "$4" "$5" "$6" "$7 }' )
		elif [ ${MASK} -le "24" ] ; then
			# $MASK AAA.BBB.CCC EEE.FFF.GGG.HHH
			#   1    2   3   4   5   6   7   8
			NW=$(echo $cidrroute_data | awk '{ print $2"."$3"."$4".0" }' )
			GW=$(echo $cidrroute_data | awk '{ print $5"."$6"."$7"."$8 }' )
			MASK_value="255.255.255.0"
			DeleteRule=$(echo $cidrroute_data | awk '{ print $1" "$2" "$3" "$4" "$5" "$6" "$7" "$8 }' )
			else
			# $MASK AAA.BBB.CCC.DDD EEE.FFF.GGG.HHH
			#   1    2   3   4   5   6   7   8   9
			NW=$(echo $cidrroute_data | awk '{ print $2"."$3"."$4"."$5 }' )
			GW=$(echo $cidrroute_data | awk '{ print $6"."$7"."$8"."$9 }' )
			MASK_value="255.255.255.255"
			DeleteRule=$(echo $cidrroute_data | awk '{ print $1" "$2" "$3" "$4" "$5" "$6" "$7" "$8" "$9 }' )
		fi
		#echo [$ROUTECOUNTER] Route Network: $NW/$MASK Gateway: $GW on $interface > /dev/console
		# TODO: Check for malformed data here to eliminate counter workaround
 		# Malformed data is: ... or xxx... or xxx.yyy.. or xxx.yyy.zzz.

		[ -n "$NW" ] && [ -n "$GW" ] && {
			echo "route add -net $NW netmask $MASK_value gw $GW dev $interface" >> /var/addOptionRoute
			#echo "[$ROUTECOUNTER]route add -net $NW netmask $MASK_value gw $GW dev $interface" > /dev/console
			chmod 755 /var/addOptionRoute
		}

		#echo "DeleteRule=>[$DeleteRule]" > /dev/console
		cidrroute_data=$(echo $cidrroute_data | sed "s/$DeleteRule//g")

		# Add to counter
		ROUTECOUNTER=`expr $ROUTECOUNTER + 1`
		MAXCIDRROUTES=`expr $MAXCIDRROUTES - 1`
		
		# Leave the loop if cidrroutes is empty (we've parsed everything)
		[ ! -n "$cidrroute_data" ] && break
	done
	echo "done."
}	
# David Lin, 2009-08-17
#fi

case "$1" in
    deconfig)
        /sbin/ifconfig $interface 0.0.0.0
        # Add for wan status query - U-Media Ricky Cao on Apr. 24 2008
	echo 0 > /var/wan_status
        ;;

    renew|bound)
        /sbin/ifconfig $interface $ip $BROADCAST $NETMASK

        if [ -n "$router" ] ; then
            echo "deleting routers"
            while route del default gw 0.0.0.0 dev $interface ; do
                :
            done

            metric=0
            for i in $router ; do
                metric=`expr $metric + 1`
                route add default gw $i dev $interface metric $metric
                #Add for recove the default after PPP disconnec - U-Media Ricky Cao on May 6 2008
                echo "#!/bin/sh" > /var/addDefaultRoute
                echo "#This commend for recover the default after the PPP disconnect" >> /var/addDefaultRoute
                echo "route add default gw $i dev $interface metric $metric" >> /var/addDefaultRoute
                chmod 755 /var/addDefaultRoute
                #U-Media Ricky Cao on May 6 2008
            done
        fi
   #Add for insert static route - U-Media Ricky Cao on Apr. 18 2008
   if [ -e /var/staticRoute  ]; then
   	/var/staticRoute
   fi

   #David Lin, 2009-11-10, Add for DHCP option 33,121,249
   if [ -e /var/addOptionRoute ]; then
        /var/addOptionRoute
   fi
   #David Lin, 2009-11-10

   #U-Media Ricky Cao on Apr. 18 2008
   #Jacky.Yang 27-Feb-2009, support manually configure dns server
   manuallyDNS=`nvram_get 2860 manuallyDNS`
   if [ "$manuallyDNS" != "1" ] ; then
        echo -n > $RESOLV_CONF
        [ -n "$domain" ] && echo search $domain >> $RESOLV_CONF
	#Jacky.Yang 7-Oct-2009, we don't need to kill udhcpd now, if needed, we will kill it first then re-initial again.
	#killall -q udhcpd
	loopCount=0
       	for i in $dns ; do
	   echo adding dns $i
                 echo nameserver $i >> $RESOLV_CONF
               #Jacky.Yang fix dhcp server can't get correct dns server
	       loopCount=`expr $loopCount + 1`
               if [ $loopCount -eq 1 ] ; then
		   #echo "$i save to nvram wan_primary_dns"
                   #nvram_set 2860 wan_primary_dns $i
		   #nvram_set 2860 wan_secondary_dns ""
		   pd=$i
               fi

               if [ $loopCount -eq 2 ] ; then
	     #echo "$i save to nvram wan_secondary_dns"
                   #nvram_set 2860 wan_secondary_dns $i
                   sd=$i
               fi
       done
   else
	#Jacky.Yang 27-Feb-2009, support manually configure dns server
	pd=`nvram_get 2860 wan_primary_dns`
	sd=`nvram_get 2860 wan_secondary_dns`
	echo nameserver $pd > $RESOLV_CONF
	echo nameserver $sd >> $RESOLV_CONF
   fi

	#Jacky.Yang 6-Nov-2009, We don't need configure udhcpd because we has supported dns relay. We don't need set dns ip again.
	#Jacky.Yang 20-May-2008, change original rule for dns relay.
	#lanIP=`nvram_get 2860 lan_ipaddr`
	#config-udhcpd.sh -d $pd $sd
	#config-udhcpd.sh -d $lanIP
	#config-udhcpd.sh -r
	
	#Add for keep both of WAN dns and PPTP dns - U-Media Ricky Cao on Apr. 18 2008
	cp -f /etc/resolv.conf /etc/wan_resolv.conf
	#U-Media Ricky Cao on Apr. 18 2008

	#Ricky CAO 2010-01-04, add for re-initiate ddns client to force update IP.
	DDNS_PROVIDER=`nvram_get 2860 DDNSProvider`
	if [ ! $DDNS_PROVIDER = "none" -a ! $DDNS_PROVIDER = "" ]; then
		echo "re-initiate dynamic DNS daemon" > /dev/console
		ddns.sh

		#Since inadyn seems be terminated before it finish to initiate on sometime
		#So, confirm it is finish to run on background before do another procedure.
		#Ricky CAO
		INADYN_PID=`ps | grep inadyn | grep -v "grep" | awk '{print $1}'`
		while [ $INADYN_PID = "" ]
		do
			sleep 1
			INADYN_PID=`ps | grep inadyn | grep -v "grep" | awk '{print $1}'`
		done
	fi

	#Jacky.Yang 25-Mar-2008, reload firewall rules
  	#Joan.Huang 2010.01.04 ,add condition to fixed stress issue.
  	 if [ "$old_ip" != "$ip" ] ; then
  		echo "run firewall_init from udhcpc.sh(old_ip='$old_ip' , new_IP='$ip')" > /dev/console
			send_event firewall_reload
   	fi
	# Add for wan status query - U-Media Ricky Cao on Apr. 24 2008
	echo 1 > /var/wan_status
        ;;
esac

exit 0

