#!/bin/sh
#
# $Id: lan.sh,v 1.24.2.1 2009-04-21 12:49:37 michael Exp $
#
# usage: wan.sh
#

. /sbin/global.sh

# stop all

killall -q lld2d
killall -q igmpproxy
killall -q upnpd
killall -q radvd
killall -q pppoe-relay
killall -q dnsmasq
rm -rf /var/run/lld2d-*
echo "" > /var/udhcpd.leases

# ip address
ip=`nvram_get 2860 lan_ipaddr`
nm=`nvram_get 2860 lan_netmask`
ifconfig $lan_if down
ifconfig $lan_if $ip netmask $nm
opmode=`nvram_get 2860 OperationMode`
if [ "$opmode" = "0" ]; then
	gw=`nvram_get 2860 wan_gateway`
	pd=`nvram_get 2860 wan_primary_dns`
	sd=`nvram_get 2860 wan_secondary_dns`
	route del default
	route add default gw $gw
	config-dns.sh $pd $sd
fi

ifconfig "br0:9" down
ifconfig "eth2:9" down
lan2enabled=`nvram_get 2860 Lan2Enabled`
if [ "$lan2enabled" = "1" ]; then
	ip_2=`nvram_get 2860 lan2_ipaddr`
	nm_2=`nvram_get 2860 lan2_netmask`
	if [ "$opmode" = "0" ]; then
		ifconfig "br0:9" "$ip_2" netmask "$nm_2"
		echo "ifconfig "br0:9" "$ip_2" netmask "$nm_2""
	elif [ "$opmode" = "1" ]; then
		ifconfig "br0:9" "$ip_2" netmask "$nm_2"
		echo "ifconfig "br0:9" "$ip_2" netmask "$nm_2""
	elif [ "$opmode" = "2" ]; then
		ifconfig "eth2:9" "$ip_2" netmask "$nm_2"
		echo "ifconfig "eth2:9" "$ip_2" netmask "$nm_2""
	elif [ "$opmode" = "3" ]; then
		ifconfig "br0:9" "$ip_2" netmask "$nm_2"
		echo "ifconfig "br0:9" "$ip_2" netmask "$nm_2""
	fi
fi

# hostname
host=`nvram_get 2860 HostName`
if [ "$host" = "" ]; then
	host="Router"
	nvram_set 2860 HostName Router
fi
hostname $host
echo "127.0.0.1 localhost.localdomain localhost" > /etc/hosts
echo "$ip $host $host" >> /etc/hosts

#Jacky.Yang udhcpd remove to single file udhcpd.sh, and that will run in the internet.sh file.

# stp
if [ "$wan_if" = "br0" -o "$lan_if" = "br0" ]; then
	stp=`nvram_get 2860 stpEnabled`
	if [ "$stp" = "1" ]; then
		brctl setfd br0 15
		brctl stp br0 1
	else
		brctl setfd br0 1
		brctl stp br0 0
	fi
fi

# lltd
lltd=`nvram_get 2860 lltdEnabled`
if [ "$lltd" = "1" ]; then
	lld2d $lan_if
fi

# igmpproxy
igmp=`nvram_get 2860 igmpEnabled`
if [ "$igmp" = "1" ]; then
	config-igmpproxy.sh $wan_if $lan_if
fi

# upnp
if [ "$opmode" = "0" -o "$opmode" = "1" -o "$opmode" = "3" ]; then
	#firewall init for upnp
	iptables -F FORWARD_UPnP
	iptables -t nat -F PREROUTING_UPnP
	iptables -N FORWARD_UPnP
	iptables -t nat -N PREROUTING_UPnP
	route del -net 239.0.0.0 netmask 255.0.0.0

	upnp=`nvram_get 2860 upnpEnabled`
	if [ "$upnp" != "0" ]; then
		route add -net 239.0.0.0 netmask 255.0.0.0 dev $lan_if
		#Jacky.Yang 2-Mar-2009, change and fix upnp confuse issue.
		echo "Start UPnP: upnpd"
		#upnp_xml.sh $ip
		LANIP=`nvram_get 2860 lan_ipaddr`
		
		# Jacky.Yang 31-Dec-2008,  start - fix upnp init procedure.
		if [ ! -f /etc/linuxigd/gatedesc_orig.xml ]; then
			cp /etc/linuxigd/gatedesc.xml /etc/linuxigd/gatedesc_orig.xml
		fi
		cp /etc/linuxigd/gatedesc_orig.xml /etc/linuxigd/gatedesc.xml
		# Jacky.Yang 31-Dec-2008,  End - fix upnp init procedure.

		echo "<presentationURL>http://${LANIP}/</presentationURL>" >> /etc/linuxigd/gatedesc.xml
		echo "</device>" >> /etc/linuxigd/gatedesc.xml
		echo "</deviceList>" >> /etc/linuxigd/gatedesc.xml
		echo "<presentationURL>http://${LANIP}/</presentationURL>" >> /etc/linuxigd/gatedesc.xml
		echo "</device>" >> /etc/linuxigd/gatedesc.xml
		echo "<presentationURL>http://${LANIP}/</presentationURL>" >> /etc/linuxigd/gatedesc.xml
		echo "</root>" >> /etc/linuxigd/gatedesc.xml
		wanMode=`nvram_get 2860 wanConnectionMode`
		#Add L2TP and PPTP, because both type also use the ppp0 interface for Internet connection
		#U-Media Ricky Cao on May 5 2008
		if [ "${wanMode}" = "PPPOE" -o "${wanMode}" = "L2TP" -o "${wanMode}" = "PPTP" -o "${wanMode}" = "3G" ]; then
        		wanIF="ppp0"
		else
        		wanIF="eth2.2"
		fi
		#upnpd -f $wan_ppp_if $lan_if &
		echo "check: ${wanIF} $lan_if"
		/bin/upnpd ${wanIF} $lan_if

		route add -host 239.255.255.250 dev br0
		killall wscd 1>/dev/null 2>&1
		killall -9 wscd 1>/dev/null 2>&1
		wscd -m 1 -a $ip -i ra0 &

	fi
fi

# radvd
radvd=`nvram_get 2860 radvdEnabled`
ifconfig sit0 down
echo "0" > /proc/sys/net/ipv6/conf/all/forwarding
if [ "$radvd" = "1" ]; then
	echo "1" > /proc/sys/net/ipv6/conf/all/forwarding
	ifconfig sit0 up
	ifconfig sit0 add 2002:1101:101::1101:101/16
	route -A inet6 add 2000::/3 gw ::17.1.1.20 dev sit0
	route -A inet6 add 2002:1101:101:0::/64 dev br0
	radvd -C /etc_ro/radvd.conf -d 1 &
fi

# pppoe-relay
pppr=`nvram_get 2860 pppoeREnabled`
if [ "$pppr" = "1" ]; then
	pppoe-relay -S $wan_if -B $lan_if
fi

# dns proxy
dnsp=`nvram_get 2860 dnsPEnabled`
if [ "$dnsp" = "1" ]; then
	dnsmasq &
fi

#Jacky.Yang run the udhcpd.sh file to initial dhcp server config file and run the daemon.
# Jacky.Yang 7-Oct-2009, for DHCP Server re-initial issue.
if [ "$1" != "setWan" -a "$1" != "wirelessBasic" -a "$1" != "wirelessAdvanced"  -a "$1" != "advancedNetwork" ]; then
	killall -q udhcpd
	udhcpd.sh
fi
