#!/bin/sh

CHAT_FILE=/etc/options.chat
CHAT_CONNECT_FILE=/sbin/chat_connect.sh
CHAT_SCRIPT_FILE=/etc/chat_script
CHAT_SCRIPT_FINAL_FILE=/etc/chat_script_final

Country=`nvram_get 2860 ThreeGCountry`
DialNumber=`nvram_get 2860 ThreeGDialNum`
Username=`nvram_get 2860 ThreeGUsername`
Password=`nvram_get 2860 ThreeGPassword`
Apn=`nvram_get 2860 ThreeGApn`
EnablePin=`nvram_get 2860 ThreeGEnablePinNum`
Pin=`nvram_get 2860 ThreeGPinNum`

CHAT_OPMODE=`nvram_get 2860 ThreeGOpmode`
CHAT_OPTIME=`nvram_get 2860 ThreeGOptime`

threeGIfName=`nvram_get 2860 ThreeGInterface`
if [ "$threeGIfName" = "" ]; then
	threeGIfName="USB"
fi


ModuleProdID=`cat /proc/bus/usb/devices | grep 'Vendor=1fac' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
if [ "$ModuleProdID" != "" ]; then
	ModuleVendorID="1fac"
fi

ProdID=`cat /proc/bus/usb/devices | grep 'Vendor=1519' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
if [ "$ProdID" != "" ]; then
	Vendor="1519"
fi
if [ "$ProdID" = "" ]; then
	ProdID=`cat /proc/bus/usb/devices | grep 'Vendor=12d1' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
	if [ "$ProdID" != "" ]; then
		Vendor="12d1"
	fi
fi
if [ "$ProdID" = "" ]; then
	ProdID=`cat /proc/bus/usb/devices | grep 'Vendor=19d2' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
	if [ "$ProdID" != "" ]; then
		Vendor="19d2"
	fi
fi
if [ "$ProdID" = "" ]; then
	ProdID=`cat /proc/bus/usb/devices | grep 'Vendor=0b05' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
	if [ "$ProdID" != "" ]; then
		Vendor="0b05"
	fi
fi
if [ "$ProdID" = "" ]; then
	ProdID=`cat /proc/bus/usb/devices | grep 'Vendor=1a8d' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
	if [ "$ProdID" != "" ]; then
		Vendor="1a8d"
	fi
fi
if [ "$ProdID" = "" ]; then
	ProdID=`cat /proc/bus/usb/devices | grep 'Vendor=0408' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
	if [ "$ProdID" != "" ]; then
		Vendor="0408"
	fi
fi
if [ "$ProdID" = "" ]; then
	ProdID=`cat /proc/bus/usb/devices | grep 'Vendor=1199' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
	if [ "$ProdID" != "" ]; then
		Vendor="1199"
	fi
fi
if [ "$ProdID" = "" ]; then
	ProdID=`cat /proc/bus/usb/devices | grep 'Vendor=16d8' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
	if [ "$ProdID" != "" ]; then
		Vendor="16d8"
	fi
fi
if [ "$ProdID" = "" ]; then
	ProdID=`cat /proc/bus/usb/devices | grep 'Vendor=1da5' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
	if [ "$ProdID" != "" ]; then
		Vendor="1da5"
	fi
fi
if [ "$ProdID" = "" ]; then
	ProdID=`cat /proc/bus/usb/devices | grep 'Vendor=0fce' | sed 's/^.*ProdID=//g' | sed 's/ Rev=.*$//g'`
	if [ "$ProdID" != "" ]; then
		Vendor="0fce"
	fi
fi

if [ "$1" != "" ]; then                                                          
        #echo "parameter 1=$1"
	USB_NAME="$1"
elif [ -e /dev/ttyUSB0 ]; then
	USB_NAME="ttyUSB0"
elif [ -e /dev/ttyACM0 ]; then
	USB_NAME="ttyACM0"
fi

# Create options.chat for configure pppd
# usbserial device, some options:
echo $USB_NAME > $CHAT_FILE
echo "115200" >> $CHAT_FILE
echo "idle 7200" >> $CHAT_FILE
echo "lock" >> $CHAT_FILE
echo "crtscts" >> $CHAT_FILE
echo "modem" >> $CHAT_FILE
echo "noauth" >> $CHAT_FILE
# dns, routing
echo "usepeerdns" >> $CHAT_FILE
if [ $CHAT_OPMODE = "KeepAlive" ]; then
	echo "persist" >> $CHAT_FILE
	echo "holdoff $CHAT_OPTIME" >> $CHAT_FILE
elif [ $CHAT_OPMODE = "OnDemand" ]; then
	CHAT_OPTIME=`expr $CHAT_OPTIME \* 60`
	echo "demand" >> $CHAT_FILE
	echo "idle $CHAT_OPTIME" >> $CHAT_FILE
	echo "active-filter 'outbound and not dst port 123'" >> $CHAT_FILE	
fi
#replacedefaultroute
echo "defaultroute" >> $CHAT_FILE
echo "noipdefault" >> $CHAT_FILE
# avoid compression:
echo "noccp" >> $CHAT_FILE
echo "nobsdcomp" >> $CHAT_FILE
echo "novj" >> $CHAT_FILE
# usually doesnt matter for GPRS/UMTS connections:
if [ "$Username" = "" ]; then
	echo "user \"username\"" >> $CHAT_FILE
else
	echo "user \"$Username\"" >> $CHAT_FILE
fi
if [ "$Password" = "" ]; then
	echo "password \"password\"" >> $CHAT_FILE
else
	echo "password \"$Password\"" >> $CHAT_FILE
fi
echo "ip-up-script \"/sbin/ppp-ip-up\"" >> $CHAT_FILE
echo "ip-down-script \"/sbin/ppp-ip-down\"" >> $CHAT_FILE
# connect script
echo "connect \"/sbin/chat_connect.sh\"" >> $CHAT_FILE
echo "debug" >> $CHAT_FILE
# t-mobile specific?
#ipcp-restart 8
#ipcp-max-configure 50
#ipcp-accept-local
#ipcp-accept-remote 

# Create chat_connect.sh for dial-up with 3.5G modem
echo "#!/bin/sh" > $CHAT_CONNECT_FILE
echo "set -x" >> $CHAT_CONNECT_FILE
# call the preparation chat script (with pin and if this fails without pin)
echo "/bin/chat -VVVV -f /etc/chat_script" >> $CHAT_CONNECT_FILE
# wait to switch between GPRS/UMTS
echo "sleep 6" >> $CHAT_CONNECT_FILE
# the final chat script:
echo "/bin/chat -VVVV -f /etc/chat_script_final" >> $CHAT_CONNECT_FILE
echo "" >> $CHAT_CONNECT_FILE

# Create chat_script for dial-up with 3.5G modem
echo "ABORT BUSY" > $CHAT_SCRIPT_FILE
echo "ABORT ERROR" >> $CHAT_SCRIPT_FILE
echo "ABORT 'NO CARRIER'" >> $CHAT_SCRIPT_FILE
echo "REPORT CONNECT" >> $CHAT_SCRIPT_FILE
echo "TIMEOUT 10" >> $CHAT_SCRIPT_FILE

if [ "$EnablePin" = "1" ] && [ "$Pin" != "" ]; then
	echo "\"\" \"AT+CPIN=\\\"$Pin\\\"\"" >> $CHAT_SCRIPT_FILE
	echo "OK \"ATZ\"" >> $CHAT_SCRIPT_FILE
else
	echo "\"\" \"ATZ\"" >> $CHAT_SCRIPT_FILE
fi

if [ "$threeGIfName" = "USB" ] && [ "$Vendor" = "19d2" ] && [ "$ProdID" = "0031" ]; then
	echo "OK \"ATV1\"" >> $CHAT_SCRIPT_FILE
	echo "OK \"ATE0\"" >> $CHAT_SCRIPT_FILE
	echo "OK \"AT&F&D2&C1S0=0\"" >> $CHAT_SCRIPT_FILE
	echo "OK \"ATS7=60S30=0\"" >> $CHAT_SCRIPT_FILE
else
	echo "OK \"ATE1V1&D2&C1S0=0+FCLASS=0\"" >> $CHAT_SCRIPT_FILE
fi

threeGIfName=`nvram_get 2860 ThreeGInterface`
if [ "$threeGIfName" = "Module" ] && [ "$ModuleVendorID" = "1fac" ]; then
	#Since ME100 is EVDO modem and doesn't support to +CFUN and +CGDCONT
	echo "Skip AT Command +CFUN and +CGDCONT"
elif [ "$Vendor" = "16d8" ] && [ "$ProdID" = "6803" ]; then
	#Since CDU-680 is EVDO modem and doesn't support to +CFUN and +CGDCONT
	echo "Skip AT Command +CFUN and +CGDCONT"
elif [ "$Vendor" = "16d8" ] && [ "$ProdID" = "6002" ]; then
	#Since CMU-300 is EVDO modem and doesn't support to +CFUN and +CGDCONT
	echo "Skip AT Command +CFUN and +CGDCONT"
else
	if [ "$Apn" != "" ]; then
		if [ "$ProdID" = "1519" ]; then
			echo "OK \"AT+CGDCONT=1,\\\"IP\\\",\\\"$Apn\\\"\"" >> $CHAT_SCRIPT_FILE
		else
			echo "OK \"AT+CFUN=1;+CGDCONT=1,\\\"IP\\\",\\\"$Apn\\\"\"" >> $CHAT_SCRIPT_FILE
		fi
	else
		if [ "$ProdID" = "1519" ]; then
			echo "OK \"AT+CGDCONT=1,\\\"IP\\\"\"" >> $CHAT_SCRIPT_FILE
		else
			echo "OK \"AT+CFUN=1;+CGDCONT=1,\\\"IP\\\"\"" >> $CHAT_SCRIPT_FILE
		fi
	fi
fi

#echo "SAY \"\\nWaiting 20 Seconds to switch between UMTS/GPRS ...\\n\"" >> $CHAT_SCRIPT_FILE
echo "" >> $CHAT_SCRIPT_FILE

# Create chat_script_final for dial-up with 3.5G modem
echo "ABORT BUSY" > $CHAT_SCRIPT_FINAL_FILE
echo "ABORT 'NO CARRIER'" >> $CHAT_SCRIPT_FINAL_FILE
echo "ABORT ERROR" >> $CHAT_SCRIPT_FINAL_FILE
echo "REPORT CONNECT" >> $CHAT_SCRIPT_FINAL_FILE
echo "TIMEOUT 10" >> $CHAT_SCRIPT_FINAL_FILE
echo "SAY \"Calling ONE\\n\"" >> $CHAT_SCRIPT_FINAL_FILE
echo "TIMEOUT 60" >> $CHAT_SCRIPT_FINAL_FILE
if [ "$DialNumber" = "" ]; then
echo "\"\" \"ATD*99#\"" >> $CHAT_SCRIPT_FINAL_FILE
else
echo "\"\" \"ATD$DialNumber\"" >> $CHAT_SCRIPT_FINAL_FILE
fi
echo "CONNECT \\c" >> $CHAT_SCRIPT_FINAL_FILE
echo "" >> $CHAT_SCRIPT_FINAL_FILE

chmod 744 /sbin/chat_connect.sh
chmod 744 /etc/chat_script
chmod 744 /etc/chat_script_final

if [ ! -e /var/lock ]; then
	mkdir /var/lock
fi
