#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>

#include <stdarg.h>

#include <string.h>

#include "defs.h"
#include "fgetline.h"
#include "connection.h"

extern Connection _channel;

FILE* rpsINFILE()
{
    return _channel.in;
}

FILE* rpsOUTFILE()
{
    return _channel.out;
}

int rpsFinish()
{
    fprintf(_channel.out, "%s\n", ".Finish.");
    if (fflush(_channel.out) != 0)
        return -1;
    return 0;
}

int rpsMessage(const char *fmt, ...)
{
    int nio = -1;
    va_list ap;
    va_start(ap, fmt);
    nio = vfprintf(_channel.out, fmt, ap);
    va_end(ap);
    if (nio < 0)
        return -1;
    
    fprintf(_channel.out, "\n");
    if (fflush(_channel.out) != 0)
        return -1;
    
    return rpsFinish();
}

int rpsErrorArguments()
{
    if (rpsMessage("Invalid arguemnts") != 0)
        return -1;
    return 1;
}

int rpsErrorSyntax()
{
    if (rpsMessage("Syntax error") != 0)
        return -1;
    return 1;
}

int rpsErrorBusy()
{
    if (rpsMessage("System Busy") != 0)
        return -1;
    return 1;
}

int rpsAccessDeny()
{
    if (rpsMessage("Access Deny") != 0)
        return -1;
    return 1;
}

int rpsErrorString(const char *str)
{
    if (rpsMessage("%s", str ? str : "") != 0)
        return -1;
    return 1;
}

int rpsString(const char *str)
{
    return rpsMessage("%s", str ? str : "");
}

int rpsNoFinish(const char *fmt, ...)
{
    int ret = -1;
    va_list ap;
    va_start(ap, fmt);
    ret = vfprintf(_channel.out, fmt, ap);
    va_end(ap);

    if (ret < 0)
        return -1;
    
    fprintf(_channel.out, "\n");
    if (fflush(_channel.out) != 0)
        return -1;
    return 0;
}

int rpsFile(const char *path)
{
    int ret = 0;
    
    FILE *fp = (FILE *) 0;
    fp = fopen(path, "r");
    if (fp) {
        char buffer[MAX_CONFIG_LINE + 1];

        for (; fgetline(buffer, MAX_CONFIG_LINE, fp) == 1; ) {
            if (rpsNoFinish("%s", buffer) < 0) {
                return -1;
            }
        }
        fclose(fp);
    }
    return ret;
}
