#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/param.h>

#include <unistd.h>
#include <fcntl.h>

#if HAVE_LIBGEN_H
#include <libgen.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <stdarg.h>

static int invokeReal(const char *pathname, char **argv, int dout, int derr)
{
    pid_t pid;
    int status;

    if ((pid = fork()) == 0) {
        int nfd = -1;
        
        if (dout < 0 || derr < 0) {
            if ((nfd = open("/dev/null", O_WRONLY)) < 0) {
                exit(1);
            }
            if (dout < 0)
                dout = nfd;
            if (derr < 0)
                derr = nfd;
        }

        if (dup2(dout, STDOUT_FILENO) < 0 || dup2(derr, STDERR_FILENO) < 0)
            exit(1);
        close(dout);
        if (derr != dout)
            close(derr);

        if (execv(pathname, argv) < 0) {
            exit(1);
        }
        exit(0);
    }
    if (waitpid(pid, &status, 0) != pid)
        return -1;
    return (status == 0) ? 0 : -1;
}

int invokeOutputError(const char *pathname, char **argv, int dout, int derr)
{
    return invokeReal(pathname, argv, dout, derr);
}

int invokeOutput(const char *pathname, char **argv, int dout)
{
    return invokeReal(pathname, argv, dout, -1);
}

int invokeQuiet(const char *pathname, char **argv)
{
    return invokeReal(pathname, argv, -1, -1);
}

char **argvNew(const char *pathname, int *size)
{
    char **argv = (char**) 0;
    char *pname = (char*) 0;
	char buf[MAXPATHLEN + 1];

    if (! pathname || ! size)
        return (char **) 0;
    
	snprintf(buf, MAXPATHLEN, "%s", pathname);
    pname = (char *)basename(buf);
    if (pname) {
        char *pncopy = strdup(pname);
        if (pncopy) {
            argv = (char **)malloc(sizeof(char*) * 2);
            if (argv) {
                argv[0] = pncopy;
                argv[1] = (char*) 0;
                *size = 2;
            }else {
                free(pncopy);
            }
        }
    }
    return argv;
}

char **argvAdd(char ***argv, const char *opt, int *size)
{
    char **oldargv = *argv;
    char **newargv = (char **) 0;
    char *add = (char*) 0;
    int osize = *size;

    if (! (add = strdup(opt)))
        return (char**) 0;
    
    newargv = (char **)malloc(sizeof(char*) * (osize + 1));
    
    if (newargv) {
        int i = 0;
        
        for (i = 0; i + 1 < osize; i++)
            newargv[i] = oldargv[i];
        
        newargv[osize - 1] = add;
        newargv[osize] = (char*) 0;
        *size = osize + 1;
        
        free(oldargv);
        *argv = newargv;
        
    }else
        free(add);
    return newargv;
}

void argvFree(char **argv)
{
    if (argv) {
        int i = 0;
    
        for (i = 0; argv[i];i++)
            free(argv[i]);
        
        free(argv);
    }
}

int invokeBackground(const char *pathname, char **argv)
{
    pid_t pid;

    if ((pid = fork()) == 0) {
        /* ӽ */
        if (execv(pathname, argv) < 0)
            exit(1);
        exit(0);
    }
    return 0;
}

char **argvDup(char **argv)
{
    char **newargv = (char**) 0;
    int nargs = 0;
    int i = 0;
    
    for (nargs = 0; argv[nargs]; nargs++)
        ;
    newargv = (char**) malloc(sizeof(char*) * (nargs + 1));
    if (newargv) {
        newargv[nargs] = (char*) 0;
        for (i = 0; i < nargs; i++) {
            newargv[i] = strdup(argv[i]);
            if (! (newargv[i])) {
                argvFree(newargv);
                return (char**) 0;
            }
        }
    }
    return newargv;
}
