#include <sys/types.h>
#include <sys/reboot.h>

#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <stdarg.h>

#include "rps.h"
#include "cmd-inc.h"
#include "connection.h"
#include "cmd-show.h"
#include "cmd-system.h"
#include "cmd-no.h"
#include "cmd-bind.h"
#include "cmd-unbind.h"
#include "cmd-policy.h"
#include "cmd-trigger.h"
#include "cmd-ip.h"
#include "cmd-name.h"
#include "cmd-help.h"
#include "cmd-write.h"
#include "cmd-load.h"
#include "cmd-move.h"

static int commandQuit(char *args)
{
    char *brkp = (char*) 0;

    if (args && strtok_r(args, ARGS_DELIM, &brkp))
        return rpsErrorArguments();
    rpsMessage("ByeBye");
    return -1;
}

static struct CommandTable {
    char *cmd;
    int (*op)(char *);
}_commandTable[] = {
    {"help", opHelp},
    {"reload", opReload},
    {"show", opShow},
    {"no", opNo},
    {"policy", opPolicy},
    {"bind", opBind},
    {"unbind", opUnBind},
    {"trigger", opTrigger},
    {"ip", opIp},
    {"name", opName},
    {"write", opWrite},
    {"load", opLoad},
    {"move", opMove},
    {"quit", commandQuit},
    {NULL, NULL}
};

int commandDispose(char *cmdCopy)
{
    int ret = 0;
    char *cmd = (char *)0;
    char *args = (char *)0;
    /* char *cmdCopy = strdup(cmdBuffer); */
    
    struct CommandTable *pTable = (struct CommandTable *) 0;
    
    if (! cmdCopy) {
        return 1;
    }
    
    cmd = strtok_r(cmdCopy, " \t", &args);
    if (! cmd || *cmd == '#')
        return rpsFinish();

    for (pTable = _commandTable;
         pTable->cmd && strcmp(pTable->cmd, cmd);
         pTable++) {
        ;
    }

    if (! pTable->cmd) {
        if (rpsMessage("Command not found") != 0) {
            return -1;
        }
        return 1;
    }

    ret = pTable->op(args);
    
    return ret;
}
