#include "cmd-inc.h"
#include "rule.h"

int opUnBind(char *args)
{
    Ruleset rs;
    char *ifalias = (char*) 0;
    char *brkp = (char*) 0;
    const char *iface = (char*) 0;
    char *group;

    if (! args
        || ! (group = strtok_r(args, ARGS_DELIM, &brkp))
        || strtok_r(NULL, ARGS_DELIM, &brkp))
        return rpsErrorArguments();
    
    if (bindGetAccessList("inside", group) != 0)
        return rpsErrorString("no ruleset bind on this interface");

    
    if (rulesetInit(&rs) < 0)
        return rpsErrorBusy();

    if (rulesetUnBind(&rs, group, "inside") < 0) {
        rulesetDestroy(&rs);
        return rpsErrorString("error while unbind ruleset");
    }
    rulesetDestroy(&rs);
    
    if (bindDelAccessList("inside", group) < 0)
        return rpsErrorBusy();

    return rpsFinish();
}
