#include "cmd-inc.h"
#include "rule.h"

int opTrigger(char *args)
{
    Ruleset rs;
    const char *iface = NULL;
    char *action, *brkp;
    const char commd[MAXPATHLEN + 1];


    action = brkp = NULL;

    if (! args ||
        ! (action = strtok_r(args, ARGS_DELIM, &brkp)) ||
        strtok_r(NULL, ARGS_DELIM, &brkp))
        return rpsErrorArguments();

    if (! (iface = ifnByAlias("outside")))
	    return rpsErrorString("interface nonexist");
    
    if (! strcmp(action, "on")) {
	    sprintf(commd, "iptables -t nat -I PREROUTING -i %s -j TRIGGER --trigger-type dnat", iface);
	    system(commd);
    } else if (! strcmp(action, "off")) {
	    sprintf(commd, "iptables -t nat -D PREROUTING -i %s -j TRIGGER --trigger-type dnat", iface);
    	    system(commd);
    } else
	    return rpsErrorArguments();
    
    return rpsFinish();
}
