#include "cmd-inc.h"
#include <sys/param.h>

#include "rule.h"
#include "test.h"
#include "fgetline.h"

static int subRoute(char *args)
{
    char *network, *router, *brkp;
    char command[MAX_CONFIG_LINE + 1];

    network = router = brkp = (char*) 0;

    if (! args ||
        ! (network = strtok_r(args, ARGS_DELIM, &brkp)) ||
        strtok_r(NULL, ARGS_DELIM, &brkp))
        return rpsErrorArguments();

    if (strcmp("default", network)) {
        if (! test_ipmask(network) && ! test_ip(network))
            return rpsErrorString("Invalid network specified");
    }
    
    snprintf(command, MAX_CONFIG_LINE, "ip route %s", network);
    if (!sfileExist(PATH_ROUTE_LIST, command))
	    return rpsErrorString("no such route exist");

    {
        char **argv = (char**) 0;
        int nargs = 0;
        int ret = -1;

        if (! (argv = argvNew(PS_ROUTE, &nargs)))
            return rpsErrorBusy();

        if (! strcmp("default", network)) {
            /* Ĭ· */
            if (! argvAdd(&argv, "del", &nargs) ||
                ! argvAdd(&argv, network, &nargs)) { 
                argvFree(argv);
                return rpsErrorBusy();
            }
        }else {
            if (test_ipmask(network)) {
                /* · */
                if (! argvAdd(&argv, "del", &nargs) ||
                    ! argvAdd(&argv, "-net", &nargs) ||
                    ! argvAdd(&argv, network, &nargs)) {
                    argvFree(argv);
                    return rpsErrorBusy();
                }
            }else {
                /* · */
                if (! argvAdd(&argv, "del", &nargs) ||
                    ! argvAdd(&argv, "-host", &nargs) ||
                    ! argvAdd(&argv, network, &nargs)) {
                    argvFree(argv);
                    return rpsErrorBusy();
                }
            }
        }
        
        ret = invokeQuiet(PS_ROUTE, argv);
        argvFree(argv);
        if (ret < 0)
            return rpsErrorString("error while alter route table");
    }
    sfileRemove(PATH_ROUTE_LIST, command);
    return rpsFinish();
}

static int subIP(char *args)
{
    char *modifier, *brkp;

    modifier = brkp = (char*) 0;

    if (! args ||
        ! (modifier = strtok_r(args, ARGS_DELIM, &brkp)))
        return rpsErrorArguments();
    if (! strcmp("route", modifier)) {
        return subRoute(brkp);
    }
    return rpsErrorSyntax();
}

static int subPolicy(char *args)
{
    Ruleset rs;
    char *group, *pos, *brkp;

    group = pos = brkp = NULL;

    if (args) {
        if ((group = strtok_r(args, ARGS_DELIM, &brkp))) {
            pos = strtok_r(NULL, ARGS_DELIM, &brkp);
            if (strtok_r(NULL, ARGS_DELIM, &brkp))
                return rpsErrorArguments();
        }
    }

    if (pos && ! test_integer(pos, 1, 65535))
        return rpsErrorSyntax();
    if (bindGetInterface(group, NULL) == 0)
	return rpsErrorString("rulesets already binded");

    if ( rulesetInit(&rs) < 0)
        return rpsErrorBusy();
    
    if (! rulesetExist(&rs, group, pos ? atoi(pos) : 0)) {
        rulesetDestroy(&rs);
        return rpsErrorString("not found");
    }
    rulesetRemove(&rs, group, pos ? atoi(pos) : 0);
    if (rulesetWrite(&rs) < 0) {
        rulesetDestroy(&rs);
        return rpsErrorBusy();
    }
    rulesetDestroy(&rs);
    return rpsFinish();
}

static int subName(char *args)
{
	char *brkp, *name, *modifier;
	char range[MAX_CONFIG_LINE + 1];
	char command[MAX_CONFIG_LINE + 1];
	
	brkp = name = (char *) 0;
	if ( ! args || ! (modifier = strtok_r(args, ARGS_DELIM, &brkp))
		    || ! (name = strtok_r(NULL, ARGS_DELIM, &brkp))
		    ||	strtok_r(NULL, ARGS_DELIM, &brkp))
		return rpsErrorArguments();

	if ( (! strcmp("ip", modifier))
	     && (! strcmp("tcp_port", modifier))
	     && (! strcmp("udp_port", modifier)))
		return rpsErrorArguments();

	if (ippGet(name, modifier, range) != 0)
		return rpsErrorString("Name nonexist");

	snprintf(command, MAX_CONFIG_LINE, "name %s %s %s", modifier, name, range);
	if (sfileRemove(PATH_NAME_LIST, command) < 0)
		return rpsErrorBusy();

	return rpsFinish();
}

int opNo(char *args)
{
    char *what, *brkp;

    what = brkp = (char*) 0;

    if (! args ||
        ! (what = strtok_r(args, ARGS_DELIM, &brkp)))
        return rpsErrorArguments();

    if (! strcmp("ip", what)) {
        return subIP(brkp);
        
    }else if (! strcmp("policy", what)) {
        return subPolicy(brkp);

    }else if (! strcmp("name", what)) {
		return subName(brkp);
    }
    
    return rpsErrorSyntax();
}
