#include "cmd-inc.h"

int opMove(char *args)
{
	char grp[MAX_NAMESIZE * 2], *fromZONE, *toZONE, *from, *to, *brkp;

	fromZONE = toZONE = from = to = brkp = NULL;

	if (! args ||
			! (fromZONE = strtok_r(args, ARGS_DELIM, &brkp)) ||
			! (toZONE = strtok_r(NULL, ARGS_DELIM, &brkp)) ||
			! (from = strtok_r(NULL, ARGS_DELIM, &brkp)) ||
			! (to = strtok_r(NULL, ARGS_DELIM, &brkp)) ||
			strtok_r(NULL, ARGS_DELIM, &brkp))
		return rpsErrorArguments();

	if (strcmp("any", fromZONE) && strcmp("inside", fromZONE) && strcmp("outside", fromZONE) && strcmp("DMZ", fromZONE)
	    && strcmp("any", toZONE) && strcmp("inside", toZONE) && strcmp("outside", toZONE) && strcmp("DMZ", toZONE))
		return rpsErrorArguments();

	strcpy(grp, fromZONE);
	strcat(grp, "_");
	strcat(grp, toZONE);

	if (! test_integer(from, 1, 65535) ||
			! test_integer(to, 1, 65535))
		return rpsErrorString("invalid rule number specified. <1-65535>");

	if (rulesetMove(grp, atoi(from), atoi(to)) < 0)
		return rpsErrorString("error while move rule, maybe nonexist");

	return rpsFinish();
}
