#!/bin/sh

PPPOE_FILE=/etc/options.pppoe

if [ ! -n "$4" ]; then
  echo "insufficient arguments!"
  echo "Usage: $0 <user> <password> <eth_name> <opmode>"
  exit 0
fi

PPPOE_USER_NAME="$1"
PPPOE_PASSWORD="$2"
PPPOE_IF="$3"
PPPOE_OPMODE="$4"
PPPOE_OPTIME="$5"

#Porting from SDK 2.3.0.0 - U-Media Ricky Cao on Oct. 16 2008
#add for set WAN MTU - U-Media Ricky Cao on May 16 2008
wan_use_default_mtu=`nvram_get 2860 wan_use_default_mtu`
if [ "$wan_use_default_mtu" = "1" ]; then
	WAN_MTU="1492"
else
	WAN_MTU=`nvram_get 2860 wan_mtu`
fi
#U-Media Ricky Cao on Oct. 16 2008

echo "noauth" > $PPPOE_FILE
echo "user '$PPPOE_USER_NAME'" >> $PPPOE_FILE
echo "password '$PPPOE_PASSWORD'" >> $PPPOE_FILE
echo "nomppe" >> $PPPOE_FILE
echo "hide-password" >> $PPPOE_FILE
echo "noipdefault" >> $PPPOE_FILE
echo "defaultroute" >> $PPPOE_FILE
echo "nodetach" >> $PPPOE_FILE
echo "maxfail 0" >> $PPPOE_FILE
echo "usepeerdns" >> $PPPOE_FILE
echo "ipcp-accept-remote" >> $PPPOE_FILE 
echo "ipcp-accept-local" >> $PPPOE_FILE 
echo "lcp-echo-failure 3" >> $PPPOE_FILE
echo "lcp-echo-interval 20" >> $PPPOE_FILE
if [ $PPPOE_OPMODE == "KeepAlive" ]; then
	echo "persist" >> $PPPOE_FILE
	echo "holdoff $PPPOE_OPTIME" >> $PPPOE_FILE
elif [ $PPPOE_OPMODE == "OnDemand" ]; then
	PPPOE_IDLETIME=`expr $PPPOE_OPTIME \* 60`
	echo "demand" >> $PPPOE_FILE
	echo "idle $PPPOE_IDLETIME" >> $PPPOE_FILE
	echo "active-filter 'outbound and not dst port 123'" >> $PPPOE_FILE
	echo "holdoff 1" >> $PPPOE_FILE
fi
#Porting from SDK 2.3.0.0 - U-Media Ricky Cao on Oct. 16 2008
#Add for process PPP interface event - U-Media Ricky Cao on Apr. 17 2008
echo "ip-up-script \"/sbin/ppp-ip-up\"" >> $PPPOE_FILE
echo "ip-down-script \"/sbin/ppp-ip-down\"" >> $PPPOE_FILE
#Add for configure MTU - U-Media Ricky Cao on May 16 2008
echo "mtu $WAN_MTU" >> $PPPOE_FILE
#U-Media Ricky Cao on Oct. 16 2008
echo "plugin /etc_ro/ppp/plugins/rp-pppoe.so $PPPOE_IF" >> $PPPOE_FILE

