/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 *  U-Media Jacky.Yang 7-Jan-2009, The file must the same with Uboot\tools\image.h
 */

#ifndef __IMAGE_H__
#define __IMAGE_H__

/*
 * Operating System Codes
 */
#define IH_OS_INVALID		0	/* Invalid OS	*/
#define IH_OS_OPENBSD		1	/* OpenBSD	*/
#define IH_OS_NETBSD		2	/* NetBSD	*/
#define IH_OS_FREEBSD		3	/* FreeBSD	*/
#define IH_OS_4_4BSD		4	/* 4.4BSD	*/
#define IH_OS_LINUX		5	/* Linux	*/
#define IH_OS_SVR4		6	/* SVR4		*/
#define IH_OS_ESIX		7	/* Esix		*/
#define IH_OS_SOLARIS		8	/* Solaris	*/
#define IH_OS_IRIX		9	/* Irix		*/
#define IH_OS_SCO		10	/* SCO		*/
#define IH_OS_DELL		11	/* Dell		*/
#define IH_OS_NCR		12	/* NCR		*/
#define IH_OS_LYNXOS		13	/* LynxOS	*/
#define IH_OS_VXWORKS		14	/* VxWorks	*/
#define IH_OS_PSOS		15	/* pSOS		*/
#define IH_OS_QNX		16	/* QNX		*/
#define IH_OS_U_BOOT		17	/* Firmware	*/
#define IH_OS_RTEMS		18	/* RTEMS	*/
#define IH_OS_ARTOS		19	/* ARTOS	*/
#define IH_OS_UNITY		20	/* Unity OS	*/

/*
 * CPU Architecture Codes (supported by Linux)
 */
#define IH_CPU_INVALID		0	/* Invalid CPU	*/
#define IH_CPU_ALPHA		1	/* Alpha	*/
#define IH_CPU_ARM		2	/* ARM		*/
#define IH_CPU_I386		3	/* Intel x86	*/
#define IH_CPU_IA64		4	/* IA64		*/
#define IH_CPU_MIPS		5	/* MIPS		*/
#define IH_CPU_MIPS64		6	/* MIPS	 64 Bit */
#define IH_CPU_PPC		7	/* PowerPC	*/
#define IH_CPU_S390		8	/* IBM S390	*/
#define IH_CPU_SH		9	/* SuperH	*/
#define IH_CPU_SPARC		10	/* Sparc	*/
#define IH_CPU_SPARC64		11	/* Sparc 64 Bit */
#define IH_CPU_M68K		12	/* M68K		*/
#define IH_CPU_NIOS		13	/* Nios-32	*/
#define IH_CPU_MICROBLAZE	14	/* MicroBlaze   */
#define IH_CPU_NIOS2		15	/* Nios-II	*/

/*
 * Image Types
 *
 * "Standalone Programs" are directly runnable in the environment
 *	provided by U-Boot; it is expected that (if they behave
 *	well) you can continue to work in U-Boot after return from
 *	the Standalone Program.
 * "OS Kernel Images" are usually images of some Embedded OS which
 *	will take over control completely. Usually these programs
 *	will install their own set of exception handlers, device
 *	drivers, set up the MMU, etc. - this means, that you cannot
 *	expect to re-enter U-Boot except by resetting the CPU.
 * "RAMDisk Images" are more or less just data blocks, and their
 *	parameters (address, size) are passed to an OS kernel that is
 *	being started.
 * "Multi-File Images" contain several images, typically an OS
 *	(Linux) kernel image and one or more data images like
 *	RAMDisks. This construct is useful for instance when you want
 *	to boot over the network using BOOTP etc., where the boot
 *	server provides just a single image file, but you want to get
 *	for instance an OS kernel and a RAMDisk image.
 *
 *	"Multi-File Images" start with a list of image sizes, each
 *	image size (in bytes) specified by an "uint32_t" in network
 *	byte order. This list is terminated by an "(uint32_t)0".
 *	Immediately after the terminating 0 follow the images, one by
 *	one, all aligned on "uint32_t" boundaries (size rounded up to
 *	a multiple of 4 bytes - except for the last file).
 *
 * "Firmware Images" are binary images containing firmware (like
 *	U-Boot or FPGA images) which usually will be programmed to
 *	flash memory.
 *
 * "Script files" are command sequences that will be executed by
 *	U-Boot's command interpreter; this feature is especially
 *	useful when you configure U-Boot to use a real shell (hush)
 *	as command interpreter (=> Shell Scripts).
 */

#define IH_TYPE_INVALID		0	/* Invalid Image		*/
#define IH_TYPE_STANDALONE	1	/* Standalone Program		*/
#define IH_TYPE_KERNEL		2	/* OS Kernel Image		*/
#define IH_TYPE_RAMDISK		3	/* RAMDisk Image		*/
#define IH_TYPE_MULTI		4	/* Multi-File Image		*/
#define IH_TYPE_FIRMWARE	5	/* Firmware Image		*/
#define IH_TYPE_SCRIPT		6	/* Script file			*/
#define IH_TYPE_FILESYSTEM	7	/* Filesystem Image (any type)	*/

/*
 * Compression Types
 */
#define IH_COMP_NONE		0	/*  No	 Compression Used	*/
#define IH_COMP_GZIP		1	/* gzip	 Compression Used	*/
#define IH_COMP_BZIP2		2	/* bzip2 Compression Used	*/
#define IH_COMP_LZMA		3	/* lzma  Compression Used	*/

#define IH_MAGIC	0x27051956	/* Image Magic Number		*/
//Jacky.Yang 3-Jul-2009, Drop new definition for support U-Media header definition.
//#define IH_NMLEN	(32-4)		/* Image Name Length		*/
#define IH_NMLEN		32	/* Image Name Length		*/

/*
 *  Jacky.Yang 6-Jan-2009, U-Media boardID defintion.
 *  EEPROM Address: D0, D1, D2
 */
// Jacky.Yang 6-Jan-2009, Start - U-Media boardID defintion.
#define IMG_OFFSET 12

#ifdef TEW647GA
#define BOARDID	0x026470
#endif

#ifdef TEW637APv2
#define BOARDID	0x026372
#endif

#ifdef TEW638APBv2
#define BOARDID	0x026382
#endif

#ifdef TEW635BRP
#define BOARDID	0x026350
#endif

#ifdef SMCWAP375L
#define BOARDID	0x023750
#endif

#ifdef SMCWBR14SNL
#define BOARDID	0x053833
#endif

#ifdef FranklinR500
#define BOARDID	0x000000
#endif

#ifdef FranklinR510
#define BOARDID	0x000000
#endif

#ifdef FranklinR520
#define BOARDID	0x000000
#endif

#ifdef FranklinR535
#define BOARDID	0x000000
#endif

#ifdef FranklinR505
#define BOARDID	0x000000
#endif

#ifdef griin_WRT385L
#define BOARDID	0x000000
#endif

//Super Mode boardID: 000000
#ifdef UMEDIA
#define BOARDID	0x000000
#endif

#ifdef TrendNET
#define BOARDID 0x026392
#endif

#define IMAGE_MAGIC_NUM 0x55525F46	//0x55(85): U(U-Media), 0x52(82): R(Ralink), 0x5F(95): -(-), 0x46(70): F(Firmware)

//0x42(66)=B:Boot Loader, 0x46(70)=F: F/W 0x4D(77)=M: Multi-Firmware, 0x41(65)A:boot loader + f/w.
#define IMAGE_TYPE_BOOTLOADER 0x42
#define IMAGE_TYPE_FW 0x46
#define IMAGE_TYPE_MULTI_FW 0x4D
#define IMAGE_TYPE_BOOTLOADER_FW 0x41

#define LOAD_FACTORY_DEFAULT_TRUE 1
#define LOAD_FACTORY_DEFAULT_FALSE 0

// Jacky.Yang 6-Jan-2009, End - U-Media boardID defintion.


/*
 * all data in network byte order (aka natural aka bigendian)
 */

typedef struct image_header {
	uint32_t	ih_magic;	/* Image Header Magic Number	*/
	uint32_t	ih_hcrc;	/* Image Header CRC Checksum	*/
	uint32_t	ih_time;	/* Image Creation Timestamp	*/
	uint32_t	ih_size;	/* Image Data Size		*/
	uint32_t	ih_load;	/* Data	 Load  Address		*/
	uint32_t	ih_ep;		/* Entry Point Address		*/
	uint32_t	ih_dcrc;	/* Image Data CRC Checksum	*/
	uint8_t		ih_os;		/* Operating System		*/
	uint8_t		ih_arch;	/* CPU architecture		*/
	uint8_t		ih_type;	/* Image Type			*/
	uint8_t		ih_comp;	/* Compression Type		*/
	uint8_t		ih_name[IH_NMLEN-IMG_OFFSET];	/* Image Name		*/
	//Jacky.Yang 3-Jul-2009, Drop new definition for support U-Media header definition.
	//uint32_t	ih_ksz;		/* Kernel Part Size		*/
	// Jacky.Yang 6-Jan-2009, U-Media check boardID.
	uint32_t	ih_UMedia_magic;	/* U-Media magic number	*/
	uint32_t	ih_UMedia_boardID;	/* U-Media magic number	*/
	uint8_t		ih_UMedia_imageType;	/* U-Media image type */
	uint8_t		ih_UMedia_LoadDefault;	/* U-Media load to factory default setting */
	uint8_t		ih_UMedia_temp1;	/* U-Media didn't use this tag */
	uint8_t		ih_UMedia_temp2;	/* U-Media didn't use this tag */
} image_header_t;


#endif	/* __IMAGE_H__ */
