/*
 *	schedule.c -- Schedule Settings 
 *
 *	Copyright (c) U-Media
 *
 *	$Id: schedule.c, Jacky.Yang 27-Mar-2008
 */

#include <arpa/inet.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/time.h>
#include "nvram.h"
#include "firewall.h"
#include "utils.h"
#include "webs.h"
#include "internet.h"

void delScheduleToNvram(char *nvramTagName, char *iptablesOldRuleName, char *iptablesNewRuleName, char *saveNow, char *crontab)
{
	int loopCount, flag=0, rule_count;
	int *deleArray;
	char rec[256], nvramTagNameTemp[32], iptablesRuleNameTemp[32];
	//char *crontab = nvram_bufget(RT2860_NVRAM, "crontab");
	
	if (!strcmp(saveNow, "true"))
		crontab = nvram_bufget(RT2860_NVRAM, "crontab");
	
	//printf("jacky - check - crontab:%s\n nvramTagName:%s, iptablesOldRuleName:%s, iptablesNewRuleName:%s\n", crontab, nvramTagName, iptablesOldRuleName, iptablesNewRuleName);
	loopCount=0;
	while(getNthValueSafe(loopCount, crontab, ';', rec, sizeof(rec)) != -1 ){
		if((getNthValueSafe(0, rec, ',', nvramTagNameTemp, sizeof(nvramTagNameTemp)) == -1)){
		}
		if (!strcmp(nvramTagNameTemp, nvramTagName)){
			if((getNthValueSafe(1, rec, ',', iptablesRuleNameTemp, sizeof(iptablesRuleNameTemp)) == -1)){
			}
			if (!strcmp(iptablesRuleNameTemp, iptablesOldRuleName) || !strcmp(iptablesRuleNameTemp, iptablesNewRuleName)) {
				flag = 1;
				break;
			}
		}
		loopCount++;
	}
	if (flag == 1) {
		rule_count = getRuleNums(crontab);
		if(!rule_count)
			return;
		deleArray = (int *)malloc(rule_count * sizeof(int));
		if (loopCount >= 0)
		{
			deleArray[0] = loopCount;
		}
	
		deleteNthValueMulti(deleArray, rule_count, crontab, ';');
		free(deleArray);
	}
	if (!strcmp(saveNow, "true"))
		nvram_set(RT2860_NVRAM, "crontab", crontab);
}

void addScheduleToNvram(char *nvramTagName, char *iptablesOldRuleName, char *iptablesNewRuleName, char *scheduleName)
{
	char rule[8192]={0};
	char *crontab = nvram_bufget(RT2860_NVRAM, "crontab");
	
	delScheduleToNvram(nvramTagName, iptablesOldRuleName, iptablesNewRuleName, "false", crontab);
	//delScheduleToNvram(nvramTagName, iptablesOldRuleName, iptablesNewRuleName, "true", crontab);
	if (!strcmp(scheduleName, "Always")) {
		nvram_set(RT2860_NVRAM, "crontab", crontab);
	}
	else {
printf("salim-adding cron");
		if(crontab && strlen( crontab) ) {
			snprintf(rule, sizeof(rule), "%s;%s,%s,%s", crontab, nvramTagName, iptablesNewRuleName, scheduleName);
		}
		else {
			snprintf(rule, sizeof(rule), "%s,%s,%s", nvramTagName, iptablesNewRuleName, scheduleName);
		}
		nvram_set(RT2860_NVRAM, "crontab", rule);
	}
}

int checkWeekTimeToRun(char *weekArray, int start_hour, int start_min, int end_hour, int end_min)
{
	int loopCount, flag=0, startStamp, endStamp, nowStamp, lastDay;
	time_t timep;
	struct tm *pt;
	//pt = gmtime(&timep);
	time(&timep);
	pt = localtime(&timep);
	
	//Jacky.Yang check time stamp, must the same with schedule.c check.
	startStamp = (start_hour*60) + start_min;
	endStamp = (end_hour*60) + end_min;
	nowStamp = (pt->tm_hour*60) + pt->tm_min;

	if (pt->tm_wday == 0)
		lastDay = 6; //for auto add one day
	else
		lastDay = pt->tm_wday - 1;
	
	if ((end_hour < start_hour) || ((start_hour == end_hour) && (end_min < start_min))) // next day
	{
		//endStamp = endStamp + 24*60;
		//if (nowStamp <= endStamp) //next day
		if (nowStamp < endStamp) //next day
		{
			if (weekArray[lastDay] == '1')
				flag = 1;
		}
		else //today
		{
			if ((startStamp <= nowStamp)) {
				if (weekArray[pt->tm_wday] == '1')
					flag = 1;
			}
		}
	}
	else
	{
		//if ((startStamp <= nowStamp) && (nowStamp <= endStamp)) {
		if ((startStamp <= nowStamp) && (nowStamp < endStamp)) {
			if (weekArray[pt->tm_wday] == '1')
				flag = 1;
		}
	}

	return flag;
}

//void getCronCmd(char startCMD[], char stopCMD[], char *nvramTagName, char *iptablesRuleName, char *iptablesTagName, char *scheduleName)
void getCronCmd(char *startCMD, char *stopCMD, int cmdLength, char *nvramTagName, char *iptablesRuleName, char *iptablesTagName, char *scheduleName)
{
	int loopCount, rcStart=0, rcStop=0, flag=-1;
	int startLen, stopLen;
	char rec[256], temp[64];
	char *startPt, *stopPt, *pt;
	char ruleName[32], allWeek[2], weekArray[8], allhrs[4], start_hour[4], start_min[4], end_hour[4], end_min[4];
	char displayWeek[16], displayWeekEnd[16], displayTime[12];
	
	char *scheduleRules = nvram_bufget(RT2860_NVRAM, "scheduleRules");
	startLen=cmdLength;
	stopLen=cmdLength;
	
	memset(rec, '\0', sizeof(rec));
	memset(temp, '\0', sizeof(temp));
	memset(ruleName, '\0', sizeof(ruleName));
	memset(allWeek, '\0', sizeof(allWeek));
	memset(weekArray, '\0', sizeof(weekArray));
	memset(allhrs, '\0', sizeof(allhrs));
	memset(start_hour, '\0', sizeof(start_hour));
	memset(start_min, '\0', sizeof(start_min));
	memset(end_hour, '\0', sizeof(end_hour));
	memset(end_min, '\0', sizeof(end_min));
	
	//search scheduleName start point
	sprintf(temp,";%s,",scheduleName);   //for some short name ,example sheduleName=1
	pt = strstr(scheduleRules, temp);
	if(pt != NULL)	{
		memset(temp, '\0', sizeof(temp));	
		sprintf(temp,"%s,",scheduleName);
		pt = strstr(pt, temp);
	}else{
		memset(temp, '\0', sizeof(temp));	
		sprintf(temp,"%s,",scheduleName);
		pt = strstr(scheduleRules, temp);
	}

	if (getNthValueSafe(0, pt, ';', rec, sizeof(rec)) != -1)
	{
		flag = 0;
		if((getNthValueSafe(0, rec, ',', ruleName, sizeof(ruleName)) == -1)){
		}
		if((getNthValueSafe(1, rec, ',', allWeek, sizeof(allWeek)) == -1)){
		}
		if((getNthValueSafe(2, rec, ',', weekArray, sizeof(weekArray)) == -1)){
		}
		if((getNthValueSafe(3, rec, ',', allhrs, sizeof(allhrs)) == -1)){
		}
		if((getNthValueSafe(4, rec, ',', start_hour, sizeof(start_hour)) == -1)){
		}
		if((getNthValueSafe(5, rec, ',', start_min, sizeof(start_min)) == -1)){
		}
		if((getNthValueSafe(6, rec, ',', end_hour, sizeof(end_hour)) == -1)){
		}
		if((getNthValueSafe(7, rec, ',', end_min, sizeof(end_min)) == -1)){
		}
		
		if (checkWeekTimeToRun(weekArray, atoi(start_hour), atoi(start_min), atoi(end_hour), atoi(end_min)) == 1)
		{
			doSystem("send_event %s %s %s %s", "start", nvramTagName, iptablesRuleName, iptablesTagName);
		}
		
		//printf("jacky - ruleName:%s, allWeek:%s, weekArray:%s, allhrs:%s, start_hour:%s, start_min:%s, end_hour:%s, end_min:%s\n", ruleName, allWeek, weekArray, allhrs, start_hour, start_min, end_hour, end_min);
		if ( (atoi(start_hour) < atoi(end_hour)) || ((atoi(start_hour) == atoi(end_hour)) && (atoi(start_min) < atoi(end_min))) ) {
			memset(displayWeek, '\0', sizeof(displayWeek));
			startPt = displayWeek;
			for (loopCount=0; loopCount<=6; loopCount++) {
				if (weekArray[loopCount] == '1') {
					rcStart = snprintf(startPt, sizeof(displayWeek)-rcStart, "%d,", loopCount);
					startPt = startPt+rcStart;
				}
			}
			rcStart = snprintf((startPt-1), sizeof(displayWeek)-rcStart, "%c", '\0'); //cut end characher ','
			strcpy(displayWeekEnd, displayWeek);
		}
		else {
			memset(displayWeek, '\0', sizeof(displayWeek));
			memset(displayWeekEnd, '\0', sizeof(displayWeekEnd));
			startPt = displayWeek;
			stopPt = displayWeekEnd;
			for (loopCount=0; loopCount<=6; loopCount++) {
				if (weekArray[loopCount] == '1') {
					rcStart = snprintf(startPt, sizeof(displayWeek)-rcStart, "%d,", loopCount);
					startPt = startPt+rcStart;
					
					rcStop = snprintf(stopPt, sizeof(displayWeekEnd)-rcStop, "%d,", loopCount+1);
					stopPt = stopPt+rcStop;
				}
			}
			rcStart = snprintf((startPt-1), sizeof(displayWeek)-rcStart, "%c", '\0'); //cut end characher ','
			rcStop = snprintf((stopPt-1), sizeof(displayWeekEnd)-rcStop, "%c", '\0'); //cut end characher ','
		}
		
		memset(displayTime, '\0', sizeof(displayTime));
		snprintf(displayTime, sizeof(displayTime), "%s:%s~%s:%s", start_hour, start_min, end_hour, end_min);
	}
	startPt = startCMD;
	stopPt = stopCMD;
	if (!strcmp(allhrs, "on") && (atoi(allWeek) == 1)) {
		//The same with Always run this rule.
		doSystem("send_event %s %s %s %s", "start", nvramTagName, iptablesRuleName, iptablesTagName);
	}
	else if (flag != -1) {
		if (!strcmp(allhrs, "on")) {
			//printf("jacky - 24hrs\n");
			rcStart = snprintf(startPt, startLen-rcStart, "0 0 ");
			startPt = startPt+rcStart;
			
			rcStop = snprintf(stopPt, stopLen-rcStop, "59 23 ");
			stopPt = stopPt+rcStop;
		}
		else {
			//printf("jacky - times: %s\n", displayTime);
			rcStart = snprintf(startPt, startLen-rcStart, "%s %s ", start_min, start_hour);
			startPt = startPt+rcStart;
			
			rcStop = snprintf(stopPt, stopLen-rcStop, "%s %s ", end_min, end_hour);
			stopPt = stopPt+rcStop;
		}
		
		if (atoi(allWeek) == 1) {
			//printf("jacky - All Week\n");
			//All week, start this rule, now.
			rcStart = snprintf(startPt, startLen-rcStart, "* * * ", displayWeek);
			startPt = startPt+rcStart;
			
			rcStop = snprintf(stopPt, stopLen-rcStop, "* * * ", displayWeekEnd);
			stopPt = stopPt+rcStop;
			//doSystem("send_event %s %s %s %s", "start", nvramTagName, iptablesRuleName, iptablesTagName);
		}
		else {
			//printf("jacky - weeks: %s\n", displayWeek);
			rcStart = snprintf(startPt, startLen-rcStart, "* * %s ", displayWeek);
			startPt = startPt+rcStart;
			
			rcStop = snprintf(stopPt, stopLen-rcStop, "* * %s ", displayWeekEnd);
			stopPt = stopPt+rcStop;
		}
		rcStart = snprintf(startPt, startLen-rcStart, "send_event %s %s %s %s", "start", nvramTagName, iptablesRuleName, iptablesTagName);
		rcStop = snprintf(stopPt, stopLen-rcStop, "send_event %s %s %s %s", "stop", nvramTagName, iptablesRuleName, iptablesTagName);
	}
}

//addScheduleToCron(<nvram tag name>, <rule name>, <firewall tag name>, <schedule name>)
//void addScheduleToCron(char *nvramTagName, char *iptablesRuleName, char *iptablesTagName, char *scheduleName)
void addScheduleToCron()
{
	FILE *fp;
	int loopCount, cmdLength=256, rc;
	char fullCrontab[20480]={0};
	char *pt;
	char rec[256]={0}, nvramTagName[32]={0}, iptablesRuleName[32]={0}, iptablesTagName[32]={0}, scheduleName[32]={0};
	char startCMD[cmdLength], stopCMD[cmdLength];
	char *crontab = nvram_bufget(RT2860_NVRAM, "crontab");
	
	memset(startCMD, '\0', sizeof(startCMD));
	memset(stopCMD, '\0', sizeof(stopCMD));
	iptablesRuleFlush("SPort");
	PortForwardAllRun("SinglePortForwardRules", "SPort");
	iptablesRuleFlush("MPort");
	PortForwardAllRun("PortRangeForwardRules", "MPort");
	iptablesRuleFlush("AC");
	PortForwardAllRun("AccessControlPolicy", "AC");

	pt = fullCrontab;
	loopCount=0;
	while(getNthValueSafe(loopCount++, crontab, ';', rec, sizeof(rec)) != -1 ){
		if((getNthValueSafe(0, rec, ',', nvramTagName, sizeof(nvramTagName)) == -1)){}
		if((getNthValueSafe(1, rec, ',', iptablesRuleName, sizeof(iptablesRuleName)) == -1)){}
		if((getNthValueSafe(2, rec, ',', scheduleName, sizeof(scheduleName)) == -1)){}
		
		if (!strcmp(nvramTagName, "SinglePortForwardRules")) {
			strcpy(iptablesTagName, "SPort");
			//iptablesRuleFlush("SPort");
			//PortForwardAllRun("SinglePortForwardRules", "SPort");
		}
		else if (!strcmp(nvramTagName, "PortRangeForwardRules")) {
			strcpy(iptablesTagName, "MPort");
			//iptablesRuleFlush("MPort");
			//PortForwardAllRun("PortRangeForwardRules", "MPort");
		}
		else if (!strcmp(nvramTagName, "AccessControlPolicy")) {
			strcpy(iptablesTagName, "AC");
			//iptablesRuleFlush("AC");
			//PortForwardAllRun("AccessControlPolicy", "AC");
		}
		else{ //Add by U-Media Ricky Cao on Apr. 11 2008
			strcpy(iptablesTagName, "NONE"); 
		}
		memset(startCMD, '\0', sizeof(startCMD));
		memset(stopCMD, '\0', sizeof(stopCMD));
		getCronCmd(startCMD, stopCMD, cmdLength, nvramTagName, iptablesRuleName, iptablesTagName, scheduleName);
		//printf("jacky - start rules:%s\n", startCMD);
		//printf("jacky - stop rules:%s\n", stopCMD);
		
		rc = snprintf(pt, sizeof(fullCrontab)-rc, "%s\n", startCMD);
		pt = pt + rc;
		rc = snprintf(pt, sizeof(fullCrontab)-rc, "%s\n", stopCMD);
		pt = pt + rc;
	}
	fp = fopen("/var/spool/cron/crontabs/admin", "w+");
	fputs(fullCrontab, fp);
	fclose(fp);
	//printf("jacky - show me crontab content:\n%s\n", fullCrontab);
	doSystem("kill `ps |grep 'crond'|grep -v 'grep'|awk '{print $1}'`");
	doSystem("crond");
}

void getScheduleInfo(char *ruleName, char *getInfo, int len)
{
	int loopCount=0;
	char rec[256], ruleNameCheck[32];
	char weekArray[8], start_hour[4], start_min[4], end_hour[4], end_min[4];
	char *rules = nvram_bufget(RT2860_NVRAM, "scheduleRules");
	//printf("jacky - ruleName:%s\n", ruleName);
	memset(weekArray, '\0', sizeof(weekArray));
	memset(start_hour, '\0', sizeof(start_hour));
	memset(start_min, '\0', sizeof(start_min));
	memset(end_hour, '\0', sizeof(end_hour));
	memset(end_min, '\0', sizeof(end_min));
	while(getNthValueSafe(loopCount++, rules, ';', rec, sizeof(rec)) != -1 ){
		getNthValueSafe(0, rec, ',', ruleNameCheck, sizeof(ruleNameCheck));	
		if (!strcmp(ruleName, ruleNameCheck)) {
			if((getNthValueSafe(2, rec, ',', weekArray, sizeof(weekArray)) == -1)){
				continue;
			}
			if((getNthValueSafe(4, rec, ',', start_hour, sizeof(start_hour)) == -1)){
				continue;
			}
			if((getNthValueSafe(5, rec, ',', start_min, sizeof(start_min)) == -1)){
				continue;
			}
			if((getNthValueSafe(6, rec, ',', end_hour, sizeof(end_hour)) == -1)){
				continue;
			}
			if((getNthValueSafe(7, rec, ',', end_min, sizeof(end_min)) == -1)){
				continue;
			}
			break;
		}
	}
	//printf("jacky - %s,%s,%s,%s,%s\,", weekArray, start_hour, start_min, end_hour, end_min);
	snprintf(getInfo, len, "%s,%s,%s,%s,%s", weekArray, start_hour, start_min, end_hour, end_min);
	//printf("jacky - check getInfo:%s\n", getInfo);
}

static void scheduleAdd(webs_t wp, char_t *path, char_t *query)
{
	int loopCount, rule_count;
	char rule[4096];
	char *action, *ruleNameID, *ruleName, *allWeek, *allhrs;
	char *start_hour, *start_min, *end_hour, *end_min;
	char weekArray[7], weekName[7];
	
	char *rules = nvram_bufget(RT2860_NVRAM, "scheduleRules");
	action = websGetVar(wp, T("action"), T("0"));
	ruleNameID = websGetVar(wp, T("ruleNameID"), T("0"));
	ruleName = websGetVar(wp, T("ruleName"), T(""));
	allWeek = websGetVar(wp, T("allWeek"), T("0"));
	
	if (atoi(allWeek) == 1) {
		strcpy(weekArray, "1111111");
	}
	else {
		for (loopCount=0; loopCount<=6; loopCount++) {
			snprintf(weekName, sizeof(weekName), "week_%d", loopCount);
			if (!strcmp(websGetVar(wp, T(weekName), T("0")), "on"))
				weekArray[loopCount] = '1';
			else
				weekArray[loopCount] = '0';
		}
	}
	
	allhrs = websGetVar(wp, T("allhrs"), T("0"));
	start_hour = websGetVar(wp, T("start_hour"), T("0"));
	start_min = websGetVar(wp, T("start_min"), T("0"));
	end_hour = websGetVar(wp, T("end_hour"), T("0"));
	end_min = websGetVar(wp, T("end_min"), T("0"));
	
	if (!strcmp(action, "edit"))
	{
		int *deleArray;
		int i=0, j=0;
		rule_count = getRuleNums(rules);
		if(!rule_count)
			return;
		deleArray = (int *)malloc(rule_count * sizeof(int));
		if (ruleNameID)
		{
			deleArray[j++] = atoi(ruleNameID);
		}
		
		/*if (getNthValueSafe(atoi(ruleNameID), rules, ';', rec, sizeof(rec)) != -1 )
		{
			if((getNthValueSafe(0, rec, ',', oldRuleName, sizeof(oldRuleName)) == -1)){
			}
		}*/
		
		
		
		deleteNthValueMulti(deleArray, rule_count, rules, ';');
		free(deleArray);
	}
	
	if(rules && strlen( rules) ) {
		if (!strcmp(allhrs, "on"))
			snprintf(rule, 4096, "%s;%s,%s,%s,%s,%s,%s,%s,%s", rules, ruleName, allWeek, weekArray, allhrs, "0", "0", "24", "0");
		else
			snprintf(rule, 4096, "%s;%s,%s,%s,%s,%s,%s,%s,%s", rules, ruleName, allWeek, weekArray, allhrs, start_hour, start_min, end_hour, end_min);
	}
	else {
		if (!strcmp(allhrs, "on"))
			snprintf(rule, 4096, "%s,%s,%s,%s,%s,%s,%s,%s", ruleName, allWeek, weekArray, allhrs, "0", "0", "24", "0");
		else
			snprintf(rule, 4096, "%s,%s,%s,%s,%s,%s,%s,%s", ruleName, allWeek, weekArray, allhrs, start_hour, start_min, end_hour, end_min);
	}
	
	nvram_set(RT2860_NVRAM, "scheduleRules", rule);
	
	if (!strcmp(action, "edit"))
		addScheduleToCron();
	
	//websRedirect(wp, "/advanced/schedule.asp");
	websRedirect(wp, "/applied.asp?url=/advanced/schedule.asp");
}

static void scheduleDelete(webs_t wp, char_t *path, char_t *query)
{
	int i, j, rule_count, loopCount=0;
	char_t name_buf[16];
	char_t *value, *delRuleName, *action;
	int *deleArray;
	char iptablesRuleName[64], scheduleName[32], rec[256], doDelete[10];
	
	action = websGetVar(wp, T("action"), T(""));
	delRuleName = websGetVar(wp, T("delRuleName"), T(""));
	
	if (!strcmp(action, "delete"))
	{
    	char *rules = nvram_bufget(RT2860_NVRAM, "scheduleRules");
    	if(!rules || !strlen(rules) )
        	return;
    
		rule_count = getRuleNums(rules);
		if(!rule_count)
			return;
	
		deleArray = (int *)malloc(rule_count * sizeof(int));
	
		value = websGetVar(wp, T("ruleNameID"), T(""));
		
		i=j=0;
		if(value){
			snprintf(name_buf, 16, "ruleName%d", atoi(value));
			deleArray[j++] = atoi(value);
		}

		deleteNthValueMulti(deleArray, rule_count, rules, ';');
		free(deleArray);

		nvram_set(RT2860_NVRAM, "scheduleRules", rules);
	}
    //websRedirect(wp, "/advanced/schedule.asp");
    websRedirect(wp, "/applied.asp?url=/advanced/schedule.asp");
}

static int showSchedule(int eid, webs_t wp, int argc, char_t **argv)
{
	int i=0, loopCount, rc=0, rcDay=0;
	char rec[128];
	char *pos, *dayPos;
	char ruleName[32], allWeek[2], weekArray[8], allhrs[4], start_hour[4], start_min[4], end_hour[4], end_min[4];
	char *wday[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
	char daysDetail[16];
	char displayWeek[32], displayTime[12];
	char *rules = nvram_bufget(RT2860_NVRAM, "scheduleRules");
	int listnumber=0;

	if(!rules)
		return 0;
	if(!strlen(rules))
		return 0;

	while(getNthValueSafe(i++, rules, ';', rec, sizeof(rec)) != -1 ){
		
		if((getNthValueSafe(0, rec, ',', ruleName, sizeof(ruleName)) == -1)){
			continue;
		}
		if((getNthValueSafe(1, rec, ',', allWeek, sizeof(allWeek)) == -1)){
			continue;
		}
		if((getNthValueSafe(2, rec, ',', weekArray, sizeof(weekArray)) == -1)){
			continue;
		}
		if((getNthValueSafe(3, rec, ',', allhrs, sizeof(allhrs)) == -1)){
			continue;
		}
		if((getNthValueSafe(4, rec, ',', start_hour, sizeof(start_hour)) == -1)){
			continue;
		}
		if((getNthValueSafe(5, rec, ',', start_min, sizeof(start_min)) == -1)){
			continue;
		}
		if((getNthValueSafe(6, rec, ',', end_hour, sizeof(end_hour)) == -1)){
			continue;
		}
		if((getNthValueSafe(7, rec, ',', end_min, sizeof(end_min)) == -1)){
			continue;
		}

		memset(daysDetail, '\0', sizeof(daysDetail));
		memset(displayWeek, '\0', sizeof(displayWeek));
		pos = daysDetail;
		dayPos = displayWeek;
		rc = rcDay = 0;
		for (loopCount=0; loopCount<=6; loopCount++) {
			if (weekArray[loopCount] == '1') {
				rcDay = snprintf(dayPos, sizeof(displayWeek)-rcDay, "%s,", wday[loopCount]);
				dayPos = dayPos+rcDay;
				
				rc = snprintf(pos, sizeof(daysDetail)-rc, "%d,", loopCount);
				pos = pos+rc;
			}
		}
		rcDay = snprintf(dayPos-sizeof(char), sizeof(displayWeek)-rcDay, "%c", '\0');
		//rc = snprintf(pos-sizeof(char), sizeof(daysDetail)-rc, "%c", '\0');
		
		memset(displayTime, '\0', sizeof(displayTime));
		snprintf(displayTime, sizeof(displayTime), "%02d:%02d~%02d:%02d", atoi(start_hour), atoi(start_min), atoi(end_hour), atoi(end_min));
		websWrite(wp, T("<tr>\n"));
		
		websWrite(wp, T("<input type=\"hidden\" id=\"ruleName%d\" name=\"ruleName%d\" value=\"%s\">"), i-1, i-1, ruleName);
		if (checkDelete("crontab", ruleName) == 1)
			websWrite(wp, T("<input type=\"hidden\" id=\"doDelete%d\" name=\"doDelete%d\" value=\"%s\">"), i-1, i-1, "true");
		else
			websWrite(wp, T("<input type=\"hidden\" id=\"doDelete%d\" name=\"doDelete%d\" value=\"%s\">"), i-1, i-1, "false");
		
		if(strlen(ruleName))
			websWrite(wp, T("<td id=\"ruleName%d\" align=center>%s</td>"), i-1, ruleName);
		else
			websWrite(wp, T("<td align=center>&nbsp;</td>"));
		
		if (atoi(allWeek) == 1) {
			websWrite(wp, T("<input type=\"hidden\" id=\"days_detail%d\" name=\"days_detail%d\" value=\"%s\">"), i-1, i-1, "allWeek");
			websWrite(wp, T("<td id=\"days%d\" align=center>%s</td>"), i-1, "All Week");
		}
		else {
			websWrite(wp, T("<input type=\"hidden\" id=\"days_detail%d\" name=\"days_detail%d\" value=\"%s\">"), i-1, i-1, daysDetail);
			websWrite(wp, T("<td id=\"days%d\" align=center>%s</td>"), i-1, displayWeek);
		}

		if (!strcmp(allhrs, "on")) {
			websWrite(wp, T("<input type=\"hidden\" id=\"timeRanges_detail%d\" name=\"timeRanges_detail%d\" value=\"%s\">"), i-1, i-1, "allhrs");
			websWrite(wp, T("<td id=\"timeRanges%d\" align=center>%s</td>"), i-1, "24hr");
		}
		else {
			websWrite(wp, T("<input type=\"hidden\" id=\"timeRanges_detail%d\" name=\"timeRanges_detail%d\" value=\"%s\">"), i-1, i-1, daysDetail);
			websWrite(wp, T("<td id=\"timeRanges%d\" align=center>%s</td>"), i-1, displayTime);
		}
		
		websWrite(wp, T("<td align=center><a href=\"javascript:submit_apply('edit', %d);\"><img src=\"/Images/img_edit.gif\"></a></td>"), i-1); //rulenameID
		websWrite(wp, T("<td align=center><a href=\"javascript:submit_apply('delete', %d);\"><img src=\"/Images/img_delete.gif\"></a></td>"), i-1); //rulenameID
		websWrite(wp, T("</tr>\n"));
		listnumber++;
	}	  
	websWrite(wp, T("<input type=\"hidden\" id=\"rulenum\" name=\"rulenum\" value=\"%d\">\n"), listnumber);
	return 0;
}

static int showScheduleMenu(int eid, webs_t wp, int argc, char_t **argv)
{
	int i=0;
	char rec[128];
	char ruleName[32];
	char *rules = nvram_bufget(RT2860_NVRAM, "scheduleRules");
	if(!rules)
		return 0;
	if(!strlen(rules))
		return 0;

	while(getNthValueSafe(i++, rules, ';', rec, sizeof(rec)) != -1 ){
		
		if((getNthValueSafe(0, rec, ',', ruleName, sizeof(ruleName)) == -1)){
			continue;
		}
		//Add "value" attribute by U-Media Ricky Cao on Apr. 11 2008
		websWrite(wp, T("<option id=sch_%s name=sch_%s value=%s >%s</option>"), ruleName, ruleName, ruleName, ruleName);
	}	  
	return 0;
}

void formDefineSchedule(void)
{
	
	//Jacky.Yang 27-Mar-2008,
	websFormDefine(T("scheduleAdd"), scheduleAdd);
	websFormDefine(T("scheduleDelete"), scheduleDelete);
	websAspDefine(T("showSchedule"), showSchedule);
	websAspDefine(T("showScheduleMenu"), showScheduleMenu);
}
