#include	<stdlib.h>
#include	<sys/ioctl.h>
#include	<arpa/inet.h>
#include	"../../autoconf.h"
#ifdef CONFIG_DEFAULTS_KERNEL_2_6_21
  #include	<linux/types.h>
  #include	<linux/socket.h>
  #include	<linux/if.h>
#endif
#include	<linux/wireless.h>
/*#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <linux/wireless.h>*/
/*#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
//#include <net/if.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <Linux/wireless.h>*/

#if WIRELESS_EXT <= 11
#ifndef SIOCDEVPRIVATE
#define SIOCDEVPRIVATE 0x8BE0
#endif
#define SIOCIWFIRSTPRIV SIOCDEVPRIVATE
#endif

/* Length of interface name.  */
#define IF_NAMESIZE	16
	
#define RTPRIV_IOCTL_E2P (SIOCIWFIRSTPRIV + 0x07)
#define ifr_name ifr_ifrn.ifrn_name /* interface name */


//Jacky.Yang 7-Jan-2007, get BoardUI eeprom 0xCE ~ 0xD2
static int getEEPROM(char *e2p_value)
{
	int socket_id, ret;
	struct iwreq wrq;
	char name[25];
	char data[4096];
	int addr, value, p1, p2;
	
	socket_id = socket(AF_INET, SOCK_DGRAM, 0);
	if(socket_id < 0) {
		printf("\nrtuser::error::Open socket error!\n\n");
		return -1;
	}
	
	sprintf(name, "ra0");
	memset(data, 0x00, sizeof(data));
	
	strcpy(data, e2p_value); // Country region code in eeprom 0x39
	strcpy(wrq.ifr_name, name);
	wrq.u.data.length = strlen(data)+1;
	wrq.u.data.pointer = data;
	wrq.u.data.flags = 0;
	ret = ioctl(socket_id, RTPRIV_IOCTL_E2P, &wrq);
	if(ret != 0) {
		printf("\nrtuser::error::get eeprom\n\n");
		//exit(0);
	}
	sscanf(wrq.u.data.pointer, "\n[%dx%04X]:%dx%X ", &p1, &addr, &p2, &value);
	printf("\nGet EEP[0x%02X]:0x%04X\n", addr, value);
	return value;
}

int main (int argc, char *argv[])
{
    int file_begin, file_end;
    int line_begin, line_end;
    char *boundary; int boundary_len;
    char *filename = getenv("UPLOAD_FILENAME");
    char *pname;

    printf(
"\
Server: %s\n\
Pragma: no-cache\n\
Content-type: text/html\n",
getenv("SERVER_SOFTWARE"));

printf("\n\
<html>\n\
<head>\n\
<TITLE>Upload Firmware</TITLE>\n\
<link rel=stylesheet href=/style/normal_ws.css type=text/css>\n\
<meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-1\">\n\
</head>\n\
<body> <h1> Upload Firmware</h1>");

	getEEPROM("D2");
	getEEPROM("CE");
	
printf("</body></html>\n");
exit(0);
}

