#!/bin/sh

BRIDGE=br0
RA2880=ra0
MARVELL=eth2
VLAN=eth2.2

platform=`nvram_get 2860 Platform`
mode=`nvram_get 2860 OperationMode`
if test -z "$mode" ; then
	echo -n "$BRIDGE"
	exit;
fi

if [ $mode -eq 0 ] ; then
	#bridge
	echo -n "$BRIDGE"; exit
fi

if [ $mode -eq 1 ] ; then
	#NAT
	if test "$platform" == "MARVELL" ; then
		echo -n "$RA2880"; exit
	fi
	if test "$platform" == "ICPLUS" ; then
		echo -n "$BRIDGE"; exit
	fi
fi

if [ $mode -eq 2 ] ; then
	#Wireless ISP
	if test "$platform" == "MARVELL" ; then
		echo -n "$MARVELL"; exit
	fi
	if test "$platform" == "ICPLUS" ; then
		echo -n "$BRIDGE"; exit
	fi
fi

