#include	<stdlib.h>
#include	<sys/ioctl.h>
#include	<arpa/inet.h>
#include	"../../autoconf.h"
#ifdef CONFIG_DEFAULTS_KERNEL_2_6_21
  #include	<linux/types.h>
  #include	<linux/socket.h>
  #include	<linux/if.h>
#endif
#include	<linux/wireless.h>

#include <stdio.h>
#include <sys/types.h>
/*#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
//#include <net/if.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/wireless.h>*/
	

/* Length of interface name.  */
#define IF_NAMESIZE	16
	
#define RTPRIV_IOCTL_E2P (SIOCIWFIRSTPRIV + 0x07)
#define ifr_name ifr_ifrn.ifrn_name /* interface name */

//Tom.Hung 2009-4-29, for getFlash
#include "nvram.h"
#include "flash_api.h"
#include "flash_ioctl.h"
//Tom.Hung 2009-4-29

//Tom.Hung 2009-4-29, get value from Flash.
static unsigned int getFlash(char *addr)
{
//# flash -r 40035 -c 1
//40035: 2 (RF IC type)
//40004~40009 (MAC Addr)
//400d0~400d2 (BoardID)
    unsigned char buffer[FLASH_MAX_RW_SIZE];
    int i=0;
    char    *src;
    char    *dst;
    unsigned int    bytes=1;
    unsigned int value;

    dst = (unsigned int *)buffer;
    src = (unsigned int *)strtol(addr, NULL, 16);

	if(flash_read(dst,src, bytes)<0){
		printf("READ: Out of scope\n");
	}else {
	    for(i=0;i<bytes;i++) {
				//printf("%X: %X\n", ((unsigned int)src)+i, buffer[i]);
				value = buffer[i];
	    }
	}
	return value;
}
//Tom.Hung 2009-4-29

//Jacky.Yang 7-Jan-2007, get BoardUI eeprom 0xCE ~ 0xD2
static int getEEPROM(char *e2p_value)
{
	int socket_id, ret;
	struct iwreq wrq;
	char name[25];
	char data[4096];
	int addr, value, p1, p2;
	
	socket_id = socket(AF_INET, SOCK_DGRAM, 0);
	if(socket_id < 0) {
		printf("\nrtuser::error::Open socket error!\n\n");
		return -1;
	}
	
	sprintf(name, "ra0");
	memset(data, 0x00, sizeof(data));
	
	strcpy(data, e2p_value); // Country region code in eeprom 0x39
	strcpy(wrq.ifr_name, name);
	wrq.u.data.length = strlen(data)+1;
	wrq.u.data.pointer = data;
	wrq.u.data.flags = 0;
	ret = ioctl(socket_id, RTPRIV_IOCTL_E2P, &wrq);
	if(ret != 0) {
		printf("\nrtuser::error::get eeprom\n\n");
		//exit(0);
	}
	sscanf(wrq.u.data.pointer, "\n[%dx%04X]:%dx%X ", &p1, &addr, &p2, &value);
	//printf("\nGet EEP[0x%02X]:0x%04X\n", addr, value);
	return value;
}

char getChar(int value)
{
	if (value == 0)
		return '0';
	else if (value == 1)
		return '1';
	else if (value == 2)
		return '2';
	else if (value == 3)
		return '3';
	else if (value == 4)
		return '4';
	else if (value == 5)
		return '5';
	else if (value == 6)
		return '6';
	else if (value == 7)
		return '7';
	else if (value == 8)
		return '8';
	else if (value == 9)
		return '9';
	else if (value == 10)
		return 'A';
	else if (value == 11)
		return 'B';
	else if (value == 12)
		return 'C';
	else if (value == 13)
		return 'D';
	else if (value == 14)
		return 'E';
	else if (value == 15)
		return 'F';
	
}

int main (int argc, char *argv[])
{
	char BOARDID[6];
	int loop=0;
	FILE *fp;
	//BoardID: 036370
	//0xD0:03, 0xD1:63, 0xD2:70
	/*printf("%d\n", (getEEPROM("D0") & 0x00F0) >> 4);
	printf("%d\n", (getEEPROM("D0") & 0x000F));
    printf("%d\n", (getEEPROM("D1") & 0x00F0) >> 4);
	printf("%d\n", (getEEPROM("D1") & 0x000F));
	printf("%d\n", (getEEPROM("D2") & 0x00F0) >> 4);
	printf("%d\n", (getEEPROM("D2") & 0x000F));*/
	//Tom.Hung 2009-4-30, get Board ID from flash directly
	/*BOARDID[0] = getChar((getEEPROM("D0") & 0x00F0) >> 4);
	BOARDID[1] = getChar((getEEPROM("D0") & 0x000F));
	BOARDID[2] = getChar((getEEPROM("D1") & 0x00F0) >> 4);
	BOARDID[3] = getChar((getEEPROM("D1") & 0x000F));
	BOARDID[4] = getChar((getEEPROM("D2") & 0x00F0) >> 4);
	BOARDID[5] = getChar((getEEPROM("D2") & 0x000F));*/
	BOARDID[0] = getChar((getFlash("400d0") & 0x00F0) >> 4);
	BOARDID[1] = getChar((getFlash("400d0") & 0x000F));
	BOARDID[2] = getChar((getFlash("400d1") & 0x00F0) >> 4);
	BOARDID[3] = getChar((getFlash("400d1") & 0x000F));
	BOARDID[4] = getChar((getFlash("400d2") & 0x00F0) >> 4);
	BOARDID[5] = getChar((getFlash("400d2") & 0x000F));
	//Tom.Hung 2009-4-30

	fp = fopen("/var/boardid", "w");
	if (fp!=NULL)
	{
		for (loop=0; loop<6; loop++)
			fputc(BOARDID[loop], fp);
		fclose(fp);
	}
}

