/*	U-Media
 *	file_add_header.c, Add header in configuration or firmware image.
 *
 *	Jacky.Yang 15-Jan-2007
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include "crc32.h"
#include "../auto_add_header/image_header.h"

void usage(char *cmd)
{
	/*printf("Usage:\n");
	printf("  %s <command> <CONF/FW> [filename]\n", cmd);
	printf("  %s add <CONF/FW> [filename] - Add header in file\n", cmd);
	printf("  %s get <CONF/FW> [filename] - Get header for file\n", cmd);
	exit(0);*/
}

int openFileFunc(const char *filename, unsigned char **fileBuf)
{
	struct stat fileStatBuf;
	int fd, file_length;
	
	//get file stat.
	stat(filename, &fileStatBuf);
	printf("file size = %d\n", fileStatBuf.st_size);
	if ((fd = open(filename, O_RDONLY)) == -1) {
		printf("Cannot open input file\n");
		close(fd);
		exit(0);
	}
	
	*fileBuf = (unsigned char *)malloc(fileStatBuf.st_size*sizeof(unsigned char));
	
	if (*fileBuf == NULL) {
		printf("Cannot allocate memory for upgrading\n");
		close(fd);
		exit(0);
	}
	memset(*fileBuf , '\0', sizeof(fileBuf));
	file_length = read(fd, *fileBuf, fileStatBuf.st_size);
	close(fd);
	
	return fileStatBuf.st_size;
}

int getHeader(char *fileType, const char *filename)
{
	printf("get\n");
	
	unsigned char *fileBuf, *writeBuf;
	unsigned int computeCheckSum;
	int fd, loop=0, file_length, setWriteBufSize, openFileSize;
	char computeCheckSumHex[IMG_HEADER_CHECKSUM_LEN+1]; // Need to add end char in string '\0';
	char checkMagic[IMG_HEADER_MAGIC_LEN];
	char *cmdString;
	
	cmdString = (char *)malloc( 2*(strlen(filename)*sizeof(char)) + 20 );
	
	if (!strcmp(fileType, "CONF"))
	{
		printf("CONF\n");
		
		struct confHeader nowConfHeader;
		char getHeader[CONF_HEADER_LEN];
		//sprintf(checkMagic, "%x", MAGIC_NUM_CONF);
		checkMagic[0] = MAGIC_NUM_CONF_0;
		checkMagic[1] = MAGIC_NUM_CONF_1;
		checkMagic[2] = MAGIC_NUM_CONF_2;
		checkMagic[3] = MAGIC_NUM_CONF_3;
		
		setWriteBufSize = openFileFunc(filename, &fileBuf) - CONF_HEADER_LEN; //cut the last char(\0) in string.
		
		writeBuf = (unsigned char *)malloc(setWriteBufSize*sizeof(unsigned char));

		memset(writeBuf, '\0', sizeof(writeBuf));
		
		//get header from file.
		for (loop=0; loop<CONF_HEADER_LEN; loop++)
		{
			if (loop < IMG_HEADER_MAGIC_LEN)
			{
				nowConfHeader.magic[loop] = *(fileBuf+loop);
			}
			else if (loop >= IMG_HEADER_MAGIC_LEN)
			{
				nowConfHeader.checksum[loop-IMG_HEADER_MAGIC_LEN] = *(fileBuf+loop);
			}
			//getHeader[loop] = *(fileBuf+loop);
		}
		
		while ((loop-CONF_HEADER_LEN) < setWriteBufSize)
		{
			*(writeBuf+(loop-CONF_HEADER_LEN)) = *(fileBuf+loop);
			loop++;
		}
		//printf("writeBuf string: %s\n", writeBuf);
		computeCheckSum = crc32(0, writeBuf, setWriteBufSize);
		snprintf(computeCheckSumHex, sizeof(computeCheckSumHex), "%x", computeCheckSum);
		computeCheckSumHex[IMG_HEADER_CHECKSUM_LEN+1] = '\0';
		
		if (strncmp(nowConfHeader.magic, checkMagic, IMG_HEADER_MAGIC_LEN))
		{
			printf("Magic Number can't match!!\n");
			
			system("echo 0 > /var/CHECKCONF");
			exit(0);
		}
		
		if (!strncmp(nowConfHeader.checksum, computeCheckSumHex, IMG_HEADER_CHECKSUM_LEN))
		{
			printf("Re-write to original file\n");
			
			memset(cmdString, '\0', sizeof(cmdString));
			strcat(cmdString, "rm -f ");
			strcat(cmdString, filename);
			system(cmdString);
			
			if ((fd = open(filename, O_WRONLY | O_CREAT)) == -1) {
				printf("Cannot open input file\n");
				close(fd);
				system("echo 0 > /var/CHECKCONF");
				exit(0);
			}
			
			write(fd, writeBuf, setWriteBufSize);
			close(fd);
			
			printf("Re-Name to compress filename %s.bz2\n", filename);
			memset(cmdString, '\0', sizeof(cmdString));
			strcat(cmdString, "mv ");
			strcat(cmdString, filename);
			strcat(cmdString, " ");
			strcat(cmdString, filename);
			strcat(cmdString, ".bz2");
			system(cmdString);
			
			printf("Decompress file to original file.\n");
			memset(cmdString, '\0', sizeof(cmdString));
			strcat(cmdString, "bunzip2 ");
			strcat(cmdString, filename);
			strcat(cmdString, ".bz2");
			system(cmdString);
			
			system("echo 1 > /var/CHECKCONF");
			
			free(writeBuf);
			free(fileBuf);
		}
		else
		{
			printf("False\n");
			memset(cmdString, '\0', sizeof(cmdString));
			strcat(cmdString, "rm -fr ");
			strcat(cmdString, filename);
			system(cmdString);
			system("echo 0 > /var/CHECKCONF");
		}
	}
	else
	{
		usage("file_add_header");
	}
}

void addHeader(char *fileType, const char *filename)
{
	printf("add\n");
	
	struct stat fileStatBuf;
	int fd, setWriteBufSize, openFileSize, loop=0, tmp_loop=0;
	unsigned char *fileBuf, *writeBuf;
	unsigned int checksum;
	char *cmdString;
	cmdString = (char *)malloc( 2*(strlen(filename)*sizeof(char)) + 20 );
       if (cmdString == NULL)
       {
               printf("Can not allocate memory\n");
               return;
       }	
	
	
	if (!strcmp(fileType, "CONF"))
	{
		printf("CONF\n");
		
		//compress first.
		memset(cmdString, '\0', sizeof(cmdString));
		strcat(cmdString, "rm -f ");
		strcat(cmdString, filename);
		strcat(cmdString, ".bz2");
		system(cmdString);
	
		memset(cmdString, '\0', sizeof(cmdString));
		strcat(cmdString, "bzip2 ");
		strcat(cmdString, filename);
		system(cmdString);
		//strcat(filename, ".bz2");
		printf("Compress completed, and change default filename to %s.bz2\n", filename);
	
		printf("Re-Name compress file to original name %s\n", filename);
		memset(cmdString, '\0', sizeof(cmdString));
		strcat(cmdString, "mv ");
		strcat(cmdString, filename);
		strcat(cmdString, ".bz2 ");
		strcat(cmdString, filename);
		system(cmdString);	
	
		//open file and save to fileBuf.
		openFileSize = openFileFunc(filename, &fileBuf);
		setWriteBufSize = openFileSize + CONF_HEADER_LEN;
		printf("writeBuf size=%d\n", setWriteBufSize);
	
		checksum = crc32(0, fileBuf, openFileSize);
		printf("checksum=%x\n", checksum);
		
		struct confHeader newConfHeader;
		//sprintf(newConfHeader.magic, "%x", MAGIC_NUM_CONF);
		newConfHeader.magic[0] = MAGIC_NUM_CONF_0;
		newConfHeader.magic[1] = MAGIC_NUM_CONF_1;
		newConfHeader.magic[2] = MAGIC_NUM_CONF_2;
		newConfHeader.magic[3] = MAGIC_NUM_CONF_3;		
		sprintf(newConfHeader.checksum, "%x", checksum);

		if ((fd = open(filename, O_WRONLY | O_CREAT)) == -1) {
			printf("Cannot open input file\n");
			close(fd);
			exit(0);
		}
		writeBuf = (unsigned char *)malloc(setWriteBufSize*sizeof(unsigned char));
		if (writeBuf == NULL)
		{
			printf("Can not allocate memory\n");
			return;
		}
		memset(writeBuf, '\0', sizeof(writeBuf));
		
		//Add header to file
		for (loop=0; loop<IMG_HEADER_MAGIC_LEN; loop++)
			*(writeBuf+loop) = newConfHeader.magic[loop];
		
		for (loop=0; loop<IMG_HEADER_CHECKSUM_LEN; loop++)
			*(writeBuf+loop+IMG_HEADER_MAGIC_LEN) = newConfHeader.checksum[loop];
		
		loop = 0;
		while (loop < setWriteBufSize)
		{
			*(writeBuf+(loop+CONF_HEADER_LEN)) = *(fileBuf+loop);
			loop++;
		}

		write(fd, writeBuf, setWriteBufSize);
		close(fd);
		free(writeBuf);
		free(fileBuf);
	}
	else
	{
		usage("file_add_header");
	}

}

int main (int argc, char *argv[])
{
	if (argc != 4)
		usage(argv[0]);

	if (!strcmp(argv[1], "add"))
	{
		addHeader(argv[2], argv[3]);
	}
	else if (!strcmp(argv[1], "get"))
	{
		getHeader(argv[2], argv[3]);
	}
	else
		usage(argv[0]);
}