/*	U-Media
 *	file_add_header.c, Add header in configuration or firmware image.
 *
 *	Jacky.Yang 15-Jan-2007
 */
#define CONF_HEADER_LEN 12
#define FW_HEADER_LEN 19
	
#define IMG_HEADER_MAGIC_LEN 4
#define IMG_HEADER_CHECKSUM_LEN 8
#define IMG_HEADER_BOARDID_LEN 6
#define IMG_HEADER_IMAGETYPE_LEN 1

#define MAGIC_NUM_CONF_0 0x55 //85:U (U-Media)
#define MAGIC_NUM_CONF_1 0x52 //82:R (Ralink)
#define MAGIC_NUM_CONF_2 0x5F //95:- (-)
#define MAGIC_NUM_CONF_3 0x43 //67:C (Configuration)

#define MAGIC_NUM_FW_0 0x55 //85:U (U-Media)
#define MAGIC_NUM_FW_1 0x52 //82:R (Ralink)
#define MAGIC_NUM_FW_2 0x5F //95:- (-)
#define MAGIC_NUM_FW_3 0x46 //70:F (Firmware)

//EEPROM Address: D0, D1, D2

#ifdef TEW637AP
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x32 //51:2
#define BOARDID_2	0x36 //54:6
#define BOARDID_3	0x33 //51:3
#define BOARDID_4	0x37 //55:7
#define BOARDID_5	0x30 //48:0
#endif

#ifdef TEW638APB
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x32 //51:2
#define BOARDID_2	0x36 //54:6
#define BOARDID_3	0x33 //51:3
#define BOARDID_4	0x38 //55:8
#define BOARDID_5	0x30 //48:0
#endif

#ifdef TEW672GR
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x32 //51:2
#define BOARDID_2	0x36 //54:6
#define BOARDID_3	0x37 //51:7
#define BOARDID_4	0x32 //55:2
#define BOARDID_5	0x30 //48:0
#endif

#ifdef TEW647GA
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x32 //51:2
#define BOARDID_2	0x36 //54:6
#define BOARDID_3	0x34 //51:7
#define BOARDID_4	0x37 //55:2
#define BOARDID_5	0x30 //48:0
#endif
	
#ifdef TEW635BRP
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x32 //51:2
#define BOARDID_2	0x36 //54:6
#define BOARDID_3	0x37 //51:3
#define BOARDID_4	0x32 //55:5
#define BOARDID_5	0x30 //48:0
#endif

#ifdef UMEDIA
//Super Mode boardID: 000000
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x30 //48:0
#define BOARDID_2	0x30 //48:0
#define BOARDID_3	0x30 //48:0
#define BOARDID_4	0x30 //48:0
#define BOARDID_5	0x30 //48:0
#endif

#ifdef SMCWAP375L
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x32 //48:0
#define BOARDID_2	0x33 //48:0
#define BOARDID_3	0x37 //48:0
#define BOARDID_4	0x35 //48:0
#define BOARDID_5	0x30 //48:0
#endif

#ifdef FranklinR500
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x30 //48:0
#define BOARDID_2	0x30 //48:0
#define BOARDID_3	0x30 //48:0
#define BOARDID_4	0x30 //48:0
#define BOARDID_5	0x30 //48:0
#endif

#ifdef FranklinR510
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x30 //48:0
#define BOARDID_2	0x30 //48:0
#define BOARDID_3	0x30 //48:0
#define BOARDID_4	0x30 //48:0
#define BOARDID_5	0x30 //48:0
#endif

#ifdef FranklinR520
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x30 //48:0
#define BOARDID_2	0x30 //48:0
#define BOARDID_3	0x30 //48:0
#define BOARDID_4	0x30 //48:0
#define BOARDID_5	0x30 //48:0
#endif

#ifdef FranklinR535
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x30 //48:0
#define BOARDID_2	0x30 //48:0
#define BOARDID_3	0x30 //48:0
#define BOARDID_4	0x30 //48:0
#define BOARDID_5	0x30 //48:0
#endif

#ifdef FranklinR505
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 0x30 //48:0
#define BOARDID_2	0x30 //48:0
#define BOARDID_3	0x30 //48:0
#define BOARDID_4	0x30 //48:0
#define BOARDID_5	0x30 //48:0
#endif

#ifdef griin_WRT385L
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x30 //48:0
#define BOARDID_2	0x30 //48:0
#define BOARDID_3	0x30 //48:0
#define BOARDID_4	0x30 //48:0
#define BOARDID_5	0x30 //48:0
#endif

/*
//Super Mode boardID: 000000
#define BOARDID_0	0x30 //48:0
#define BOARDID_1 	0x30 //51:3
#define BOARDID_2	0x30 //54:6
#define BOARDID_3	0x30 //51:3
#define BOARDID_4	0x30 //55:7
#define BOARDID_5	0x30 //48:0
*/

#define IMAGE_TYPE 0x46 //0x42(66)=B:Boot Loader , 0x46(70)=F: F/W, 0x41(65)A:boot loader + f/w.

struct confHeader {
	unsigned char magic[IMG_HEADER_MAGIC_LEN];
	unsigned char checksum[IMG_HEADER_CHECKSUM_LEN];
};

struct imgHeader {
	unsigned char magic[IMG_HEADER_MAGIC_LEN];
	unsigned char checksum[IMG_HEADER_CHECKSUM_LEN];
	unsigned char boardID[IMG_HEADER_BOARDID_LEN];
	unsigned char imageType[IMG_HEADER_IMAGETYPE_LEN];
};
