/*	U-Media
 *	file_add_header.c, Add header in configuration or firmware image.
 *
 *	Jacky.Yang 15-Jan-2007
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include "crc32.h"
#include "image_header.h"

void checkFileHeader()
{
	printf("checkfile\n");
}

int openFileFunc(const char *filename, unsigned char **fileBuf)
{
	struct stat fileStatBuf;
	int fd, file_length;
	
	//get file stat.
	stat(filename, &fileStatBuf);
	printf("file size = %d\n", fileStatBuf.st_size);
	if ((fd = open(filename, O_RDONLY)) == -1) {
		printf("Cannot open input file\n");
		close(fd);
		exit(0);
	}
	
	*fileBuf = (unsigned char *)malloc(fileStatBuf.st_size*sizeof(unsigned char));
	memset(*fileBuf , '\0', sizeof(fileBuf));
	
	if (*fileBuf == NULL) {
		printf("Cannot allocate memory for upgrading\n");
		close(fd);
		exit(0);
	}
	file_length = read(fd, *fileBuf, fileStatBuf.st_size);
	close(fd);
	
	return fileStatBuf.st_size;
}


void addHeader(const char *filename)
{
	struct stat fileStatBuf;
	int fd, setWriteBufSize, openFileSize, loop=0, tmp_loop=0;
	unsigned char *fileBuf, *writeBuf;
	unsigned int checksum;
	char *cmdString;
	cmdString = (char *)malloc( (strlen(filename)*sizeof(char)) + 20 );
		struct imgHeader newImgHeader;
		//open file and save to fileBuf.
		openFileSize = openFileFunc(filename, &fileBuf);
		setWriteBufSize = openFileSize + FW_HEADER_LEN;
		//printf("writeBuf size=%d\n", setWriteBufSize);
	
		checksum = crc32(0, fileBuf, openFileSize);
		printf("checksum=%x\n", checksum);
		sprintf(newImgHeader.checksum, "%08x", checksum);
		
		//sprintf(newImgHeader.magic, "%04x", MAGIC_NUM_FW);
		newImgHeader.magic[0] = MAGIC_NUM_FW_0;
		newImgHeader.magic[1] = MAGIC_NUM_FW_1;
		newImgHeader.magic[2] = MAGIC_NUM_FW_2;
		newImgHeader.magic[3] = MAGIC_NUM_FW_3;
		
		newImgHeader.boardID[0] = BOARDID_0;
		newImgHeader.boardID[1] = BOARDID_1;
		newImgHeader.boardID[2] = BOARDID_2;
		newImgHeader.boardID[3] = BOARDID_3;
		newImgHeader.boardID[4] = BOARDID_4;
		newImgHeader.boardID[5] = BOARDID_5;

		newImgHeader.imageType[0] = IMAGE_TYPE;
		printf("BoardID: ");
		for (loop=0; loop<IMG_HEADER_BOARDID_LEN; loop++)
			printf("%c", newImgHeader.boardID[loop]);
		printf("\n");
		//printf("magic:%s, checksum:%s, boardID:%s, imageType:%s\n", newImgHeader.magic, newImgHeader.checksum, newImgHeader.boardID, newImgHeader.imageType);
		//printf("jacky - magic:%d, checksum:%x, boardID:%d, imageType:%d\n", MAGIC_NUM_FW, checksum, BOARDID, IMAGE_TYPE);

		if ((fd = open(filename, O_WRONLY | O_CREAT)) == -1) {
			printf("Cannot open input file\n");
			close(fd);
			exit(0);
		}
		writeBuf = (unsigned char *)malloc(setWriteBufSize*sizeof(unsigned char));
		memset(writeBuf, '\0', sizeof(writeBuf));
		
		loop = 0;
		while (loop < openFileSize)
		{
			*(writeBuf+loop) = *(fileBuf+loop);
			loop++;
		}
		
		//Add header to last in file
		
		for (tmp_loop=0; tmp_loop<IMG_HEADER_MAGIC_LEN; tmp_loop++) {
			//printf("magic[%d]:%c\n", tmp_loop, newImgHeader.magic[tmp_loop]);
			*(writeBuf+(loop++)) = newImgHeader.magic[tmp_loop];
		}
		
		for (tmp_loop=0; tmp_loop<IMG_HEADER_CHECKSUM_LEN; tmp_loop++) {
			//printf("checksum[%d]:%c\n", tmp_loop, newImgHeader.checksum[tmp_loop]);
			*(writeBuf+(loop++)) = newImgHeader.checksum[tmp_loop];
		}
		
		for (tmp_loop=0; tmp_loop<IMG_HEADER_BOARDID_LEN; tmp_loop++) {
			//printf("boardID[%d]:%c\n", tmp_loop, newImgHeader.boardID[tmp_loop]);
			*(writeBuf+(loop++)) = newImgHeader.boardID[tmp_loop];
		}
		
		for (tmp_loop=0; tmp_loop<IMG_HEADER_IMAGETYPE_LEN; tmp_loop++) {
			//printf("imageType[%d]:%c\n", tmp_loop, newImgHeader.imageType[tmp_loop]);
			*(writeBuf+(loop++)) = newImgHeader.imageType[tmp_loop];
		}
		printf("Successful add header in firmware.\n");
		write(fd, writeBuf, setWriteBufSize);
		close(fd);
		free(writeBuf);
		free(fileBuf);
}

int main (int argc, char *argv[])
{

		addHeader(argv[1]);
}