#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "flash_api.h"

#define START_ADDRESS 0x3a000
#define BLK_SIZE 0x4000

int usage(char *name) {
	printf("%s usage:\n", name);
	printf("	%s putfile\n",name);
	printf("	%s getfile\n",name);
	return -1;
}

int putfile() {
	int fd;
	struct stat fst;
	char *buf;
	unsigned long addr = START_ADDRESS;
	unsigned long count;

	if (-1 == stat("/etc/app_config.dat", &fst)) {
		printf("file not found!\n");
		return -1;
	} else {
		fd = open("/etc/app_config.dat", O_RDWR);
	}

	if (fd == -1) {
		printf("Open config file error!\n");
		return -1;
	}

	if (fst.st_size >= BLK_SIZE) {
		printf("config file is too large\n");
		return -1;
	}
	
	//printf("config file size = %d\n", fst.st_size);
	
	buf = malloc(fst.st_size);
	read(fd, buf, fst.st_size);
	
	flash_write((char *)&fst.st_size, (char *) addr, sizeof(unsigned long));
	flash_write((char *)buf, (char *) (addr + sizeof(unsigned long)*2), fst.st_size);
	
	free(buf);
	close(fd);
	
	return 0;
}

int getfile() {
	int fd;
	char *buf;
	unsigned long fsize;
	unsigned long addr = START_ADDRESS;
	unsigned long count = 1;
	

	fd = open("/etc/app_config.dat", O_CREAT|O_RDWR|O_TRUNC);
	if (fd == -1) {
		printf("creat config file error!\n");
		return -1;
	}

	flash_read((char *)&fsize, (char *) addr, sizeof(unsigned long));

	//printf("config file size = %d\n", fsize);

	if ((fsize > BLK_SIZE) || (fsize < 5)) {
		printf("flash error, file size too large!\n");
		printf("no config file to read, put it first.\n"); // first run
		flash_write((char *)&count, (char *) (addr + sizeof(unsigned long)), sizeof(unsigned long));
		system("/bin/cp /usr/local/etc/*.conf /etc/");
		system("/bin/rm /tmp/rfw/*");
		system("/bin/cp /etc_ro/rfw/* /tmp/rfw/");
		system("/bin/appconf_gen conf2dat");
		putfile();
		close(fd);
		return -1;
	}
	
	flash_read((char *)&count, (char *) (addr +sizeof(unsigned long)), sizeof(unsigned long));
	count++;
	// count reboot times
	flash_write((char *)&count, (char *) (addr + sizeof(unsigned long)), sizeof(unsigned long));
	buf = malloc(fsize);
	flash_read((char *)buf, (char *)(addr + sizeof(unsigned long)*2), fsize);

	write(fd, buf, fsize);

	free(buf);

	close(fd);

	return 0;
}
	

int main(int argc,char **argv) {
	int rc;
	if (argc == 1 || argc > 2)
		return usage(argv[0]);

	if (!strncmp(argv[1], "getfile", 8))
		rc = getfile();
	else if (!strncmp(argv[1], "putfile", 8))
		rc = putfile();
	else
		return usage(argv[0]);

	return rc;
}


