/*
 * RTSP extension for IP connection tracking.
 * (C) 2003 by Tom Marshall <tmarshall@real.com>
 * based on ip_conntrack_irc.h
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 */

/*
 *
 * Arthur modified it for port range\discon port\diff client using same port\etc, 2007-12-18
 *
 * Arthur porting it to linux-2.6.21, 2008-8-27
 *
 * Arthur's mail: tangjingbiao@gmail.com
 *
 */

#ifndef _NF_CONNTRACK_RTSP_H
#define _NF_CONNTRACK_RTSP_H

/* #define IP_NF_RTSP_DEBUG 1 */
#define IP_NF_RTSP_VERSION "0.03"

/* port block types */
typedef enum {
    pb_single,  /* client_port=x */
    pb_range,   /* client_port=x-y */
    pb_discon   /* client_port=x/y (rtspbis) */
} portblock_t;

/* We record seq number and length of rtsp headers here, all in host order. */

/*
 * This structure is per expected connection.  It is a member of struct
 * ip_conntrack_expect.  The TCP SEQ for the conntrack expect is stored
 * there and we are expected to only store the length of the data which
 * needs replaced.  If a packet contains multiple RTSP messages, we create
 * one expected connection per message.
 *
 * We use these variables to mark the entire header block.  This may seem
 * like overkill, but the nature of RTSP requires it.  A header may appear
 * multiple times in a message.  We must treat two Transport headers the
 * same as one Transport header with two entries.
 */
struct nf_ct_rtsp_expect
{
    u_int32_t   len;        /* length of header block */
    portblock_t pbtype;     /* Type of port block that was requested */
    u_int16_t   loport;     /* Port that was requested, low or first */
    u_int16_t   hiport;     /* Port that was requested, high or second */
#if 0
    uint        method;     /* RTSP method */
    uint        cseq;       /* CSeq from request */
#endif
};

#ifdef __KERNEL__

#include <linux/spinlock.h>

#define RTSP_PORT   554

/* Protects rtsp part of conntracks */
extern rwlock_t nf_rtsp_lock;

extern unsigned int (*nf_nat_rtsp_hook)(struct sk_buff **pskb,
      		                        enum ip_conntrack_info ctinfo,
                	                unsigned int matchoff,
                        	        unsigned int matchlen,
                                	struct nf_conntrack_expect *exp,
                                	struct nf_conntrack_expect *exp2,
	                                struct nf_ct_rtsp_expect *expinfo,
                	                unsigned int destioff,
                        	        unsigned int destilen);

#endif /* __KERNEL__ */

#endif /* _IP_CONNTRACK_RTSP_H */
