/*
 * Copyright (C) 2001 Palmchip Corporation.  All rights reserved.
 *
 * This program is free software; you can distribute it and/or modify it
 * under the terms of the GNU General Public License (Version 2) as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * Defines of the Palmchip boards specific address-MAP, registers, etc.
 */
#ifndef __ASM_SURFBOARD_GENERIC_H
#define __ASM_SURFBOARD_GENERIC_H

#include <linux/config.h>
#include <asm/addrspace.h>
#include <asm/byteorder.h>


/*
 * Reset register.
 */
#define SOFTRES_REG       (KSEG1ADDR(0x00300034))
#define GORESET           (0x1)

/*
 * Power-off register
 */
#define POWER_DIR_REG     (KSEG1ADDR(0x00300624))
#define POWER_DIR_OUTPUT  (0x80)	/* GPIO 7 */
#define POWER_POL_REG     (KSEG1ADDR(0x00300628))
#define POWEROFF_REG      (KSEG1ADDR(0x00300620))
#define POWEROFF          (0x0)		/* drive low */


#endif  /* __ASM_SURFBOARD_GENERIC_H */
