/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology	5th	Rd.
 * Science-based Industrial	Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2006, Ralink Technology, Inc.
 *
 * All rights reserved.	Ralink's source	code is	an unpublished work	and	the
 * use of a	copyright notice does not imply	otherwise. This	source code
 * contains	confidential trade secret material of Ralink Tech. Any attemp
 * or participation	in deciphering,	decoding, reverse engineering or in	any
 * way altering	the	source code	is stricitly prohibited, unless	the	prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	wsc.c

	Abstract:

	Revision History:
	Who			When			What
	--------	----------		----------------------------------------------
	Paul Lin	06-08-08		Initial
	Snowpin Lee 06-09-12        Do modifications and Add APIs for AP
*/
#include    "rt_config.h"
#include    "wsc_tlv.h"
#include <net/iw_handler.h>
#include <linux/vmalloc.h>

#define WSC_UPNP_MSG_TIMEOUT			(150 * HZ)
#define RTMP_WSC_NLMSG_SIGNATURE_LEN	8

#ifndef PF_NOFREEZE
#define PF_NOFREEZE  0
#endif

char WSC_MSG_SIGNATURE[]={"RAWSCMSG"};
static int gWscActionMode;

// <<WCN vista logo>> ++, add by johnli
// General used field
UCHAR Wsc_Uuid_E[UUID_LEN_HEX] = {0x0};
UCHAR Wsc_Uuid_Str[UUID_LEN_STR]= {0x0};
// <<WCN vista logo>> --
UCHAR	Wsc_Pri_Dev_Type[8] = {0x00, 0x06, 0x00, 0x50, 0xf2, 0x04, 0x00, 0x01};

VOID    WscDelWPARetryTimer(
    IN  PRTMP_ADAPTER pAd);

// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
void    WscWriteConfToApCliCfg(
    IN  PRTMP_ADAPTER   pAd,
    IN  BOOLEAN         bEnrollee);
#endif // APCLI_SUPPORT //
// --

BOOLEAN WscCheckNonce(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	MLME_QUEUE_ELEM	*Elem,
	IN  BOOLEAN         bFlag,
// For AP Client support WPS Modification
	IN  PWSC_CTRL       pWscControl);
// --

void    WscWriteConfToPortCfg(
    IN  PRTMP_ADAPTER   pAd,
    IN  MAC_TABLE_ENTRY *pEntry,
    IN  BOOLEAN         bEnrollee);

VOID    WscEapActionDisabled(
    IN  PRTMP_ADAPTER       pAdapter,
// For AP Client support WPS Modification
    IN  PWSC_CTRL           pWscControl);
// --

// <<Reject Same PinCode>> ++, edit by johnli
//VOID    WscGetConfigErrFromNack(
USHORT    WscGetConfigErrFromNack(
// <<Reject Same PinCode>> --
    IN  PRTMP_ADAPTER       pAdapter,
    IN	MLME_QUEUE_ELEM	    *pElem);

INT	    WscSetAuthMode(
	IN	PRTMP_ADAPTER	pAd, 
	IN	PUCHAR			arg);

INT	    WscSetEncrypType(
	IN	PRTMP_ADAPTER	pAd, 
	IN	PUCHAR			arg);

INT write_dat_file_thread (void *data);

// <<WCN vista logo>> ++, add by johnli
/*
	Standard UUID generation procedure. The UUID format generated by this function is base on UUID std. version 1.
	It's a 16 bytes, one-time global unique number. and can show in string format like this:
			550e8400-e29b-41d4-a716-446655440000 
			
	The format of uuid is:
		uuid                        = <time_low> "-"
		                              <time_mid> "-"
		                              <time_high_and_version> "-"
		                              <clock_seq_high_and_reserved>
	    	                          <clock_seq_low> "-"
		                              <node>
		time_low                    = 4*<hex_octet>
		time_mid                    = 2*<hex_octet>
		time_high_and_version       = 2*<hex_octet>
		clock_seq_high_and_reserved = <hex_octet>
		clock_seq_low               = <hex_octet>
		node                        = 6*<hex_octet>
		hex_octet                   = <hex_digit> <hex_digit>
		hex_digit                   = "0"|"1"|"2"|"3"|"4"|"5"|"6"|"7"|"8"|"9"
		                              |"a"|"b"|"c"|"d"|"e"|"f"
		                              |"A"|"B"|"C"|"D"|"E"|"F"
*/
INT WscGenerateUUID(RTMP_ADAPTER *pAd, UCHAR *uuidHexStr, UCHAR *uuidAscStr, int apIdx)
{
	
	WSC_UUID_T uuid_t;
	unsigned long long uuid_time;
	int i;
	UINT16 clkSeq;
	
	// Get the current time.
	uuid_time = xtime.tv_sec; 
	uuid_time *= 10000000;
	uuid_time += 0x01b21dd213814000LL;
	
	uuid_t.timeLow = (UINT32)uuid_time & 0xFFFFFFFF;
	uuid_t.timeMid = (UINT16)((uuid_time >>32) & 0xFFFF);
	uuid_t.timeHi_Version = (UINT16)((uuid_time >> 48) & 0x0FFF);
	uuid_t.timeHi_Version |= (1 << 12);

	// Get the clock sequence.
	clkSeq = (UINT16)(jiffies & 0xFFFF);
	uuid_t.clockSeqLow = clkSeq & 0xFF;
	uuid_t.clockSeqHi_Var = (clkSeq & 0x3F00) >> 8;
	uuid_t.clockSeqHi_Var |= 0x80;

	// copy the Mac address as the value of node
	NdisMoveMemory(&uuid_t.node[0], &pAd->PortCfg.MBSSID[apIdx].Bssid[0], sizeof(uuid_t.node));

	// Create the UUID ASCII string.
	snprintf(uuidAscStr, UUID_LEN_STR, "%08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x", 
			(unsigned int)uuid_t.timeLow, uuid_t.timeMid, uuid_t.timeHi_Version, uuid_t.clockSeqHi_Var, uuid_t.clockSeqLow, 
			uuid_t.node[0], uuid_t.node[1], uuid_t.node[2], uuid_t.node[3], uuid_t.node[4], uuid_t.node[5]);

	// Create the UUID Hex format number
	uuid_t.timeLow = cpu2be32(uuid_t.timeLow);
	NdisMoveMemory(&uuidHexStr[0], &uuid_t.timeLow, 4);
	uuid_t.timeMid = cpu2be16(uuid_t.timeMid);
	NdisMoveMemory(&uuidHexStr[4], &uuid_t.timeMid, 2);
	uuid_t.timeHi_Version = cpu2be16(uuid_t.timeHi_Version);
	NdisMoveMemory(&uuidHexStr[6], &uuid_t.timeHi_Version, 2);
	NdisMoveMemory(&uuidHexStr[8], &uuid_t.clockSeqHi_Var, 1);
	NdisMoveMemory(&uuidHexStr[9], &uuid_t.clockSeqLow, 1);
	NdisMoveMemory(&uuidHexStr[10], &uuid_t.node[0], 6);

	printk("The UUID Hex string is:");
	for (i=0; i< 16; i++)
	{
		printk("%02x", (uuidHexStr[i] & 0xff));
	}
	printk("\n");
	printk("The UUID ASCII string is:%s!\n", uuidAscStr);
	return 0;
}
// <<WCN vista logo>> --

VOID    WscStateMachineInit(
	IN	PRTMP_ADAPTER		pAdapter, 
	IN	STATE_MACHINE		*S, 
	OUT	STATE_MACHINE_FUNC	Trans[])	
{
	UCHAR         apidx = MAIN_MBSSID;

	StateMachineInit(S,	(STATE_MACHINE_FUNC*)Trans, MAX_WSC_STATE, MAX_WSC_MSG, (STATE_MACHINE_FUNC)Drop, WSC_IDLE, WSC_MACHINE_BASE);
    StateMachineSetAction(S, WSC_IDLE, WSC_EAPOL_START_MSG, (STATE_MACHINE_FUNC)WscEAPOLStartAction);
	StateMachineSetAction(S, WSC_IDLE, WSC_EAPOL_PACKET_MSG, (STATE_MACHINE_FUNC)WscEAPAction);
    StateMachineSetAction(S, WSC_IDLE, WSC_EAPOL_UPNP_MSG, (STATE_MACHINE_FUNC)WscEAPAction);

//    for (apidx = MAIN_MBSSID; apidx < MAX_MBSSID_NUM; apidx++)
    // Support WSC in ra0 now 2006.11.08
    {
    	RTMPWscInitTimer(&pAdapter->PortCfg.MBSSID[apidx].WscControl, &pAdapter->PortCfg.MBSSID[apidx].WscControl.EapolTimer, (PVOID)&WscEAPOLTimeOutAction);
    	pAdapter->PortCfg.MBSSID[apidx].WscControl.EapolTimerRunning = FALSE;

    	RTMPWscInitTimer(&pAdapter->PortCfg.MBSSID[apidx].WscControl, &pAdapter->PortCfg.MBSSID[apidx].WscControl.Wsc2MinsTimer, (PVOID)&Wsc2MinsTimeOutAction);
    	pAdapter->PortCfg.MBSSID[apidx].WscControl.Wsc2MinsTimerRunning = FALSE;

	    //create the timer used to trigger timeout handler when UPnP STATE MACHINE failed.
    	RTMPWscInitTimer(&pAdapter->PortCfg.MBSSID[apidx].WscControl, &pAdapter->PortCfg.MBSSID[apidx].WscControl.WscUPnPNodeInfo.UPnPMsgTimer, (PVOID)&WscUPnPMsgTimeOutAction);
    	pAdapter->PortCfg.MBSSID[apidx].WscControl.WscUPnPNodeInfo.bUPnPMsgTimerRunning = FALSE;
    	pAdapter->PortCfg.MBSSID[apidx].WscControl.WscUPnPNodeInfo.bUPnPMsgTimerPending = FALSE;

    	RTMPWscInitTimer(&pAdapter->PortCfg.MBSSID[apidx].WscControl, &pAdapter->PortCfg.MBSSID[apidx].WscControl.WscUPnPNodeInfo.UPnPM2DTimer, (PVOID)&WscUPnPM2DTimeOutAction);
    	pAdapter->PortCfg.MBSSID[apidx].WscControl.WscUPnPNodeInfo.bUPnPM2DTimerRunning = FALSE;

#ifdef OLD_DH_KEY
		pAdapter->PortCfg.MBSSID[apidx].WscControl.pPubKeyMem = vmalloc(15*MAX_NN_DIGITS+1);
		if (pAdapter->PortCfg.MBSSID[apidx].WscControl.pPubKeyMem == NULL)
			DBGPRINT(RT_DEBUG_ERROR, "Allocate memory for WscControl.pPubKeyMem failed\n");
		pAdapter->PortCfg.MBSSID[apidx].WscControl.pSecKeyMem = vmalloc(15*MAX_NN_DIGITS+1);
		if (pAdapter->PortCfg.MBSSID[apidx].WscControl.pSecKeyMem == NULL)
			DBGPRINT(RT_DEBUG_ERROR, "Allocate memory for WscControl.pSecKeyMem failed\n");
#endif //OLD_DH_KEY
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	RTMPWscInitTimer(&pAdapter->ApCliTab.ApCliEntry[apidx].WscControl, &pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.EapolTimer, (PVOID)&WscEAPOLTimeOutAction);
    	pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.EapolTimerRunning = FALSE;

	RTMPWscInitTimer(&pAdapter->ApCliTab.ApCliEntry[apidx].WscControl, &pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.Wsc2MinsTimer, (PVOID)&Wsc2MinsTimeOutAction);
    	pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.Wsc2MinsTimerRunning = FALSE;

	//create the timer used to trigger timeout handler when UPnP STATE MACHINE failed.
	RTMPWscInitTimer(&pAdapter->ApCliTab.ApCliEntry[apidx].WscControl, &pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.WscUPnPNodeInfo.UPnPMsgTimer, (PVOID)&WscUPnPMsgTimeOutAction);
    	pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.WscUPnPNodeInfo.bUPnPMsgTimerRunning = FALSE;
	pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.WscUPnPNodeInfo.bUPnPMsgTimerPending = FALSE;

	RTMPWscInitTimer(&pAdapter->ApCliTab.ApCliEntry[apidx].WscControl, &pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.WscUPnPNodeInfo.UPnPM2DTimer, (PVOID)&WscUPnPM2DTimeOutAction);
    	pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.WscUPnPNodeInfo.bUPnPM2DTimerRunning = FALSE;
#ifdef OLD_DH_KEY
	pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.pPubKeyMem = vmalloc(15*MAX_NN_DIGITS+1);
	if (pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.pPubKeyMem == NULL)
		DBGPRINT(RT_DEBUG_ERROR, "Allocate memory for WscControl.pPubKeyMem failed\n");
	pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.pSecKeyMem = vmalloc(15*MAX_NN_DIGITS+1);
	if (pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.pSecKeyMem == NULL)
		DBGPRINT(RT_DEBUG_ERROR, "Allocate memory for WscControl.pSecKeyMem failed\n");
#endif //OLD_DH_KEY
#endif // APCLI_SUPPORT //
// --
    }
}

void WscUPnPM2DTimeOutAction(IN unsigned long data)
{
	/* For each state, we didn't care about the retry issue, we just send control message
		to notify the UPnP deamon that some error happened in STATE MACHINE.
	*/
// For AP Client support WPS Modification
//	RTMP_ADAPTER *pAd = (PRTMP_ADAPTER)data;
	RTMP_ADAPTER *pAd;
// --
	WSC_UPNP_NODE_INFO	*pWscNodeInfo;
	WSC_CTRL 			*pWscControl;
	MAC_TABLE_ENTRY		*pEntry = NULL;
//	UCHAR		        apidx = MAIN_MBSSID;

// For AP Client support WPS Modification
	if (data == 0)
	{
		DBGPRINT(RT_DEBUG_TRACE, "data is NULL!!\n");
		DBGPRINT(RT_DEBUG_TRACE, "<----- WscUPnPM2DTimeOutAction\n");
		return;
	}
	else
	{
		pWscControl = (PWSC_CTRL)data;
		pAd = pWscControl->pAd;
	}
// --
//	pWscControl = &pAd->PortCfg.MBSSID[apidx].WscControl;
	pWscNodeInfo = &pWscControl->WscUPnPNodeInfo;
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (pWscControl->EntryApIdx != MIN_NET_DEVICE_FOR_APCLI)
#endif // APCLI_SUPPORT //
// --
	pEntry = MacTableLookup(pAd, pWscControl->EntryAddr);
	
	DBGPRINT(RT_DEBUG_TRACE, "UPnP StateMachine TimeOut(State=%d!)\n", pWscControl->WscState);

//	if ((pEntry == NULL) || (pWscNodeInfo->registrarID != 0))
// For AP Client support WPS Modification
	if (((pWscControl->EntryApIdx != MIN_NET_DEVICE_FOR_APCLI) &&(pEntry == NULL)) || (pWscNodeInfo->registrarID != 0))
// --
	{
		DBGPRINT(RT_DEBUG_TRACE, "%s():pEntry maybe gone or already received M2 Packet!\n", __FUNCTION__);
		goto done;
	}
	
	if (pWscNodeInfo->M2DACKBalance != 0)
	{
		DBGPRINT(RT_DEBUG_TRACE, "%s(): waiting for M2DACK balance, extend the time!\n", __FUNCTION__);
		// Waiting for M2DACK balance.
		mod_timer(&pWscNodeInfo->UPnPM2DTimer, jiffies + WSC_EAP_ID_TIME_OUT);
		return;
	}
	else
    {	
	    DBGPRINT(RT_DEBUG_TRACE, "%s(): send EAP-Fail to wireless Station!\n", __FUNCTION__);
		
    	// Send EAPFail to Wireless Station and reset the status of Wsc.
		WscSendEapFail(pAd);
		RTMPCancelTimer(&pWscControl->EapolTimer);
		pWscControl->EapolTimerRunning = FALSE;

		pWscControl->EapMsgRunning = FALSE;                
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
		if (pWscControl->EntryApIdx != MIN_NET_DEVICE_FOR_APCLI)
#endif // APCLI_SUPPORT //
// --
		{
			pEntry->bWscCapable = FALSE;
			pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
		}
		pWscControl->WscState = WSC_STATE_OFF;
    }
	
done:
	pWscNodeInfo->bUPnPM2DTimerRunning = FALSE;
	pWscNodeInfo->M2DACKBalance = 0;
	pWscNodeInfo->registrarID = 0;
		
	
}


VOID WscUPnPMsgTimeOutAction(IN unsigned long data)
{
// For AP Client support WPS Modification
//	RTMP_ADAPTER *pAd = (PRTMP_ADAPTER)data;
	RTMP_ADAPTER *pAd;
// --
	WSC_UPNP_NODE_INFO	*pWscNodeInfo;
	WSC_CTRL 			*pWscControl;
//	UCHAR		        apidx = MAIN_MBSSID;

	DBGPRINT(RT_DEBUG_TRACE, "-----> WscUPnPMsgTimeOutAction\n");

// For AP Client support WPS Modification
	//It shouldn't happened!
/*
	if (!pAd)
		return;
*/
	if (data == 0)
	{
		DBGPRINT(RT_DEBUG_TRACE, "data is NULL!!\n");
		DBGPRINT(RT_DEBUG_TRACE, "<----- WscUPnPMsgTimeOutAction\n");
		return;
	}
	else
	{
		pWscControl = (PWSC_CTRL)data;
		pAd = pWscControl->pAd;
	}
// --
	
//	pWscControl = &pAd->PortCfg.MBSSID[apidx].WscControl;
	pWscNodeInfo = &pWscControl->WscUPnPNodeInfo;
	
	DBGPRINT(RT_DEBUG_TRACE, "UPnP StateMachine TimeOut(State=%d!)\n", pWscControl->WscState);

    if (pWscNodeInfo->bUPnPMsgTimerPending)
    {
#define WSC_UPNP_TIMER_PENDIND_WAIT	(2 * HZ)

        mod_timer(&pWscNodeInfo->UPnPMsgTimer, jiffies+WSC_UPNP_TIMER_PENDIND_WAIT);
        DBGPRINT(RT_DEBUG_TRACE, "UPnPMsgTimer Pending......\n");
        DBGPRINT(RT_DEBUG_TRACE, "<----- WscUPnPMsgTimeOutAction\n");
        return;
    } else {
	
		// <<WCN vista logo>> ++, add by johnli
		int dataLen;
		UCHAR *pWscData;

		if( (pWscData = kmalloc(WSC_MAX_DATA_LEN, GFP_ATOMIC)))
		{
			memset(pWscData, 0, WSC_MAX_DATA_LEN);

			dataLen = BuildMessageNACK(pAd, pWscControl, pWscData);
			WscSendUPnPMessage(pAd, WSC_OPCODE_UPNP_DATA, 
			WSC_UPNP_DATA_SUB_NORMAL, pWscData, dataLen, 0, 0);
			
			kfree(pWscData);
		}
		// <<WCN vista logo>> --

		pWscNodeInfo->bUPnPInProgress = FALSE;
		pWscNodeInfo->bUPnPMsgTimerPending = FALSE;
		pWscNodeInfo->bUPnPMsgTimerRunning = FALSE;
		pWscControl->WscState = WSC_STATE_OFF;
		pWscControl->WscStatus = STATUS_WSC_FAIL;
    }
	DBGPRINT(RT_DEBUG_TRACE, "<----- WscUPnPMsgTimeOutAction\n");
		
}


VOID WscEAPOLStartAction(
    IN PRTMP_ADAPTER    pAd, 
    IN MLME_QUEUE_ELEM  *Elem) 
{
    MAC_TABLE_ENTRY     *pEntry;

    DBGPRINT(RT_DEBUG_TRACE, "-----> WscEAPOLStartAction\n");

    if (Elem->MsgLen == 6)
        pEntry = MacTableLookup(pAd, Elem->Msg);
    else
    {
        PHEADER_802_11      pHeader;
        pHeader = (PHEADER_802_11)Elem->Msg;
        pEntry = MacTableLookup(pAd, pHeader->Addr2);
    }

    if (pEntry == NULL)
    {
        DBGPRINT(RT_DEBUG_TRACE, "pEntry is NULL.\n");
        DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPOLStartAction\n");
        return;
    }
    
    if (pEntry->Receive_EapolStart_EapRspId == 0)
    {
        pEntry->Receive_EapolStart_EapRspId |= WSC_ENTRY_GET_EAPOL_START;
        if (Elem->MsgLen != 6)
        {
            DBGPRINT(RT_DEBUG_TRACE, "WscEAPOLStartAction - receive EAPOL-Start from %02x:%02x:%02x:%02x:%02x:%02x\n",
                                     pEntry->Addr[0],
                                     pEntry->Addr[1],
                                     pEntry->Addr[2],
                                     pEntry->Addr[3],
                                     pEntry->Addr[4],
                                     pEntry->Addr[5]);
            pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EapMsgRunning = TRUE;
            pEntry->EnqueueEapolStartTimerForWscRunning = FALSE;
            RTMPCancelTimer(&pEntry->EnqueueEapolStartTimerForWsc);
        }
        if (pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EntryApIdx == WSC_INIT_ENTRY_APIDX)
        {
            WscInitEntryFunc(pEntry);
        }
        
        pEntry->bWscCapable = TRUE;
        DBGPRINT(RT_DEBUG_TRACE, "WscEAPOLStartAction(raL%d) - send EAP-Req(Id) to %02x:%02x:%02x:%02x:%02x:%02x\n",
                                 pEntry->ApIdx,
                                 pEntry->Addr[0],
                                 pEntry->Addr[1],
                                 pEntry->Addr[2],
                                 pEntry->Addr[3],
                                 pEntry->Addr[4],
                                 pEntry->Addr[5]);
        WscSendEapReqId(pAd, pEntry);
//        pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.WscState = WSC_STATE_WAIT_RESP_ID;
        if (!pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EapolTimerRunning)
        {
            pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EapolTimerRunning = TRUE;
            RTMPAddTimer(&pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EapolTimer, WSC_EAP_ID_TIME_OUT);
        }
    } 
    else
        DBGPRINT(RT_DEBUG_TRACE, "Ignore EAPOL-Start.\n");
    
    DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPOLStartAction\n");
}

VOID WscEAPAction(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	MLME_QUEUE_ELEM	*Elem) 
{		
    UCHAR               MsgType;
    BOOLEAN             bUPnPMsg;
    MAC_TABLE_ENTRY     *pEntry = NULL;
    UCHAR               MacAddr[MAC_ADDR_LEN] = {0};
    UCHAR               apidx = MAIN_MBSSID;
    PWSC_CTRL           pWscControl;
    PWSC_UPNP_NODE_INFO pWscUPnPNodeInfo = NULL;
// For AP Client support WPS Modification
    BOOLEAN         bFromApCli = FALSE;
// --
	
	DBGPRINT(RT_DEBUG_TRACE, "-----> WscEAPAction\n");

#if 0
    switch(pAdapter->PortCfg.MBSSID[apidx].WscControl.WscConfMode)
    {
        case WSC_AP_Enrollee:
            WscEapUnConfiguredApAction(pAdapter, Elem);
            break;
        case WSC_AP_PROXY:
            WscEapApProxyAction(pAdapter, Elem);
            break;
        case WSC_AP_REGISTRAR:
            WscEapApRegistrarAction(pAdapter, Elem);
            break;
        default:
            break;
    }
#else
	memmove(MacAddr, Elem->Msg, MAC_ADDR_LEN);
	memmove(Elem->Msg, Elem->Msg+6, Elem->MsgLen);

#ifdef DBG
{
    int k;
    printk("\nElem->MsgLen = %d\n", Elem->MsgLen);
    for (k=0; k<Elem->MsgLen; k++)
    {
        if (k%16 == 0)
            printk("\n");
        printk("%02X ", Elem->Msg[k]);
    }
    printk("\n\n");
}
#endif /* DBG */

	MsgType = WscRxMsgType(pAdapter, Elem);
	bUPnPMsg = Elem->MsgType == WSC_EAPOL_UPNP_MSG ? TRUE : FALSE;
	DBGPRINT(RT_DEBUG_TRACE, "WscEAPAction: Addr: %02x:%02x:%02x:%02x:%02x:%02x, MsgType: 0x%02X, bUPnPMsg: %s\n",
			MacAddr[0], MacAddr[1], MacAddr[2], MacAddr[3], MacAddr[4], MacAddr[5], MsgType, bUPnPMsg ? "TRUE" : "FALSE");
		
	if (bUPnPMsg)
	{	int i;
		for (i = 0 ; i < MAX_MBSSID_NUM; i++)
		{
			if(NdisEqualMemory(pAdapter->PortCfg.MBSSID[i].Bssid, MacAddr, MAC_ADDR_LEN))
			{
				apidx = i;
				break;
			}
		}
		pWscUPnPNodeInfo = &pAdapter->PortCfg.MBSSID[apidx].WscControl.WscUPnPNodeInfo;
		pWscUPnPNodeInfo->bUPnPMsgTimerPending = TRUE;
	}
	else
    {
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (MAC_ADDR_EQUAL(pAdapter->ApCliTab.ApCliEntry[apidx].WscControl.EntryAddr, MacAddr))
		bFromApCli = TRUE;
	else
#endif // APCLI_SUPPORT //
// --
	{
	        pEntry = MacTableLookup(pAdapter, MacAddr);
	        if (pEntry)
	        {
	            if (pEntry->ApIdx != MAIN_MBSSID)
	            {
	                DBGPRINT(RT_DEBUG_TRACE, "WscEAPAction: Only support WSC in ra0 now.\n");
	                DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPAction\n");
	                return;
	            }
	        }
	        else
	        {
	            DBGPRINT(RT_DEBUG_TRACE, "WscEAPAction: sta is left.\n");
	            DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPAction\n");
	            return;
	        }
	        if ((MsgType == WSC_MSG_EAP_REG_RSP_ID) || (MsgType == WSC_MSG_EAP_ENR_RSP_ID))
	        {
	            if ((pEntry->Receive_EapolStart_EapRspId & WSC_ENTRY_GET_EAP_RSP_ID) == WSC_ENTRY_GET_EAP_RSP_ID)
	            {
	                DBGPRINT(RT_DEBUG_TRACE, "WscEAPAction: Already receive EAP_RSP(Identitry) from this STA, ignore it.\n");
	                DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPAction\n");
	                return;
	            }
	            else
	                pEntry->Receive_EapolStart_EapRspId |= WSC_ENTRY_GET_EAP_RSP_ID;
	        }
	}
    }

// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (bFromApCli)
		pWscControl = &pAdapter->ApCliTab.ApCliEntry[apidx].WscControl;
	else
#endif // APCLI_SUPPORT //
// --
	pWscControl = &pAdapter->PortCfg.MBSSID[apidx].WscControl;
	pWscControl->EapolTimerPending = TRUE;
	
	if ((pWscControl->WscConfMode & WSC_AP_Enrollee_PROXY_REGISTRAR) == WSC_DISABLE)
	{
		DBGPRINT(RT_DEBUG_TRACE, "WscEAPAction(raL%d): Wsc StateMachine is disabled!\n", apidx);
		DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPAction\n");
		goto out;
	}

	if (MsgType == WSC_MSG_EAP_REG_RSP_ID)
	{
        if (((pWscControl->WscConfMode & WSC_AP_Enrollee) != 0) ||
            (((pWscControl->WscConfMode & WSC_AP_PROXY) != 0) && bUPnPMsg))
        {
            if (!bUPnPMsg && !pWscControl->bWscTrigger)
                ;
            else
            {
                gWscActionMode = WSC_AP_Enrollee;
                pWscControl->WscUseUPnP = bUPnPMsg ? 1 : 0;
        		MsgType = WSC_MSG_EAP_RSP_ID;
                WscEapEnrolleeAction(pAdapter, Elem, WSC_MSG_EAP_RSP_ID, pEntry, pWscControl, bFromApCli);
            }
        }
    }
    else if (MsgType == WSC_MSG_EAP_ENR_RSP_ID)
    {
        DBGPRINT(RT_DEBUG_TRACE, "WscEAPAction: Rx Identity\n");
        gWscActionMode = WSC_AP_REGISTRAR;
        if (bUPnPMsg)
        {
            // receive enrollee identity from UPnP
        }
        else
        {
            // receive enrollee identity from EAP
            if ((pWscControl->WscConfMode & WSC_AP_PROXY_REGISTRAR) != 0)
            {
                INT					DH_Len;  // <<Low Power CPU>> ++, add by johnli

                // Notify UPnP daemon before send Eap-Req(wsc-start)
    		    DBGPRINT(RT_DEBUG_TRACE, "%s: pEntry->Addr=%02x:%02x:%02x:%02x:%02x:%02x\n", __FUNCTION__,
    		    		pEntry->Addr[0], pEntry->Addr[1], pEntry->Addr[2], pEntry->Addr[3], pEntry->Addr[4], pEntry->Addr[5]);
    			WscSendUPnPConfReqMsg(pAdapter, pAdapter->PortCfg.MBSSID[pEntry->ApIdx].Ssid, pEntry->Addr, 2, 0);
                // Reset the UPnP timer and status.
    			if (pWscControl->WscUPnPNodeInfo.bUPnPM2DTimerRunning == TRUE)
    			{
    				RTMPCancelTimer(&pWscControl->WscUPnPNodeInfo.UPnPM2DTimer);
    				pWscControl->WscUPnPNodeInfo.bUPnPM2DTimerRunning = FALSE;
    			}
                pWscControl->WscUPnPNodeInfo.registrarID = 0;
        		pWscControl->WscUPnPNodeInfo.M2DACKBalance = 0;
                
                WscDelWPARetryTimer(pAdapter);
                pWscControl->EapMsgRunning = TRUE;
                // <<Atheros JumpStart>> <<Low Power CPU>> ++, add by johnli
                GenerateDHPublicKey(NULL, NULL, 0, pWscControl->RegData.Pkr, &DH_Len);
                // <<Atheros JumpStart>> <<Low Power CPU>> --
    			// Change the state to next one
    			pWscControl->WscState = WSC_STATE_WAIT_M1;
                // send EAP WSC_START
                WscSendMessage(pAdapter, WSC_OPCODE_START, NULL, 0, pWscControl, FALSE);
            }
        }
    }
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
    else if (MsgType == WSC_MSG_EAP_REQ_ID)
    {        
        DBGPRINT(RT_DEBUG_TRACE, "Receive EAP_Req/Identity from WPS AP or WCN\n");
		if (bUPnPMsg && (pWscControl->WscConfMode == WSC_AP_Enrollee))
		{
			gWscActionMode = WSC_AP_Enrollee;
            pWscControl->WscUseUPnP = 1;
            WscEapEnrolleeAction(pAdapter, Elem, WSC_MSG_EAP_REQ_START, pEntry, pWscControl, bFromApCli);
		}
		else
        {      
        	WscSendEapRspId(pAdapter, pWscControl); // Receive EAP_Req/Identity from WPS AP
        }
        
        if (!bUPnPMsg)
        {
            if (pWscControl->WscConfMode == WSC_AP_REGISTRAR)
                pWscControl->WscState = WSC_STATE_WAIT_M1;
            else
                pWscControl->WscState = WSC_STATE_WAIT_WSC_START;
        }
    }
    else if (MsgType == WSC_MSG_EAP_REQ_START)
    {
        // Receive EAP_Req(Wsc_Start) from WPS AP        
        if (pWscControl->WscConfMode == WSC_AP_Enrollee)
        {
            gWscActionMode = WSC_AP_Enrollee;
            pWscControl->WscUseUPnP = bUPnPMsg ? 1 : 0;
            DBGPRINT(RT_DEBUG_TRACE, "Receive EAP_Req(Wsc_Start) from WPS AP\n");
            WscEapEnrolleeAction(pAdapter, Elem, WSC_MSG_EAP_REQ_START, pEntry, pWscControl, bFromApCli);

            if (!pWscControl->EapolTimerRunning)
            {
                pWscControl->EapolTimerRunning = TRUE;
                RTMPAddTimer(&pWscControl->EapolTimer, WSC_EAP_ID_TIME_OUT);
            }
        }
        else
            DBGPRINT(RT_DEBUG_TRACE, "Ignore EAP_Req(Wsc_Start) from WPS AP\n");
    }
    else if (MsgType == WSC_MSG_EAP_FAIL)
    {
        // Receive EAP_Fail from WPS AP
        DBGPRINT(RT_DEBUG_TRACE, "Receive EAP_Fail from WPS AP\n");
        if (pWscControl->WscState >= WSC_STATE_WAIT_EAPFAIL)
        {            
            pWscControl->WscState = WSC_STATE_OFF;
			pWscControl->WscStatus = STATUS_WSC_CONFIGURED;
            pWscControl->WscConfMode = WSC_DISABLE;
    		// bring apcli interface down first
    		if(bFromApCli && pAdapter->ApCliTab.ApCliEntry[apidx].Enable == TRUE )
    		{
    			pAdapter->ApCliTab.ApCliEntry[apidx].Enable = FALSE;
    			ApCliIfDown(pAdapter);
                pAdapter->ApCliTab.ApCliEntry[apidx].Enable = TRUE;
    		}
        }
        else if (pWscControl->WscState == WSC_STATE_RX_M2D)
        {
            // Wait M2;
        }
        else
        {
            pWscControl->WscStatus = STATUS_WSC_FAIL;	

			// Change the state to next one
			pWscControl->WscState = WSC_STATE_OFF;
            //pWscControl->WscConfMode = WSC_DISABLE;
        }
    }
#endif // APCLI_SUPPORT //
// --
    else if (MsgType == WSC_MSG_M1)
    {
        if ((pWscControl->WscConfMode & WSC_AP_REGISTRAR) != 0 &&
             pWscControl->bWscTrigger)
        {
            gWscActionMode = WSC_AP_REGISTRAR;
            // If Message is from EAP, but UPnP Registrar is in progress now, ignore EAP_M1
            if (!bUPnPMsg && pWscControl->WscUPnPNodeInfo.bUPnPInProgress)
            {
                WscEapActionDisabled(pAdapter, pWscControl);
                DBGPRINT(RT_DEBUG_TRACE, "UPnP Registrar is working now, ignore EAP M1.\n");
                goto out;
            }
            else
                WscEapApRegistrarAction(pAdapter, Elem, MsgType, pEntry);
        }
        if (((pWscControl->WscConfMode & WSC_AP_PROXY) != 0) && !bUPnPMsg)
        {
            if (pWscControl->bWscTrigger && (pWscControl->WscState >= WSC_STATE_WAIT_M3))
                ;
            else
            {
                gWscActionMode = WSC_AP_PROXY;
                WscEapApProxyAction(pAdapter, Elem, MsgType, pEntry);
            }
        }
        else if (!pWscControl->bWscTrigger && ((pWscControl->WscConfMode & WSC_AP_PROXY) == 0))
        {
            WscEapActionDisabled(pAdapter, pWscControl);
            DBGPRINT(RT_DEBUG_TRACE, "UPnP Registrar is working now, ignore EAP M1.\n");
            goto out;
        }
    }
    else if (MsgType == WSC_MSG_M3 ||
             MsgType == WSC_MSG_M5 ||
             MsgType == WSC_MSG_M7 ||
             MsgType == WSC_MSG_WSC_DONE)
    {
        if (((pWscControl->WscConfMode & WSC_AP_REGISTRAR) != 0) &&
              pWscControl->bWscTrigger &&
              WscCheckNonce(pAdapter, Elem, TRUE, pWscControl))
        {
            // If Message is from EAP, but UPnP Registrar is in progress now, ignore EAP Messages
            if (!bUPnPMsg && pWscControl->WscUPnPNodeInfo.bUPnPInProgress)
            {
                WscEapActionDisabled(pAdapter, pWscControl);
                DBGPRINT(RT_DEBUG_TRACE, "UPnP Registrar is working now, ignore EAP Messages.\n");
                goto out;
            }
            else
            {
                gWscActionMode = WSC_AP_REGISTRAR;
                WscEapApRegistrarAction(pAdapter, Elem, MsgType, pEntry);
            }
        }
        else if (((pWscControl->WscConfMode & WSC_AP_PROXY) != 0) && !bUPnPMsg)
        {
            gWscActionMode = WSC_AP_PROXY;
            WscEapApProxyAction(pAdapter, Elem, MsgType, pEntry);
            if (pWscControl->Wsc2MinsTimerRunning)
        	{
        		pWscControl->Wsc2MinsTimerRunning = FALSE;
        		RTMPCancelTimer(&pWscControl->Wsc2MinsTimer);
        	}
        }
    }
    else if (MsgType == WSC_MSG_M2 ||
             MsgType == WSC_MSG_M2D ||
             MsgType == WSC_MSG_M4 ||
             MsgType == WSC_MSG_M6 ||
             MsgType == WSC_MSG_M8)
    {
        if (((pWscControl->WscConfMode & WSC_AP_Enrollee) != 0) &&
              pWscControl->bWscTrigger &&
              WscCheckNonce(pAdapter, Elem, FALSE, pWscControl))
        {
            gWscActionMode = WSC_AP_Enrollee;
            pWscControl->WscUseUPnP = bUPnPMsg ? 1 : 0;
            if (MsgType == WSC_MSG_M2)
            {
                // For Re-Generate Pin-Code Modification
                //WscGetRegDataPIN(pAdapter, WscGeneratePinCode(pAdapter, apidx));
                WscGetRegDataPIN(pAdapter, pWscControl->WscEnrolleePinCode, pWscControl);
                DBGPRINT(RT_DEBUG_TRACE, "WscEnrolleePinCode: %08u\n", pWscControl->WscEnrolleePinCode);
                // --
            }
            // If Message is from EAP, but UPnP Registrar is in progress now, ignore EAP Messages
            if (!bUPnPMsg && pWscControl->WscUPnPNodeInfo.bUPnPInProgress)
            {
                WscEapActionDisabled(pAdapter, pWscControl);
                DBGPRINT(RT_DEBUG_TRACE, "UPnP Registrar is working now, ignore EAP Messages.\n");
                goto out;
            }
            else
                WscEapEnrolleeAction(pAdapter, Elem, MsgType, pEntry, pWscControl, bFromApCli);
        }
        else if ((pWscControl->WscConfMode & WSC_AP_PROXY) != 0 && bUPnPMsg)
        {
            gWscActionMode = WSC_AP_PROXY;
            WscEapApProxyAction(pAdapter, Elem, MsgType, pEntry);
        }
    }
    else if (MsgType == WSC_MSG_WSC_ACK)
    {
        if (((pWscControl->WscConfMode & WSC_AP_REGISTRAR) != 0) && 
               pWscControl->bWscTrigger &&
               pWscControl->WscState == WSC_STATE_SENT_M2D)
        {
            if (WscCheckNonce(pAdapter, Elem, TRUE, pWscControl))
            {
                gWscActionMode = WSC_AP_REGISTRAR;
                pWscControl->WscState = WSC_STATE_WAIT_M1;
            }
        }
        else
        {
            if (((pWscControl->WscConfMode & WSC_AP_Enrollee) != 0) && 
                  pWscControl->bWscTrigger &&
                  WscCheckNonce(pAdapter, Elem, FALSE, pWscControl))
            {
                gWscActionMode = WSC_AP_Enrollee;
                pWscControl->WscUseUPnP = bUPnPMsg ? 1 : 0;
                WscEapEnrolleeAction(pAdapter, Elem, MsgType, pEntry, pWscControl, bFromApCli);
            }
            else if ((pWscControl->WscConfMode & WSC_AP_PROXY) != 0)
            {
                gWscActionMode = WSC_AP_PROXY;
                WscEapApProxyAction(pAdapter, Elem, MsgType, pEntry);
            }
        }
    }
    else if (MsgType == WSC_MSG_WSC_NACK)
    {
        if (!bUPnPMsg &&
            (WscCheckNonce(pAdapter, Elem, FALSE, pWscControl) || WscCheckNonce(pAdapter, Elem, TRUE, pWscControl)))
        {
//            INT     WscMode;
		USHORT err = 0;

            DBGPRINT(RT_DEBUG_TRACE, "Receive NACK from WPS client.\n");
            // <<Reject Same PinCode>> ++, edit by johnli
            //WscGetConfigErrFromNack(pAdapter, Elem);
            if (err = WscGetConfigErrFromNack(pAdapter, Elem))
            {
                if ((err == WSC_ERROR_DECRYPT_CRC_FAIL) || (err == WSC_ERROR_DEV_PWD_AUTH_FAIL))
                {
                    pWscControl->WscLastPinCode = pWscControl->WscPinCode;
                    pWscControl->WscLastStatus = err;
                }
            }
            // <<Reject Same PinCode>> --
            WscSendEapFail(pAdapter);
            RTMPCancelTimer(&pWscControl->EapolTimer);
            pWscControl->WscState = WSC_STATE_FAIL;
// For AP Client support WPS Modification
            pWscControl->RegData.ReComputePke = 1;
// --
#if 0       // fix IOT problem with Atheros Client Registrar
			pWscControl->EapolTimerRunning = FALSE;
			pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
			pWscControl->WscStatus = STATUS_WSC_FAIL;
            NdisZeroMemory(&(pWscControl->EntryAddr[0]), MAC_ADDR_LEN);
			pWscControl->WscRetryCount = 0;
			pWscControl->EapMsgRunning = 0;
			pWscControl->bWscTrigger = FALSE;
			NdisZeroMemory(&(pWscControl->EntryAddr[0]), MAC_ADDR_LEN);
			if (pWscControl->Wsc2MinsTimerRunning)
			{
				pWscControl->Wsc2MinsTimerRunning = FALSE;
				RTMPCancelTimer(&pWscControl->Wsc2MinsTimer);
			}
			if (pWscControl->WscMode == 1)
				WscMode = DEV_PASS_ID_PIN;
			else
				WscMode = DEV_PASS_ID_PBC;
			WscBuildBeaconIE(pAdapter, pWscControl->WscConfStatus, FALSE, WscMode, WSC_CONFIG_METHODS);
            WscBuildProbeRespIE(pAdapter, WSC_MSGTYPE_AP_WLAN_MGR, pWscControl->WscConfStatus, FALSE, WscMode, WSC_CONFIG_METHODS);
            MakeAllBssBeacon(pAdapter);
        	UpdateAllBeaconFrame(pAdapter);
#endif // if 0
        }
    }
    else
    {
        DBGPRINT(RT_DEBUG_TRACE, "Unsupported Msg Type (%02X)\n", MsgType);
        goto out;
    }
#endif
    
	if (bUPnPMsg)
	{
		// Messages from UPnP
		if (pWscUPnPNodeInfo->bUPnPMsgTimerRunning)
			mod_timer(&pWscUPnPNodeInfo->UPnPMsgTimer, jiffies + WSC_UPNP_MSG_TIME_OUT);
	}
	else
	{
		// Messages from EAP
		if (pWscControl->EntryApIdx != WSC_INIT_ENTRY_APIDX)
        {      
		mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
		pWscControl->EapolTimerRunning = TRUE;
	}
	}
	
	if (bUPnPMsg && pWscControl->EapolTimerRunning)
	{   
		if (gWscActionMode == WSC_AP_PROXY)
		{
			mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
		}
        else
        {
            RTMPCancelTimer(&pWscControl->EapolTimer);
            pWscControl->EapolTimerRunning = FALSE;
        }
    }
	 pWscControl->WscRetryCount = 0; // add by johnli, bug fix: reset retry count when receive eap message

out:
	if (bUPnPMsg)
		pWscUPnPNodeInfo->bUPnPMsgTimerPending = FALSE;
	
    pWscControl->EapolTimerPending = FALSE;
	
	DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPAction\n");
}

// For AP Client support WPS Modification
//VOID WscEapUnConfiguredApAction(
VOID WscEapEnrolleeAction(
// --
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	MLME_QUEUE_ELEM	*Elem,
	IN  UCHAR	        MsgType,
	IN  MAC_TABLE_ENTRY *pEntry,
// For AP Client support WPS Modification
	IN  PWSC_CTRL       pWscControl,
	BOOLEAN         bFromApCli)
// --
{
    INT     DataLen = 0, rv = 0;
    UCHAR   OpCode;
    PUCHAR  WscData = NULL;
    UCHAR	apidx = MAIN_MBSSID;
	
//	PWSC_CTRL pWscControl = &pAdapter->PortCfg.MBSSID[apidx].WscControl;
	WSC_UPNP_NODE_INFO *pWscUPnPInfo = &pAdapter->PortCfg.MBSSID[apidx].WscControl.WscUPnPNodeInfo;
	BOOLEAN bUPnPMsg, bUPnPStatus = FALSE;

    DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction Enter!\n");

	bUPnPMsg = Elem->MsgType == WSC_EAPOL_UPNP_MSG ? TRUE : FALSE;
	OpCode = bUPnPMsg ? WSC_OPCODE_UPNP_MASK : 0;

	// Early check. 
	if ((gWscActionMode != WSC_AP_Enrollee) ||
// For AP Client support WPS Modification
/*
		(pWscControl->WscUseUPnP && pEntry) ||
		(pWscControl->WscUseUPnP == 0 && (!pEntry)))
*/
		(pWscControl->WscUseUPnP && (pEntry || bFromApCli)) ||
		(pWscControl->WscUseUPnP == 0 && (!pEntry) && (!bFromApCli)))
// --
	{	
		DBGPRINT(RT_DEBUG_TRACE, "EarlyCheckFailed: gWscActionMode=%d, Configured=%d, WscUseUPnP=%d, pEntry=%p!\n", 
					gWscActionMode, pWscControl->WscConfStatus, pWscControl->WscUseUPnP, pEntry);
		goto Fail;
	}
	DBGPRINT(RT_DEBUG_TRACE, "MsgType=0x%x, WscState=%d, bUPnPMsg=%d!\n", MsgType, pWscControl->WscState, bUPnPMsg);

	if (bUPnPMsg)
	{
#if 0
		/* It's a WSC message send from UPnP daemon. */
		if(MsgType == WSC_MSG_EAP_RSP_ID)
		{	/* It's a GetDeviceInfo message, we may need to initialize our state machine. */
			if (gWscActionMode == WSC_AP_Enrollee && pWscControl->EntryApIdx == WSC_INIT_ENTRY_APIDX && pWscUPnPInfo->bUPnPInProgress == FALSE)
//				pWscControl->WscState == WSC_STATE_WAIT_UPNP_START && pWscUPnPInfo->bUPnPInProgress == FALSE)
			{
				pWscUPnPInfo->bUPnPInProgress = TRUE;
				//Set the WscState as "WSC_STATE_WAIT_RESP_ID" because UPnP start from this state.
				pWscControl->WscState = WSC_STATE_WAIT_RESP_ID;
				RTMPAddTimer(&pWscUPnPInfo->UPnPMsgTimer, WSC_UPNP_MSG_TIME_OUT);
				pWscUPnPInfo->bUPnPMsgTimerRunning = TRUE;
			}
			//For other case, we accept it because it may just a 
		} 
		else if(pWscUPnPInfo->bUPnPInProgress == FALSE)
		{
			goto Done;
		}
#else
        if (MsgType ==WSC_MSG_EAP_RSP_ID)
        {
           //let it pass
        }
        else if(MsgType ==WSC_MSG_M2 && pWscUPnPInfo->bUPnPInProgress == FALSE)
        {
            if(pWscControl->EntryApIdx != WSC_INIT_ENTRY_APIDX)
			{
			    MAC_TABLE_ENTRY *tempEntry;
    			tempEntry = MacTableLookup(pAdapter, &pWscControl->EntryAddr[0]);
                if (tempEntry)
                {
                    if((tempEntry->Receive_EapolStart_EapRspId & WSC_ENTRY_GET_EAP_RSP_ID) == WSC_ENTRY_GET_EAP_RSP_ID)
                    {
            			goto Done;
                    }
                }
                /* else cannot find the pEntry, so we need to do handle this msg. */           
            } 

    		pWscUPnPInfo->bUPnPInProgress = TRUE;
    		//Set the WscState as "WSC_STATE_WAIT_RESP_ID" because UPnP start from this state.
    		//pWscControl->WscState = WSC_STATE_WAIT_RESP_ID;
    		RTMPAddTimer(&pWscUPnPInfo->UPnPMsgTimer, WSC_UPNP_MSG_TIME_OUT);
    		pWscUPnPInfo->bUPnPMsgTimerRunning = TRUE; 
        }
        else 
        {
            // For other messages, we must make sure pWscUPnPInfo->bUPnPInProgress== TRUE
            if (pWscUPnPInfo->bUPnPInProgress == FALSE)
            {
			    goto Done;
            }
        }
#endif
	}

	if( (WscData = kmalloc(WSC_MAX_DATA_LEN, GFP_ATOMIC)) == NULL)
	{
		DBGPRINT(RT_DEBUG_TRACE, "WscData Allocate failed!\n");
		goto Fail;
	}
	memset(WscData, 0, WSC_MAX_DATA_LEN);
	
	switch (MsgType)
	{
		case WSC_MSG_EAP_RSP_ID:
            DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction : Rx Identity\n");
//			if (pWscControl->WscState >= WSC_STATE_WAIT_RESP_ID)
			{
				//pWscControl->WscStatus = STATUS_WSC_EAP_RSP_ID_RECEIVED;

				if(!bUPnPMsg)
				{
	                WscDelWPARetryTimer(pAdapter);
                	pWscControl->EapMsgRunning = TRUE;
				}
				
				OpCode |= WSC_OPCODE_MSG;
				DataLen = BuildMessageM1(pAdapter, pWscControl, WscData);
				//pWscControl->WscStatus = STATUS_WSC_EAP_M1_SENT;
                
				// Change the state to next one
				if (pWscControl->WscState < WSC_STATE_SENT_M1)
			        pWscControl->WscState = WSC_STATE_SENT_M1;
			}
			break;

// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
		case WSC_MSG_EAP_REQ_START:
			DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction : Rx Wsc_Start\n");

			OpCode |= WSC_OPCODE_MSG;

			DataLen = BuildMessageM1(pAdapter, pWscControl, WscData);
			pWscControl->WscStatus = STATUS_WSC_EAP_M1_SENT;
			if(!bUPnPMsg)
			{
				if (!bFromApCli)
					WscDelWPARetryTimer(pAdapter);
				pWscControl->EapMsgRunning = TRUE;
			}

			// Change the state to next one
			if (pWscControl->WscState < WSC_STATE_SENT_M1)
				pWscControl->WscState = WSC_STATE_SENT_M1;
			break;
#endif // APCLI_SUPPORT //
// --
		case WSC_MSG_M2:
            DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction : Rx M2\n");
            
			// Receive M2, if we are at WSC_STATE_WAIT_M2 start, process it immediately
			if (pWscControl->WscState == WSC_STATE_SENT_M1)
			{
				// Process M2
				pWscControl->WscStatus = STATUS_WSC_EAP_M2_RECEIVED;
				if ((rv = ProcessMessageM2(pAdapter, Elem->Msg, Elem->MsgLen, &pWscControl->RegData)))
                    goto Fail;
                else
                {
                    OpCode |= WSC_OPCODE_MSG;
    				DataLen = BuildMessageM3(pAdapter, pWscControl, WscData);
    				pWscControl->WscStatus = STATUS_WSC_EAP_M3_SENT;
    				
    				// Change the state to next one
    				pWscControl->WscState = WSC_STATE_WAIT_M4;
                }
			}
			break;
			
		case WSC_MSG_M2D:
            DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction : Rx M2D\n");
            
			// Receive M2D, if we are at WSC_STATE_WAIT_M2 start, process it immediately
			if (pWscControl->WscState == WSC_STATE_WAIT_M2)
			{
				/*
					TODO: We need to handle about the M2D State!
				*/
				pWscControl->WscStatus = STATUS_WSC_EAP_M2D_RECEIVED;
				
				OpCode |= WSC_OPCODE_ACK;
				DataLen = BuildMessageACK(pAdapter, pWscControl, WscData);

				// Change the state to next one
				pWscControl->WscState = WSC_STATE_RX_M2D;
			}
			break;

		case WSC_MSG_M4:
            DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction : Rx M4\n");
            
			// Receive M4, if we are at WSC_STATE_WAIT_M4 start, process it immediately
			if (pWscControl->WscState == WSC_STATE_WAIT_M4)
			{       
				// Process M4
				pWscControl->WscStatus = STATUS_WSC_EAP_M4_RECEIVED;
				if ((rv = ProcessMessageM4(pAdapter, pWscControl, Elem->Msg, Elem->MsgLen, &pWscControl->RegData)))
                    goto Fail;
                else
                {
                    OpCode |= WSC_OPCODE_MSG;
    				DataLen = BuildMessageM5(pAdapter, pWscControl, WscData);
    				pWscControl->WscStatus = STATUS_WSC_EAP_M5_SENT;
                    
    				// Change the state to next one
    				pWscControl->WscState = WSC_STATE_WAIT_M6;
                }
			}
			break;

		case WSC_MSG_M6:
            DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction : Rx M6\n");
            
			// Receive M6, if we are at WSC_STATE_WAIT_M6 start, process it immediately
			if (pWscControl->WscState == WSC_STATE_WAIT_M6)
			{      
				// Process M6
				pWscControl->WscStatus = STATUS_WSC_EAP_M6_RECEIVED;
				if ((rv=ProcessMessageM6(pAdapter, pWscControl, Elem->Msg, Elem->MsgLen, &pWscControl->RegData)))
				// <<Reject Same PinCode>> ++, edit by johnli
	    			//	goto Fail;
	    			{
	    				if (rv == WSC_ERROR_HASH_FAIL)
	    				{
		    				pWscControl->WscLastPinCode = pWscControl->WscPinCode;
						pWscControl->WscLastStatus = rv;
	    				}
	    				goto Fail;
	    			}
				// <<Reject Same PinCode>> --
                else
                {
                    OpCode |= WSC_OPCODE_MSG;
    				DataLen = BuildMessageM7(pAdapter, pWscControl, WscData);
    				pWscControl->WscStatus = STATUS_WSC_EAP_M7_SENT;

    				// Change the state to next one
    				pWscControl->WscState = WSC_STATE_WAIT_M8;
                }
			}
			break;

		case WSC_MSG_M8:
            DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction : Rx M8\n");
            
			// Receive M8, if we are at WSC_STATE_WAIT_M6 start, process it immediately
			if (pWscControl->WscState == WSC_STATE_WAIT_M8)
			{
				// Process M8
				pWscControl->WscStatus = STATUS_WSC_EAP_M8_RECEIVED;
				if ((rv=ProcessMessageM8(pAdapter, pWscControl, Elem->Msg, Elem->MsgLen, &pWscControl->RegData)))
                    goto Fail;
                else
                {
                    OpCode |= WSC_OPCODE_DONE;
    				DataLen = BuildMessageDONE(pAdapter, pWscControl, WscData);
                    
    				// Change the state to next one
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
			// Ap Client only supports Inband(EAP)-Enrollee.
			if (!bUPnPMsg && bFromApCli)
				pWscControl->WscState = WSC_STATE_WAIT_EAPFAIL;
			else
#endif // APCLI_SUPPORT //
// --
    				pWscControl->WscState = WSC_STATE_WAIT_ACK;
// For AP Client support WPS Modification
			pWscControl->RegData.ReComputePke = 0;
// --
                }
			}
			break;	

        case WSC_MSG_WSC_ACK:
            DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction : Rx ACK\n");
            
            // Receive ACK
            if (pWscControl->WscState == WSC_STATE_WAIT_ACK)
            {
                // Process ACK
                pWscControl->WscStatus = STATUS_WSC_EAP_RAP_RSP_ACK;
                
                // Send out EAP-Fail
                WscSendEapFail(pAdapter);
				
                pWscControl->WscState = WSC_STATE_CONFIGURED;                
                pWscControl->WscStatus = STATUS_WSC_CONFIGURED;
            }
            break;
		default:
			DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction : Unsupported Msg Type\n");	   
			break;
	}
	
	if (bUPnPMsg)
	{
		if ((MsgType == WSC_MSG_M8) && (pWscControl->WscState == WSC_STATE_WAIT_ACK))
		{
			pWscControl->EapMsgRunning = FALSE;
            pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
            pWscControl->WscState = WSC_STATE_CONFIGURED;
            pWscControl->WscStatus = STATUS_WSC_CONFIGURED;
			if(pWscUPnPInfo->bUPnPMsgTimerRunning == TRUE)
			{	RTMPCancelTimer(&pWscUPnPInfo->UPnPMsgTimer);
            	pWscUPnPInfo->bUPnPMsgTimerRunning = FALSE;
			}
			pWscUPnPInfo->bUPnPInProgress = FALSE;
			pWscUPnPInfo->registrarID = 0;
		}
	}
	else
	{
		if ((MsgType == WSC_MSG_WSC_ACK) && (pWscControl->WscState == WSC_STATE_CONFIGURED))
		{
			RTMPCancelTimer(&pWscControl->EapolTimer);
			pWscControl->EapolTimerRunning = FALSE;
			pWscControl->EapMsgRunning = FALSE;
            pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
		}
	}
	
	if(OpCode > WSC_OPCODE_UPNP_MASK)
		bUPnPStatus = WscSendUPnPMessage(pAdapter, WSC_OPCODE_UPNP_DATA, WSC_UPNP_DATA_SUB_NORMAL, 
											WscData, DataLen, Elem->TimeStamp.vv.LowPart, Elem->TimeStamp.vv.HighPart);
	else if(OpCode > 0 && OpCode < WSC_OPCODE_UPNP_MASK)
    {   
        if (pWscControl->WscState != WSC_STATE_CONFIGURED)
		    WscSendMessage(pAdapter, OpCode, WscData, DataLen, pWscControl, bFromApCli);
    }
	else
		bUPnPStatus = TRUE;
	
Fail:
    DBGPRINT(RT_DEBUG_TRACE, "WscEapEnrolleeAction : rv = %d\n", rv);
    if (rv)
    {          
        switch(rv)
        {
            case WSC_ERROR_DEV_PWD_AUTH_FAIL:
                pWscControl->WscStatus = STATUS_WSC_ERROR_DEV_PWD_AUTH_FAIL;
                pWscControl->RegData.EnrolleeInfo.ConfigError = WSC_ERROR_DEV_PWD_AUTH_FAIL;
                break;
            default:
                pWscControl->WscStatus = STATUS_WSC_FAIL;
                pWscControl->RegData.EnrolleeInfo.ConfigError = WSC_ERROR_DECRYPT_CRC_FAIL;
                break;
        }
		if (bUPnPMsg)
		{
			if (pWscUPnPInfo->bUPnPMsgTimerRunning == TRUE)
			{
            	RTMPCancelTimer(&pWscUPnPInfo->UPnPMsgTimer);
	            pWscUPnPInfo->bUPnPMsgTimerRunning = FALSE;
			}
			pWscUPnPInfo->bUPnPInProgress = FALSE;
		}
		else
        {
            DataLen = BuildMessageNACK(pAdapter, pWscControl,WscData);
            WscSendMessage(pAdapter, WSC_OPCODE_NACK, WscData, DataLen, pWscControl, bFromApCli);
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
		if (!bFromApCli)
#endif // APCLI_SUPPORT //
// --
            pEntry->bWscCapable = FALSE;
            RTMPCancelTimer(&pWscControl->EapolTimer);
            pWscControl->EapolTimerRunning = FALSE;
        }
        //pWscControl->bWscTrigger = FALSE;
        // For Re-Generate Pin-Code Modification
        if (pWscControl->WscState >= WSC_STATE_WAIT_M4)
            pWscControl->WscEnrolleePinCode = WscRandomGeneratePinCode(pAdapter, 0);
        // --
        pWscControl->WscState = WSC_STATE_OFF;
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
        if (!bFromApCli)
#endif // APCLI_SUPPORT //
// --
        pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
        pWscControl->WscPinCode = 0;
        pWscControl->WscMode = 1;

        bUPnPStatus = FALSE;
    }

Done:
	if(WscData)
		kfree(WscData);
	if(bUPnPMsg && (bUPnPStatus == FALSE))
		WscUPnPErrHandle(pAdapter, Elem->TimeStamp.vv.LowPart, pWscControl);
		
// For AP Client support WPS Modification
//    if (pWscControl->WscState == WSC_STATE_CONFIGURED)
    if (((bUPnPMsg || pEntry) && pWscControl->WscState == WSC_STATE_CONFIGURED)
#ifdef APCLI_SUPPORT        
        ||((!bUPnPMsg && bFromApCli) && (pWscControl->WscState == WSC_STATE_WAIT_EAPFAIL || pWscControl->WscState == WSC_STATE_CONFIGURED))
#endif // APCLI_SUPPORT //
// --
	)
    {
        pWscControl->bWscTrigger = FALSE;
        // For Re-Generate Pin-Code Modification
        pWscControl->WscEnrolleePinCode = WscRandomGeneratePinCode(pAdapter, 0);
        // --
        if (pWscControl->Wsc2MinsTimerRunning)
    	{
    		pWscControl->Wsc2MinsTimerRunning = FALSE;
    		RTMPCancelTimer(&pWscControl->Wsc2MinsTimer);
    	}
        if (pWscControl->WscConfStatus == WSC_SCSTATE_UNCONFIGURED)
        {
            pAdapter->WriteWscCfgToDatFile = TRUE;
            pWscControl->WscStatus = STATUS_WSC_CONFIGURED;
            pWscControl->WscConfStatus = WSC_SCSTATE_CONFIGURED;
            pWscControl->WscPinCode = 0;
            pWscControl->WscMode = 1;

// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
		if (bFromApCli)
			WscWriteConfToApCliCfg(pAdapter, TRUE);
		else
#endif // APCLI_SUPPORT //
// --
		{
			WscBuildBeaconIE(pAdapter, WSC_SCSTATE_CONFIGURED, FALSE, 0, 0);
			WscBuildProbeRespIE(pAdapter, WSC_MSGTYPE_AP_WLAN_MGR, WSC_SCSTATE_CONFIGURED, FALSE, 0, 0);
			WscWriteConfToPortCfg(pAdapter, pEntry, TRUE);
			ApStop(pAdapter, TRUE);
			ApStartUp(pAdapter, TRUE);

			up(&(pAdapter->write_dat_file_semaphore));
		}
        }
    }

}


VOID WscEapApProxyAction(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	MLME_QUEUE_ELEM	*Elem,
	IN  UCHAR	        MsgType,
	IN  MAC_TABLE_ENTRY *pEntry)
{
	PUCHAR  WscData = NULL;
    UCHAR	apidx = MAIN_MBSSID;
	
	PWSC_CTRL pWscControl = &pAdapter->PortCfg.MBSSID[apidx].WscControl;
	WSC_UPNP_NODE_INFO *pWscUPnPInfo = &pAdapter->PortCfg.MBSSID[apidx].WscControl.WscUPnPNodeInfo;
	BOOLEAN sendToUPnP = FALSE, bUPnPStatus = FALSE;
	int reqID = 0;
		
    DBGPRINT(RT_DEBUG_TRACE, "WscEapApProxyAction Enter!\n");

	if (Elem->MsgType == WSC_EAPOL_UPNP_MSG)
	{	
		reqID = Elem->TimeStamp.vv.LowPart;
		if(reqID > 0)
			sendToUPnP = TRUE;
	}

	DBGPRINT(RT_DEBUG_TRACE, "WscEapApProxyAction():pEntry=%p, ElemMsgType=%d, MsgType=%d!\n", pEntry, Elem->MsgType, MsgType);
 
	if ((gWscActionMode != WSC_AP_PROXY) || 
	   ((Elem->MsgType == WSC_EAPOL_PACKET_MSG) && (pEntry == NULL)))
//	   ((Elem->MsgType == WSC_EAPOL_UPNP_MSG) && (pEntry == NULL) && (MsgType!= WSC_MSG_EAP_RSP_ID)))
	{	
		DBGPRINT(RT_DEBUG_TRACE, "EarlyCheckFailed: gWscActionMode=%d, pEntry=%p!\n", gWscActionMode, pEntry);
		goto Fail;
	}

	if ((WscData = kmalloc(WSC_MAX_DATA_LEN, GFP_ATOMIC)) == NULL)
	{
		DBGPRINT(RT_DEBUG_TRACE, "WscData Allocate failed!\n");
		goto Fail;
	}
	memset(WscData, 0, WSC_MAX_DATA_LEN);

    /* Base on state doing the Msg, State change diagram */
    if (Elem->MsgType == WSC_EAPOL_UPNP_MSG)
    {	// WSC message send from UPnP.
		switch (MsgType)
		{
#if 0		
			case WSC_MSG_EAP_RSP_ID:
				// It's a message send by UPnP (Microsoft Vista based) daemon use "GetDeviceInfo"
				DBGPRINT(RT_DEBUG_TRACE, "WscEapApProxyAction: Rx Id from Vista UPnP, eventID=0x%x!\n", reqID);
				DataLen = BuildMessageM1(pAdapter,WscData);
				bUPnPStatus = WscSendUPnPMessage(pAdapter, WSC_OPCODE_UPNP_DATA, WSC_UPNP_DATA_SUB_NORMAL, WscData, DataLen, reqID, 0);
				break;
#endif /* if 0 */                
			case WSC_MSG_M2:
			case WSC_MSG_M4:
			case WSC_MSG_M6:
			case WSC_MSG_M8:
	            DBGPRINT(RT_DEBUG_TRACE, "WscEapApProxyAction: Rx WSC Msg(%d) from UPnP, eventID=0x%x!\n", MsgType, reqID);
/*				
	            if (pWscControl->WscState >= WSC_STATE_WAIT_M1)
				{
					if (MsgType == WSC_MSG_M8)
						pWscControl->WscState = WSC_STATE_WAIT_DONE;
				}
*/				
				WscSendMessage(pAdapter, WSC_OPCODE_MSG, Elem->Msg, Elem->MsgLen, pWscControl, FALSE);

				//Notify the UPnP daemon which remote registar is negotiating with enrollee.
				if (MsgType == WSC_MSG_M2)
				{
					pWscUPnPInfo->registrarID = Elem->TimeStamp.vv.HighPart;
					DBGPRINT(RT_DEBUG_TRACE, "%s():registrarID=0x%x!\n", __FUNCTION__, pWscUPnPInfo->registrarID);
					WscSendUPnPMessage(pAdapter, WSC_OPCODE_UPNP_MGMT, WSC_UPNP_MGMT_SUB_REG_SELECT, (PUCHAR)(&pWscUPnPInfo->registrarID), sizeof(LONG), 0, 0);
				}
				break;
				
			case WSC_MSG_M2D:
				DBGPRINT(RT_DEBUG_TRACE, "WscEapApProxyAction: Rx WSC_M2D Msg(%d) from UPnP, eventID=0x%x!\n", MsgType, reqID);

				//If it's send by UPnP Action, response ok directly to remote UPnP Control Point!
				if (reqID > 0)
					WscSendUPnPMessage(pAdapter, WSC_OPCODE_UPNP_DATA, WSC_UPNP_DATA_SUB_ACK, 0, 0, reqID, 0);

				//Send M2D to wireless station.
				WscSendMessage(pAdapter, WSC_OPCODE_MSG, Elem->Msg, Elem->MsgLen, pWscControl, FALSE);
				pWscUPnPInfo->M2DACKBalance++;
				if ((pWscUPnPInfo->registrarID == 0) && (pWscUPnPInfo->bUPnPM2DTimerRunning == FALSE))
				{
					// Add M2D timer used to trigger the EAPFail Packet!
					RTMPAddTimer(&pWscUPnPInfo->UPnPM2DTimer, WSC_UPNP_M2D_TIME_OUT);
					pWscUPnPInfo->bUPnPM2DTimerRunning = TRUE;
				}
				break;
				
			case WSC_MSG_WSC_NACK:
			default:
				DBGPRINT(RT_DEBUG_TRACE, "Recv WSC Msg(%d) from UPnP, request EventID=%d! drop it!\n", MsgType, reqID);
				break;
		}
    }
	else	
	{	//WSC msg send from EAP.
		switch (MsgType)
		{
	        case WSC_MSG_M1:
			case WSC_MSG_M3:
			case WSC_MSG_M5:
			case WSC_MSG_M7:
	            DBGPRINT(RT_DEBUG_TRACE, "WscEapApProxyAction: Rx WSC Msg(%d) from EAP\n", MsgType);
/*
	            if (pWscControl->WscState >= WSC_STATE_WAIT_M1)
				{
					if (MsgType == WSC_MSG_M7)
						pWscControl->WscState = WSC_STATE_WAIT_DONE;
				}
*/
				//This msg send to event-based external registrar
				if (MsgType == WSC_MSG_M1)
                {            
					WscSendUPnPMessage(pAdapter, WSC_OPCODE_UPNP_DATA, WSC_UPNP_DATA_SUB_TO_ALL, Elem->Msg, Elem->MsgLen, 0, 0);
                    pWscControl->WscState = WSC_STATE_SENT_M1;
                }
				else
					WscSendUPnPMessage(pAdapter, WSC_OPCODE_UPNP_DATA, WSC_UPNP_DATA_SUB_TO_ONE, Elem->Msg, Elem->MsgLen, 0, pWscUPnPInfo->registrarID);
				
				break;
				
			case WSC_MSG_WSC_ACK:
				DBGPRINT(RT_DEBUG_TRACE, "WscEapApProxyAction: Rx WSC_ACK from EAP\n");

				// The M2D must appeared before the ACK, so we just need sub it when (pWscUPnPInfo->M2DACKBalance > 0)
				if (pWscUPnPInfo->M2DACKBalance > 0)
					pWscUPnPInfo->M2DACKBalance--;
				break;
				
			case WSC_MSG_WSC_DONE:
	            DBGPRINT(RT_DEBUG_TRACE, "WscEapApProxyAction: Rx WSC_DONE from EAP\n");
				
//	            if (pWscControl->WscState == WSC_STATE_WAIT_DONE)
				{
					DBGPRINT(RT_DEBUG_TRACE, "WscEapApProxyAction: send WSC_DONE to UPnP Registrar!\n");
					//Send msg to event-based external registrar
					WscSendUPnPMessage(pAdapter, WSC_OPCODE_UPNP_DATA, WSC_UPNP_DATA_SUB_TO_ONE, Elem->Msg, Elem->MsgLen, 0, pWscUPnPInfo->registrarID);
					//Reset the UPnP timer and status.
					if (pWscUPnPInfo->bUPnPM2DTimerRunning == TRUE)
					{
						RTMPCancelTimer(&pWscUPnPInfo->UPnPM2DTimer);
						pWscUPnPInfo->bUPnPM2DTimerRunning = FALSE;
					}
					pWscUPnPInfo->M2DACKBalance = 0;
					pWscUPnPInfo->registrarID = 0;

					//Send EAPFail to wireless station to finish the whole process.
					WscSendEapFail(pAdapter);
	                
                    RTMPCancelTimer(&pWscControl->EapolTimer);
                    pWscControl->EapolTimerRunning = FALSE;

	                pEntry->bWscCapable = FALSE;
	                pWscControl->EapMsgRunning = FALSE;
	                pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
//	                pWscControl->WscState = WSC_STATE_OFF;
				}
	            break;
				
			default:
				DBGPRINT(RT_DEBUG_TRACE, "Recv WSC Msg(%d) from EAP , it's impossible, drop it!\n", MsgType);
				break;
		}
	}

Fail:
	if (WscData)
		kfree(WscData);
	if (sendToUPnP && (bUPnPStatus == FALSE)){
		DBGPRINT(RT_DEBUG_TRACE, "Need to send UPnP but bUPnPStatus is false!MsgType=%d, regID=0x%x!\n", MsgType, reqID);
		WscUPnPErrHandle(pAdapter, reqID, pWscControl);
	}
		
}

VOID WscEapApRegistrarAction(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	MLME_QUEUE_ELEM	*Elem,
	IN  UCHAR	        MsgType,
	IN  MAC_TABLE_ENTRY *pEntry)
{
    INT     DataLen = 0, rv = 0;
    UCHAR   OpCode = 0;
    UCHAR   *WscData = NULL, apidx = MAIN_MBSSID;
	BOOLEAN bUPnPMsg, bUPnPStatus = FALSE;
    PWSC_CTRL   pWscControl = &pAdapter->PortCfg.MBSSID[apidx].WscControl;
	WSC_UPNP_NODE_INFO *pWscUPnPInfo = &pAdapter->PortCfg.MBSSID[apidx].WscControl.WscUPnPNodeInfo;
	
    DBGPRINT(RT_DEBUG_TRACE, "WscEapApRegistrarAction Enter!\n");

	bUPnPMsg = Elem->MsgType == WSC_EAPOL_UPNP_MSG ? TRUE : FALSE;

	if(bUPnPMsg)
	{
		printk("Receive a UPnP message in RegistrarAction()!\n");
		if(MsgType == WSC_MSG_M1)
		{	/* It's a M1 message, we may need to initialize our state machine. */
			if (gWscActionMode == WSC_AP_REGISTRAR && pWscControl->EntryApIdx == WSC_INIT_ENTRY_APIDX &&
				pWscControl->WscState < WSC_STATE_WAIT_M1 && pWscUPnPInfo->bUPnPInProgress == FALSE)
			{
				pWscUPnPInfo->bUPnPInProgress = TRUE;
				//Set the WscState as "WSC_STATE_WAIT_RESP_ID" because UPnP start from this state.
				pWscControl->WscState = WSC_STATE_WAIT_M1;
				RTMPAddTimer(&pWscUPnPInfo->UPnPMsgTimer, WSC_UPNP_MSG_TIME_OUT);
				pWscUPnPInfo->bUPnPMsgTimerRunning = TRUE;
			}
		}
		OpCode = WSC_OPCODE_UPNP_MASK;
		
	} else {
	    if (pWscControl->EapolTimerRunning)
    	    pWscControl->EapolTimerRunning = FALSE;

	}

	if( (WscData = kmalloc(WSC_MAX_DATA_LEN, GFP_ATOMIC)) == NULL)
	{
		DBGPRINT(RT_DEBUG_TRACE, "WscData Allocate failed!\n");
		goto Fail;
	}
	memset(WscData, 0, WSC_MAX_DATA_LEN);
	
	// Base on state doing the Msg, State change diagram
	switch (MsgType)
	{
		case WSC_MSG_M1:
            DBGPRINT(RT_DEBUG_TRACE, "WscEapApRegistrarAction : Rx M1\n");
            printk("pWscControl->WscState = %d <%d>\n", pWscControl->WscState, WSC_STATE_WAIT_M1);
            
			// Receive M1, if we are at WSC_STATE_WAIT_M1 start, process it immediately
			if (pWscControl->WscState == WSC_STATE_WAIT_M1)
			{
			    OpCode |= WSC_OPCODE_MSG;
                
				// Process M1
			    //pWscControl->WscStatus = STATUS_WSC_EAP_M1_RECEIVED;
				if ((rv=ProcessMessageM1(pAdapter, Elem->Msg, Elem->MsgLen, &pWscControl->RegData)))
                    goto Fail;
                else
                {
                    if (pWscControl->WscMode == 1 && pWscControl->WscPinCode == 0)
                    {
                        DataLen = BuildMessageM2D(pAdapter, pWscControl, WscData);
                        pWscControl->WscState = WSC_STATE_SENT_M2D;
                    }
                    else
                    {
        				DataLen = BuildMessageM2(pAdapter, pWscControl, WscData);
        				//pWscControl->WscStatus = STATUS_WSC_EAP_M2_SENT;
        				// Change the state to next one
        				pWscControl->WscState = WSC_STATE_WAIT_M3;
                    }
                }
			}
			break;
			
		case WSC_MSG_M3:
			// Receive M3
			DBGPRINT(RT_DEBUG_TRACE, "WscEapApRegistrarAction : Rx M3\n");
			if (pWscControl->WscState == WSC_STATE_WAIT_M3)
			{
                pWscControl->WscStatus = STATUS_WSC_EAP_M3_RECEIVED;

    			if((rv = ProcessMessageM3(pAdapter, Elem->Msg, Elem->MsgLen, &pWscControl->RegData)))
    				goto Fail;
    			else
    			{
    			    OpCode |= WSC_OPCODE_MSG;
	    			DataLen = BuildMessageM4(pAdapter, pWscControl, WscData);
    				pWscControl->WscStatus = STATUS_WSC_EAP_M4_SENT;
					// Change the state to next one
					pWscControl->WscState = WSC_STATE_WAIT_M5;
				}
			}
			break;

		case WSC_MSG_M5:
            DBGPRINT(RT_DEBUG_TRACE, "WscEapApRegistrarAction : Rx M5\n");
			if (pWscControl->WscState == WSC_STATE_WAIT_M5)
			{
                pWscControl->WscStatus = STATUS_WSC_EAP_M5_RECEIVED;
				if ((rv=ProcessMessageM5(pAdapter, pWscControl, Elem->Msg, Elem->MsgLen, &pWscControl->RegData)))
				// <<Reject Same PinCode>> ++, edit by johnli
	    			//	goto Fail;
	    			{
	    				if (rv == WSC_ERROR_HASH_FAIL)
	    				{
		    				pWscControl->WscLastPinCode = pWscControl->WscPinCode;
						pWscControl->WscLastStatus = rv;
	    				}
	    				goto Fail;
	    			}
				// <<Reject Same PinCode>> --
                 else
                {
                    OpCode |= WSC_OPCODE_MSG;
        			DataLen = BuildMessageM6(pAdapter, pWscControl, WscData);
        			pWscControl->WscStatus = STATUS_WSC_EAP_M6_SENT;
    				// Change the state to next one
    				pWscControl->WscState = WSC_STATE_WAIT_M7;
                }
			}
			break;
		case WSC_MSG_M7:
			DBGPRINT(RT_DEBUG_TRACE, "WscEapApRegistrarAction : Rx M7\n");
			if (pWscControl->WscState == WSC_STATE_WAIT_M7)
			{
                pWscControl->WscStatus = STATUS_WSC_EAP_M7_RECEIVED;
				if ((rv=ProcessMessageM7(pAdapter, pWscControl, Elem->Msg, Elem->MsgLen, &pWscControl->RegData)))
				// <<Reject Same PinCode>> ++, edit by johnli
	    			//	goto Fail;
	    			{
	    				pWscControl->WscLastPinCode = pWscControl->WscPinCode;
					pWscControl->WscLastStatus = rv;
	    				goto Fail;
	    			}
				// <<Reject Same PinCode>> --
                else
                {
                    OpCode |= WSC_OPCODE_MSG;

        			DataLen = BuildMessageM8(pAdapter, pWscControl, WscData);
        			pWscControl->WscStatus = STATUS_WSC_EAP_M8_SENT;
    				// Change the state to next one
    				pWscControl->WscState = WSC_STATE_WAIT_DONE;
                }
			}
			break;

		case WSC_MSG_WSC_DONE:
			DBGPRINT(RT_DEBUG_TRACE, "WscEapApRegistrarAction : Rx DONE\n");
			if (pWscControl->WscState == WSC_STATE_WAIT_DONE)
			{
				pWscControl->WscStatus = STATUS_WSC_EAP_RAP_RSP_DONE_SENT;
                // Send EAP-Fail
                WscSendEapFail(pAdapter);
				// Change the state to OFF, regComplete
				pWscControl->WscState = WSC_STATE_CONFIGURED;
				pWscControl->WscStatus = STATUS_WSC_CONFIGURED;
                pWscControl->EapMsgRunning = FALSE;
			}
			break;
		default:
			DBGPRINT(RT_DEBUG_TRACE, "WscEapApRegistrarAction : Unsupported Msg Type\n");	   
			return;
	}

	if(OpCode > WSC_OPCODE_UPNP_MASK)
		bUPnPStatus = WscSendUPnPMessage(pAdapter, WSC_OPCODE_UPNP_DATA, WSC_UPNP_DATA_SUB_NORMAL, 
											WscData, DataLen, Elem->TimeStamp.vv.LowPart, Elem->TimeStamp.vv.HighPart);
	else if(OpCode > 0 && OpCode < WSC_OPCODE_UPNP_MASK)
    {   
        if (pWscControl->WscState != WSC_STATE_CONFIGURED)
		    WscSendMessage(pAdapter, OpCode, WscData, DataLen, pWscControl, FALSE);
    }
	else
		bUPnPStatus = TRUE;

	if(bUPnPMsg)
	{
		if(pWscControl->WscState == WSC_STATE_SENT_M2D)
		{	//After M2D, reset the status of State Machine.
			pWscControl->WscState = WSC_STATE_WAIT_UPNP_START;
			pWscUPnPInfo->bUPnPInProgress = FALSE;
		}
	}
Fail:
    DBGPRINT(RT_DEBUG_TRACE, "WscEapApRegistrarAction : rv = %d\n", rv);
    if (rv)
    {        
        switch(rv)
        {
            case WSC_ERROR_HASH_FAIL:
                pWscControl->WscStatus = STATUS_WSC_ERROR_HASH_FAIL;
				pWscControl->RegData.EnrolleeInfo.ConfigError = WSC_ERROR_HASH_FAIL;
                break;
            case WSC_ERROR_HMAC_FAIL:
                pWscControl->WscStatus = STATUS_WSC_ERROR_HMAC_FAIL;
				pWscControl->RegData.EnrolleeInfo.ConfigError = WSC_ERROR_HMAC_FAIL;
                break;
            default:
                pWscControl->WscStatus = STATUS_WSC_FAIL;
				pWscControl->RegData.EnrolleeInfo.ConfigError = WSC_ERROR_DECRYPT_CRC_FAIL;
                break;
        }
        
        if (bUPnPMsg)
        {
			if (pWscUPnPInfo->bUPnPMsgTimerRunning == TRUE)
			{
            	RTMPCancelTimer(&pWscUPnPInfo->UPnPMsgTimer);
	            pWscUPnPInfo->bUPnPMsgTimerRunning = FALSE;
			}
			pWscUPnPInfo->bUPnPInProgress = FALSE;
        }
		else
        {
            DataLen = BuildMessageNACK(pAdapter, pWscControl,WscData);
            WscSendMessage(pAdapter, WSC_OPCODE_NACK, WscData, DataLen, pWscControl, FALSE);
            pEntry->bWscCapable = FALSE;
            RTMPCancelTimer(&pWscControl->EapolTimer);
            pWscControl->EapolTimerRunning = FALSE;
        }
        //pWscControl->bWscTrigger = FALSE;
        pWscControl->WscState = WSC_STATE_OFF;
        pWscControl->WscStatus = STATUS_WSC_IDLE;
        pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
        pWscControl->WscPinCode = 0;
        pWscControl->WscMode = 1;
        bUPnPStatus = FALSE;
    }

//Done:
	if(WscData)
		kfree(WscData);
	
	if(bUPnPMsg && (bUPnPStatus == FALSE))
		WscUPnPErrHandle(pAdapter, Elem->TimeStamp.vv.LowPart, pWscControl);

    if (pWscControl->WscState == WSC_STATE_CONFIGURED)
    {
        pWscControl->bWscTrigger = FALSE;
        if (pWscControl->Wsc2MinsTimerRunning)
    	{
    		pWscControl->Wsc2MinsTimerRunning = FALSE;
    		RTMPCancelTimer(&pWscControl->Wsc2MinsTimer);
    	}
		if (bUPnPMsg)
		{
			if (pWscUPnPInfo->bUPnPMsgTimerRunning == TRUE)
			{	RTMPCancelTimer(&pWscUPnPInfo->UPnPMsgTimer);
            	pWscUPnPInfo->bUPnPMsgTimerRunning = FALSE;
			}
			pWscUPnPInfo->bUPnPInProgress = FALSE;
			pWscUPnPInfo->registrarID = 0;
		}
		else
		{
        	WscBuildBeaconIE(pAdapter, WSC_SCSTATE_CONFIGURED, FALSE, 0, 0);
			WscBuildProbeRespIE(pAdapter, WSC_MSGTYPE_AP_WLAN_MGR, WSC_SCSTATE_CONFIGURED, FALSE, 0, 0);
			MakeAllBssBeacon(pAdapter);
			UpdateAllBeaconFrame(pAdapter);
		}
		
        if (pWscControl->WscConfStatus == WSC_SCSTATE_UNCONFIGURED)
        {
            pAdapter->WriteWscCfgToDatFile = TRUE;
            WscWriteConfToPortCfg(pAdapter, pEntry, FALSE);
            ApStop(pAdapter, TRUE);
        	ApStartUp(pAdapter, TRUE);

            up(&(pAdapter->write_dat_file_semaphore));
        }
    	pWscControl->WscStatus = STATUS_WSC_CONFIGURED;
        pWscControl->WscPinCode = 0;
        pWscControl->WscMode = 1;
        pWscControl->WscConfStatus = WSC_SCSTATE_CONFIGURED;
        RTMPCancelTimer(&pWscControl->EapolTimer);
	    pWscControl->EapolTimerRunning = FALSE;
        return;
    }	
}


VOID WscEnqueueEapolStart(
    IN  unsigned long data) 
{
	MAC_TABLE_ENTRY     *pEntry = (PMAC_TABLE_ENTRY) data;

	if ((pEntry) && (pEntry->EnqueueEapolStartTimerForWscRunning == TRUE))
	{
		RTMP_ADAPTER		*pAd = (PRTMP_ADAPTER)pEntry->pAd;

		pEntry->EnqueueEapolStartTimerForWscRunning = FALSE;	
		DBGPRINT(RT_DEBUG_TRACE, "WscEAPOLTimeOutAction: Enqueue EAPOL-Start for %02x:%02x:%02x:%02x:%02x:%02x\n",
								pEntry->Addr[0], pEntry->Addr[1], pEntry->Addr[2],
    							pEntry->Addr[3], pEntry->Addr[4], pEntry->Addr[5]);

        MlmeEnqueue(pAd, WSC_AP_STATE_MACHINE, WSC_EAPOL_START_MSG, 6, &pEntry->Addr);
	}				
}

VOID WscTimeOutProcess(
    IN  PRTMP_ADAPTER       pAd,
    IN  PMAC_TABLE_ENTRY    pEntry,
    IN  INT                 nWscState,
// For AP Client support WPS Modification
    IN  PWSC_CTRL       pWscControl,
    BOOLEAN         bFromApCli)
// --
{
    INT     WscMode;

    if (nWscState == WSC_STATE_WAIT_ACK)
        pWscControl->WscState = WSC_STATE_CONFIGURED;
    else if (nWscState == WSC_STATE_WAIT_RESP_ID)
        pWscControl->WscState = WSC_STATE_OFF;
    else if (nWscState == WSC_STATE_RX_M2D)
    {
        pWscControl->WscState = WSC_STATE_OFF;
        WscSendEapFail(pAd);
// For AP Client support WPS Modification
 //       MlmeEnqueue(pAd, WSC_AP_STATE_MACHINE, WSC_EAPOL_START_MSG, 6, &pEntry->Addr);
        MlmeEnqueue(pAd, WSC_AP_STATE_MACHINE, WSC_EAPOL_START_MSG, 6, &pWscControl->EntryAddr);
// --
        pWscControl->EapolTimerRunning = FALSE;
        pWscControl->WscRetryCount = 0;
        return;
    }
// For AP Client support WPS Modification
    else if (nWscState == WSC_STATE_WAIT_EAPFAIL)
    {
        pWscControl->WscState = WSC_STATE_OFF;
		pWscControl->WscStatus = STATUS_WSC_CONFIGURED;
        pWscControl->WscConfMode = WSC_DISABLE;
    }
// --
    else
    {
        if (gWscActionMode == WSC_AP_PROXY)
        {
    		pWscControl->WscState = WSC_STATE_OFF;
            //WscSendEapFail(pAd);
        }
    	else
    		pWscControl->WscState = WSC_STATE_FAIL;
    }  
//    WscSendEapFail(pAd);
    pWscControl->WscRetryCount = 0;
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
    if (!bFromApCli)
#endif // APCLI_SUPPORT //
// --
    pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
    pWscControl->EapolTimerRunning = FALSE;
    pWscControl->WscPinCode = 0;
/* remove by johnli
    pWscControl->WscMode = 1;
    pEntry->bWscCapable = FALSE;
*/
    if (pWscControl->WscMode == 1)
		WscMode = DEV_PASS_ID_PIN;
	else
		WscMode = DEV_PASS_ID_PBC;
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
    if (!bFromApCli)
#endif // APCLI_SUPPORT //
// --
    {
// For AP Client support WPS Modification
        if (pEntry != NULL)
// --
        	pEntry->bWscCapable = FALSE;
        WscSendEapFail(pAd);
        WscBuildBeaconIE(pAd, pWscControl->WscConfStatus, FALSE, WscMode, WSC_CONFIG_METHODS);
        WscBuildProbeRespIE(pAd, WSC_MSGTYPE_AP_WLAN_MGR, pWscControl->WscConfStatus, FALSE, WscMode, WSC_CONFIG_METHODS);
    }
}

VOID WscEAPOLTimeOutAction(
    IN  unsigned long data)
{
    PRTMP_ADAPTER       pAd;
    PMAC_TABLE_ENTRY    pEntry = NULL;
    INT                 DataLen = 0;
    PUCHAR              WscData = NULL;
//    UCHAR				apidx = MAIN_MBSSID;
// For AP Client support WPS Modification
    PWSC_CTRL           pWscControl = NULL;
    BOOLEAN         bFromApCli = FALSE;
// --

    DBGPRINT(RT_DEBUG_TRACE, "-----> WscEAPOLTimeOutAction\n");
    
    if (data == 0)
    {
        DBGPRINT(RT_DEBUG_TRACE, "data is NULL!!\n");
        DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPOLTimeOutAction\n");
        return;
    }
    else
    {
// For AP Client support WPS Modification
/*
        pAd = (PRTMP_ADAPTER)data;
        printk("###$$) WSC EntryAddr: %02X%02X%02X%02X%02X%02X\n", 
                       pAd->PortCfg.MBSSID[apidx].WscControl.EntryAddr[0],
                       pAd->PortCfg.MBSSID[apidx].WscControl.EntryAddr[1],
                       pAd->PortCfg.MBSSID[apidx].WscControl.EntryAddr[2],
                       pAd->PortCfg.MBSSID[apidx].WscControl.EntryAddr[3],
                       pAd->PortCfg.MBSSID[apidx].WscControl.EntryAddr[4],
                       pAd->PortCfg.MBSSID[apidx].WscControl.EntryAddr[5]);
*/
		pWscControl = (PWSC_CTRL)data;
		pAd = pWscControl->pAd;

#ifdef APCLI_SUPPORT
		if (pWscControl->EntryApIdx == MIN_NET_DEVICE_FOR_APCLI)
			bFromApCli = TRUE;
		else
#endif // APCLI_SUPPORT //
// --
		{
			pEntry = MacTableLookup(pAd,pWscControl->EntryAddr);

			if (pEntry == NULL)
			{
				pWscControl->EapolTimerRunning = FALSE;
				pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
				DBGPRINT(RT_DEBUG_TRACE, "sta is left.\n");
				DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPOLTimeOutAction\n");
				return;
			}
		}
    }

    if (!pWscControl->EapolTimerRunning)
    {
        pWscControl->WscRetryCount = 0;
        goto out;
    }
    
    if (pWscControl->EapolTimerPending)
    {
        mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
        DBGPRINT(RT_DEBUG_TRACE, "EapolTimer Pending......\n");
        DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPOLTimeOutAction\n");
        return;
    }

    if ((WscData = kmalloc(WSC_MAX_DATA_LEN, GFP_ATOMIC))!= NULL)
        memset(WscData, 0, WSC_MAX_DATA_LEN);

// For AP Client support WPS Modification
//    if (pWscControl->WscState <= WSC_STATE_CONFIGURED )
    if ((!bFromApCli) && (pWscControl->WscState <= WSC_STATE_CONFIGURED))
// --
    {
        // A timer in the AP should cause to be disconnected after 5 seconds if a 
        // valid EAP-Rsp/Identity indicating WPS is not received.
        // << from WPS EAPoL and RSN handling.doc >>
        WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_RESP_ID, pWscControl, bFromApCli);
        WscSendEapFail(pAd);

//      If do disassocation here, it will affect connection of non-WPS clients.        
//      DisAssocAction(pAd, pEntry, SUBTYPE_DISASSOC, REASON_RESERVED);
        goto out;
    }
    
    switch(pWscControl->WscState)
    {
/*    
	   case WSC_STATE_WAIT_RESP_ID:
            // A timer in the AP should cause to be disconnected after 5 seconds if a 
            // valid EAP-Rsp/Identity indicating WPS is not received.
            // << from WPS EAPoL and RSN handling.doc >>
            WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_RESP_ID);
            WscSendEapFail(pAd);
            DisAssocAction(pAd, pEntry, SUBTYPE_DISASSOC, REASON_RESERVED);
			break;
*/
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	case WSC_STATE_WAIT_REQ_ID:
			WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_REQ_ID, pWscControl, bFromApCli);
		break;
	case WSC_STATE_WAIT_WSC_START:
		if (pWscControl->WscRetryCount >= 2)
			WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_WSC_START, pWscControl, bFromApCli);
		else
		{
			WscSendEapRspId(pAd, pWscControl); // Receive EAP_Req/Identity from WPS AP
			pWscControl->WscRetryCount++;
		}
		break;
#endif // APCLI_SUPPORT //
	// --
	case WSC_STATE_WAIT_M1:
		if (pWscControl->WscRetryCount >= 2)
			WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M1, pWscControl, bFromApCli);
		else
		{
			WscSendMessage(pAd, WSC_OPCODE_START, NULL, 0, pWscControl, bFromApCli);
			pWscControl->WscRetryCount++;
			mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
		}
		break;
// For AP Client support WPS Modification

	case WSC_STATE_SENT_M1:
		if (pWscControl->WscRetryCount >= 2)
			WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M2, pWscControl, bFromApCli);
		else
		{
			if (gWscActionMode == WSC_AP_Enrollee)
				WscSendMessage(pWscControl->pAd, WSC_OPCODE_MSG, pWscControl->RegData.LastTx.Data, pWscControl->RegData.LastTx.Length, pWscControl, bFromApCli);
			pWscControl->WscRetryCount++;
			mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
		}
		break;
// --
        case WSC_STATE_WAIT_M2:
		    if (pWscControl->WscRetryCount >= 2)
                WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M2, pWscControl, bFromApCli);
			else
			{
			    if (gWscActionMode == WSC_AP_Enrollee)
                {         
    			    if (WscData)
                    {
        			    DataLen = BuildMessageM1(pAd, pWscControl,WscData);
                        WscSendMessage(pAd, WSC_OPCODE_MSG, WscData, DataLen, pWscControl, bFromApCli);
                    }
                    else
                    {
                        DBGPRINT(RT_DEBUG_TRACE, "WscData is NULL, cannot send M1 out!\n");
                        WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M2, pWscControl, bFromApCli);
                        break;
                    }
                }
				pWscControl->WscRetryCount++;
				mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
			}
            break;
        case WSC_STATE_RX_M2D:
            if (pWscControl->WscRetryCount >= 2)
			    WscTimeOutProcess(pAd, pEntry, WSC_STATE_RX_M2D, pWscControl, bFromApCli);
			else
			{
				pWscControl->WscRetryCount++;
				mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
			}
             break;
        case WSC_STATE_WAIT_M3:
            if (pWscControl->WscRetryCount >= 2)
                WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M3, pWscControl, bFromApCli);
			else
			{
			    if (gWscActionMode == WSC_AP_REGISTRAR)
                {         
    			    if (WscData)
                    {
        			    DataLen = BuildMessageM2(pAd, pWscControl, WscData);
                        WscSendMessage(pAd, WSC_OPCODE_MSG, WscData, DataLen, pWscControl, bFromApCli);
                    }
                    else
                    {
                        DBGPRINT(RT_DEBUG_TRACE, "WscData is NULL, cannot send M2 out!\n");
                        WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M3, pWscControl, bFromApCli);
                        break;
                    }
                }
				pWscControl->WscRetryCount++;
				mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
			}
            break;
        case WSC_STATE_WAIT_M4:
            if (pWscControl->WscRetryCount >= 2)
			    WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M4, pWscControl, bFromApCli);
			else
			{
			    if (gWscActionMode == WSC_AP_Enrollee)
                {         
    			    if (WscData)
                    {
        			    DataLen = BuildMessageM3(pAd, pWscControl, WscData);
                        WscSendMessage(pAd, WSC_OPCODE_MSG, WscData, DataLen, pWscControl, bFromApCli);
                    }
                    else
                    {
                        DBGPRINT(RT_DEBUG_TRACE, "WscData is NULL, cannot send M3 out!\n");
                        WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M5, pWscControl, bFromApCli);
                        break;
                    }
                }
				pWscControl->WscRetryCount++;
				mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
			}
            break;
        case WSC_STATE_WAIT_M5:
            if (pWscControl->WscRetryCount >= 2)
			    WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M5, pWscControl, bFromApCli);
			else
			{
			    if (gWscActionMode == WSC_AP_REGISTRAR)
                {         
    			    if (WscData)
                    {
        			    DataLen = BuildMessageM4(pAd, pWscControl, WscData);
                        WscSendMessage(pAd, WSC_OPCODE_MSG, WscData, DataLen, pWscControl, bFromApCli);
                    }
                    else
                    {
                        DBGPRINT(RT_DEBUG_TRACE, "WscData is NULL, cannot send M4 out!\n");
                        WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M5, pWscControl, bFromApCli);
                        break;
                    }
                }
				pWscControl->WscRetryCount++;
				mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
			}
            break;
        case WSC_STATE_WAIT_M6:
            if (pWscControl->WscRetryCount >= 2)
                WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M6, pWscControl, bFromApCli);
			else
			{
			    if (gWscActionMode == WSC_AP_Enrollee)
                {         
    			    if (WscData)
                    {
        			    DataLen = BuildMessageM5(pAd, pWscControl, WscData);
                        WscSendMessage(pAd, WSC_OPCODE_MSG, WscData, DataLen, pWscControl, bFromApCli);
                    }
                    else
                    {
                        DBGPRINT(RT_DEBUG_TRACE, "WscData is NULL, cannot send M5 out!\n");
                        WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M6, pWscControl, bFromApCli);
                        break;
                    }
                }
				pWscControl->WscRetryCount++;
				mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
			}
            break;
        case WSC_STATE_WAIT_M7:
            if (pWscControl->WscRetryCount >= 2)
			    WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M7, pWscControl, bFromApCli);
			else
			{
			    if (gWscActionMode == WSC_AP_REGISTRAR)
                {         
    			    if (WscData)
                    {
        			    DataLen = BuildMessageM6(pAd, pWscControl, WscData);
                        WscSendMessage(pAd, WSC_OPCODE_MSG, WscData, DataLen, pWscControl, bFromApCli);
                    }
                    else
                    {
                        DBGPRINT(RT_DEBUG_TRACE, "WscData is NULL, cannot send M6 out!\n");
                        WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M7, pWscControl, bFromApCli);
                        break;
                    }
                }
				pWscControl->WscRetryCount++;
				mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
			}
            break;
        case WSC_STATE_WAIT_M8:
            if (pWscControl->WscRetryCount >= 2)
			    WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M8, pWscControl, bFromApCli);
			else
			{
			    if (gWscActionMode == WSC_AP_Enrollee)
                {
                    if (WscData)
                    {
        			    DataLen = BuildMessageM7(pAd, pWscControl, WscData);
                        WscSendMessage(pAd, WSC_OPCODE_MSG, WscData, DataLen, pWscControl, bFromApCli);
                    }
                    else
                    {
                        DBGPRINT(RT_DEBUG_TRACE, "WscData is NULL, cannot send M7 out!\n");
                        WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_M8, pWscControl, bFromApCli);
                        break;
                    }
                }
				pWscControl->WscRetryCount++;
				mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
			}
			break;
		case WSC_STATE_WAIT_DONE:
            if (pWscControl->WscRetryCount >= 2)
                WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_DONE, pWscControl, bFromApCli);
			else
			{
				if (gWscActionMode == WSC_AP_REGISTRAR)
                {
                    if (WscData)
                    {
        			    DataLen = BuildMessageM8(pAd, pWscControl, WscData);
                        WscSendMessage(pAd, WSC_OPCODE_MSG, WscData, DataLen, pWscControl, bFromApCli);
                    }
                    else
                    {
                        DBGPRINT(RT_DEBUG_TRACE, "WscData is NULL, cannot send M8 out!\n");
                        WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_DONE, pWscControl, bFromApCli);
                        break;
                    }
                }
				pWscControl->WscRetryCount++;
				mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_TIME_OUT);
			}
			break;
        case WSC_STATE_WAIT_ACK:     
            if (pWscControl->WscRetryCount >= 2)
                WscTimeOutProcess(pAd, pEntry, WSC_STATE_WAIT_ACK, pWscControl, bFromApCli);
            else
            {
// For AP Client support WPS Modification
//                if (gWscActionMode == WSC_AP_Enrollee)
                if ((!bFromApCli) && gWscActionMode == WSC_AP_Enrollee)
// --
                {
    			    DataLen = BuildMessageDONE(pAd, pWscControl, WscData);
                    WscSendMessage(pAd, WSC_OPCODE_MSG, WscData, DataLen, pWscControl, bFromApCli);
                }
                mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_MSG_ACK_TIME_OUT);
                pWscControl->WscRetryCount++;
			}
			break;
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
        case WSC_STATE_WAIT_EAPFAIL:
            // Wait 2 seconds
            if (pWscControl->WscRetryCount >= 1)
                WscTimeOutProcess(pWscControl->pAd, pEntry, WSC_STATE_WAIT_EAPFAIL, pWscControl, bFromApCli);
            else
            {
                mod_timer(&pWscControl->EapolTimer, jiffies+WSC_EAP_EAP_FAIL_TIME_OUT);
                pWscControl->WscRetryCount++;
            }
            break;
#endif // APCLI_SUPPORT //
// --
        default:
            break;
    }

out:  // move by johnli
    if (WscData)
        kfree(WscData);

//out:    
    DBGPRINT(RT_DEBUG_TRACE, "<----- WscEAPOLTimeOutAction\n");
}

VOID Wsc2MinsTimeOutAction(
    IN  unsigned long data)
{
// For AP Client support WPS Modification
/*
    RTMP_ADAPTER    *pAd = (PRTMP_ADAPTER)data;
    UCHAR			apidx = MAIN_MBSSID;
    INT				IsAPConfigured = pAd->PortCfg.MBSSID[apidx].WscControl.WscConfStatus;
*/
    PRTMP_ADAPTER       pAd;
    INT				IsAPConfigured;
    PWSC_CTRL           pWscControl = NULL;
 // --

    DBGPRINT(RT_DEBUG_TRACE, "-----> Wsc2MinsTimeOutAction\n");
// For AP Client support WPS Modification
    if (data == 0)
    {
        DBGPRINT(RT_DEBUG_TRACE, "data is NULL!!\n");
        DBGPRINT(RT_DEBUG_TRACE, "<----- Wsc2MinsTimeOutAction\n");
        return;
    }
    else
    {
        pWscControl = (PWSC_CTRL)data;
        pAd = pWscControl->pAd;
    }
// --
    DBGPRINT(RT_DEBUG_TRACE, "Wsc2MinsTimerRunning is %s\n", 
                             pWscControl->Wsc2MinsTimerRunning ? "TRUE, reset WscState to WSC_STATE_OFF":"FALSE");

    if (pWscControl->Wsc2MinsTimerRunning)
    {
        WscSendEapFail(pAd);
        pWscControl->bWscTrigger = FALSE;
        pWscControl->EapolTimerRunning = FALSE;
        RTMPCancelTimer(&pWscControl->EapolTimer);
        
    	if ((pWscControl->WscConfMode & 0x2) == 0)
    	{   // Proxy mechanism is disabled            
    	    pWscControl->WscRetryCount = 0;
            pWscControl->WscState = WSC_STATE_OFF;
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
            if (pWscControl->EntryApIdx != MIN_NET_DEVICE_FOR_APCLI)
#endif // APCLI_SUPPORT //
// --
            pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
        }
		pWscControl->Wsc2MinsTimerRunning = FALSE;

        pWscControl->WscSelReg = 0;
        pWscControl->WscStatus = STATUS_WSC_IDLE;
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
		if (pWscControl->EntryApIdx != MIN_NET_DEVICE_FOR_APCLI)
#endif // APCLI_SUPPORT //
// --
		{
			IsAPConfigured = pWscControl->WscConfStatus;
			WscBuildBeaconIE(pAd, IsAPConfigured, FALSE, 0, 0);
			WscBuildProbeRespIE(pAd, WSC_MSGTYPE_AP_WLAN_MGR, IsAPConfigured, FALSE, 0, 0);
			MakeAllBssBeacon(pAd);
			UpdateAllBeaconFrame(pAd);
		}
    }
    DBGPRINT(RT_DEBUG_TRACE, "<----- Wsc2MinsTimeOutAction\n");
}

/*
	========================================================================
	
	Routine Description:
		Classify EAP message type for enrolee

	Arguments:
		pAd         - NIC Adapter pointer
		Elem		- The EAP packet
		
	Return Value:
		Received EAP message type

	IRQL = DISPATCH_LEVEL
	
	Note:
		
	========================================================================
*/
UCHAR	WscRxMsgType(
	IN	PRTMP_ADAPTER		pAdapter,
	IN	PMLME_QUEUE_ELEM	pElem) 
{
	USHORT				Length;
	PUCHAR				pData;
	USHORT				WscType, WscLen;
    UCHAR               regIdentity[] = {"WFA-SimpleConfig-Registrar"};
    UCHAR               enrIdentity[] = {"WFA-SimpleConfig-Enrollee"};
// For AP Client support WPS Modification
    UCHAR	            id_data[] = {"hello"};
    UCHAR	            fail_data[] = {"EAP_FAIL"};
    UCHAR	            wsc_start[] = {"WSC_START"};
// --
    
    if (pElem->Msg[0] == 'W' && pElem->Msg[1] == 'F' && pElem->Msg[2] == 'A')
    {
        // Eap-Rsp(Identity)
		if (memcmp(regIdentity, pElem->Msg, strlen(regIdentity)) == 0)
			return  WSC_MSG_EAP_REG_RSP_ID;
        else if (memcmp(enrIdentity, pElem->Msg, strlen(enrIdentity)) == 0)
			return  WSC_MSG_EAP_ENR_RSP_ID;
    }
// For AP Client support WPS Modification
    else if (NdisEqualMemory(id_data, pElem->Msg, pElem->MsgLen))
    {
        // Eap-Req/Identity(hello)
		return  WSC_MSG_EAP_REQ_ID;
    }
    else if (NdisEqualMemory(fail_data, pElem->Msg, pElem->MsgLen))
    {
        // Eap-Fail
		return  WSC_MSG_EAP_FAIL;
    }
    else if (NdisEqualMemory(wsc_start, pElem->Msg, pElem->MsgLen))
    {
        // Eap-Req(Wsc_Start)
        return WSC_MSG_EAP_REQ_START;
    }
// --
    else
    {   // Eap-Esp(Messages)
        pData = pElem->Msg;
        Length = pElem->MsgLen;

        // the first TLV item in EAP Messages must be WSC_IE_VERSION
        NdisMoveMemory(&WscType, pData, 2);
        if (ntohs(WscType) != WSC_ID_VERSION)
            goto out;

        // Not Wsc Start, We have to look for WSC_IE_MSG_TYPE to classify M2 ~ M8, the remain size must large than 4
		while (Length > 4)
		{
			// arm-cpu has packet alignment issue, it's better to use memcpy to retrieve data
			NdisMoveMemory(&WscType, pData, 2);
			NdisMoveMemory(&WscLen,  pData + 2, 2);
			WscLen = ntohs(WscLen);
			if (ntohs(WscType) == WSC_ID_MSG_TYPE)
			{
				return(*(pData + 4));	// Found the message type
			}
			else
			{
				pData  += (WscLen + 4);
				Length -= (WscLen + 4);
			}
		}
    }

out:
	return  WSC_MSG_UNKNOWN;
}

/*
	========================================================================
	
	Routine Description:
		Classify WSC message type

	Arguments:
		EAPType		Value of EAP message type
		MsgType		Internal Message definition for MLME state machine
		
	Return Value:
		TRUE		Found appropriate message type
		FALSE		No appropriate message type

	IRQL = DISPATCH_LEVEL
	
	Note:
		All these constants are defined in wpa.h
		For supplicant, there is only EAPOL Key message avaliable
		
	========================================================================
*/
BOOLEAN	WscMsgTypeSubst(
	IN	UCHAR	EAPType,
	IN	UCHAR	EAPCode,
	OUT	ULONG	*MsgType)	
{
	switch (EAPType)
	{
		case EAPPacket:
			*MsgType = WSC_EAPOL_PACKET_MSG;
			break;
        case EAPOLStart:
            *MsgType = WSC_EAPOL_START_MSG;
			break;
		default:
			DBGPRINT(RT_DEBUG_TRACE, "WscMsgTypeSubst : unsupported EAP Type(%d); \n", EAPType);
			return FALSE;		
	}	

	return TRUE;
}

/*
	========================================================================
	
	Routine Description:
		Init WSC MAC header

	Arguments:
		pAdapter	Pointer	to our adapter
		
	Return Value:
		None
		
	Note:
		
	========================================================================
*/
VOID	WscMacHeaderInit(
	IN		PRTMP_ADAPTER	pAdapter, 
	IN OUT	PHEADER_802_11	Hdr, 
	IN		PUCHAR			pAddr1,
// For AP Client support WPS Modification
//	IN      PUCHAR          pBSSID)	
	IN  PUCHAR          pBSSID,
	IN      BOOLEAN         bFromApCli)
// --
{
	NdisZeroMemory(Hdr,	sizeof(HEADER_802_11));
	Hdr->FC.Type = BTYPE_DATA;
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (bFromApCli)
		Hdr->FC.ToDs = 1;
	else
#endif // APCLI_SUPPORT //
// --
 	{
		Hdr->FC.ToDs = 0;
		Hdr->FC.FrDs = 1;
	}	
	 //	Addr1: DA, Addr2: BSSID, Addr3:	SA
	
	COPY_MAC_ADDR(&Hdr->Addr1, pAddr1);
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (bFromApCli)
	{
		COPY_MAC_ADDR(&Hdr->Addr2, &pAdapter->ApCliTab.ApCliEntry[0].CurrentAddress);
	}
	else
#endif // APCLI_SUPPORT //
// --
	COPY_MAC_ADDR(&Hdr->Addr2, &pAdapter->CurrentAddress);
	COPY_MAC_ADDR(&Hdr->Addr3, pBSSID);
	Hdr->Sequence =	pAdapter->Sequence;		
}

VOID	WscInitRegistrarPair(
// For AP Client support WPS Modification
//	IN	PRTMP_ADAPTER		pAdapter)
	IN	PRTMP_ADAPTER		pAdapter,
	IN	BOOLEAN         bFromApCli,
	IN	PWSC_CTRL           pWscControl)
// --
{
	INT		idx; //, DH_Len;
	UCHAR	apidx = MAIN_MBSSID;
// For AP Client support WPS Modification
	USHORT          authType = 0, encyType = 0;
	UCHAR           WepKeyId = 0;
//    USHORT  authType = WscGetAuthType(pAdapter->PortCfg.MBSSID[pAdapter->IoctlIF].AuthMode);
//    USHORT  encyType = WscGetEncryType(pAdapter->PortCfg.MBSSID[pAdapter->IoctlIF].WepStatus);
// --
//	UCHAR	uuidStr[17];  // remove by johnli
	
	DBGPRINT(RT_DEBUG_TRACE, "-----> WscInitRegistrarPair\n");
    gWscActionMode = 0;
	
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
        if (bFromApCli)
	{
		authType = WscGetAuthType(pAdapter->ApCliTab.ApCliEntry[apidx].AuthMode);
		encyType = WscGetEncryType(pAdapter->ApCliTab.ApCliEntry[apidx].PairCipher);
		WepKeyId = pAdapter->ApCliTab.ApCliEntry[apidx].DefaultKeyId;
	}
	else
#endif // APCLI_SUPPORT //
	{
		authType = WscGetAuthType(pAdapter->PortCfg.MBSSID[apidx].AuthMode);
		encyType = WscGetEncryType(pAdapter->PortCfg.MBSSID[apidx].WepStatus);
		WepKeyId = pAdapter->PortCfg.MBSSID[apidx].DefaultKeyId;
	}
// --

    // NewKey, NewKeyIndex for M8
// For AP Client support WPS Modification
//	if(WSC_SCSTATE_UNCONFIGURED == pAdapter->PortCfg.MBSSID[apidx].WscControl.WscConfStatus)
	if((!bFromApCli) && (WSC_SCSTATE_UNCONFIGURED == pWscControl->WscConfStatus))
// --
	{
	    UCHAR   tempKey[32] = {0};
		authType = WSC_AUTHTYPE_WPAPSK;
		encyType = WSC_ENCRTYPE_TKIP;
        memset(pWscControl->RegData.RegistrarInfo.NewKey, 0, 64);
		for (idx = 0; idx < 32; idx++)
		{
		    tempKey[idx] = RandomByte(pAdapter);
            sprintf(pWscControl->RegData.RegistrarInfo.NewKey, 
                    "%s%02x", pWscControl->RegData.RegistrarInfo.NewKey,
                              tempKey[idx]);
		}
        pWscControl->RegData.RegistrarInfo.NewKeyLen = 64;
        pWscControl->RegData.RegistrarInfo.NewKeyIndex = 1;
	}
    else
    {
//        UCHAR   WepKeyId = pAdapter->PortCfg.MBSSID[apidx].DefaultKeyId;
        pWscControl->RegData.RegistrarInfo.NewKeyIndex = 1;
        pWscControl->RegData.RegistrarInfo.NewKeyLen = 0;
        memset(pWscControl->RegData.RegistrarInfo.NewKey, 0, 64);
        switch (encyType)
        {
            case WSC_ENCRTYPE_NONE:
                break;
            case WSC_ENCRTYPE_WEP:
                pWscControl->RegData.RegistrarInfo.NewKeyIndex = (WepKeyId + 1);
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
                if ((bFromApCli) && (pAdapter->ApCliTab.ApCliEntry[apidx].SharedKey[WepKeyId].KeyLen))
                {
                    if (pAdapter->ApCliTab.ApCliEntry[apidx].SharedKey[WepKeyId].WepKeyType == WEP_ASCII_TYPE)
                    {
                        memcpy(pWscControl->RegData.RegistrarInfo.NewKey,
                               pAdapter->ApCliTab.ApCliEntry[apidx].SharedKey[WepKeyId].Key,
                               pAdapter->ApCliTab.ApCliEntry[apidx].SharedKey[WepKeyId].KeyLen);
                        pWscControl->RegData.RegistrarInfo.NewKeyLen = 
                            pAdapter->ApCliTab.ApCliEntry[apidx].SharedKey[WepKeyId].KeyLen;
                    }
                    else // Hex WEP Key
                    {
                        int i;
                        for (i=0; i<pAdapter->ApCliTab.ApCliEntry[apidx].SharedKey[WepKeyId].KeyLen; i++)
                            sprintf(pWscControl->RegData.RegistrarInfo.NewKey,
                                    "%s%02x", pWscControl->RegData.RegistrarInfo.NewKey,
                                        pAdapter->ApCliTab.ApCliEntry[apidx].SharedKey[WepKeyId].Key[i]);
                        pWscControl->RegData.RegistrarInfo.NewKeyLen = 
                            pAdapter->ApCliTab.ApCliEntry[apidx].SharedKey[WepKeyId].KeyLen*2;
                    }
                }
                else
#endif // APCLI_SUPPORT //
// --
                if ((!bFromApCli) && (pAdapter->PortCfg.MBSSID[apidx].SharedKey[WepKeyId].KeyLen))
                {
                    if (pAdapter->PortCfg.MBSSID[apidx].SharedKey[WepKeyId].WepKeyType == WEP_ASCII_TYPE)
                    {
                        memcpy(pWscControl->RegData.RegistrarInfo.NewKey,
                               pAdapter->PortCfg.MBSSID[apidx].SharedKey[WepKeyId].Key,
                               pAdapter->PortCfg.MBSSID[apidx].SharedKey[WepKeyId].KeyLen);
                        pWscControl->RegData.RegistrarInfo.NewKeyLen = 
                            pAdapter->PortCfg.MBSSID[apidx].SharedKey[WepKeyId].KeyLen;
                    }
                    else // Hex WEP Key
                    {
                        int i;
                        for (i=0; i<pAdapter->PortCfg.MBSSID[apidx].SharedKey[WepKeyId].KeyLen; i++)
                            sprintf(pWscControl->RegData.RegistrarInfo.NewKey,
                                    "%s%02x", pWscControl->RegData.RegistrarInfo.NewKey,
                                        pAdapter->PortCfg.MBSSID[apidx].SharedKey[WepKeyId].Key[i]);
                        pWscControl->RegData.RegistrarInfo.NewKeyLen = 
                            pAdapter->PortCfg.MBSSID[apidx].SharedKey[WepKeyId].KeyLen*2;
                    }
                }                
                break;
    		case WSC_ENCRTYPE_TKIP:
            case WSC_ENCRTYPE_AES:
                pWscControl->RegData.RegistrarInfo.NewKeyLen = pWscControl->WpaPskLen;
                memcpy(pWscControl->RegData.RegistrarInfo.NewKey, 
                       pWscControl->WpaPsk, 
                       pWscControl->WpaPskLen);
                break;
        }
    }

	// 1. Version
	pWscControl->RegData.EnrolleeInfo.Version = WSC_VERSION;
	pWscControl->RegData.RegistrarInfo.Version = WSC_VERSION;

	// 2. UUID Enrollee, last 6 bytes use MAC
	// <<WCN vista logo>> ++, edit by johnli
/*
	memset(&uuidStr[0], 0, 17);
	NdisMoveMemory(&uuidStr[0], &Wsc_Uuid_E[0], 4);
	snprintf(&uuidStr[4], 13, "%02x%02x%02x%02x%02x%02x", 
			pAdapter->PortCfg.MBSSID[apidx].Bssid[0], pAdapter->PortCfg.MBSSID[apidx].Bssid[1], pAdapter->PortCfg.MBSSID[apidx].Bssid[2], 
			pAdapter->PortCfg.MBSSID[apidx].Bssid[3], pAdapter->PortCfg.MBSSID[apidx].Bssid[4], pAdapter->PortCfg.MBSSID[apidx].Bssid[5]);
	NdisMoveMemory(&pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.RegistrarInfo.Uuid[0], &uuidStr[0], 16);
	NdisMoveMemory(&pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.EnrolleeInfo.Uuid[0], &uuidStr[0], 16);
*/	
	NdisMoveMemory(&pWscControl->RegData.RegistrarInfo.Uuid[0], &Wsc_Uuid_E[0], UUID_LEN_HEX);
	NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.Uuid[0], &Wsc_Uuid_E[0], UUID_LEN_HEX);
	// <<WCN vista logo>> --

	// 3. MAC address
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (bFromApCli)
		NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.MacAddr, &pAdapter->ApCliTab.ApCliEntry[apidx].CurrentAddress, 6);
	else
#endif // APCLI_SUPPORT //
// --
	NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.MacAddr, &pAdapter->PortCfg.MBSSID[apidx].Bssid, 6);

	// 4. Device Name
	NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.DeviceName, WSC_DEVICE_NAME, sizeof(WSC_DEVICE_NAME));
	
	// 5. Manufacture
	NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.Manufacturer, WSC_MANUFACTURE, sizeof(WSC_MANUFACTURE));

	// 6. Model Name
	NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.ModelName, WSC_MODEL_NAME, sizeof(WSC_MODEL_NAME));
	
	// 7. Model Number
	NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.ModelNumber, WSC_MODEL_NUMBER, sizeof(WSC_MODEL_NUMBER));
	
	// 8. Serial Number
	NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.SerialNumber, WSC_MODEL_SERIAL, sizeof(WSC_MODEL_SERIAL));
	
	// 9. Authentication Type Flags
	// <<WCN vista logo>> ++, edit by johnli
/*
	pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.EnrolleeInfo.AuthTypeFlags = cpu2be16(authType);// AP support WPA2PSK, WPAPSK, Open
	pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.RegistrarInfo.AuthTypeFlags = cpu2be16(authType);// config STA WPAPSK
*/
	// Open(=1), WPAPSK(=2),Shared(=4), WPA2PSK(=20),WPA(=8),WPA2(=10)
	// (0x01 | 0x02 | 0x04 | 0x20 | 0x08 | 0x10) = 0x3F
	// WCN vista logo will check this flags.
	pWscControl->RegData.EnrolleeInfo.AuthType = cpu2be16(authType);
	pWscControl->RegData.RegistrarInfo.AuthType = cpu2be16(authType);
	pWscControl->RegData.EnrolleeInfo.AuthTypeFlags = cpu2be16(0x003F);
	pWscControl->RegData.RegistrarInfo.AuthTypeFlags = cpu2be16(0x003F);
	// <<WCN vista logo>> --
	
	// 10. Encryption Type Flags
	// <<WCN vista logo>> ++, edit by johnli
/*
	pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.EnrolleeInfo.EncrTypeFlags  = cpu2be16(encyType);// AP support AES TKIP NONE
	pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.RegistrarInfo.EncrTypeFlags  = cpu2be16(encyType);// config STA TKIP
*/
	// None(=1), WEP(=2), TKIP(=4), AES(=8)
	// (0x01 | 0x02 | 0x04 | 0x08) = 0x0F
	pWscControl->RegData.EnrolleeInfo.EncrType  = cpu2be16(encyType);
	pWscControl->RegData.RegistrarInfo.EncrType  = cpu2be16(encyType);
	pWscControl->RegData.EnrolleeInfo.EncrTypeFlags  = cpu2be16(0x000F);
	pWscControl->RegData.RegistrarInfo.EncrTypeFlags  = cpu2be16(0x000F);
	// <<WCN vista logo>> --
	
	// 11. Connection Type Flag
	pWscControl->RegData.EnrolleeInfo.ConnTypeFlags = 0x01;					// ESS

	// 12. Associate state
	pWscControl->RegData.EnrolleeInfo.AssocState = cpu2be16(0x0000);		// Not associated

	// 13. Configure Error
	pWscControl->RegData.EnrolleeInfo.ConfigError = cpu2be16(0x0000);

	// 14. OS Version
	pWscControl->RegData.EnrolleeInfo.OsVersion = cpu2be32(0x80000000);		// first bit must be 1
	
	// 15. RF Band
	if (pAdapter->PortCfg.PhyMode == PHY_11A)
    {   
	    pWscControl->RegData.EnrolleeInfo.RfBand = WSC_RFBAND_50GHZ;	// 5G
	    pWscControl->RegData.RegistrarInfo.RfBand = WSC_RFBAND_50GHZ;	// 5G
    }   
    else
    {
        pWscControl->RegData.EnrolleeInfo.RfBand = WSC_RFBAND_24GHZ;	// 2.4G
        pWscControl->RegData.RegistrarInfo.RfBand = WSC_RFBAND_24GHZ;	// 2.4G
    }

	// 16. Config Method
	// TODO: Might need to differ between PBC and PIN mode
	pWscControl->RegData.EnrolleeInfo.ConfigMethods = cpu2be16(0x008c);		// Label, Display, PBC

	// 17. Simple Config State
	pWscControl->RegData.EnrolleeInfo.ScState = pWscControl->WscConfStatus;
	pWscControl->RegData.RegistrarInfo.ScState = pWscControl->WscConfStatus;

	// 18. Device Password ID
	if (pWscControl->WscMode == WSC_PIN_MODE)
	{
		pWscControl->RegData.EnrolleeInfo.DevPwdId = cpu2be16(DEV_PASS_ID_PIN);		// PIN mode
	}
	else
	{
		pWscControl->RegData.EnrolleeInfo.DevPwdId = cpu2be16(DEV_PASS_ID_PBC);		// PBC
	}

	// 19. SSID
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (bFromApCli)
		NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.Ssid, &pAdapter->ApCliTab.ApCliEntry[apidx].Ssid, pAdapter->ApCliTab.ApCliEntry[apidx].SsidLen);
	else
#endif // APCLI_SUPPORT //
// --
	NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.Ssid, &pAdapter->PortCfg.MBSSID[apidx].Ssid, pAdapter->PortCfg.MBSSID[apidx].SsidLen);

	// 20. Primary Device Type
	NdisMoveMemory(&pWscControl->RegData.EnrolleeInfo.PriDeviceType, &Wsc_Pri_Dev_Type[0], 8);

#if 0

	// Unknown field
	ULONG	FeatureId;
	UCHAR	KeyMgmt[20];

#endif

	// Other enrollee controlled data in RegData structure
	
	// 1. Enrollee Nonce, first generate and save to Wsc Control Block
	for (idx = 0; idx < 16; idx++)
	{
		pWscControl->RegData.SelfNonce[idx] = RandomByte(pAdapter);
		pWscControl->RegData.EnrolleeNonce[idx] = pWscControl->RegData.SelfNonce[idx];
		pWscControl->RegData.RegistrarNonce[idx] = pWscControl->RegData.SelfNonce[idx];
	}
	
/*	move to Set_WscGetConf_Proc
	// 2. Enrollee 192 random bytes for DH key generation
	for (idx = 0; idx < 192; idx++)
		pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.EnrolleeRandom[idx] = RandomByte(pAdapter);
	GenerateDHPublicKey(pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.EnrolleeRandom, 192, pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.Pkr, &DH_Len);
	memcpy(pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.Pke, pAdapter->PortCfg.MBSSID[apidx].WscControl.RegData.Pkr, DH_Len);
*/
	
	// PIN Code
	// WscGetRegDataPIN(pAdapter, pAdapter->PortCfg.MBSSID[apidx].WscControl.WscPinCode);
//    DBGPRINT(RT_DEBUG_TRACE, "Enrollee PinCode = %u\n", WscGeneratePinCode(pAdapter, 0));
	DBGPRINT(RT_DEBUG_TRACE, "<----- WscInitRegistrarPair\n");	
}

VOID WscInitEntryFunc(
    IN  PMAC_TABLE_ENTRY pEntry)
{
    DBGPRINT(RT_DEBUG_TRACE, "-----> WscInitEntryFunc\n");

    if (pEntry)
    {
        RTMP_ADAPTER	*pAd = (PRTMP_ADAPTER)pEntry->pAd;

        pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EntryApIdx = pEntry->ApIdx;
        NdisZeroMemory(pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EntryAddr, MAC_ADDR_LEN);
        NdisMoveMemory(pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EntryAddr, pEntry->Addr, MAC_ADDR_LEN);
        pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.WscRetryCount = 0;
    }

    DBGPRINT(RT_DEBUG_TRACE, "<----- WscInitEntryFunc\n");	
}

BOOLEAN WscCheckWSCHeader(
    IN	PRTMP_ADAPTER		pAdapter,
    IN  PUCHAR              pData)
{
    PWSC_FRAME			pWsc;
//    UCHAR				apidx = MAIN_MBSSID;

	pWsc = (PWSC_FRAME) pData;

    // Verify SMI first
	if (((pWsc->SMI[0] * 256 + pWsc->SMI[1]) * 256 + pWsc->SMI[2]) != WSC_SMI)
	{
		// Wrong WSC SMI Vendor ID, Update WSC status
		//pAdapter->PortCfg.MBSSID[apidx].WscControl.WscStatus = STATUS_WSC_EAP_RSP_WRONG_SMI;				
		return  FALSE;
	}
    
    // Verify Vendor Type
	if (cpu2be32(pWsc->VendorType) != WSC_VENDOR_TYPE)
	{
		// Wrong WSC Vendor Type, Update WSC status
		//pAdapter->PortCfg.MBSSID[apidx].WscControl.WscStatus = STATUS_WSC_EAP_RSP_WRONG_VENDOR_TYPE;
		return  FALSE;
	}
    return TRUE;
}

VOID	WscSendEapReqId(
	IN	PRTMP_ADAPTER		pAdapter,
	IN	PMAC_TABLE_ENTRY	pEntry)
{
	HEADER_802_11		Header_802_11;
	USHORT				Length;
	IEEE8021X_FRAME		Ieee_8021x;
	EAP_FRAME			EapFrame;
	UCHAR				*OutBuffer = NULL;
	ULONG				FrameLen = 0;
	UCHAR				EAPHEAD[8] = {0xaa,	0xaa, 0x03,	0x00, 0x00,	0x00, 0x88, 0x8e};
    UCHAR				Data[] = "hello";
    UCHAR				Id;
	
	// 1. Send EAP-Req Id
	DBGPRINT(RT_DEBUG_TRACE, "-----> WscSendEapReqId\n");

	// =====================================
	// Use Priority Ring & MiniportMMRequest
	// =====================================
	pAdapter->Sequence = ((pAdapter->Sequence) + 1)	& (MAX_SEQ_NUMBER);
    
	WscMacHeaderInit(pAdapter, 
                     &Header_802_11, 
                     pEntry->Addr,
                     pAdapter->PortCfg.MBSSID[pEntry->ApIdx].Bssid,
                     FALSE);

	// Length, -1 NULL pointer of string
	Length = sizeof(EAP_FRAME) + sizeof(Data) - 1;
	
	// Zero 802.1x body
	NdisZeroMemory(&Ieee_8021x, sizeof(Ieee_8021x));
	Ieee_8021x.Version = EAPOL_VER;
	Ieee_8021x.Type    = EAPPacket;
	Ieee_8021x.Length  = cpu2be16(Length);

	// Zero EAP frame
	NdisZeroMemory(&EapFrame, sizeof(EapFrame));
    /* RFC 3748 Ch 4.1: recommended to initalize Identifier with a
	 * random number */
	Id = RandomByte(pAdapter);
    if (Id == pAdapter->PortCfg.MBSSID[pEntry->ApIdx].WscControl.lastId)
        Id += 1;
	EapFrame.Code   = EAP_CODE_REQ;
	EapFrame.Id     = Id;
	EapFrame.Length = cpu2be16(Length);
	EapFrame.Type   = EAP_TYPE_ID;
    pAdapter->PortCfg.MBSSID[pEntry->ApIdx].WscControl.lastId = Id;
	
    // Out buffer for transmitting EAP-Req(Identity)
    OutBuffer = kmalloc(MAX_LEN_OF_MLME_BUFFER, MEM_ALLOC_FLAG);
    if(OutBuffer == NULL)
        return;

	FrameLen = 0;
	
	// Make	 Transmitting frame
	MakeOutgoingFrame(OutBuffer, &FrameLen,	sizeof(HEADER_802_11), &Header_802_11,
		sizeof(EAPHEAD), EAPHEAD, sizeof(IEEE8021X_FRAME), &Ieee_8021x,
		sizeof(EapFrame), &EapFrame, (sizeof(Data) - 1), Data,
		END_OF_ARGS);

	// Send using priority queue
	MiniportMMRequest(pAdapter, OutBuffer, FrameLen);
	kfree(OutBuffer);  // add by johnli

	// Update WSC status
	//pAdapter->PortCfg.MBSSID[pEntry->ApIdx].WscControl.WscStatus = STATUS_WSC_EAP_REQ_ID_SENT;	

	DBGPRINT(RT_DEBUG_TRACE, "<----- WscSendEapReqId\n");	
}


// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
/*
	========================================================================
	
	Routine Description:
		Send EAPoL-Start packet to AP.

	Arguments:
		pAd         - NIC Adapter pointer
		
	Return Value:
		None
		
	IRQL = DISPATCH_LEVEL
	
	Note:
		Actions after link up
		1. Change the correct parameters
		2. Send EAPOL - START
		
	========================================================================
*/
VOID    WscSendEapolStart(
	IN	PRTMP_ADAPTER	pAdapter,
	IN  PUCHAR          pBssid,
	IN  BOOLEAN         bFromApCli)
{
	HEADER_802_11		Header_802_11;
	UCHAR				AckRate = RATE_2;
	USHORT				AckDuration = 0;
	IEEE8021X_FRAME		Packet;
	UCHAR				*OutBuffer = NULL;
	ULONG				FrameLen = 0;
	UCHAR				EAPHEAD[8] = {0xaa,	0xaa, 0x03,	0x00, 0x00,	0x00,0x88,0x8e};
	
	DBGPRINT(RT_DEBUG_TRACE, "-----> WscSendEapolStart\n");

	// 1. Change the authentication to open and encryption to none if necessary.

	// 2. Send EAPOL start
	
	// =====================================
	// Use Priority Ring & MiniportMMRequest
	// =====================================
	pAdapter->Sequence = ((pAdapter->Sequence) + 1)	& (MAX_SEQ_NUMBER);

	WscMacHeaderInit(pAdapter, &Header_802_11, pBssid, pBssid, bFromApCli);

	// ACK size	is 14 include CRC, and its rate	is based on real time information
	AckRate = pAdapter->PortCfg.ExpectedACKRate[pAdapter->ApCliTab.ApCliEntry[0].CurrTxRate];
	AckDuration = RTMPCalcDuration(pAdapter, AckRate, 14);
	Header_802_11.Duration = pAdapter->PortCfg.Dsifs + AckDuration;
	
	// Zero message 2 body
	NdisZeroMemory(&Packet, sizeof(Packet));
	Packet.Version = EAPOL_VER;
	Packet.Type    = EAPOLStart;
	Packet.Length  = cpu2be16(0);
	
	// Out buffer for transmitting message 2
	
	OutBuffer = kmalloc(MAX_LEN_OF_MLME_BUFFER, MEM_ALLOC_FLAG);  //Get an unused nonpaged memory
	if (OutBuffer == NULL)	
		return;					

	FrameLen = 0;
	// Make	 Transmitting frame
	MakeOutgoingFrame(OutBuffer, &FrameLen,	sizeof(HEADER_802_11), &Header_802_11,
		sizeof(EAPHEAD), EAPHEAD, 
		4, &Packet,
		END_OF_ARGS);

    // Send using priority queue
	MiniportMMRequest(pAdapter, OutBuffer, FrameLen);
	kfree(OutBuffer);  // add by johnli

	// Update WSC status
	pAdapter->ApCliTab.ApCliEntry[0].WscControl.WscStatus = STATUS_WSC_EAPOL_START_SENT;
	pAdapter->ApCliTab.ApCliEntry[0].WscControl.WscStatus = WSC_STATE_WAIT_REQ_ID;
	if (!pAdapter->ApCliTab.ApCliEntry[0].WscControl.EapolTimerRunning)
	{
		pAdapter->ApCliTab.ApCliEntry[0].WscControl.EapolTimerRunning = TRUE;
		RTMPAddTimer(&pAdapter->ApCliTab.ApCliEntry[0].WscControl.EapolTimer, WSC_EAPOL_START_TIME_OUT);
	}

	DBGPRINT(RT_DEBUG_TRACE, "<----- WscSendEapolStart\n");
}

VOID	WscSendEapRspId(
	IN	PRTMP_ADAPTER		pAdapter,
	IN  PWSC_CTRL           pWscControl)
{
	HEADER_802_11		Header_802_11;
	USHORT				Length = 0;
	IEEE8021X_FRAME		Ieee_8021x;
	EAP_FRAME			EapFrame;
	UCHAR				*OutBuffer = NULL;
	ULONG				FrameLen = 0;
	UCHAR				EAPHEAD[8] = {0xaa,	0xaa, 0x03,	0x00, 0x00,	0x00, 0x88, 0x8e};
	UCHAR               enrIdentity[] = "WFA-SimpleConfig-Enrollee-1-0";
	
	// 1. Send EAP-Rsp Id
	DBGPRINT(RT_DEBUG_TRACE, "-----> WscSendEapRspId\n");

	// =====================================
	// Use Priority Ring & MiniportMMRequest
	// =====================================
	pAdapter->Sequence = ((pAdapter->Sequence) + 1)	& (MAX_SEQ_NUMBER);

	WscMacHeaderInit(pAdapter, &Header_802_11, pWscControl->EntryAddr, pWscControl->EntryAddr, TRUE);
	Length = sizeof(EAP_FRAME) + sizeof(enrIdentity) - 1;
	pWscControl->WscConfMode = WSC_AP_Enrollee; // Ap Client only support Enrollee now. 20070518

	// Zero 802.1x body
	NdisZeroMemory(&Ieee_8021x, sizeof(Ieee_8021x));
	Ieee_8021x.Version = EAPOL_VER;
	Ieee_8021x.Type    = EAPPacket;
	Ieee_8021x.Length  = cpu2be16(Length);

	// Zero EAP frame
	NdisZeroMemory(&EapFrame, sizeof(EapFrame));
	EapFrame.Code   = EAP_CODE_RSP;
	EapFrame.Id     = pWscControl->lastId;
	EapFrame.Length = cpu2be16(Length);
	EapFrame.Type   = EAP_TYPE_ID;

	// Out buffer for transmitting EAP-Req(Identity)
	OutBuffer = kmalloc(MAX_LEN_OF_MLME_BUFFER, MEM_ALLOC_FLAG);
	if(OutBuffer == NULL)
		return;

	FrameLen = 0;

	if (pWscControl->WscConfMode == WSC_AP_Enrollee)
	{
// Make	 Transmitting frame
	MakeOutgoingFrame(OutBuffer, &FrameLen,	sizeof(HEADER_802_11), &Header_802_11,
		sizeof(EAPHEAD), EAPHEAD, sizeof(IEEE8021X_FRAME), &Ieee_8021x,
		sizeof(EapFrame), &EapFrame, (sizeof(enrIdentity) - 1), enrIdentity,
		END_OF_ARGS);
	}
	else
	{
		DBGPRINT(RT_DEBUG_TRACE, "WscConfMode(%d) is not WSC_AP_Enrollee.\n", pWscControl->WscConfMode);	
		goto out;
	}

	// Send using priority queue
	MiniportMMRequest(pAdapter, OutBuffer, FrameLen);	

	if (!pWscControl->EapolTimerRunning)
	{
		pWscControl->EapolTimerRunning = TRUE;
		RTMPAddTimer(&pWscControl->EapolTimer, WSC_EAP_ID_TIME_OUT);
	}
out:
	kfree(OutBuffer);
	DBGPRINT(RT_DEBUG_TRACE, "<----- WscSendEapRspId\n");	
}
#endif // APCLI_SUPPORT //
// --

VOID WscUPnPErrHandle(
	IN PRTMP_ADAPTER pAd,
	IN ULONG eventID,
// For AP Client support WPS Modification
	IN  PWSC_CTRL           pWscControl)
// --
{
	// <<WCN vista logo>> ++, add by johnli
	int dataLen;
	UCHAR *pWscData;
	// <<WCN vista logo>> --

	DBGPRINT(RT_DEBUG_TRACE, "Into WscUPnPErrHandle, send WSC_OPCODE_UPNP_CTRL with eventID=0x%x!\n", eventID);
	// <<WCN vista logo>> ++, add by johnli
	//WscSendUPnPMessage(pAd, WSC_OPCODE_UPNP_CTRL, 0, NULL, 0, eventID, 0);

	if( (pWscData = kmalloc(WSC_MAX_DATA_LEN, GFP_ATOMIC)))
	{
		memset(pWscData, 0, WSC_MAX_DATA_LEN);
	
		dataLen = BuildMessageNACK(pAd, pWscControl, pWscData);
		WscSendUPnPMessage(pAd, WSC_OPCODE_UPNP_DATA, WSC_UPNP_DATA_SUB_NORMAL, pWscData, dataLen, eventID, 0);
	
		kfree(pWscData);
	} 
	else 
	{
	WscSendUPnPMessage(pAd, WSC_OPCODE_UPNP_CTRL, 0, NULL, 0, eventID, 0);
	}
	// <<WCN vista logo>> --
}

/*
	Format of iwcustom msg WSC clientJoin message:
		1. SSID which station want to probe(32 bytes):
			<SSID string>
			*If the length if SSID string is small than 32 bytes, fill 0x0 for remaining bytes.
		2. sender MAC address(6 bytes):
		3. Status:
			Set as 1 means change APStatus as 1. 
			Set as 2 means change STAStatus as 1.
			Set as 3 means trigger msg.
								
			32         6        1 
		+----------+--------+------+
		|SSIDString| SrcMAC |Status|
*/
int WscSendUPnPConfReqMsg(
	IN PRTMP_ADAPTER pAd,
	IN PUCHAR ssidStr,
	IN PUCHAR macAddr,
	IN INT	  Status,
	IN ULONG eventID)
{
	UCHAR pData[39] = {0};
	
	strncpy(pData, ssidStr, strlen(ssidStr));
	NdisMoveMemory(&pData[32], macAddr, MAC_ADDR_LEN);
	pData[38] = Status;
	WscSendUPnPMessage(pAd, WSC_OPCODE_UPNP_MGMT, WSC_UPNP_MGMT_SUB_CONFIG_REQ, &pData[0], 39, eventID, 0);

	return 0;
}

	
/*
	NETLINK tunnel msg format send to WSCUPnP handler in user space:
	1. Signature of following string(Not include the quote, 8 bytes)
			"RAWSCMSG"
	2. eID: eventID (4 bytes)
			the ID of this message(4 bytes)
	3. aID: ackID (4 bytes)
			means that which event ID this mesage was response to.
	4. TL:  Message Total Length (4 bytes) 
			Total length of this message.
	5. F:   Flag (2 bytes)
			used to notify some specific character of this msg segment.
				Bit 1: fragment
					set as 1 if netlink layer have more segment of this Msg need to send.
				Bit 2~15: reserve, should set as 0 now.
	5. SL:  Segment Length(2 bytes)
			msg actual length in this segment, The SL may not equal the "TL" field if "F" ==1
	6. "WSC_MSG" info:

          8        4     4    4   2  2     variable length(MAXIMA=232)
	+------------+----+----+----+--+--+------------------------------+
	|  Signature |eID |aID | TL |F |SL|            WSC_MSG           |

*/
int WscSendUPnPMessage(
	IN	PRTMP_ADAPTER		pAd, 
	IN  USHORT              msgType,
	IN  USHORT				msgSubType,
	IN  PUCHAR				pData,
	IN  INT					dataLen,
	IN	ULONG				eventID,
	IN  ULONG				toIPAddr)
{
	union iwreq_data wrqu;
	RTMP_WSC_NLMSG_HDR *pNLMsgHdr;
	RTMP_WSC_MSG_HDR *pWscMsgHdr;
	
	UCHAR hdrBuf[36]; //RTMP_WSC_NLMSG_HDR_LEN + RTMP_WSC_MSG_HDR_LEN
	int totalLen, leftLen;
	PUCHAR pBuf = NULL, pBufPtr = NULL, pPos = NULL;
	
	DBGPRINT(RT_DEBUG_TRACE, "-----> WscSendUPnPMessage\n");

	if ((msgType & WSC_OPCODE_UPNP_MASK) != WSC_OPCODE_UPNP_MASK)
		return FALSE;
		
	//Prepare the NLMsg header
	memset(hdrBuf, 0, sizeof(hdrBuf));
	pNLMsgHdr = (RTMP_WSC_NLMSG_HDR *)hdrBuf;
	memcpy(pNLMsgHdr, WSC_MSG_SIGNATURE, RTMP_WSC_NLMSG_SIGNATURE_LEN);

	pNLMsgHdr->envID = jiffies;
	pNLMsgHdr->ackID = eventID;
	pNLMsgHdr->msgLen = dataLen + RTMP_WSC_MSG_HDR_LEN;

	//Prepare the WscMsg header
	pWscMsgHdr = (RTMP_WSC_MSG_HDR *)(hdrBuf + sizeof(RTMP_WSC_NLMSG_HDR));
	switch(msgType)
	{
		case WSC_OPCODE_UPNP_DATA:
				pWscMsgHdr->msgType = WSC_OPCODE_UPNP_DATA;
				break;
		case WSC_OPCODE_UPNP_MGMT:
				pWscMsgHdr->msgType = WSC_OPCODE_UPNP_MGMT;
				break;
		case WSC_OPCODE_UPNP_CTRL:
				pWscMsgHdr->msgType = WSC_OPCODE_UPNP_CTRL;
				break;
		default:
				return FALSE;
	}
	pWscMsgHdr->msgSubType = msgSubType;
	pWscMsgHdr->ipAddr = toIPAddr;
	pWscMsgHdr->msgLen = dataLen;
	
//+++Add for debug
#if 0
{
	int i;
	char *tmp = pData;
	
	printk("\nDump the pData payload(msgType=%d, msgSubType=%d, toIPAddr=0x%x, dataLen=%d):\n", msgType, msgSubType, toIPAddr, dataLen);
	for(i=0;i< dataLen; i++)
	{
		if(i % 16==0 && i!=0)
			printk("\n");
		printk("%02x ", tmp[i] & 0xff);
	}							
	printk("\n------DumpFinished!\n");
}
#endif
//---Add for debug

	//Allocate memory and copy the msg.
	totalLen = leftLen = pNLMsgHdr->msgLen;
	pPos = pData;
	if((pBuf = kmalloc(IWEVCUSTOM_MSG_MAX_LEN, GFP_ATOMIC)) != NULL)
	{
		int firstSeg = 1;
	
		while(leftLen)
		{
			//Prepare the payload 
			memset(pBuf, 0, IWEVCUSTOM_MSG_MAX_LEN);

			pNLMsgHdr->segLen = (leftLen > IWEVCUSTOM_PAYLOD_MAX_LEN ? IWEVCUSTOM_PAYLOD_MAX_LEN : leftLen);
			leftLen -= pNLMsgHdr->segLen;
			pNLMsgHdr->flags = (leftLen > 0 ? 1 : 0);

			memcpy(pBuf, pNLMsgHdr, RTMP_WSC_NLMSG_HDR_LEN);
			pBufPtr = &pBuf[RTMP_WSC_NLMSG_HDR_LEN];

			if(firstSeg){
				memcpy(pBufPtr, pWscMsgHdr, RTMP_WSC_MSG_HDR_LEN);
				pBufPtr += RTMP_WSC_MSG_HDR_LEN;
				NdisMoveMemory(pBufPtr, pPos, (pNLMsgHdr->segLen - RTMP_WSC_MSG_HDR_LEN));
				pPos += (pNLMsgHdr->segLen - RTMP_WSC_MSG_HDR_LEN);
				firstSeg = 0;
			} else {
				NdisMoveMemory(pBufPtr, pPos, pNLMsgHdr->segLen);
				pPos += pNLMsgHdr->segLen;
			}
			//Prepare the wreq msg header.
			memset(&wrqu, 0, sizeof(wrqu));
			wrqu.data.length = pNLMsgHdr->segLen + sizeof(RTMP_WSC_NLMSG_HDR);
						
			//Send WSC Msg to wscd
			wireless_send_event(pAd->net_dev, IWEVCUSTOM, &wrqu, pBuf);
		}
		
		kfree(pBuf);
	}

	DBGPRINT(RT_DEBUG_TRACE, "<----- WscSendUPnPMessage\n");
	return TRUE;
}


VOID	WscSendMessage(
	IN	PRTMP_ADAPTER		pAdapter, 
	IN  UCHAR               OpCode,
	IN  PUCHAR				pData,
	IN  INT					Len,
// For AP Client support WPS Modification
	IN  PWSC_CTRL           pWscControl,
	IN	BOOLEAN         bFromApcli)
// --
{	
	UCHAR	apidx = MAIN_MBSSID;

	// Send message
	DBGPRINT(RT_DEBUG_TRACE, "-----> WscSendMessage\n");	

    {
        // Inb-EAP Message
        HEADER_802_11		Header_802_11;
    	USHORT				Length;
    	IEEE8021X_FRAME		Ieee_8021x;
    	EAP_FRAME			EapFrame;
    	WSC_FRAME			WscFrame;
    	UCHAR				*OutBuffer = NULL;
        ULONG				FrameLen = 0;
	    UCHAR				EAPHEAD[8] = {0xaa,	0xaa, 0x03,	0x00, 0x00,	0x00, 0x88, 0x8e};
    
    	// =====================================
    	// Use Priority Ring & MiniportMMRequest
    	// =====================================
    	pAdapter->Sequence = ((pAdapter->Sequence) + 1)	& (MAX_SEQ_NUMBER);
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (bFromApcli)
            WscMacHeaderInit(pAdapter, 
                             &Header_802_11,
                             pWscControl->EntryAddr,
                             pWscControl->EntryAddr,
                             TRUE);
	else
#endif // APCLI_SUPPORT //
// --
        WscMacHeaderInit(pAdapter, 
                         &Header_802_11,
                         pWscControl->EntryAddr, 
                         pAdapter->PortCfg.MBSSID[apidx].Bssid,
                         FALSE);	

    	// Length = EAP + WSC_Frame + Payload
    	Length = sizeof(EAP_FRAME) + sizeof(WSC_FRAME) + Len;
    	
    	// Zero 802.1x body
    	NdisZeroMemory(&Ieee_8021x, sizeof(Ieee_8021x));
    	Ieee_8021x.Version = EAPOL_VER;
    	Ieee_8021x.Type    = EAPPacket;
    	Ieee_8021x.Length  = cpu2be16(Length);

    	// Zero EAP frame
    	NdisZeroMemory(&EapFrame, sizeof(EapFrame));
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (bFromApcli)
	{
		EapFrame.Code   = EAP_CODE_RSP;
		EapFrame.Id     = pWscControl->lastId; // same as AP eap_req id
	}
	else
#endif // APCLI_SUPPORT //
// --
	{
		EapFrame.Code   = EAP_CODE_REQ;
		EapFrame.Id     = ++(pWscControl->lastId);
	}
    	EapFrame.Length = cpu2be16(Length);
    	EapFrame.Type   = EAP_TYPE_WSC;

    	// Zero WSC Frame
    	NdisZeroMemory(&WscFrame, sizeof(WscFrame));
    	WscFrame.SMI[0] = 0x00;
    	WscFrame.SMI[1] = 0x37;
    	WscFrame.SMI[2] = 0x2A;
    	WscFrame.VendorType = cpu2be32(WSC_VENDOR_TYPE);
    	WscFrame.OpCode = OpCode;
    	WscFrame.Flags  = 0x00;

        // Out buffer for transmitting message
        OutBuffer = kmalloc(MAX_LEN_OF_MLME_BUFFER, MEM_ALLOC_FLAG);
        if(OutBuffer == NULL)
            return;

    	FrameLen = 0;
    	
    	// Make	 Transmitting frame
    	if (pData && (Len > 0))
        	MakeOutgoingFrame(OutBuffer, &FrameLen,	sizeof(HEADER_802_11), &Header_802_11,
        		sizeof(EAPHEAD), EAPHEAD, sizeof(IEEE8021X_FRAME), &Ieee_8021x,
        		sizeof(EapFrame), &EapFrame, sizeof(WscFrame), &WscFrame, Len, pData,
        		END_OF_ARGS);
        else
            MakeOutgoingFrame(OutBuffer, &FrameLen,	sizeof(HEADER_802_11), &Header_802_11,
        		sizeof(EAPHEAD), EAPHEAD, sizeof(IEEE8021X_FRAME), &Ieee_8021x,
        		sizeof(EapFrame), &EapFrame, sizeof(WscFrame), &WscFrame, END_OF_ARGS);

    	// Send using priority queue
    	MiniportMMRequest(pAdapter, OutBuffer, FrameLen);

    	kfree(OutBuffer);
    }
	DBGPRINT(RT_DEBUG_TRACE, "<----- WscSendMessage\n");	
}

/*
	========================================================================
	
	Routine Description:
		Ap send EAP-Fail to station

	Arguments:
		pAdapter    - NIC Adapter pointer
		Id			- ID between EAP-Req and EAP-Rsp pair
		pEntry		- The Station Entry information
		
	Return Value:
		None
		
	========================================================================
*/
VOID	WscSendEapFail(
	IN	PRTMP_ADAPTER		pAdapter)
{
	HEADER_802_11		Header_802_11;
	USHORT				Length;
	IEEE8021X_FRAME		Ieee_8021x;
	EAP_FRAME			EapFrame;
	UCHAR				*OutBuffer = NULL;
	ULONG				FrameLen = 0;
	UCHAR				apidx = MAIN_MBSSID;
	UCHAR				EAPHEAD[8] = {0xaa,	0xaa, 0x03,	0x00, 0x00,	0x00, 0x88, 0x8e};
	
	// 1. Send EAP-Rsp Id
	DBGPRINT(RT_DEBUG_TRACE, "-----> WscSendEapFail\n");

	// =====================================
	// Use Priority Ring & MiniportMMRequest
	// =====================================
	pAdapter->Sequence = ((pAdapter->Sequence) + 1)	& (MAX_SEQ_NUMBER);
    
    WscMacHeaderInit(pAdapter, 
                         &Header_802_11,
                         pAdapter->PortCfg.MBSSID[apidx].WscControl.EntryAddr, 
                         pAdapter->PortCfg.MBSSID[apidx].Bssid,
                         FALSE);	

	// Length, -1 type size, Eap-Fail doesn't need Type item
	Length = sizeof(EAP_FRAME) - sizeof(UCHAR);
	
	// Zero 802.1x body
	NdisZeroMemory(&Ieee_8021x, sizeof(Ieee_8021x));
	Ieee_8021x.Version = EAPOL_VER;
	Ieee_8021x.Type    = EAPPacket;
	Ieee_8021x.Length  = cpu2be16(Length);

	// Zero EAP frame
	NdisZeroMemory(&EapFrame, sizeof(EapFrame));
	EapFrame.Code   = EAP_CODE_FAIL;
	EapFrame.Id     = pAdapter->PortCfg.MBSSID[apidx].WscControl.lastId;
	EapFrame.Length = cpu2be16(Length);
	
    // Out buffer for transmitting EAP-Req(Identity)
    OutBuffer = kmalloc(MAX_LEN_OF_MLME_BUFFER, MEM_ALLOC_FLAG);
    if(OutBuffer == NULL)
        return;

	FrameLen = 0;
	
	// Make	 Transmitting frame
	MakeOutgoingFrame(OutBuffer, &FrameLen,	sizeof(HEADER_802_11), &Header_802_11,
		sizeof(EAPHEAD), EAPHEAD, sizeof(IEEE8021X_FRAME), &Ieee_8021x,
		sizeof(EapFrame)-1, &EapFrame, END_OF_ARGS);

	// Send using priority queue
	MiniportMMRequest(pAdapter, OutBuffer, FrameLen);

    pAdapter->PortCfg.MBSSID[apidx].WscControl.EntryApIdx = WSC_INIT_ENTRY_APIDX;
	// Update WSC status
	//pAdapter->PortCfg.MBSSID[apidx].WscControl.WscStatus = STATUS_WSC_EAP_FAIL_SENT;	
	kfree(OutBuffer);

	DBGPRINT(RT_DEBUG_TRACE, "<----- WscSendEapFail\n");	
}

VOID WscBuildBeaconIE(
	IN	PRTMP_ADAPTER	pAd, 
	IN	UCHAR b_configured,
	IN	BOOLEAN b_selRegistrar,
	IN	USHORT devPwdId,
	IN	USHORT selRegCfgMethods)
{
	WSC_IE_HEADER 	ieHdr;
	UCHAR 			Data[256];
	PUCHAR			pData;
	INT				Len = 0, templen = 0;
	UCHAR			apidx = MAIN_MBSSID;
    USHORT          tempVal = 0;
	PWSC_REG_DATA	pReg = (PWSC_REG_DATA) &pAd->PortCfg.MBSSID[apidx].WscControl.RegData;
 
	DBGPRINT(RT_DEBUG_TRACE, "-----> WscBuildBeaconIE\n");
	// WSC IE HEader
	ieHdr.elemId = 221;
	ieHdr.length = 4;
	ieHdr.oui[0] = 0x00; ieHdr.oui[1] = 0x50; 
    ieHdr.oui[2] = 0xF2; ieHdr.oui[3] = 0x04;

	pData = (PUCHAR) &Data[0];
	Len = 0;
	
	// 1. Version
	templen = AppendWSCTLV(WSC_ID_VERSION, pData, &pReg->RegistrarInfo.Version, 0);
	pData += templen;
	Len   += templen;

	// 2. Simple Config State
	templen = AppendWSCTLV(WSC_ID_SC_STATE, pData, (u8 *)&b_configured, 0);
	pData += templen;
	Len   += templen;
	
	if ( b_selRegistrar )
	{
		// 3.Selected Registrar
		templen = AppendWSCTLV(WSC_ID_SEL_REGISTRAR, pData, (u8 *)&b_selRegistrar, 0);
    	pData += templen;
    	Len   += templen;

		//4. Device Password ID
		tempVal = htons(devPwdId);
		templen = AppendWSCTLV(WSC_ID_DEVICE_PWD_ID, pData, (u8 *)&tempVal, 0);
    	pData += templen;
    	Len   += templen;

		// 5. Selected Registrar Config Methods
		tempVal = htons(selRegCfgMethods);
		templen = AppendWSCTLV(WSC_ID_SEL_REG_CFG_METHODS, pData, (u8 *)&tempVal, 0);
    	pData += templen;
    	Len   += templen;
	}

	// 6. UUID last 6 bytes use MAC
	templen = AppendWSCTLV(WSC_ID_UUID_E, pData, pReg->RegistrarInfo.Uuid, 0);
	pData += templen;
	Len   += templen;

	// 7. RF Bands
	templen = AppendWSCTLV(WSC_ID_RF_BAND, pData, (u8 *)&pReg->RegistrarInfo.RfBand, 0);
	pData += templen;
	Len   += templen;

	ieHdr.length = ieHdr.length + Len;
	memcpy(pAd->PortCfg.MBSSID[apidx].WscIEBeacon.Value, &ieHdr, sizeof(WSC_IE_HEADER));
	memcpy(pAd->PortCfg.MBSSID[apidx].WscIEBeacon.Value + sizeof(WSC_IE_HEADER), Data, Len);
	pAd->PortCfg.MBSSID[apidx].WscIEBeacon.ValueLen = sizeof(WSC_IE_HEADER) + Len;

	DBGPRINT(RT_DEBUG_TRACE, "<----- WscBuildBeaconIE\n");
}

VOID WscBuildProbeRespIE(
	IN	PRTMP_ADAPTER	pAd, 
	IN	UCHAR respType,
	IN	UCHAR scState,
	IN	BOOLEAN b_selRegistrar,
	IN	USHORT devPwdId,
	IN	USHORT selRegCfgMethods)
{
	WSC_IE_HEADER 	ieHdr;
	UCHAR 			Data[512];
	PUCHAR			pData;
	INT				Len = 0, templen = 0;
	USHORT			tempVal = 0;
	UCHAR			apidx = MAIN_MBSSID;
    PWSC_REG_DATA	pReg = (PWSC_REG_DATA) &pAd->PortCfg.MBSSID[apidx].WscControl.RegData;

	DBGPRINT(RT_DEBUG_TRACE, "-----> WscBuildProbeRespIE\n");

	// WSC IE Header
	ieHdr.elemId = 221;
	ieHdr.length = 4;
	ieHdr.oui[0] = 0x00; ieHdr.oui[1] = 0x50;
    ieHdr.oui[2] = 0xF2; ieHdr.oui[3] = 0x04;

	pData = (PUCHAR) &Data[0];
	Len = 0;
	
	// 1. Version
	templen = AppendWSCTLV(WSC_ID_VERSION, pData, &pReg->RegistrarInfo.Version, 0);
	pData += templen;
	Len   += templen;

	// 2. Simple Config State
	templen = AppendWSCTLV(WSC_ID_SC_STATE, pData, (u8 *)&scState, 0);
	pData += templen;
	Len   += templen;

	if ( b_selRegistrar )
	{
		// 3. Selected Registrar
		templen = AppendWSCTLV(WSC_ID_SEL_REGISTRAR, pData, (u8 *)&b_selRegistrar, 0);
    	pData += templen;
    	Len   += templen;

		// 4. Device Password ID
		tempVal = htons(devPwdId);
		templen = AppendWSCTLV(WSC_ID_DEVICE_PWD_ID, pData, (u8 *)&tempVal, 0);
    	pData += templen;
    	Len   += templen;

		// 5. Selected Registrar Config Methods
		tempVal = htons(selRegCfgMethods);
		templen = AppendWSCTLV(WSC_ID_SEL_REG_CFG_METHODS, pData, (u8 *)&tempVal, 0);
    	pData += templen;
    	Len   += templen;
	}

	// 6. Response Type WSC_ID_RESP_TYPE
	templen = AppendWSCTLV(WSC_ID_RESP_TYPE, pData, (u8 *)&respType, 0);
   	pData += templen;
   	Len   += templen;

	// 7. UUID last 6 bytes use MAC
	templen = AppendWSCTLV(WSC_ID_UUID_E, pData, pReg->RegistrarInfo.Uuid, 0);
	pData += templen;
	Len   += templen;

	// 8. Manufacturer
	NdisZeroMemory(pData, 64 + 4);
    templen = AppendWSCTLV(WSC_ID_MANUFACTURER, pData,  pReg->EnrolleeInfo.Manufacturer, strlen(pReg->EnrolleeInfo.Manufacturer));
	pData += templen;
	Len   += templen;

	// 9. Model Name
	NdisZeroMemory(pData, 32 + 4);
    templen = AppendWSCTLV(WSC_ID_MODEL_NAME, pData, pReg->EnrolleeInfo.ModelName, strlen(pReg->EnrolleeInfo.ModelName));
	pData += templen;
	Len   += templen;

	// 10. Model Number
	NdisZeroMemory(pData, 32 + 4);
    templen = AppendWSCTLV(WSC_ID_MODEL_NUMBER, pData, pReg->EnrolleeInfo.ModelNumber, strlen(pReg->EnrolleeInfo.ModelNumber));
	pData += templen;
	Len   += templen;

	// 11. Serial Number
	NdisZeroMemory(pData, 32 + 4);
    templen = AppendWSCTLV(WSC_ID_SERIAL_NUM, pData, pReg->EnrolleeInfo.SerialNumber, strlen(pReg->EnrolleeInfo.SerialNumber));
	pData += templen;
	Len   += templen;

	// 12. Primary Device Type
	templen = AppendWSCTLV(WSC_ID_PRIM_DEV_TYPE, pData, pReg->EnrolleeInfo.PriDeviceType, 0);
	pData += templen;
	Len   += templen;

	// 13. Device Name
	NdisZeroMemory(pData, 32 + 4);
    templen = AppendWSCTLV(WSC_ID_DEVICE_NAME, pData, pReg->EnrolleeInfo.DeviceName, strlen(pReg->EnrolleeInfo.DeviceName));
	pData += templen;
	Len   += templen;

	// 14. Config Methods
	//tempVal = htons(0x008a);
	templen = AppendWSCTLV(WSC_ID_CONFIG_METHODS, pData, (u8 *)&pReg->EnrolleeInfo.ConfigMethods, 0);
	pData += templen;
	Len   += templen;

	// 15. RF Bands
	if (pAd->PortCfg.PhyMode == PHY_11A)
		tempVal = 2;
	else
		tempVal = 1;
    templen = AppendWSCTLV(WSC_ID_RF_BAND, pData, (u8 *)&tempVal, 0);
	pData += templen;
	Len   += templen;
     
	ieHdr.length = ieHdr.length + Len;
	memcpy(pAd->PortCfg.MBSSID[apidx].WscIEProbeResp.Value, &ieHdr, sizeof(WSC_IE_HEADER));
	memcpy(pAd->PortCfg.MBSSID[apidx].WscIEProbeResp.Value + sizeof(WSC_IE_HEADER), Data, Len);
	pAd->PortCfg.MBSSID[apidx].WscIEProbeResp.ValueLen = sizeof(WSC_IE_HEADER) + Len;

	DBGPRINT(RT_DEBUG_TRACE, "<----- WscBuildProbeRespIE\n");
}

VOID WscSelectedRegistrar(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR	pReginfo,
	IN	UINT	Length)
{
	PUCHAR	pData;
	INT		IsAPConfigured;
	UCHAR   wsc_version, wsc_sel_reg = 0;
	USHORT	wsc_dev_pass_id = 0, wsc_sel_reg_conf_mthd = 0;
	USHORT	WscType, WscLen;
	UCHAR	apidx = MAIN_MBSSID;

// remove by johnli, do not check variable "gWscActionMode", because it will be set after SetSelectedRegistrar action
/*
	if (gWscActionMode != WSC_AP_PROXY)
		return;
*/
	pData = (PUCHAR)pReginfo;

	if (Length < 4)
	{
		DBGPRINT(RT_DEBUG_TRACE, "WscSelectedRegistrar --> Unknown IE \n");
		return;
	}
	
	while (Length > 4)
	{
	    // arm-cpu has packet alignment issue, it's better to use memcpy to retrieve data
		NdisMoveMemory(&WscType, pData, 2);
		NdisMoveMemory(&WscLen,  pData + 2, 2);
		WscLen = ntohs(WscLen);
		pData  += 4;
		Length -= 4;
		switch (ntohs(WscType))
		{
			case WSC_ID_VERSION:
				wsc_version = *pData;
				break;

			case WSC_ID_SEL_REGISTRAR:
				wsc_sel_reg = *pData;
				break;

			case WSC_ID_DEVICE_PWD_ID:
				wsc_dev_pass_id = be2cpu16(*((PUSHORT) pData));
				break;

			case WSC_ID_SEL_REG_CFG_METHODS:
				wsc_sel_reg_conf_mthd = be2cpu16(*((PUSHORT) pData));
				break;

			default:
				DBGPRINT(RT_DEBUG_TRACE, "WscSelectedRegistrar --> Unknown IE 0x%04x\n", WscType);
				break;
		}

		// Offset to net WSC Ie
		pData  += WscLen;
		Length -= WscLen;
	}

	IsAPConfigured = pAd->PortCfg.MBSSID[apidx].WscControl.WscConfStatus;

	if (wsc_sel_reg == 0x01)
	{
		pAd->PortCfg.MBSSID[apidx].WscControl.WscSelReg = 1;
		WscBuildBeaconIE(pAd, WSC_SCSTATE_CONFIGURED, TRUE, wsc_dev_pass_id, wsc_sel_reg_conf_mthd);
		WscBuildProbeRespIE(pAd, WSC_MSGTYPE_AP_WLAN_MGR, WSC_SCSTATE_CONFIGURED, TRUE, wsc_dev_pass_id, wsc_sel_reg_conf_mthd);
	}
	else
	{
		pAd->PortCfg.MBSSID[apidx].WscControl.WscSelReg = 0;
		WscBuildBeaconIE(pAd, WSC_SCSTATE_CONFIGURED, FALSE, 0, 0);
		WscBuildProbeRespIE(pAd, WSC_MSGTYPE_AP_WLAN_MGR, WSC_SCSTATE_CONFIGURED, FALSE, 0, 0);
	}

	MakeAllBssBeacon(pAd);
	UpdateAllBeaconFrame(pAd);
}

INT ComputeChecksum(
	IN UINT PIN)
{
	INT digit_s;
    UINT accum = 0;

	PIN *= 10;
	accum += 3 * ((PIN / 10000000) % 10); 
	accum += 1 * ((PIN / 1000000) % 10); 
	accum += 3 * ((PIN / 100000) % 10); 
	accum += 1 * ((PIN / 10000) % 10); 
	accum += 3 * ((PIN / 1000) % 10); 
	accum += 1 * ((PIN / 100) % 10); 
	accum += 3 * ((PIN / 10) % 10); 

	digit_s = (accum % 10);
	return ((10 - digit_s) % 10);
} // ComputeChecksum

BOOLEAN ValidateChecksum(
	IN UINT PIN)
{
	UINT accum = 0;

	accum += 3 * ((PIN / 10000000) % 10); 
	accum += 1 * ((PIN / 1000000) % 10); 
	accum += 3 * ((PIN / 100000) % 10); 
	accum += 1 * ((PIN / 10000) % 10); 
	accum += 3 * ((PIN / 1000) % 10); 
	accum += 1 * ((PIN / 100) % 10); 
	accum += 3 * ((PIN / 10) % 10); 
	accum += 1 * ((PIN / 1) % 10); 
	
    return (0 == (accum % 10));
} // ValidateChecksum

UINT WscGeneratePinCode(
	IN	PRTMP_ADAPTER	pAd,
// For AP Client support WPS Modification
	IN	BOOLEAN         bFromApcli,
// --
	IN	UCHAR			apidx)
{
	UCHAR	macAddr[MAC_ADDR_LEN];
	UINT 	iPin;
	UINT	checksum;

// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (bFromApcli)
		NdisMoveMemory(&macAddr[0], pAd->ApCliTab.ApCliEntry[apidx].CurrentAddress, MAC_ADDR_LEN);
	else
#endif // APCLI_SUPPORT //
// --
	NdisMoveMemory(&macAddr[0], pAd->PortCfg.MBSSID[apidx].Bssid, MAC_ADDR_LEN);

	iPin = macAddr[3] * 256 * 256 + macAddr[4] * 256 + macAddr[5];
	iPin = iPin % 10000000;
	checksum = ComputeChecksum( iPin );
	iPin = iPin*10 + checksum;

	return iPin;
}

// For Re-Generate Pin-Code Modification
UINT WscRandomGeneratePinCode(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			apidx)
{
	UINT 	iPin;
	UINT	checksum;

	iPin = RandomByte(pAd) * 256 * 256 + RandomByte(pAd) * 256 + RandomByte(pAd);

	iPin = iPin % 10000000;
	checksum = ComputeChecksum( iPin );
	iPin = iPin*10 + checksum;

	return iPin;
}
// --

VOID  WscInformFromWPA(
    IN  PMAC_TABLE_ENTRY    pEntry)
{
    // WPA_STATE_MACHINE informs this Entry is already WPA_802_1X_PORT_SECURED.
    RTMP_ADAPTER	*pAd = (PRTMP_ADAPTER)pEntry->pAd;

    if (pEntry->ApIdx != MAIN_MBSSID)
        return;

    DBGPRINT(RT_DEBUG_TRACE, "-----> WscInformFromWPA\n");
    
    if (MAC_ADDR_EQUAL(pEntry->Addr, pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EntryAddr))
    {
        pEntry->EnqueueEapolStartTimerForWscRunning = FALSE;
        RTMPCancelTimer(&pEntry->EnqueueEapolStartTimerForWsc);
        
        pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EntryApIdx = WSC_INIT_ENTRY_APIDX;
        RTMPCancelTimer(&pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EapolTimer);
        pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.EapolTimerRunning = FALSE;
        pEntry->bWscCapable = FALSE;
        pAd->PortCfg.MBSSID[pEntry->ApIdx].WscControl.WscState = WSC_STATE_CONFIGURED;

        DBGPRINT(RT_DEBUG_TRACE, "Reset EntryApIdx to %d\n", WSC_INIT_ENTRY_APIDX);
    }

    DBGPRINT(RT_DEBUG_TRACE, "<----- WscInformFromWPA\n");
}

VOID WscDelWPARetryTimer(
    IN  PRTMP_ADAPTER pAd)
{
    PMAC_TABLE_ENTRY    pEntry;
    UCHAR				apidx = MAIN_MBSSID;

    DBGPRINT(RT_DEBUG_TRACE, "<----- WscDelWPARetryTimer\n");
    
    pEntry = MacTableLookup(pAd, pAd->PortCfg.MBSSID[apidx].WscControl.EntryAddr);
    
    if (pEntry)
    {
        if (pEntry->RetryTimerRunning)
        {
            RTMPCancelTimer(&pEntry->RetryTimer);
            pEntry->RetryTimerRunning = FALSE;
        }
        pEntry->WpaState = AS_NOTUSE;
    }

    DBGPRINT(RT_DEBUG_TRACE, "<----- WscDelWPARetryTimer\n");
}

#ifdef APCLI_SUPPORT
// For AP Client support WPS Modification
/*
	========================================================================
	
	Routine Description:
		Make WSC IE for the ProbeReq frame

	Arguments:
		pAdapter    - NIC Adapter pointer
		pOutBuf		- all of WSC IE field 
		pIeLen		- length
		
	Return Value:
		None

	IRQL = DISPATCH_LEVEL
	
	Note:
		None
		
	========================================================================
*/
VOID WscMakeProbeReqIE(
	IN	PRTMP_ADAPTER	pAd,
	OUT	PUCHAR			pOutBuf,
	OUT	PUCHAR			pIeLen)
{
	UCHAR			WscIEFixed[] = {0xdd, 0x0e, 0x00, 0x50, 0xf2, 0x04};	// length will modify later
	UCHAR			Len;
	PUCHAR			pData;
	PWSC_REG_DATA	pReg;
	UCHAR 			Data[512];

	DBGPRINT(RT_DEBUG_INFO, "-----> WscMakeProbeReqIE\n");

	pReg = (PWSC_REG_DATA) &pAd->ApCliTab.ApCliEntry[0].WscControl.RegData;
	pData =  (PUCHAR) &Data[0];
	Len = 0;
	*pIeLen = 0;
	
	// 0. WSC fixed IE
	memcpy(pData, &WscIEFixed[0], 6);
	pData += 6;
	Len += 6;
				
	// 1. Version
	*((PUSHORT) pData) = cpu2be16(WSC_ID_VERSION);
	*((PUSHORT) (pData + 2)) = cpu2be16(0x0001);
	*(pData + 4) = pReg->EnrolleeInfo.Version;
	pData += 5;
	Len   += 5;

	// 2. Request Type, Enrollee, 802.1x
	*((PUSHORT) pData) = cpu2be16(WSC_ID_REQ_TYPE);
	*((PUSHORT) (pData + 2)) = cpu2be16(0x0001);
	*(pData + 4) = 0x01;
	pData += 5;
	Len   += 5;

	// 3. Config method
	*((PUSHORT) pData) = cpu2be16(WSC_ID_CONFIG_METHODS);
	*((PUSHORT) (pData + 2)) = cpu2be16(0x0002);
	*((PUSHORT) (pData + 4)) = pReg->EnrolleeInfo.ConfigMethods;		// Label, Display, PBC
	pData += 6;
	Len   += 6;

	// 4. UUID
	*((PUSHORT) pData) = cpu2be16(WSC_ID_UUID_E);
	*((PUSHORT) (pData + 2)) = cpu2be16(0x0010);	
	NdisMoveMemory((pData + 4), pReg->EnrolleeInfo.Uuid, 16);
	pData += 20;
	Len   += 20;

	// 5. Primary device type
	*((PUSHORT) pData) = cpu2be16(WSC_ID_PRIM_DEV_TYPE);
	*((PUSHORT) (pData + 2)) = cpu2be16(0x0008);	
	NdisMoveMemory((pData + 4), pReg->EnrolleeInfo.PriDeviceType, 8);
	pData += 12;
	Len   += 12;

	// 6. RF band, shall change based on current channel
	*((PUSHORT) pData) = cpu2be16(WSC_ID_RF_BAND);
	*((PUSHORT) (pData + 2)) = cpu2be16(0x0001);
	*(pData + 4) = pReg->EnrolleeInfo.RfBand;
	pData += 5;
	Len   += 5;

	// 7. Associate state
	*((PUSHORT) pData) = cpu2be16(WSC_ID_ASSOC_STATE);
	*((PUSHORT) (pData + 2)) = cpu2be16(0x0002);
	*((PUSHORT) (pData + 4)) = pReg->EnrolleeInfo.AssocState;	// Not associated
	pData += 6;
	Len   += 6;
				
	// 8. Config error
	*((PUSHORT) pData) = cpu2be16(WSC_ID_CONFIG_ERROR);
	*((PUSHORT) (pData + 2)) = cpu2be16(0x0002);
	*((PUSHORT) (pData + 4)) = pReg->EnrolleeInfo.ConfigError;	// No error
	pData += 6;
	Len   += 6;

	// 9. Device password ID
	*((PUSHORT) pData) = cpu2be16(WSC_ID_DEVICE_PWD_ID);
	*((PUSHORT) (pData + 2)) = cpu2be16(0x0002);
	*((PUSHORT) (pData + 4)) = pReg->EnrolleeInfo.DevPwdId;
	pData += 6;
	Len   += 6;

	// update the total length in vendor specific IE
	Data[1] = Len - 2;

	// fill in output buffer
	*pIeLen = Len;
	NdisMoveMemory(pOutBuf, &Data[0], *pIeLen);
	
	DBGPRINT(RT_DEBUG_INFO, "<----- WscMakeProbeReqIE\n");

}
// --
#endif // APCLI_SUPPORT //

VOID WscStop(
// For AP Client support WPS Modification
//	IN	PRTMP_ADAPTER	pAd)
	IN	PRTMP_ADAPTER	pAd,
	IN  PWSC_CTRL       pWscControl,
	IN  BOOLEAN         bFromApCli)
// --
{
	MAC_TABLE_ENTRY  *pEntry;
//	PWSC_CTRL pWscControl;
	PWSC_UPNP_NODE_INFO pWscUPnPInfo;
	UCHAR	apidx = MAIN_MBSSID;
	
//	pWscControl = &pAd->PortCfg.MBSSID[apidx].WscControl;
	pWscUPnPInfo = &pWscControl->WscUPnPNodeInfo;
	
	if(pWscUPnPInfo->bUPnPMsgTimerRunning == TRUE)
	{
		pWscUPnPInfo->bUPnPMsgTimerRunning = FALSE;
		RTMPCancelTimer(&pWscUPnPInfo->UPnPMsgTimer);
		pWscUPnPInfo->bUPnPMsgTimerPending = FALSE;
	}
	if(pWscUPnPInfo->bUPnPM2DTimerRunning)
	{
		pWscUPnPInfo->bUPnPM2DTimerRunning = FALSE;
		RTMPCancelTimer(&pWscUPnPInfo->UPnPM2DTimer);
	}
	
    pWscUPnPInfo->bUPnPInProgress = FALSE;
    pWscUPnPInfo->M2DACKBalance = 0;
	pWscUPnPInfo->registrarID = 0;

	if (pWscControl->Wsc2MinsTimerRunning)
	{
		pWscControl->Wsc2MinsTimerRunning = FALSE;
		RTMPCancelTimer(&pWscControl->Wsc2MinsTimer);
	}
// For AP Client support WPS Modification
//	if (pWscControl->EntryApIdx != WSC_INIT_ENTRY_APIDX)
	if ((!bFromApCli) && (pWscControl->EntryApIdx != WSC_INIT_ENTRY_APIDX))
// --
	{
	    pEntry = MacTableLookup(pAd, pWscControl->EntryAddr);
        
//		RTMPCancelTimer(&pWscControl->EapolTimer);
//        pWscControl->EapolTimerRunning = FALSE;

        if (pEntry) 
        {
            pEntry->bWscCapable = FALSE;
            if (pEntry->EnqueueEapolStartTimerForWscRunning)
            {
                RTMPCancelTimer(&pEntry->EnqueueEapolStartTimerForWsc);
                pEntry->EnqueueEapolStartTimerForWscRunning = FALSE;
            }
        }

        pWscControl->EntryApIdx = WSC_INIT_ENTRY_APIDX;
//        NdisZeroMemory(pWscControl->EntryAddr, MAC_ADDR_LEN);
	}
// For AP Client support WPS Modification
	RTMPCancelTimer(&pWscControl->EapolTimer);
	pWscControl->EapolTimerRunning = FALSE;
	NdisZeroMemory(pWscControl->EntryAddr, MAC_ADDR_LEN);
// --

	pWscControl->WscSelReg = 0;
	pWscControl->WscStatus = 0;
	pWscControl->WscState = WSC_STATE_OFF;
	pWscControl->lastId = 1;
    pWscControl->EapMsgRunning = FALSE;
    pWscControl->EapolTimerPending = FALSE;
    pWscControl->bWscTrigger = FALSE;
	
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
	if (!bFromApCli)
#endif // APCLI_SUPPORT //
// --
	{
		pAd->PortCfg.MBSSID[apidx].WscIEBeacon.ValueLen = 0;
		pAd->PortCfg.MBSSID[apidx].WscIEProbeResp.ValueLen = 0;
	}
}

VOID WscInit(
// For AP Client support WPS Modification
//	IN	PRTMP_ADAPTER	pAd)
	IN	PRTMP_ADAPTER	pAd,
	IN	BOOLEAN         bFromApCli,
	IN	PWSC_CTRL       pWscControl)
// --
{
//	UCHAR	apidx = MAIN_MBSSID;
	INT IsAPConfigured;

#ifdef OLD_DH_KEY
// For AP Client support WPS Modification
/*
	if (pAd->PortCfg.MBSSID[apidx].WscControl.pPubKeyMem)
		memset(pAd->PortCfg.MBSSID[apidx].WscControl.pPubKeyMem, 0, 15 * MAX_NN_DIGITS + 1);
	if (pAd->PortCfg.MBSSID[apidx].WscControl.pPubKeyMem)
		memset(pAd->PortCfg.MBSSID[apidx].WscControl.pPubKeyMem, 0, 15 * MAX_NN_DIGITS + 1);
*/
	if (pWscControl->pPubKeyMem)
		memset(pWscControl->pPubKeyMem, 0, 15 * MAX_NN_DIGITS + 1);
	if (pWscControl->pPubKeyMem)
		memset(pWscControl->pPubKeyMem, 0, 15 * MAX_NN_DIGITS + 1);
// --
#endif //OLD_DH_KEY
    if (pWscControl->WscConfMode == WSC_DISABLE)
    {
// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
        if (!bFromApCli)
#endif // APCLI_SUPPORT //
// --
        {
                pAd->PortCfg.MBSSID[MAIN_MBSSID].WscIEBeacon.ValueLen = 0;
                pAd->PortCfg.MBSSID[MAIN_MBSSID].WscIEProbeResp.ValueLen = 0;
        }
    }
    else
    {
// For AP Client support WPS Modification
/*
        IsAPConfigured = pAd->PortCfg.MBSSID[apidx].WscControl.WscConfStatus;
        WscInitRegistrarPair(pAd);
        pAd->PortCfg.MBSSID[apidx].WscControl.WscStatus = STATUS_WSC_IDLE;
*/
        WscInitRegistrarPair(pAd, bFromApCli, pWscControl);
        pWscControl->WscStatus = STATUS_WSC_IDLE;
#ifdef APCLI_SUPPORT
        if (!bFromApCli)
#endif // APCLI_SUPPORT //
// --
        {
            IsAPConfigured = pWscControl->WscConfStatus;
            WscBuildBeaconIE(pAd, IsAPConfigured, FALSE, 0, 0);
            WscBuildProbeRespIE(pAd, WSC_MSGTYPE_AP_WLAN_MGR, IsAPConfigured, FALSE, 0, 0);

            MakeAllBssBeacon(pAd);
            UpdateAllBeaconFrame(pAd);
        }
    }
}

USHORT WscGetAuthType(
    IN NDIS_802_11_AUTHENTICATION_MODE authType)
{
	switch(authType)
	{
		case Ndis802_11AuthModeOpen:
			return WSC_AUTHTYPE_OPEN;
		case Ndis802_11AuthModeWPAPSK:
			return WSC_AUTHTYPE_WPAPSK;
		case Ndis802_11AuthModeShared:
			return WSC_AUTHTYPE_SHARED;
		case Ndis802_11AuthModeWPA:
			return WSC_AUTHTYPE_WPA;
		case Ndis802_11AuthModeWPA2:
			return WSC_AUTHTYPE_WPA2;
        default:
		case Ndis802_11AuthModeWPA2PSK:
			return WSC_AUTHTYPE_WPA2PSK;
	}
}

USHORT WscGetEncryType(
    IN NDIS_802_11_WEP_STATUS encryType)
{
	switch(encryType)
	{
		case Ndis802_11WEPDisabled:
			return WSC_ENCRTYPE_NONE;
		case Ndis802_11WEPEnabled:
			return WSC_ENCRTYPE_WEP;
        default:
		case Ndis802_11Encryption2Enabled:
			return WSC_ENCRTYPE_TKIP;
		case Ndis802_11Encryption3Enabled:
			return WSC_ENCRTYPE_AES;
	}
}

PCHAR   WscGetAuthTypeStr(
    IN  USHORT authFlag)
{
	switch(authFlag)
	{
		case WSC_AUTHTYPE_OPEN:
			return "OPEN";
        default:
		case WSC_AUTHTYPE_WPAPSK:
			return "WPAPSK";
		case WSC_AUTHTYPE_SHARED:
			return "SHARED";
		case WSC_AUTHTYPE_WPA:
			return "WPA";
		case WSC_AUTHTYPE_WPA2:
			return "WPA2";
		case WSC_AUTHTYPE_WPA2PSK:
			return "WPA2PSK";
	}
}

PCHAR   WscGetEncryTypeStr(
    IN  USHORT encryFlag)
{
	switch(encryFlag)
	{
		case WSC_ENCRTYPE_NONE:
			return "NONE";
		case WSC_ENCRTYPE_WEP:
			return "WEP";
        default:
		case WSC_ENCRTYPE_TKIP:
			return "TKIP";
		case WSC_ENCRTYPE_AES:
			return "AES";
	}
}

void    WscWriteConfToPortCfg(
    IN  PRTMP_ADAPTER   pAd,
    IN  MAC_TABLE_ENTRY *pEntry,
    IN  BOOLEAN         bEnrollee)
{
    UCHAR               CurApIdx;
    PWSC_PROFILE	    pProfile;
    PWSC_CTRL           pWscControl;

    DBGPRINT(RT_DEBUG_TRACE, "-----> WscWriteConfToPortCfg\n");
    
    if (pEntry)
        CurApIdx = pEntry->ApIdx;
    else
        CurApIdx = MAIN_MBSSID;

    pWscControl = &pAd->PortCfg.MBSSID[CurApIdx].WscControl;

    if (bEnrollee)
    {
        pProfile = (PWSC_PROFILE) &pAd->PortCfg.MBSSID[CurApIdx].WscControl.WscProfile;
        
        NdisZeroMemory(pAd->PortCfg.MBSSID[CurApIdx].Ssid, MAX_LEN_OF_SSID);
    	NdisMoveMemory(pAd->PortCfg.MBSSID[CurApIdx].Ssid, pProfile->Profile[0].SSID.Ssid, pProfile->Profile[0].SSID.SsidLength);
    	pAd->PortCfg.MBSSID[CurApIdx].SsidLen = pProfile->Profile[0].SSID.SsidLength;

        DBGPRINT(RT_DEBUG_TRACE, "AuthType: %d, EncrType: %d\n", pProfile->Profile[0].AuthType, pProfile->Profile[0].EncrType);
        if ((pProfile->Profile[0].AuthType == WSC_AUTHTYPE_WPAPSK) || 
            (pProfile->Profile[0].AuthType == WSC_AUTHTYPE_WPA2PSK))
        {
            if ((pProfile->Profile[0].EncrType != WSC_ENCRTYPE_TKIP) && (pProfile->Profile[0].EncrType != WSC_ENCRTYPE_AES))
            {
                DBGPRINT(RT_DEBUG_TRACE, "AuthType is WPAPSK or WPA2PAK.\n"
                                         "Get illegal EncrType(%d) from External Registrar, set EncrType to TKIP\n", 
                                          pProfile->Profile[0].EncrType);
                pProfile->Profile[0].EncrType = WSC_ENCRTYPE_TKIP;
            }
        }
        WscSetAuthMode(pAd, WscGetAuthTypeStr(pProfile->Profile[0].AuthType));
        WscSetEncrypType(pAd, WscGetEncryTypeStr(pProfile->Profile[0].EncrType));
        if (pProfile->Profile[0].EncrType != WSC_ENCRTYPE_NONE)
        {
            if ((pProfile->Profile[0].EncrType == WSC_ENCRTYPE_TKIP) ||
                (pProfile->Profile[0].EncrType == WSC_ENCRTYPE_AES))
            {
                pAd->PortCfg.MBSSID[CurApIdx].DefaultKeyId = 1;                
                if (pProfile->Profile[0].KeyLength >= 8 && pProfile->Profile[0].KeyLength <= 64)
                {
                    pWscControl->WpaPskLen = pProfile->Profile[0].KeyLength;
                    memset(pWscControl->WpaPsk, 0, 64);
                    memcpy(pWscControl->WpaPsk, pProfile->Profile[0].Key, pWscControl->WpaPskLen);

                    if (pWscControl->WpaPskLen == 64)
                	{
                	    AtoH(pWscControl->WpaPsk, pAd->PortCfg.MBSSID[CurApIdx].PMK, 32);
                	}
                	else
                	{
                	    UCHAR       keyMaterial[40] = {0};
                	    PasswordHash((CHAR *)pWscControl->WpaPsk, 
                                     pAd->PortCfg.MBSSID[CurApIdx].Ssid, pAd->PortCfg.MBSSID[CurApIdx].SsidLen, keyMaterial);
                	    NdisMoveMemory(pAd->PortCfg.MBSSID[CurApIdx].PMK, keyMaterial, 32);
                	}
                    DBGPRINT(RT_DEBUG_TRACE, "WpaPskLen = %d\n", pWscControl->WpaPskLen);
                }
                else
                {
                    pWscControl->WpaPskLen = 0;
                    DBGPRINT(RT_DEBUG_TRACE, "WPAPSK: Invalid Key Length (%d)\n", pProfile->Profile[0].KeyLength);
                }
            }
            else if (pProfile->Profile[0].EncrType == WSC_ENCRTYPE_WEP)
            {
                UCHAR   WepKeyId = 0;
                USHORT  WepKeyLen = pProfile->Profile[0].KeyLength;
				
				WepKeyId = pProfile->Profile[0].KeyIndex;
                if ((WepKeyId >= 0) && (WepKeyId <=3))
                {
                    pAd->PortCfg.MBSSID[CurApIdx].DefaultKeyId = WepKeyId;
                    // 5 or 13 ASCII characters
                    // 10 or 26 Hex characters
                    if (WepKeyLen == 5 || WepKeyLen == 13 || WepKeyLen == 10 || WepKeyLen == 26)
                    {
                        if (WepKeyLen == 5 || WepKeyLen == 13)
                        {
                            pAd->PortCfg.MBSSID[CurApIdx].SharedKey[WepKeyId].KeyLen = WepKeyLen;
                            memcpy(pAd->PortCfg.MBSSID[CurApIdx].SharedKey[WepKeyId].Key, 
                                   pProfile->Profile[0].Key, 
                                   WepKeyLen);
                            if (WepKeyLen == 5)
                                pAd->PortCfg.MBSSID[CurApIdx].SharedKey[WepKeyId].CipherAlg = CIPHER_WEP64;
                            else
                                pAd->PortCfg.MBSSID[CurApIdx].SharedKey[WepKeyId].CipherAlg = CIPHER_WEP128;
                            pAd->PortCfg.MBSSID[CurApIdx].SharedKey[WepKeyId].WepKeyType = WEP_ASCII_TYPE;
                        }
                        else
                        {
                            pAd->PortCfg.MBSSID[CurApIdx].SharedKey[WepKeyId].KeyLen = WepKeyLen/2;
                            AtoH(pProfile->Profile[0].Key, pAd->PortCfg.MBSSID[CurApIdx].SharedKey[WepKeyId].Key, WepKeyLen/2);
                            if (WepKeyLen == 10)
                                pAd->PortCfg.MBSSID[CurApIdx].SharedKey[WepKeyId].CipherAlg = CIPHER_WEP64;
                            else
                                pAd->PortCfg.MBSSID[CurApIdx].SharedKey[WepKeyId].CipherAlg = CIPHER_WEP128;
                            pAd->PortCfg.MBSSID[CurApIdx].SharedKey[WepKeyId].WepKeyType = WEP_HEXADECIMAL_TYPE;
                        }
                    }
                    else
                        DBGPRINT(RT_DEBUG_TRACE, "WEP: Invalid Key Length (%d)\n", pProfile->Profile[0].KeyLength);
                }
                else
               	{
               		DBGPRINT(RT_DEBUG_TRACE, "Unsupport default key index (%d), use key Index 1.\n", WepKeyId);
               		pAd->PortCfg.MBSSID[CurApIdx].DefaultKeyId = WepKeyId = 0;
                }
            }
        }
    }
    else
    {
        pAd->PortCfg.MBSSID[CurApIdx].DefaultKeyId = 1;
        WscSetAuthMode(pAd, "WPAPSK");
        WscSetEncrypType(pAd, "TKIP");
        pWscControl->WpaPskLen = pWscControl->RegData.RegistrarInfo.NewKeyLen;
        memset(pWscControl->WpaPsk, 0, 64);
        memcpy(pWscControl->WpaPsk, pWscControl->RegData.RegistrarInfo.NewKey, pWscControl->WpaPskLen);
        AtoH(pWscControl->WpaPsk, pAd->PortCfg.MBSSID[CurApIdx].PMK, 32);
    }    

    DBGPRINT(RT_DEBUG_TRACE, "<----- WscWriteConfToPortCfg\n");
}

void    WscWriteConfToDatFile(
    IN  PRTMP_ADAPTER pAd)
{
    PCHAR				fileName, cfgData = 0;
    struct file			*file_r, *file_w;
    INT 				orgfsuid, orgfsgid;
   	mm_segment_t		orgfs;
    PWSC_PROFILE	    pProfile;
    ssize_t             rv, fileLen = 0;
    CHAR                *offset = 0;
    CHAR                *pTempStr = 0;
    int                 index = 0;
    UCHAR				apidx = MAIN_MBSSID;
    int i;  // add by johnli

    DBGPRINT(RT_DEBUG_TRACE, "-----> WscWriteConfToDatFile\n");

    pProfile = (PWSC_PROFILE) &pAd->PortCfg.MBSSID[apidx].WscControl.WscProfile;
    
    fileName = PROFILE_PATH;

    // Save uid and gid used for filesystem access.
	// Set user and group to 0 (root)	
	orgfsuid = current->fsuid;
	orgfsgid = current->fsgid;
	current->fsuid = current->fsgid = 0;    
	orgfs = get_fs();
    set_fs(KERNEL_DS);
    
    file_r = filp_open(fileName, O_RDONLY, 0);
	if (IS_ERR(file_r)) 
	{
		DBGPRINT(RT_DEBUG_TRACE, "-->1) %s: Error %ld opening %s\n", __FUNCTION__, -PTR_ERR(file_r), fileName);    
        return;
	}
	else 
	{
	    if (file_r->f_op && file_r->f_op->read) 
		{
		    char tempStr[64] = {0};            
            while ((rv = file_r->f_op->read(file_r, tempStr, 64, &file_r->f_pos)) > 0)
            {
                fileLen += rv;
            }
            cfgData = kmalloc(fileLen, MEM_ALLOC_FLAG);
            if (cfgData == NULL)
            {
                filp_close(file_r, NULL);
                DBGPRINT(RT_DEBUG_TRACE, "CfgData kmalloc fail. (fileLen = %d)\n", fileLen);
                goto out;
            }
            NdisZeroMemory(cfgData, fileLen);
            file_r->f_pos = 0;
            rv = file_r->f_op->read(file_r, cfgData, fileLen, &file_r->f_pos);
            if (rv != fileLen)
            {
                filp_close(file_r, NULL);
                DBGPRINT(RT_DEBUG_TRACE, "CfgData kmalloc fail, fileLen = %d\n", fileLen);
                goto ReadErr;
            }
        }
        filp_close(file_r, NULL);
    }

    file_w = filp_open(fileName, O_WRONLY|O_TRUNC, 0);
    if (IS_ERR(file_w)) 
	{
		DBGPRINT(RT_DEBUG_TRACE, "-->2) %s: Error %ld opening %s\n", __FUNCTION__, -PTR_ERR(file_w), fileName);    
        goto WriteFileOpenErr;
	}
	else 
	{
	    if (file_w->f_op && file_w->f_op->write) 
		{
            offset = rtstrstr(cfgData, "Default\n");
            offset += strlen("Default\n");
            file_w->f_op->write(file_w, cfgData, (size_t)(offset - cfgData), &file_w->f_pos);
            pTempStr = kmalloc(512, MEM_ALLOC_FLAG);
            if (!pTempStr)
            {
                DBGPRINT(RT_DEBUG_TRACE, "pTempStr kmalloc fail. (512)\n");
                filp_close(file_w, NULL);
                goto WriteErr;
            }
		    for (;;)
            {                
                NdisZeroMemory(pTempStr, 512);
//                sscanf(offset, "%s\n", pTempStr);  // remove by johnli
                if ((size_t)(offset - cfgData) < fileLen)
                {
			// add by johnli, read a line include blank spaces
			for (i=0;i<512;i++)
			{
				if (offset[i] != '\n')
					pTempStr[i] = offset[i];
				else
				{
					pTempStr[i] = '\0';
					break;
				}
			}
			// end johnli
                    offset += strlen(pTempStr) + 1;

                    if (rtstrstr(pTempStr, "SSID=") && 
                        !rtstrstr(pTempStr, "NoForwardingBTNBSSID") && 
                        !rtstrstr(pTempStr, "HideSSID"))
                    {
                        NdisZeroMemory(pTempStr, 512);
                        sprintf(pTempStr, "SSID=");
                        for (index = 0; index < MAX_MBSSID_NUM; index++)
                        {
                            if (pAd->PortCfg.MBSSID[index].SsidLen)
                            {
                                if (index == 0)
                                    sprintf(pTempStr, "%s%s", pTempStr, pAd->PortCfg.MBSSID[index].Ssid);
                                else
                                    sprintf(pTempStr, "%s;%s", pTempStr, pAd->PortCfg.MBSSID[index].Ssid);
                            }
                        }
                    }
                    else if (rtstrstr(pTempStr, "AuthMode=") &&
                             !rtstrstr(pTempStr, "ApCliAuthMode"))
                    {
                        NdisZeroMemory(pTempStr, 512);
                        sprintf(pTempStr, "AuthMode=");
                        for (index = 0; index < MAX_MBSSID_NUM; index++)
                        {
                            if (pAd->PortCfg.MBSSID[index].SsidLen)
                            {
                                USHORT auth_flag = WscGetAuthType(pAd->PortCfg.MBSSID[index].AuthMode);
                                if (index == 0)
                                    sprintf(pTempStr, "%s%s", pTempStr, WscGetAuthTypeStr(auth_flag));
                                else
                                    sprintf(pTempStr, "%s;%s", pTempStr, WscGetAuthTypeStr(auth_flag));
                            }
                        }
                    }
                    else if (rtstrstr(pTempStr, "EncrypType=") &&
                             !rtstrstr(pTempStr, "WdsEncrypType") &&
                             !rtstrstr(pTempStr, "ApCliEncrypType"))
                    {
                        NdisZeroMemory(pTempStr, 512);
                        sprintf(pTempStr, "EncrypType=");
                        for (index = 0; index < MAX_MBSSID_NUM; index++)
                        {
                            if (pAd->PortCfg.MBSSID[index].SsidLen)
                            {
                                USHORT encrypt_flag = WscGetEncryType(pAd->PortCfg.MBSSID[index].WepStatus);
                                if (index == 0)
                                    sprintf(pTempStr, "%s%s", pTempStr, WscGetEncryTypeStr(encrypt_flag));
                                else
                                    sprintf(pTempStr, "%s;%s", pTempStr, WscGetEncryTypeStr(encrypt_flag));
                            }
                        }
                    }
                    else if (rtstrstr(pTempStr, "WPAPSK=") &&
                             !rtstrstr(pTempStr, "ApCliWPAPSK"))
                    {
                        NdisZeroMemory(pTempStr, 512);
                        sprintf(pTempStr, "WPAPSK=");
                        if (pAd->PortCfg.MBSSID[apidx].WscControl.WpaPskLen >=8 &&
                            pAd->PortCfg.MBSSID[apidx].WscControl.WpaPskLen <=64)
                            NdisMoveMemory(pTempStr+7, pAd->PortCfg.MBSSID[apidx].WscControl.WpaPsk, 
                                                       pAd->PortCfg.MBSSID[apidx].WscControl.WpaPskLen);
                    }
                    else if (rtstrstr(pTempStr, "WscConfStatus="))
                    {
                    	NdisZeroMemory(pTempStr, 512);
                    	sprintf(pTempStr, "WscConfStatus=%d", pAd->PortCfg.MBSSID[apidx].WscControl.WscConfStatus);
                    }
                    else if (rtstrstr(pTempStr, "DefaultKeyID=") &&
                             !rtstrstr(pTempStr, "ApCliDefaultKeyID"))
                    {
                        NdisZeroMemory(pTempStr, 512);
                    	sprintf(pTempStr, "DefaultKeyID=%d", pAd->PortCfg.MBSSID[apidx].DefaultKeyId+1);
                    }
                    file_w->f_op->write(file_w, pTempStr, strlen(pTempStr), &file_w->f_pos);
                    file_w->f_op->write(file_w, "\n", 1, &file_w->f_pos);
                }
                else
                {
                    break;
                }
        }
    }
        filp_close(file_w, NULL);
    }

WriteErr:   
    if (pTempStr)
        kfree(pTempStr);
ReadErr:
WriteFileOpenErr:    
    if (cfgData)
        kfree(cfgData);
out:
    set_fs(orgfs);
    current->fsuid = orgfsuid;
	current->fsgid = orgfsgid;

    DBGPRINT(RT_DEBUG_TRACE, "<----- WscWriteConfToDatFile\n");
    return;
}

void start_write_dat_file_thread(
    IN  PRTMP_ADAPTER pAd)
{
    DBGPRINT(RT_DEBUG_TRACE, "-----> start_write_dat_file_thread\n");
    pAd->write_dat_file_pid = -1;
    pAd->time_to_die = 0;
    pAd->write_dat_file_pid = kernel_thread(write_dat_file_thread, pAd, CLONE_VM);
	if (pAd->write_dat_file_pid < 0) {
		printk (KERN_WARNING "unable to start kernel write dat file thread\n");
	}
    wait_for_completion (&pAd->write_dat_file_notify);
    DBGPRINT(RT_DEBUG_TRACE, "<----- start_write_dat_file_thread\n");
}

INT write_dat_file_thread (
    IN void *Context)
{
	PRTMP_ADAPTER   pAd = (PRTMP_ADAPTER)Context;	

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
    daemonize("%s", pAd->net_dev->name);
#else
    daemonize();
#endif
	current->flags |= PF_NOFREEZE;
    /* signal that we've started the thread */
	complete(&(pAd->write_dat_file_notify));
#if 1    
	while (1) {
        /* lock the device pointers */
		down(&(pAd->write_dat_file_semaphore));
        
		if (pAd->time_to_die)
			break;

        /* device had been closed */
    	if (RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_REMOVE_IN_PROGRESS))
    		continue;

        if (pAd->WriteWscCfgToDatFile)
        {
            WscWriteConfToDatFile(pAd);
            pAd->WriteWscCfgToDatFile = FALSE;
        }
	}
#endif
    complete_and_exit (&pAd->write_dat_file_notify, 0);
    return 0;
}

BOOLEAN WscCheckNonce(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	MLME_QUEUE_ELEM	*pElem,
	IN  BOOLEAN         bFlag,
// For AP Client support WPS Modification
	IN  PWSC_CTRL       pWscControl)
// --
{
    USHORT				Length;
	PUCHAR				pData;
	USHORT				WscType, WscLen, WscId;

    DBGPRINT(RT_DEBUG_TRACE, "-----> WscCheckNonce\n");
    
    if (bFlag)
    {
        // check Registrar Nonce
        WscId = WSC_ID_REGISTRAR_NONCE;
        DBGPRINT(RT_DEBUG_TRACE, "check Registrar Nonce\n");
    }
    else
    {
        // check Enrollee Nonce
        WscId = WSC_ID_ENROLLEE_NONCE;
        DBGPRINT(RT_DEBUG_TRACE, "check Enrollee Nonce\n");
    }
    
    pData = pElem->Msg;
    Length = pElem->MsgLen;

    // We have to look for WSC_IE_MSG_TYPE to classify M2 ~ M8, the remain size must large than 4
	while (Length > 4)
	{
		WSC_TLV_0B	TLV_Recv;
        char ZeroNonce[16] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
        
		memcpy((u8 *)&TLV_Recv, pData, 4);
		WscType = cpu2be16(TLV_Recv.tag);
		WscLen  = cpu2be16(TLV_Recv.len);
		pData  += 4;
		Length -= 4;
        
		if (WscType == WscId)
		{
			if (RTMPCompareMemory(pWscControl->RegData.SelfNonce, pData, 16) == 0)
			{
			    DBGPRINT(RT_DEBUG_TRACE, "Nonce match!!\n");
                DBGPRINT(RT_DEBUG_TRACE, "<----- WscCheckNonce\n");
				return TRUE;
			}
            else if (NdisEqualMemory(pData, ZeroNonce, 16))
            {
                // Intel external registrar will send WSC_NACK with enrollee nonce
                // "10 1A 00 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00"
                // when AP is configured and user selects not to configure AP.
                DBGPRINT(RT_DEBUG_TRACE, "Zero Enrollee Nonce!!\n");
                DBGPRINT(RT_DEBUG_TRACE, "<----- WscCheckNonce\n");
                return TRUE;
            }
		}
        
		// Offset to net WSC Ie
		pData  += WscLen;
		Length -= WscLen;
	}

    DBGPRINT(RT_DEBUG_TRACE, "Nonce mismatch!!\n");
    DBGPRINT(RT_DEBUG_TRACE, "<----- WscCheckNonce\n");
    return FALSE;
}

VOID    WscGetRegDataPIN(
    IN  PRTMP_ADAPTER   pAdapter,
    IN  UINT            PinCode,
// For AP Client support WPS Modification
    IN  PWSC_CTRL       pWscControl)
// --
{
//    UCHAR   apidx = MAIN_MBSSID;
	UCHAR	tempPIN[9] = {0};

    if (pWscControl->WscMode == 2)
        pWscControl->WscPinCode = 0;
    else
        pWscControl->WscPinCode = PinCode;

    memset(pWscControl->RegData.PIN, 0, 8);
	if (pWscControl->WscPinCode == 0)
		sprintf(tempPIN, "00000000");
	else
		sprintf(tempPIN, "%8u", pWscControl->WscPinCode);
	memcpy(pWscControl->RegData.PIN, tempPIN, 8);
}

VOID    WscEapActionDisabled(
    IN  PRTMP_ADAPTER       pAdapter,
// For AP Client support WPS Modification
    IN  PWSC_CTRL           pWscControl)
// --
{
    INT     DataLen = 0;
    UCHAR   WscData[60] = {0};

    pWscControl->RegData.EnrolleeInfo.ConfigError = WSC_ERROR_DEVICE_BUSY;
// For AP Client support WPS Modification
/*    
    DataLen = BuildMessageNACK(pAdapter,WscData);
    WscSendMessage(pAdapter, WSC_OPCODE_NACK, WscData, DataLen);
*/
    DataLen = BuildMessageNACK(pAdapter, pWscControl, WscData);

#ifdef APCLI_SUPPORT
    if (pWscControl->EntryApIdx == MIN_NET_DEVICE_FOR_APCLI)
        WscSendMessage(pAdapter, WSC_OPCODE_NACK, WscData, DataLen, pWscControl, TRUE);
    else
#endif // APCLI_SUPPORT //
        WscSendMessage(pAdapter, WSC_OPCODE_NACK, WscData, DataLen, pWscControl, FALSE);
// --
    
    RTMPCancelTimer(&pWscControl->EapolTimer);
    pWscControl->EapolTimerRunning = FALSE;
}

// <<Reject Same PinCode>> ++, edit by johnli
//VOID    WscGetConfigErrFromNack(
USHORT    WscGetConfigErrFromNack(
// <<Reject Same PinCode>> --
    IN  PRTMP_ADAPTER       pAdapter,
    IN	MLME_QUEUE_ELEM	    *pElem)
{
    USHORT				Length = 0;
	PUCHAR				pData;
	USHORT				WscType, WscLen, ConfigError = 0;

    pData = pElem->Msg;
    Length = pElem->MsgLen;
    
	while (Length > 4)
	{
		WSC_TLV_0B	TLV_Recv;
		memcpy((u8 *)&TLV_Recv, pData, 4);
		WscType = cpu2be16(TLV_Recv.tag);
		WscLen  = cpu2be16(TLV_Recv.len);
		pData  += 4;
		Length -= 4;
        
		if (WscType == WSC_ID_CONFIG_ERROR)
		{
			NdisMoveMemory(&ConfigError, pData, sizeof(USHORT));
		    DBGPRINT(RT_DEBUG_TRACE, "WSC_ID_CONFIG_ERROR: %d\n", ntohs(ConfigError));
			// <<Reject Same PinCode>> ++, edit by johnli
			//return;
			return ntohs(ConfigError);
			// <<Reject Same PinCode>> --
		}
        
		// Offset to net WSC Ie
		pData  += WscLen;
		Length -= WscLen;
	}
    DBGPRINT(RT_DEBUG_TRACE, "WSC_ID_CONFIG_ERROR is missing\n");
    return 0;  // <<Reject Same PinCode>> ++, add by johnli
}

INT	WscSetAuthMode(
	IN	PRTMP_ADAPTER	pAd, 
	IN	PUCHAR			arg)
{
	ULONG       sec_csr4 = 0;
    UCHAR       apidx = MAIN_MBSSID;

	if ((strcmp(arg, "WEPAUTO") == 0) || (strcmp(arg, "wepauto") == 0))
		pAd->PortCfg.MBSSID[apidx].AuthMode = Ndis802_11AuthModeAutoSwitch;
	else if ((strcmp(arg, "OPEN") == 0) || (strcmp(arg, "open") == 0))
		pAd->PortCfg.MBSSID[apidx].AuthMode = Ndis802_11AuthModeOpen;
	else if ((strcmp(arg, "SHARED") == 0) || (strcmp(arg, "shared") == 0))
		pAd->PortCfg.MBSSID[apidx].AuthMode = Ndis802_11AuthModeShared;
	else if ((strcmp(arg, "WPAPSK") == 0) || (strcmp(arg, "wpapsk") == 0))
		pAd->PortCfg.MBSSID[apidx].AuthMode = Ndis802_11AuthModeWPAPSK;
	else if ((strcmp(arg, "WPA2PSK") == 0) || (strcmp(arg, "wpa2psk") == 0))
		pAd->PortCfg.MBSSID[apidx].AuthMode = Ndis802_11AuthModeWPA2PSK;

	pAd->PortCfg.MBSSID[apidx].PortSecured = WPA_802_1X_PORT_NOT_SECURED;
    RTMPMakeRSNIE(pAd, pAd->PortCfg.MBSSID[apidx].AuthMode, pAd->PortCfg.MBSSID[apidx].WepStatus, apidx);

	// set key table enable bit
	RTMP_IO_READ32(pAd, SEC_CSR4, &sec_csr4);
    if (pAd->PortCfg.MBSSID[apidx].AuthMode >= Ndis802_11AuthModeWPA)
    {
    	sec_csr4 |= BIT32[apidx];
        DBGPRINT(RT_DEBUG_TRACE, "AP AuthMode=%d, Pairwise Key Table in-used\n", pAd->PortCfg.MBSSID[apidx].AuthMode);
    }
    else
    {
    	sec_csr4 &= ~BIT32[apidx];
        DBGPRINT(RT_DEBUG_TRACE, "AP AuthMode=%d, disable Pairwise Key Table\n", pAd->PortCfg.MBSSID[apidx].AuthMode);
    }
    RTMP_IO_WRITE32(pAd, SEC_CSR4, sec_csr4);

	DBGPRINT(RT_DEBUG_TRACE, "IF(raL%d) Set_AuthMode_Proc::(AuthMode=%d, sec_csr4=0x%x)\n", apidx, pAd->PortCfg.MBSSID[apidx].AuthMode, sec_csr4);

	return TRUE;
}

INT	WscSetEncrypType(
	IN	PRTMP_ADAPTER	pAd, 
	IN	PUCHAR			arg)
{
    UCHAR       apidx = MAIN_MBSSID;
    
	if ((strcmp(arg, "NONE") == 0) || (strcmp(arg, "none") == 0))
		pAd->PortCfg.MBSSID[apidx].WepStatus = Ndis802_11WEPDisabled;
	else if ((strcmp(arg, "WEP") == 0) || (strcmp(arg, "wep") == 0))
		pAd->PortCfg.MBSSID[apidx].WepStatus = Ndis802_11WEPEnabled;
	else if ((strcmp(arg, "TKIP") == 0) || (strcmp(arg, "tkip") == 0))
		pAd->PortCfg.MBSSID[apidx].WepStatus = Ndis802_11Encryption2Enabled;
	else if ((strcmp(arg, "AES") == 0) || (strcmp(arg, "aes") == 0))
		pAd->PortCfg.MBSSID[apidx].WepStatus = Ndis802_11Encryption3Enabled;

    RTMPMakeRSNIE(pAd, pAd->PortCfg.MBSSID[apidx].AuthMode, pAd->PortCfg.MBSSID[apidx].WepStatus, apidx);

	return TRUE;
}

// For AP Client support WPS Modification
#ifdef APCLI_SUPPORT
void    WscWriteConfToApCliCfg(
    IN  PRTMP_ADAPTER   pAd,
    IN  BOOLEAN         bEnrollee)
{
    UCHAR               CurApIdx = MAIN_MBSSID;
    PWSC_PROFILE	    pProfile;
    PWSC_CTRL           pWscControl;

    DBGPRINT(RT_DEBUG_TRACE, "-----> WscWriteConfToApCliCfg\n");
    
    pWscControl = &pAd->ApCliTab.ApCliEntry[CurApIdx].WscControl;

    {
        pProfile = (PWSC_PROFILE) &pWscControl->WscProfile;
        NdisZeroMemory(pAd->ApCliTab.ApCliEntry[CurApIdx].Ssid, MAX_LEN_OF_SSID);
    	NdisMoveMemory(pAd->ApCliTab.ApCliEntry[CurApIdx].Ssid, pProfile->Profile[0].SSID.Ssid, pProfile->Profile[0].SSID.SsidLength);
    	pAd->ApCliTab.ApCliEntry[CurApIdx].SsidLen = pProfile->Profile[0].SSID.SsidLength;

        NdisZeroMemory(pAd->ApCliTab.ApCliEntry[CurApIdx].CfgSsid, MAX_LEN_OF_SSID);
    	NdisMoveMemory(pAd->ApCliTab.ApCliEntry[CurApIdx].CfgSsid, pProfile->Profile[0].SSID.Ssid, pProfile->Profile[0].SSID.SsidLength);
    	pAd->ApCliTab.ApCliEntry[CurApIdx].CfgSsidLen = pProfile->Profile[0].SSID.SsidLength;

        DBGPRINT(RT_DEBUG_TRACE, "AuthType: %d, EncrType: %d\n", pProfile->Profile[0].AuthType, pProfile->Profile[0].EncrType);
        if ((pProfile->Profile[0].AuthType == WSC_AUTHTYPE_WPAPSK) || 
            (pProfile->Profile[0].AuthType == WSC_AUTHTYPE_WPA2PSK))
        {
            if ((pProfile->Profile[0].EncrType != WSC_ENCRTYPE_TKIP) && (pProfile->Profile[0].EncrType != WSC_ENCRTYPE_AES))
            {
                DBGPRINT(RT_DEBUG_TRACE, "AuthType is WPAPSK or WPA2PAK.\n"
                                         "Get illegal EncrType(%d) from External Registrar, set EncrType to TKIP\n", 
                                          pProfile->Profile[0].EncrType);
                pProfile->Profile[0].EncrType = WSC_ENCRTYPE_TKIP;
            }
        }
        Set_ApCli_AuthMode_Proc(pAd, WscGetAuthTypeStr(pProfile->Profile[0].AuthType));
        Set_ApCli_EncrypType_Proc(pAd, WscGetEncryTypeStr(pProfile->Profile[0].EncrType));
        if (pProfile->Profile[0].EncrType != WSC_ENCRTYPE_NONE)
        {
            if ((pProfile->Profile[0].EncrType == WSC_ENCRTYPE_TKIP) ||
                (pProfile->Profile[0].EncrType == WSC_ENCRTYPE_AES))
            {
                pAd->ApCliTab.ApCliEntry[CurApIdx].DefaultKeyId = 1;

                if (pProfile->Profile[0].KeyLength >= 8 && pProfile->Profile[0].KeyLength <= 64)
                {
                    pWscControl->WpaPskLen = pProfile->Profile[0].KeyLength;
                    memset(pWscControl->WpaPsk, 0, 64);
                    memcpy(pWscControl->WpaPsk, pProfile->Profile[0].Key, pWscControl->WpaPskLen);

                    if (pWscControl->WpaPskLen == 64)
                	{
                	    AtoH(pWscControl->WpaPsk, pAd->ApCliTab.ApCliEntry[CurApIdx].PMK, 32);
                	}
                	else
                	{
                	    UCHAR       keyMaterial[40] = {0};
                	    PasswordHash((CHAR *)pWscControl->WpaPsk, 
                                     pAd->ApCliTab.ApCliEntry[CurApIdx].Ssid, pAd->ApCliTab.ApCliEntry[CurApIdx].SsidLen, keyMaterial);
                	    NdisMoveMemory(pAd->ApCliTab.ApCliEntry[CurApIdx].PMK, keyMaterial, 32);

                	}
                    pAd->ApCliTab.ApCliEntry[CurApIdx].WpaState = SS_START;
                    DBGPRINT(RT_DEBUG_TRACE, "WpaPskLen = %d\n", pWscControl->WpaPskLen);
                }
                else
                {
                    pWscControl->WpaPskLen = 0;
                    DBGPRINT(RT_DEBUG_TRACE, "WPAPSK: Invalid Key Length (%d)\n", pProfile->Profile[0].KeyLength);
                }
            }
            else if (pProfile->Profile[0].EncrType == WSC_ENCRTYPE_WEP)
            {
                CHAR   WepKeyId = 0;
                USHORT  WepKeyLen = pProfile->Profile[0].KeyLength;

                printk("snowpin - pProfile->Profile[0].KeyIndex = %d\n", pProfile->Profile[0].KeyIndex);
				WepKeyId = (pProfile->Profile[0].KeyIndex - 1); // KeyIndex = 1 ~ 4
                if ((WepKeyId >= 0) && (WepKeyId <=3))
                {
                    pAd->ApCliTab.ApCliEntry[CurApIdx].DefaultKeyId = WepKeyId;

                    // 5 or 13 ASCII characters
                    // 10 or 26 Hex characters
                    if (WepKeyLen == 5 || WepKeyLen == 13 || WepKeyLen == 10 || WepKeyLen == 26)
                    {
                        if (WepKeyLen == 5 || WepKeyLen == 13)
                        {
                            pAd->ApCliTab.ApCliEntry[CurApIdx].SharedKey[WepKeyId].KeyLen = WepKeyLen;
                            memcpy(pAd->ApCliTab.ApCliEntry[CurApIdx].SharedKey[WepKeyId].Key, 
                                   pProfile->Profile[0].Key,
                                   WepKeyLen);
                            if (WepKeyLen == 5)
                                pAd->ApCliTab.ApCliEntry[CurApIdx].SharedKey[WepKeyId].CipherAlg = CIPHER_WEP64;
                            else
                                pAd->ApCliTab.ApCliEntry[CurApIdx].SharedKey[WepKeyId].CipherAlg = CIPHER_WEP128;
                        }
                        else
                        {
                            pAd->ApCliTab.ApCliEntry[CurApIdx].SharedKey[WepKeyId].KeyLen = WepKeyLen/2;
                            AtoH(pProfile->Profile[0].Key, pAd->ApCliTab.ApCliEntry[CurApIdx].SharedKey[WepKeyId].Key, WepKeyLen/2);
                            if (WepKeyLen == 10)
                                pAd->ApCliTab.ApCliEntry[CurApIdx].SharedKey[WepKeyId].CipherAlg = CIPHER_WEP64;
                            else
                                pAd->ApCliTab.ApCliEntry[CurApIdx].SharedKey[WepKeyId].CipherAlg = CIPHER_WEP128;
                        }
                    }
                    else
                        DBGPRINT(RT_DEBUG_TRACE, "WEP: Invalid Key Length (%d)\n", pProfile->Profile[0].KeyLength);
                }
                else
               	{
               		DBGPRINT(RT_DEBUG_TRACE, "Unsupport default key index (%d), use key Index 1.\n", WepKeyId);
               		pAd->ApCliTab.ApCliEntry[CurApIdx].DefaultKeyId = WepKeyId = 0;
                }
            }
        }
    }

    DBGPRINT(RT_DEBUG_TRACE, "<----- WscWriteConfToApCliCfg\n");
}
#endif // APCLI_SUPPORT //
// --

