#############################################################
#
# rxvt
#
#############################################################
# Copyright (C) 2002 by Tom Walsh <Tom@OpenHardware.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA

RXVT_VERSION:=2.6.4
RXVT_SOURCE:=rxvt-$(RXVT_VERSION).tar.gz
RXVT_SITE:=http://$(BR2_SOURCEFORGE_MIRROR).dl.sourceforge.net/sourceforge/rxvt
RXVT_CAT:=$(ZCAT)
RXVT_DIR:=$(BUILD_DIR)/rxvt-$(RXVT_VERSION)
RXVT_BINARY:=$(RXVT_DIR)/src/rxvt

$(DL_DIR)/$(RXVT_SOURCE):
	 $(WGET) -P $(DL_DIR) $(RXVT_SITE)/$(RXVT_SOURCE)

rxvt-source: $(DL_DIR)/$(RXVT_SOURCE)

$(RXVT_DIR)/.unpacked: $(DL_DIR)/$(RXVT_SOURCE)
	$(RXVT_CAT) $(DL_DIR)/$(RXVT_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	toolchain/patch-kernel.sh $(RXVT_DIR) package/rxvt/ \*.patch
	touch $(RXVT_DIR)/.unpacked

$(RXVT_DIR)/.configured: $(RXVT_DIR)/.unpacked
	(cd $(RXVT_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		rxvt_cv_ptys=GLIBC \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr/X11R6 \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--x-includes=$(STAGING_DIR)/usr/X11R6/include \
		--x-libraries=$(STAGING_DIR)/usr/X11R6/lib \
		--disable-resources \
		--disable-memset \
		--enable-xgetdefault \
	);
	touch $(RXVT_DIR)/.configured

$(RXVT_BINARY): $(RXVT_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(RXVT_DIR)
	$(STRIP) -x $(RXVT_BINARY)

$(TARGET_DIR)/usr/X11R6/bin/rxvt: $(RXVT_BINARY)
	cp -f $(RXVT_BINARY) $(TARGET_DIR)/usr/X11R6/bin
	(cd $(TARGET_DIR)/usr/X11R6/bin; ln -fs rxvt xterm)

ifeq ($(strip $(BR2_PACKAGE_TINYX)),y)
rxvt: tinyx $(TARGET_DIR)/usr/X11R6/bin/rxvt
endif
ifeq ($(strip $(BR2_PACKAGE_XORG)),y)
rxvt: xorg $(TARGET_DIR)/usr/X11R6/bin/rxvt
endif

rxvt-clean:
	rm -f $(TARGET_DIR)/usr/X11R6/bin/rxvt
	-$(MAKE) -C $(RXVT_DIR) clean

rxvt-dirclean:
	rm -rf $(RXVT_DIR)

#############################################################
#
# Toplevel Makefile options
#
#############################################################
ifeq ($(strip $(BR2_PACKAGE_RXVT)),y)
TARGETS+=rxvt
endif
