/*
 * sysd.c - Sysetm Daemon
 * Jacky.Yang 29-Nov-2007
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <sys/ioctl.h>
#include "ralink_gpio.h"
#include "../../../config/autoconf.h"

#define GPIO_DEV	"/dev/gpio"
#define RESET_TIMER		5	//0.5s save status, 6=>5s
#define RESET_BUTTON	10	//reset button, 1:non-push, 1:push
#ifdef CONFIG_DIP_SWITCH
  #define DIP_SWITCH		CONFIG_DIP_SWITCH_GPIO_NUM	//define in TEW672GR_config.vendor-2.4x
  #ifdef CONFIG_DIP_SWITCH_FULL_HI
	#define DIP_SWITCH_ON	1	//raido on: 1, raido off: 0
	#define DIP_SWITCH_OFF	0	//raido on: 1, raido off: 0
  #else
	#define DIP_SWITCH_ON	0	//raido on: 0, raido off: 1
	#define DIP_SWITCH_OFF	1	//raido on: 0, raido off: 1
  #endif
#endif
#define WPS_BUTTON		0	//led, 1:non-push, 1:push
#define WPSLED_ORANGE	11	//led, 0:on, 1:off
#define WPSLED_GREEN	14	//led, 0:on, 1:off
#define PWRLED_ORANGE	12	//led, 0:on, 1:off
#define LEDON			0
#define LEDOFF			1
#define TIMENULL		-1
#define PUSHBUTTON			0
#define NONPUSHBUTTON		1

int gpio_read_bit(int idx, int *value)
{
	int fd, req;

	*value = 0;
	fd = open(GPIO_DEV, O_RDONLY);
	if (fd < 0) {
		perror(GPIO_DEV);
printf("can not open GPIO_DEV\n");
		return -1;
	}
	if (0L <= idx && idx < RALINK_GPIO_DATA_LEN)
		req = RALINK_GPIO_READ_BIT | (idx << RALINK_GPIO_DATA_LEN);
	else {
		close(fd);
		printf("gpio_read_bit: index %d out of range\n", idx);
		return -1;
	}
	if (ioctl(fd, req, value) < 0) {
		perror("ioctl");
		close(fd);
		return -1;
	}
	close(fd);
}

int GPIO_Check(int pin)
{
	int d;

	gpio_read_bit(pin, &d);
	//printf("salim - get GPIO Pin %d: %d\n",pin, d);
	return d;
}
#ifdef CONFIG_DIP_SWITCH
int checkDipSwitch(int *dipSwitchArray, int GPIOvalue, int *pt)
{
	dipSwitchArray[*pt] = GPIOvalue;
	if (*pt == 0) {
		*pt = 1;
	}
	else {
		*pt = 0;
	}
	if (dipSwitchArray[0] != dipSwitchArray[1])
		return -1;
	else
		return 0;
}
#endif
int checkResetButton(int *timerArray, int GPIOvalue, int pushStatus, int *pt)
{
	int i, virtualPoint;
	char cmd[256];
	
	timerArray[*pt] = GPIOvalue;
	virtualPoint = *pt;
	//printf("jacky - timerArray[%d]=%d (%d)\n", *pt, timerArray[*pt], GPIOvalue);
	
	//gpio-11: 0=>push
	if (GPIOvalue == PUSHBUTTON) {
		snprintf(cmd, sizeof(cmd), "gpio l %d 10 1 1 1 1", WPSLED_ORANGE);
		system(cmd);
	}
	
	if ((*pt + 1) > (RESET_TIMER - 1))
		*pt = 0;
	else
		*pt = *pt + 1;
	
	for (i = 0; i < RESET_TIMER; i++)
	{
		virtualPoint = virtualPoint - i;
		if (virtualPoint < 0)
			virtualPoint = RESET_TIMER - 1;
		if (timerArray[virtualPoint] != pushStatus)
			return -1;
	}
	return 0;
}

int main(int argc, char *argv[])
{
	int *resetTimerArray, *dipSwitch;
	int resetPoint, i;
	int resetPushStatus=0;
	char defaultString1[256], defaultString2[256], cmd[256];
	strcpy(defaultString1, "ralink_init renew 2860 /etc_ro/Wireless/RT2860AP/");
	strcpy(defaultString2, "ralink_init renew inic /etc_ro/Wireless/RT2860AP/");
	strcat(defaultString1, LoadToDefaultFileName_2860);
	strcat(defaultString2, LoadToDefaultFileName_inic);
	
	resetTimerArray = (int *) malloc((RESET_TIMER) * sizeof(int));
	memset(resetTimerArray, 1, sizeof(resetTimerArray));
	resetPoint = 0;

#ifdef CONFIG_DIP_SWITCH
	int dipSwitchPt, dipSwitchArray[2];
	//resetTimerArray = (int *) malloc((2) * sizeof(int));
	dipSwitchArray[0] = dipSwitchArray[1] = GPIO_Check(DIP_SWITCH);
	dipSwitchPt=0;
	dipSwitch = dipSwitchArray;
	
	sleep(5);
	printf("Start System Deamon\n");
	system("gpio u set_gpio_dir 21 in"); //Salim:Make pin 21 direction IN
	if (GPIO_Check(DIP_SWITCH) == DIP_SWITCH_OFF) {
		system("ifconfig ra3 down");
		system("ifconfig ra2 down");
		system("ifconfig ra1 down");
		//Tom.Hung 2010-1-27, ra0 only need turn off radio from driver, don't need down ra0 interface.
		//system("ifconfig ra0 down");
		system("iwpriv ra0 set RadioOn=0");
		//Tom.Hung 2010-1-27
		system("nvram_set 2860 RadioOff 1");
	}
#endif

#ifdef CONFIG_PWRLED_ORANGE
	//Jacky.Yang 9-Sep-2008, close orange power led
	//snprintf(cmd, sizeof(cmd), "gpio 0 %d 1 300 1 1 1", PWRLED_ORANGE);
	//system(cmd);
#endif
	
	while (1)
	{
		sleep(1);  //sleep(1) not equal 1s
		
		/*WPS LED control
		if (GPIO_Check(WPS_BUTTON) == PUSHBUTTON) {
			snprintf(cmd, sizeof(cmd), "gpio l %d 10 1 1 1 1", WPSLED_GREEN);
			system(cmd);
		}*/
#ifdef CONFIG_DIP_SWITCH
		if (checkDipSwitch(dipSwitch, GPIO_Check(DIP_SWITCH), &dipSwitchPt))
		{
			if (GPIO_Check(DIP_SWITCH) == DIP_SWITCH_ON) {
				//Tom.Hung 2010-1-27, ra0 only need turn off radio from driver, don't need down ra0 interface.
				//system("ifconfig ra0 up");
				system("iwpriv ra0 set RadioOn=1");
				//Tom.Hung 2010-1-27
				system("ifconfig ra1 up");
				system("ifconfig ra2 up");
				system("ifconfig ra3 up");
				//system("ifconfig wds0 up");
				//system("ifconfig wds1 up");
				//system("ifconfig wds2 up");
				//system("ifconfig wds3 up");
				system("nvram_set 2860 RadioOff 0");
				system("getBoardID"); //re-get board id from eeprom.
			}
			else if (GPIO_Check(DIP_SWITCH) == DIP_SWITCH_OFF) {
				system("ifconfig ra3 down");
				system("ifconfig ra2 down");
				system("ifconfig ra1 down");
				//Tom.Hung 2010-1-27, ra0 only need turn off radio from driver, don't need down ra0 interface.
				//system("ifconfig ra0 down");
				system("iwpriv ra0 set RadioOn=0");
				//Tom.Hung 2010-1-27
				system("send_event stopWPS");
				system("ifconfig wds3 down");
				system("ifconfig wds2 down");
				system("ifconfig wds1 down");
				system("ifconfig wds0 down");
				system("gpio r");
				system("nvram_set 2860 RadioOff 1");
			}
		}
#endif
		if (checkResetButton(resetTimerArray, GPIO_Check(RESET_BUTTON), resetPushStatus, &resetPoint) == 0)
		{
			//printf("Running load to default!");
			snprintf(cmd, sizeof(cmd), "gpio l %d 1 1 20 1 1", WPSLED_ORANGE);
			system(cmd);
			memset(resetTimerArray, 1, sizeof(resetTimerArray));
			resetPoint = 0;
			system("ralink_init clear 2860");
			system("ralink_init clear inic");
			system(defaultString1);
			system(defaultString2);
			system("rfwcmd load default"); //Load default setting for outsourcing features - U-Media Ricky Cao on Apr. 22 2008
			//printf("Rebooting");
			//sleep(2);
			system("reboot");
		}
	}
	free(resetTimerArray);

}