#!/bin/sh

#Jacky.Yang 2-OCt-2008, reset all phy from mii

#  arg1:  phy address.
reset_phy()
{
	# get original register value
	get_mii=`mii_mgr -g -p $1 -r 0`
	orig=`echo $get_mii | sed 's/^.....................//'`

	# stupid hex value calculation.
	pre=`echo $orig | sed 's/...$//'`
	post=`echo $orig | sed 's/^..//'`
	num_hex=`echo $orig | sed 's/^.//' | sed 's/..$//'`
	case $num_hex in
		"0")	rep="8"	;;
		"1")	rep="9"	;;
		"2")	rep="a"	;;
		"3")	rep="b"	;;
		"4")	rep="c"	;;
		"5")	rep="d"	;;
		"6")	rep="e"	;;
		"7")	rep="f"	;;
		# The power is already down
		*)		echo "Warning in PHY reset script";return;;
	esac
	new=$pre$rep$post
	# power down
	mii_mgr -s -p $1 -r 0 -v $new
	# power up
	mii_mgr -s -p $1 -r 0 -v $orig
}

reset_all_phys()
{
	#Jacky.Yang 2-Oct-2008, fix the port number for WRT-383L
	reset_phy 0
	reset_phy 1
	reset_phy 2
	reset_phy 3
	#This is wan port
	reset_phy 4
}

reset_all_phys


