#!/bin/sh
#
# This script is used to send some packets via ppp interface
# It is for bring ppp interface up when it is configured to on demand mode.
# This script will be call when user click connect button on status page of GUI
# Ricky CAO on Jan 27 2010
#

CONN_TYPE=`nvram_get 2860 wanConnectionMode`
if [ "$CONN_TYPE" = "PPPOE" ]; then
	RECONNECT_MODE=`nvram_get 2860 wan_pppoe_opmode`
elif [ "$CONN_TYPE" = "L2TP" ]; then
	RECONNECT_MODE=`nvram_get 2860 wan_l2tp_opmode`
elif [ "$CONN_TYPE" = "PPTP" ]; then
	RECONNECT_MODE=`nvram_get 2860 wan_pptp_opmode`
else
	echo "The WAN is not PPP interface!"
	exit 0
fi

if [ ! "$RECONNECT_MODE" = "OnDemand" ]; then
	echo "The reconnect mode is not on demand!"
	exit 0
fi

while [ 1 ]
do
	PPP_IF_STATUS=`cat /var/ppp_status`
	if [ "$PPP_IF_STATUS" = "1" ]; then
		break
	fi

	ping -c 1 `ifconfig ppp0 | grep P-t-P | awk '{print $3}' | sed -n 's/P-t-P://p'` > /dev/null
	sleep 2
done