#!/bin/sh
CONF_DIR=/etc/l2tp
CONF_FILE=/etc/l2tp/l2tp.conf
L2TP_FILE=/etc/options.l2tp

if [ ! -n "$3" ]; then
  echo "insufficient arguments!"
  echo "Usage: $0 <user> <password> <serv_ip>"
  exit 0
fi

L2TP_USER_NAME="$1"
L2TP_PASSWORD="$2"
L2TP_SERV_IP="$3"
L2TP_HOSTNAME="$4"
L2TP_OPMODE="$5"
L2TP_OPTIME="$6"

#add for set WAN MTU - U-Media Ricky Cao on May 16 2008
wan_use_default_mtu=`nvram_get 2860 wan_use_default_mtu`
if [ "$wan_use_default_mtu" = "1" ]; then
	WAN_MTU="1400"
else
	WAN_MTU=`nvram_get 2860 wan_mtu`
fi
#U-Media Ricky Cao on May 16 2008

if [ ! -d $CONF_DIR ] ; then mkdir -p $CONF_DIR; fi

echo "global
load-handler \"sync-pppd.so\"
load-handler \"cmd.so\"
listen-port 1701
section sync-pppd
lac-pppd-opts \"file $L2TP_FILE\"
pppd-path \"/bin/pppd\"
section peer
peer $L2TP_SERV_IP
port 1701
lac-handler sync-pppd
hide-avps no
retain-tunnel 0
hostname $L2TP_HOSTNAME
maxfail 32767" > $CONF_FILE
echo "#########L2TP_OPMODE=$L2TP_OPMODE" > /dev/console
if [ "$L2TP_OPMODE" = "KeepAlive" -o "$L2TP_OPMODE" = "OnDemand" ]; then
echo "persist yes
holdoff $L2TP_OPTIME" >> $CONF_FILE
fi
echo "section cmd" >> $CONF_FILE

echo "noauth 
refuse-eap
user \"$L2TP_USER_NAME\"
password \"$L2TP_PASSWORD\"
nomppe nomppc
lock
maxfail 0
usepeerdns" > $L2TP_FILE
if [ "$L2TP_OPMODE" = "KeepAlive" ]; then
	echo "persist" >> $L2TP_FILE
	echo "holdoff $L2TP_OPTIME" >> $L2TP_FILE
elif [ "$L2TP_OPMODE" = "OnDemand" ]; then
	L2TP_OPTIME=`expr $L2TP_OPTIME \* 60`
	echo "demand" >> $L2TP_FILE
	echo "idle $L2TP_OPTIME" >> $L2TP_FILE
	echo "active-filter 'outbound and not dst port 123'" >> $L2TP_FILE
	echo "holdoff 1" >> $L2TP_FILE
#add - U-Media Ricky Cao on Oct 08 2008
#if this variable doesn't be add, the pppd will not use the ppp0 always, and it will use ppp0, ppp1, ppp2 (change after resume ppp link)...
	echo "nopersist" >> $L2TP_FILE
fi
#Add for configure MTU - U-Media Ricky Cao on Oct 08 2008
echo "mtu $WAN_MTU" >> $L2TP_FILE
#Add for on demand mode can not work properly - U-Media Ricky Cao on Oct 08 2008
#if this veriable doen't be add, pppd will exit abnormally
echo "connect true" >> $L2TP_FILE
#Both script is for treat events of ppp interface UP and DOWN - U-Media Ricky Cao on Oct 08 2008
echo "ip-up-script \"/sbin/ppp-ip-up\"
ip-down-script \"/sbin/ppp-ip-down\"
defaultroute 
ipcp-accept-remote ipcp-accept-local noipdefault
ktune
default-asyncmap nopcomp noaccomp
novj nobsdcomp nodeflate
lcp-echo-interval 10
lcp-echo-failure 6
unit 0 " >> $L2TP_FILE

