#ifndef VLIST_H
#define VLIST_H 1

#ifdef __cplusplus
extern "C" {
#endif

    typedef struct _vlistEntry{
	void *elem;
	struct _vlistEntry *prev;
	struct _vlistEntry *next;
    } vlistEntry;

    typedef struct _vlist{
	vlistEntry *first;
	vlistEntry *last;
    } vlist;

    vlistEntry* vlistEntryAlloc(void *v);
    void vlistEntryDestroy(vlistEntry *entry, void (*vdestroy)(void *));

    void vlistInit(vlist *vl);

    vlistEntry *vlistInsertFirst(vlist *vl, void *v);
    vlistEntry *vlistInsertLast(vlist *vl, void *v);
    vlistEntry *vlistInsertBefore(vlist *vl, void *v, vlistEntry *ent);
    vlistEntry *vlistInsertAfter(vlist *vl, void *v, vlistEntry *ent);

    vlistEntry *vlistFirstEntry(vlist *vl);
    vlistEntry *vlistLastEntry(vlist *vl);
    vlistEntry *vlistPrevEntry(vlistEntry *ent);
    vlistEntry *vlistNextEntry(vlistEntry *ent);

    int vlistMove(vlist *vl, int from, int to);
    int vlistExchange(vlist *vl, int pos1, int pos2);

    void vlistRemove(vlist *vl, void *item, void (*vdestroy)(void*), int (*compare)(const void*, const void*));
    void vlistRemoveFirst(vlist *vl, void (*vdestroy)(void*));
    void vlistRemoveLast(vlist *vl, void (*vdestroy)(void*));
    void vlistRemoveEntry(vlist *vl, vlistEntry *ent, void (*vdestroy)(void*));

    int vlistEmpty(vlist *vl);
    unsigned int vlistCount(vlist *vl);
    void vlistDestroy(vlist *vl, void (*vdestroy)(void *));

#ifdef __cplusplus
}
#endif
#endif
