#ifndef RULESET_H
#define RULESET_H

#include <stdio.h>
#include "vlist.h"

typedef struct _Rule {
	char *rule;
	vlist binds;
	vlist unbinds;
} Rule;

typedef struct _RuleGroup {
    char *name;
    vlist rules;
} RuleGroup;

typedef vlist Ruleset;

int rulesetInit(Ruleset *rs);
int rulesetRemove(Ruleset *rs, const char *name, int pos);
int rulesetList(Ruleset *rs, const char *name, FILE *fp);
int rulesetExist(Ruleset *rs, const char *name, int pos);
int rulesetBind(Ruleset *rs, const char *name, const char *iface);
int rulesetUnBind(Ruleset *rs, const char *name, const char *iface);
int rulesetWrite(Ruleset *rs);
void rulesetDestroy(Ruleset *rs);
int rulesetAdd(const char *what, char *jfwrule);
int rulesetMove(const char *grp, int from, int to);

#endif
