#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <fcntl.h>
#include <unistd.h>

#include "fgetline.h"
#include "rule.h"
#include "cmd-inc.h"
#include "test.h"


int bindInterface(const char *ifalias, const char *group)
{
    char buf[MAX_CONFIG_LINE + 1];

    snprintf(buf, MAX_CONFIG_LINE, "bind %s %s", ifalias, group);
    return sfileAppend(PATH_BIND_LIST, buf);
}

int bindGetInterface(const char *accessList, char *ifalias)
{
    FILE *fp = (FILE*) 0;
    int ret = -1;
    char *modifier, *ifa, *al, *brkp;
    char buf[MAX_CONFIG_LINE + 1];

    if (! (fp = fopen(PATH_BIND_LIST, "r")))
        return -1;
    for (; (ret = fgetline(buf, MAXPATHLEN, fp)) != -1;) {
        modifier = ifa = al = brkp = (char*) 0;
        
        if (ret
            && (modifier = strtok_r(buf, ARGS_DELIM, &brkp))
            && (ifa = strtok_r(NULL, ARGS_DELIM, &brkp))
            && (al =strtok_r(NULL, ARGS_DELIM, &brkp))
            && ! strtok_r(NULL, ARGS_DELIM, &brkp)
            && ! strcmp("bind", modifier)) {
            
            ret = 0;
            if (accessList && strcmp(al, accessList))
                ret = -1;
            if (ret == 0) {
                if (ifalias)
                    strcpy(ifalias, ifa);
                fclose(fp);
                return 0;
            }
        }
    }
    fclose(fp);
    return -1;
}

int bindGetAccessList(const char *ifalias, char *accessList)
{
    FILE *fp = (FILE*) 0;
    int ret = -1;
    char *modifier, *ifa, *al, *brkp;
    char buf[MAX_CONFIG_LINE + 1];

    if (! (fp = fopen(PATH_BIND_LIST, "r")))
        return -1;
    for (; (ret = fgetline(buf, MAXPATHLEN, fp)) != -1;) {
        modifier = ifa = al = brkp = (char*) 0;
        
        if (ret
            && (modifier = strtok_r(buf, ARGS_DELIM, &brkp))
            && (ifa = strtok_r(NULL, ARGS_DELIM, &brkp))
            && (al =strtok_r(NULL, ARGS_DELIM, &brkp))
            && ! strtok_r(NULL, ARGS_DELIM, &brkp)
            && ! strcmp("bind", modifier)
	    && ! strcmp(al, accessList)
            && ! strcmp(ifa, ifalias)) {
            
            fclose(fp);
            return 0;
        }
    }
    fclose(fp);
    return -1;
}

int bindDelAccessList(const char *ifalias, char *name)
{
    FILE *fp = (FILE*) 0;
    FILE *cp = (FILE*) 0;
    int ret = -1;
    char expath[MAXPATHLEN + 1];
    char buf[MAX_CONFIG_LINE + 1];
    char psrbuf[MAX_CONFIG_LINE + 1];
    char *c1, *ifa, *group, *brkp;
	int tfd = -1;

    snprintf(expath, MAXPATHLEN, "/tmp/rfw.XXXXXX");
//    if ((tfd = mkstemp(expath)) < 0)
    if ((tfd = open(expath, O_CREAT|O_TRUNC|O_RDWR), S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH) < 0)
		return -1;
/*	if (chmod(expath, 0644) < 0) {
		close(tfd);
		unlink(expath);
		return -1;
	} */
    if (! (fp = fopen(PATH_BIND_LIST, "r"))) {
		close(tfd);
		unlink(expath);
        return -1;
	}
    if (! (cp = fdopen(tfd, "w"))) {
		close(tfd);
		unlink(expath);
        fclose(fp);
        return -1;
    }
    for (; (ret = fgetline(buf, MAXPATHLEN, fp)) != -1; ) {
        if (! ret)
            continue;
        
        strcpy(psrbuf, buf);
        c1 = ifa = brkp = (char*) 0;
        
        if ((c1 = strtok_r(psrbuf, ARGS_DELIM, &brkp))
            && (ifa = strtok_r(NULL, ARGS_DELIM, &brkp))
            && (group = strtok_r(NULL, ARGS_DELIM, &brkp))
            && ! strcmp("bind", c1)
            && (strcmp(ifa, ifalias) || strcmp(name, group))) {
            
            if (fprintf(cp, "%s\n", buf) < 0) {
                fclose(fp);
                fclose(cp);
                unlink(expath);
                return -1;
            }
        }
    }

    ret = ferror(fp) ? -1 : 0;
    fclose(fp);
    fclose(cp);
    if (ret < 0) {
        unlink(expath);
        return -1;
    }
        
    if (sfileMove(expath, PATH_BIND_LIST) < 0) {
        unlink(expath);
        return -1;
    }
    return 0;
}

int ippGet(const char *name, const char *modifier, char *range)
{
    /* дļ */
    int ret = -1;
    FILE *fp = (FILE*) 0;

    fp = fopen(PATH_NAME_LIST, "r");
    if (fp) {
        char buffer[MAX_CONFIG_LINE + 1];
        char *sname, *srange, *brkp, *c1, *c2;

        for (; (ret = fgetline(buffer, MAX_CONFIG_LINE, fp)) != -1;) {
            c1 = c2 = sname = srange = brkp = (char*) 0;
            
            if (ret
                && (c1 = strtok_r(buffer, ARGS_DELIM, &brkp))
                && (c2 = strtok_r(NULL, ARGS_DELIM, &brkp))
                && (sname = strtok_r(NULL, ARGS_DELIM, &brkp))
                && (srange = strtok_r(NULL, ARGS_DELIM, &brkp))
                && ! strtok_r(NULL, ARGS_DELIM, &brkp)
                && ! strcmp("name", c1)
                && ! strcmp(modifier, c2)
                && ! strcmp(name, sname)) {
                
                if (range)
                    strcpy(range, srange);
                fclose(fp);
                return 0;
            }
        }
        fclose(fp);
    }
    return -1;
}

int ippDel(const char *name)
{
    return 0;
}
