#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "defs.h"
#include "fgetline.h"

int fetchResult(FILE *fp)
{
    char buffer[MAX_CONFIG_LINE + 1];

    for (;;) {
        if (fgetline(buffer, MAX_CONFIG_LINE, fp) != 1) {
            fprintf(stderr, "!!! fetchResult error.\n");
            return -1;
        }
        if (! strcmp(".Finish.", buffer))
            break;
        else
            printf("%s\n", buffer);
    }
    return 0;
}

int handshake(FILE *in, FILE *out)
{
	char buffer[MAX_CONFIG_LINE + 1];
	uid_t uid;

	uid = getuid();
	snprintf(buffer, MAX_CONFIG_LINE, "%d\n", uid);
	fputs(buffer, out);
	fflush(out);

	if (fgetline(buffer, MAX_CONFIG_LINE, in) != 1)
		return -1;
	if (strcmp(buffer, "OK"))
		return -1;

	return 0;
}

int main(int argc, char **argv)
{
    char buffer[MAX_CONFIG_LINE + 1];
    int fd = -1;
    FILE *fpin = (FILE*) 0;
    FILE *fpout = (FILE*) 0;
    struct sockaddr_un sun;

    sun.sun_family = AF_LOCAL;
    strncpy(sun.sun_path, "/etc/rfwadm.sock", sizeof(sun.sun_path) - 1);
    fd = socket(AF_LOCAL, SOCK_STREAM, 0);
    if (fd < 0) {
        fprintf(stderr, "socket error.\n");
        exit(1);
    }
    if (connect(fd, (struct sockaddr*) &sun, sizeof(sun)) != 0) {
        fprintf(stderr, "connect error.\n");
        exit(1);
    }

    fpin = fdopen(fd, "r");
    fpout = fdopen(fd, "w");
    if (! fpin || ! fpout) {
        fprintf(stderr, "fdopen error.\n");
		exit(1);
    }

	if (handshake(fpin, fpout) < 0) {
		fprintf(stderr, "user deny\n");
		exit(1);
	}

	for (; fgets(buffer, MAX_CONFIG_LINE, stdin); ) {
		fputs(buffer, fpout);
		fflush(fpout);

		/* ȡ */
		if (fetchResult(fpin) < 0)
			break;
		if (! strcmp(buffer, "quit\n"))
			break;
	}
    return 0;
}
