#include <sys/types.h>
#include <sys/socket.h>

#include <unistd.h>
#include <fcntl.h>

#include <stdarg.h>

#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "fgetline.h"
#include "connection.h"
#include "rps.h"

#include "command.h"
#include "defs.h"
#include "peer.h"

int handshake()
{
	int r = -1;
	char buffer[MAX_CONFIG_LINE + 1];

	if ((r = fgetline(buffer, MAX_CONFIG_LINE, _channel.in)) < 0)
		return -1;

	return rpsNoFinish("OK");
}

#define MAX_CONFIG_LINE 1024
void peerDispose(int fd)
{
	int r = -1;
	char _cmdBuffer[MAX_CONFIG_LINE + 1];

	if (ConnectionInit(fd, &_channel) < 0)
		return;

	if (handshake() < 0)
		return;

	/* ѭ */
	for (;;) {
		r = fgetline(_cmdBuffer, MAX_CONFIG_LINE, _channel.in);
		if (r < 0) {
			break;
		}
		if (! r) {
			/* ̫ */
			if (rpsErrorSyntax() < 0)
				break;
			continue;
		}

		if (commandDispose(_cmdBuffer) < 0)
			break;
	}

	/* Ҫclose(fd),  */
}
