#include <sys/types.h>
#include <unistd.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "parser.h"

/* parserConfig FILENAME CONTENT KEY */
int main(int argc, char **argv)
{
	char *path, *content, *key, *value;
	parser psr;

	if (argc != 4) {
		fprintf(stderr, "usage: parserConfig FILENAME CONTENT KEY\n");
		exit(1);
	}

	path = argv[1];
	content = argv[2];
	key = argv[3];
	
	if (parserInit(&psr, path, '=', 1) != 0)
		exit(1);

	value = NULL;
	parserStr(&psr, content, key, &value);

	if (value && *value)
		fprintf(stdout, "%s\n", value);

	parserDestroy(&psr);
	exit(0);
}
