#ifndef PARSER_H
#define PARSER_H 1

#include "vlist.h"

#define PARSER_CONTENT_LENGTH 512
#define PARSER_KEY_LENGTH 512
#define PARSER_VALUE_LENGTH 2048

typedef vlist parser;

typedef struct _parserEntry {
    char *key;
    char *value;
} parserEntry;

typedef struct _parserContent {
    char *content;
    vlist entries;
} parserContent;


int parserInit(parser *psr, const char *path, int deli, int nosptab);
int parserWrite(parser *psr, const char *path, int deli);
void parserDestroy(parser *psr);

int parserLong(parser *psr, const char *content, const char *key, long *longval);
int parserStr(parser *psr, const char *content, const char *key, char **strval);

int parserSetLong(parser *psr, const char *content, const char *key, long longval);
int parserSetStr(parser *psr, const char *content, const char *key, const char *strval);

int parserFirstContent(parser *psr, char **strval);
int parserNextContent(parser *psr, char **strval);

int parserRemove(parser *psr, const char *content, const char *key);

#endif
