#ifndef IFNS_H
#define IFSN_H

#define MAX_IFN_LENGTH 32
#define MAX_IFN_LINE ((MAX_IFN_LENGTH * 2) + 5)

typedef struct _ifnNode {
	char alias[MAX_IFN_LENGTH + 1];
	char ifn[MAX_IFN_LENGTH + 1];
} IfnNode;

void ifnsInit();
const char *ifnByAlias(const char *alias);
char *ifaddrByAlias(const char *alias);
char *ifmaskByAlias(const char *alias);
char *ifstatByAlias(const char *alias);
char *ifinetByAlias(const char *alias);
int test_interfaces(const char *ifs);

#endif
