#include "cts.h"
#include "parser.h"
#include "defs.h"

int ctsSet(const char *path, const char *content, const char *key, const char *value)
{
    parser psr;
    parserInit(&psr, path, '=', 1);
    if (parserSetStr(&psr, content, key, value) < 0) {
        parserDestroy(&psr);
        return -1;
    }
    if (parserWrite(&psr, path, '=') < 0) {
        parserDestroy(&psr);
        return -1;
    }
    parserDestroy(&psr);
    return 0;
}


int ctsDel(const char *path, const char *content, const char *key)
{
    parser psr;
    parserInit(&psr, path, '=', 1);
    if (parserRemove(&psr, content, key) < 0) {
        parserDestroy(&psr);
        return -1;
    }
    if (parserWrite(&psr, path, '=') < 0) {
        parserDestroy(&psr);
        return -1;
    }
    parserDestroy(&psr);
    return 0;
}
