#include <sys/time.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>

#include "cmd-inc.h"
#include "vlist.h"
#include "connection.h"
#include "rule.h"


static int subName(char *args)
{
	char *brkp = (char *) 0;
	
	if (args && strtok_r(args, ARGS_DELIM, &brkp))
		return rpsErrorArguments();

	if(rpsFile(PATH_NAME_LIST) < 0)
		return -1;

	return rpsFinish();
}


static int subRoute(char *args)
{
	char **argv = (char**) 0;
	int nargs = 0;
	int ret = 0;
	char *brkp = (char*) 0;

	if (args && strtok_r(args, ARGS_DELIM, &brkp))
		return rpsErrorArguments();

	if (! (argv = argvNew(PS_ROUTE, &nargs)))
		return rpsErrorBusy();

	if (! argvAdd(&argv, "-n", &nargs)) {
		argvFree(argv);
		return rpsErrorBusy();
	}

	ret = invokeOutput(PS_ROUTE, argv, fileno(rpsOUTFILE()));

	argvFree(argv);

	if (ret != 0)
		return rpsErrorString("error while access route table");

	return rpsFinish();
}

static int subPolicy(char *args)
{
	Ruleset rs;
	char *group = (char*) 0;
	char *brkp = (char*) 0;

	if (args) {
	        if ((group = strtok_r(args, ARGS_DELIM, &brkp))
		     && strtok_r(NULL, ARGS_DELIM, &brkp))
			return rpsErrorArguments();
	}

	if (rulesetInit(&rs) < 0)
		return rpsErrorBusy();

	if (rulesetList(&rs, group, rpsOUTFILE()) < 0)
		return -1;
	return rpsFinish();
}

static int subIP(char *args)
{
	char *modifier, *brkp;

	modifier = brkp = (char*) 0;

	if (! args ||
			! (modifier = strtok_r(args, ARGS_DELIM, &brkp)))
		return rpsErrorArguments();

	if (! strcmp("route", modifier)) {
		return subRoute(brkp);
	}
	return rpsErrorSyntax();
}

static int subVersion(char *args)
{
	char *brkp = (char*) 0;

	if (args && strtok_r(args, ARGS_DELIM, &brkp))
		return rpsErrorArguments();

	return rpsString("RFW v0.2 All CopyRight Reserved.");
}

extern vlist _ifnList;
extern Connection _channel;

static int subBind(char *args)
{
	char *brkp = (char*) 0;

	if (args && strtok_r(args, ARGS_DELIM, &brkp))
		return rpsErrorArguments();

	if (rpsFile(PATH_BIND_LIST) < 0)
		return -1;
	return rpsFinish();
}

int opShow(char *args)
{
	char *what = (char*) 0;
	char *brkp = (char*) 0;

	if (! args)
		return rpsErrorArguments();

	if (! (what = strtok_r(args, ARGS_DELIM, &brkp)))
		return rpsErrorArguments();

	if (! strcmp("version", what)) {
		return subVersion(brkp);

	}else if (! strcmp("running", what)) {
		return rpsErrorString("##############");

	}else if (! strcmp("ip", what)) {
		return subIP(brkp);

	}else if (! strcmp("name", what)) {
		return subName(brkp);

	}else if (! strcmp("policy", what)) {
		return subPolicy(brkp);

	}else if (! strcmp("bind", what)) {
		return subBind(brkp);
	}

	return rpsErrorSyntax();
}
