#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <strings.h>

#include "cmd-inc.h"
#include "rule.h"

static char *miprange, *mportrange;

int process_miprange(char *args)
{
        char *iprange1, *iprange2, *brkp, *newrange, *tmpbuf;
        int i = 0;

        iprange1 = iprange2 = brkp = (char *) 0;

        iprange1 = strtok_r(args, ",", &brkp);

        newrange = malloc(MAX_CONFIG_LINE * sizeof(char));
        tmpbuf = malloc(MAX_CONFIG_LINE * sizeof(char));

	bzero(newrange, MAX_CONFIG_LINE);
	bzero(tmpbuf, MAX_CONFIG_LINE);

        while (iprange1 != NULL) {
                i++;
                if ((iprange2 = strchr(iprange1,'-'))) {

                        in_addr_t inlow, inhigh;

                        *iprange2 = '\0';
                        iprange2++;
                        if (inet_pton(AF_INET, iprange1, &inlow) != 1 ||
                            inet_pton(AF_INET, iprange2, &inhigh) != 1) {
                                free(newrange);
                                free(tmpbuf);
                                return 0;
                        }
                        snprintf(tmpbuf, MAX_CONFIG_LINE, "%s-%s", iprange1, iprange2);
                        strcat(newrange, tmpbuf);
                } else if ((iprange2 = strchr(iprange1,'/'))) {
                        if ( !test_ipm(iprange1) ) {
                                free(newrange);
                                free(tmpbuf);
                                return 0;
                        }

                        *iprange2 = '\0';
                        iprange2++;

                        char *bcast, *net;
                        unsigned long nmask=0, nm, loop;
                        struct in_addr in_ip;

                        bcast = net = (char *)0;

                        inet_aton(iprange1, &in_ip);
                        nm = atoi(iprange2);
                        for (loop = 1; loop <= nm; loop++)
                                //nmask = (unsigned long) 2147483648 + (nmask >> 1);
                                nmask = (unsigned long) 0x80000000 + (nmask >> 1);
                        nmask = htonl(nmask);
                        in_ip.s_addr = in_ip.s_addr | (~nmask);
                        bcast = strdup(inet_ntoa(in_ip));
                        inet_aton(iprange1, &in_ip);
                        in_ip.s_addr = in_ip.s_addr & nmask;
                        net = strdup(inet_ntoa(in_ip));
                        snprintf(tmpbuf, MAX_CONFIG_LINE, "%s-%s", net, bcast);
                        strcat(newrange, tmpbuf);
                } else if ( test_ip(iprange1) ) {
                        strcat(newrange, iprange1);
                } else {
                        free(newrange);
                        free(tmpbuf);
                        return 0;
                }

                iprange1 = strtok_r(NULL, ",", &brkp);
                if (iprange1 != NULL) strcat(newrange, ",");
        } ;

        miprange = strdup(newrange);
        free(newrange);
        free(tmpbuf);

        return i;
}

int test_mportrange(char *args)
{
	char *port1, *port2, *brkp;

	int i = 0;

	port1 = port2 = brkp =0;
	port1 = strtok_r(args, ",", &brkp);
	while (port1 != NULL) {
		i++;
		if ((port2 = strchr(port1, ':'))) {
			if ((!test_portrange(port1))) return 0;
		} else if ( !test_port(port1)) {
			return 0;
		}
		port1 = strtok_r(NULL, ",", &brkp);
	}
	return i;
}


int sub_Range(char *args, char *modifier)
{
	char *name, *range, *brkp;
	char append[MAX_CONFIG_LINE + 1];
	int ret;

	miprange = mportrange = name = range = brkp = (char *) 0;

	if (! args || ! (name = strtok_r(args, ARGS_DELIM, &brkp)) ||
	    ! (range = strtok_r(NULL, ARGS_DELIM, &brkp)) ||
	    strtok_r(NULL, ARGS_DELIM, &brkp))
		return rpsErrorArguments();

	if (! strcmp("ip", modifier)) {
		ret = process_miprange(range);
	} else {
		mportrange = strdup(range);
		ret = test_mportrange(range);
	}

	if (ret == 0 || ret > 15) {
		return rpsErrorString("Invalid Multi Range specified. ");
	}
	
	if (ippGet(name, modifier, NULL) == 0)
		return rpsErrorString("Name already exist");

	if (! strcmp("ip", modifier)) {
		snprintf(append, MAX_CONFIG_LINE, "name %s %s %s", modifier, name, miprange);
	} else {
		snprintf(append, MAX_CONFIG_LINE, "name %s %s %s", modifier, name, mportrange);
	}
	if (sfileAppend(PATH_NAME_LIST, append) < 0) {
		return rpsErrorBusy();
	}

	return rpsFinish();
}

int opName(char *args)
{
	char *modifier, *brkp;

	modifier = brkp = (char *)0;

	if (!args)
		return rpsErrorArguments();
	if (! (modifier = strtok_r(args, ARGS_DELIM, &brkp)))
		return rpsErrorArguments();
	if ((! strcmp("ip", modifier)) || (! strcmp("tcp_port", modifier)) || (! strcmp("udp_port", modifier))) {
		return sub_Range(brkp, modifier);
	}
	return rpsErrorSyntax();
}

