#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "cmd-inc.h"

#include "rule.h"

int subRoute(char *args)
{
    char *network, *router, *brkp;
    char command[MAX_CONFIG_LINE + 1];

    network = router = brkp = (char*) 0;

    if (! args ||
        ! (network = strtok_r(args, ARGS_DELIM, &brkp)) ||
        ! (router = strtok_r(NULL, ARGS_DELIM, &brkp)) ||
        strtok_r(NULL, ARGS_DELIM, &brkp))
        return rpsErrorArguments();

    if (strcmp("default", network)) {
        if (! test_ipmask(network) && ! test_ip(network))
            return rpsErrorString("Invalid network specified");
    }
    
    if (! test_ip(router))
        return rpsErrorString("Invalid gateway specified");

    snprintf(command, MAX_CONFIG_LINE, "ip route %s", network);

    if (sfileExist(PATH_ROUTE_LIST, command))
        return rpsErrorString("route already exist");
    
    snprintf(command, MAX_CONFIG_LINE, "ip route %s %s", network, router);
    
    {                           /* ϵͳ */
        char **argv = (char**) 0;
        int nargs = 0;
        int ret = -1;

        if (! (argv = argvNew(PS_ROUTE, &nargs)))
            return rpsErrorBusy();

        if (! strcmp("default", network)) {
            /* Ĭ· */
            if (! argvAdd(&argv, "add", &nargs) ||
                ! argvAdd(&argv, network, &nargs) ||
                ! argvAdd(&argv, "gw", &nargs) ||
                ! argvAdd(&argv, router, &nargs)) {
                argvFree(argv);
                return rpsErrorBusy();
            }
        }else {
            if (test_ipmask(network)) {
                /* · */
                if (! argvAdd(&argv, "add", &nargs) ||
                    ! argvAdd(&argv, "-net", &nargs) ||
                    ! argvAdd(&argv, network, &nargs) ||
                    ! argvAdd(&argv, "gw", &nargs) ||
                    ! argvAdd(&argv, router, &nargs)) {
                    argvFree(argv);
                    return rpsErrorBusy();
                }
            }else {
                /* · */
                if (! argvAdd(&argv, "add", &nargs) ||
                    ! argvAdd(&argv, "-host", &nargs) ||
                    ! argvAdd(&argv, network, &nargs) ||
                    ! argvAdd(&argv, "gw", &nargs) ||
                    ! argvAdd(&argv, router, &nargs)) {
                    argvFree(argv);
                    return rpsErrorBusy();
                }
            }
        }
        
        ret = invokeQuiet(PS_ROUTE, argv);
        argvFree(argv);
        if (ret < 0)
            return rpsErrorString("Error while alter route table");
    }
    
    if (sfileAppend(PATH_ROUTE_LIST, command) < 0)
        return rpsErrorString("Error while record");
    
    return rpsFinish();
}

int opIp(char *args)
{
    char *modifier, *brkp;

    modifier = brkp = (char*) 0;
    if (! args)
        return rpsErrorArguments();
    if (! (modifier = strtok_r(args, ARGS_DELIM, &brkp)))
        return rpsErrorArguments();

    if (! strcmp("route", modifier)) {
        return subRoute(brkp);
    }

    return rpsErrorSyntax();
}
