#include "cmd-inc.h"
#include "rule.h"

int opBind(char *args)
{
    Ruleset rs;
    const char *iface = NULL;
    char *group, *brkp;

    group = brkp = NULL;

    if (! args ||
        ! (group = strtok_r(args, ARGS_DELIM, &brkp)) ||
        strtok_r(NULL, ARGS_DELIM, &brkp))
        return rpsErrorArguments();

    if (strcmp(group, "ipv4")) {

	    if (bindGetAccessList("inside", group) == 0)
        	return rpsErrorString("this policy already binded, unbind it first");


	    if (rulesetInit(&rs) < 0)
        	return rpsErrorBusy();

	    if (rulesetBind(&rs, group, "inside") < 0) {
        	rulesetDestroy(&rs);
	        return rpsErrorString("error while bind ruleset, maybe ruleset is empty");
	    }
	    rulesetDestroy(&rs);
    }

    if (rulesetInit(&rs) < 0)
	    return rpsErrorBusy();
    rulesetUnBind(&rs, "ipv4", "inside");
    rulesetBind(&rs, "ipv4", "inside");
    rulesetDestroy(&rs);

    system("/bin/iptables -D FORWARD -p 0 -j DROP");
    system("/bin/iptables -A FORWARD -p 0 -j DROP");
    
    if (bindInterface("inside", group) < 0)
        return rpsErrorBusy();
    
    return rpsFinish();
}
