#include <sys/types.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "alstr.h"

char *al_strndup(const char *s, size_t len)
{
    char *dst = (char *)0;

    if (! s)
        return (char *)0;

    dst = (char *)malloc((len + 1) * sizeof(char));
    if (dst) {
        size_t i;

        for (i = 0; s[i] && i < len; i++)
            dst[i] = s[i];
        dst[i] = (char) 0;
    }
    return dst;
}

char *al_strcat(char **s, const char *append)
{
    if (! s)
        return (char *)0;

    if (append) {
        size_t applen = strlen(append);
        if (applen) {
            char *ns = (char *)0;
            size_t oldlen = 0, newlen = 0;

            if (*s)
                oldlen = strlen(*s);
            newlen = oldlen + applen;

            ns = realloc(*s, (size_t)(newlen + 1));
            if (ns) {
                memcpy(ns + oldlen, append, applen);
                ns[newlen] = (char)0;
                *s = ns;
            }
        } /* applen */
    } /* append */
    return *s;
}

char *al_struntil(const char *s, int c)
{
    const char *p = (char *)0;

    if (! s)
        return (char *)0;
    
    for (p = s; *p && c != *p; p++)
        ;
    if (p == s)
        return (char *)0;
    
    return al_strndup(s, p - s);
}

char *srmp(char *s)
{
    char *iter = (char *) 0;

    if (s) {
        for (iter = s; *iter; iter++) {
            if (*iter != ' ' && *iter != '\t')
                break;
        }
        if (*iter) {
            if (iter > s) {
                char *t = s;
            
                for (; *iter;)
                    *(t++) = *(iter++);
                *t = '\0';
            }
        }else
            *s = '\0';
    }            
    return s;
}

char *srms(char *s)
{
    char *iter = (char *) 0;
    char *last = (char *) 0;
    
    if (! s)
        return (char *)0;

    for (iter = s; *iter; iter++)
        if (*iter != ' ' && *iter != '\t')
            last = iter;
    if (last)
        *(last + 1) = '\0';
    else
        *s = '\0';
    return s;
}

char *srmps(char *s)
{
    char *from = (char *) 0;

    if (! s)
        return (char *)0;
    
    for (from = s; *from; from++) {
        if (*from != ' ' && *from != '\t')
            break;
    }
    if (*from) {
        char *to = (char *) 0;
        char *last = (char *) 0;

        for (last = to = from + 1; *to; to++) {
            if (*to != ' ' && *to != '\t')
                last = to;
        }
        last++; 
        *last = '\0';
        if (from != s)
            memmove(s, from, last - from + 1);
    }else
        *s = '\0';
    return s;
}

char *al_dupsrmp(const char *s)
{
    char *t = (char *)0;
    char *dup = (char *)0;
    
    if (! s)
        return (char *)0;
    dup = strdup(s);
    if (! dup)
        return (char *)0;
    srmp(dup);
    t = strdup(dup);
    free(dup);
    return t;
}

char *al_dupsrms(const char *s)
{
    char *t = (char *)0;
    char *dup = (char *)0;

    if (! s)
        return (char *)0;
    if (! (dup = strdup(s)))
        return (char *)0;
    srms(dup);
    t = strdup(dup);
    free(dup);
    return t;
}

char *al_dupsrmps(const char *s)
{
    char *t = (char *)0;
    char *dup = (char *)0;

    if (! s)
        return (char *)0;
    if (! (dup = strdup(s)))
        return (char *)0;
    srmps(dup);
    t = strdup(dup);
    free(dup);
    return t;
}

char *al_strdelc(const char *s, int c)
{
    char *dup = (char *)0;

    if (! s)
        return (char *)0;
    
    dup = strdup(s);
    if (dup) {
        char *to, *from;
        for (to = from = dup; *from; from++) {
            if (*from != c) {
                if (from > to)
                    *to = *from;
                to++;
            }
        }
        *to = '\0';
    }
    return dup;
}

